/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_scn extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Ura Minzana di Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Ura sulari di Samoa",
               "",
               "Ura ligali di Samoa",
               "",
               "Ura di Samoa",
               "",
            };
        final String[] Cook = new String[] {
               "Ura sulari di l’Ìsuli Cook",
               "",
               "Ura ligali di l’Ìsuli Cook",
               "",
               "Ura di l’Ìsuli Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Ura sulari di Cubba",
               "CuST",
               "Ura ligali di Cubba",
               "CuDT",
               "Ura di Cubba",
               "CuT",
            };
        final String[] Fiji = new String[] {
               "Ura sulari dî Figi",
               "",
               "Ura ligali dî Figi",
               "",
               "Ura dî Figi",
               "",
            };
        final String[] Gulf = new String[] {
               "Ura Nurmali dû Gurfu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Ura sulari di Khovd",
               "",
               "Ura ligali di Khovd",
               "",
               "Ura di Khovd",
               "",
            };
        final String[] Iran = new String[] {
               "Ura sulari di l’Iran",
               "",
               "Ura ligali di l’Iran",
               "",
               "Ura di l’Iran",
               "",
            };
        final String[] Niue = new String[] {
               "Ura di Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Ura sulari di Omsk",
               "",
               "Ura ligali di Omsk",
               "",
               "Ura di Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Ura sulari dû Pirù",
               "",
               "Ura ligali dû Pirù",
               "",
               "Ura dû Pirù",
               "",
            };
        final String[] Truk = new String[] {
               "Ura di Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Ura di l’Ìsula Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Ura sulari dû Cili",
               "",
               "Ura ligali dû Cili",
               "",
               "Ura dû Cili",
               "",
            };
        final String[] China = new String[] {
               "Ura sulari dâ Cina",
               "CST",
               "Ura ligali dâ Cina",
               "CDT",
               "Ura dâ Cina",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Ura di l’Ìsuli Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Ura di Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Ura sulari di l’Ìnnia",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Ura sulari dû Giappuni",
               "JST",
               "Ura ligali dû Giappuni",
               "JDT",
               "Ura dû Giappuni",
               "JT",
            };
        final String[] Korea = new String[] {
               "Ura sulari dâ Curìa",
               "KST",
               "Ura ligali dâ Curìa",
               "KST",
               "Ura dâ Curìa",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Ura di Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Ura dû Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Ura di Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Ura sulari dî Samoa miricani",
               "SST",
               "Ura ligali dî Samoa miricani",
               "SST",
               "Ura dî Samoa miricani",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Ura di Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Ura sulari di Tonga",
               "",
               "Ura ligali di Tonga",
               "",
               "Ura di Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Ura dû Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Ura sulari di l’Alaska",
               "AKST",
               "Ura ligali di l’Alaska",
               "AKDT",
               "Ura di l’Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Ura sulari di l’Amazzonia",
               "",
               "Ura ligali di l’Amazzonia",
               "",
               "Ura di l’Amazzonia",
               "",
            };
        final String[] Azores = new String[] {
               "Ura sulari di l’Azzorri",
               "",
               "Ura ligali di l’Azzorri",
               "",
               "Ura di l’Azzorri",
               "",
            };
        final String[] Bhutan = new String[] {
               "Ura dû Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Ura dû Brunei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Ura sulari di l’Ìsula di Pasca",
               "",
               "Ura ligali di l’Ìsula di Pasca",
               "",
               "Ura di l’Ìsula di Pasca",
               "",
            };
        final String[] Guyana = new String[] {
               "Ura dâ Guiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Ura sulari di l’Hawaai",
               "HAST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Ura sulari di Isdraeli",
               "IST",
               "Ura ligali di Isdraeli",
               "IDT",
               "Ura di Isdraeli",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Ura di Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Ura di Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Ura sulari di Mosca",
               "MSK",
               "Ura ligali di Mosca",
               "MSK",
               "Ura di Mosca",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ura di Pohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Ura di Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Ura sulari di Taiwan",
               "CST",
               "Ura ligali di Taiwan",
               "CDT",
               "Ura di Taiwan",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Ura di Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Ura di Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Ura di Wallis e Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Ura sulari Àrabba",
               "",
               "Ura ligali Àrabba",
               "",
               "Ura Àrabba",
               "",
            };
        final String[] Armenia = new String[] {
               "Ura sulari di l’Armenia",
               "",
               "Ura ligali di l’Armenia",
               "",
               "Ura di l’Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Ura dâ Bulivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Ura sulari di Chatham",
               "",
               "Ura ligali di Chatham",
               "",
               "Ura di Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Ura Curdinata Univirsali",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ura di l’Ècuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Ura di Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Ura sulari dâ Giorgia",
               "",
               "Ura ligali dâ Giorgia",
               "",
               "Ura dâ Giorgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Ura sulari di Irtkutsk",
               "",
               "Ura ligali di Irtkutsk",
               "",
               "Ura di Irtkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Ura sulari di Magdan",
               "",
               "Ura ligali di Magdan",
               "",
               "Ura di Magdan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Ura di Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Ura sulari di l’Ìsula Norfolk",
               "",
               "Ura ligali di l’Ìsula Norfolk",
               "",
               "Ura di l’Ìsula Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Ura sulari di Fernando di Noronha",
               "",
               "Ura ligali di Fernando di Noronha",
               "",
               "Ura di Fernando di Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Ura di Réunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Ura di Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Ura di l’Ìsuli Salumuni",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Ura di Tukilau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Ura sulari di l’Uruguay",
               "",
               "Ura ligali di l’Uruguay",
               "",
               "Ura di l’Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Ura sulari di Vanuatu",
               "",
               "Ura ligali di Vanuatu",
               "",
               "Ura di Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Ura sulari di Yakutsk",
               "",
               "Ura ligali di Yakutsk",
               "",
               "Ura di Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Ura sulari di l’Atlànticu",
               "AST",
               "Ura ligali di l’Atlànticu",
               "ADT",
               "Ura di l’Atlànticu",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Ura sulari di Brasilia",
               "",
               "Ura ligali di Brasilia",
               "",
               "Ura di Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Ura di Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Ura sulari dâ Culommia",
               "",
               "Ura ligali dâ Culommia",
               "",
               "Ura dâ Culommia",
               "",
            };
        final String[] Falkland = new String[] {
               "Ura sulari di l’Ìsuli Falkland",
               "",
               "Ura ligali di l’Ìsuli Falkland",
               "",
               "Ura di l’Ìsuli Falkland",
               "",
            };
        final String[] Malaysia = new String[] {
               "Ura dâ Malisia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Ura dî Mardivi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ura sulari di Ulaanbaatar",
               "",
               "Ura ligali di Ulaanbaatar",
               "",
               "Ura di Ulaanbaatar",
               "",
            };
        final String[] Pakistan = new String[] {
               "Ura sulari dû Pàkistan",
               "PKT",
               "Ura ligali dû Pàkistan",
               "PKST",
               "Ura dû Pàkistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Ura sulari dû Paraguay",
               "",
               "Ura ligali dû Paraguay",
               "",
               "Ura dû Paraguay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Ura di Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Ura dû Surinami",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Ura sulari di l’Argintina",
               "",
               "Ura ligali di l’Argintina",
               "",
               "Ura di l’Argintina",
               "",
            };
        final String[] Christmas = new String[] {
               "Ura di l’Ìsula di Natali",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Ura dî Galàpagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland = new String[] {
               "Ura sulari dâ Gruillannia",
               "",
               "Ura ligali dâ Gruillannia",
               "",
               "Ura dâ Gruillannia",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Ura sulari di Hong Kong",
               "HKT",
               "Ura ligali di Hong Kong",
               "HKST",
               "Ura di Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Ura di l’Innucina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Ura dû Kirghìzzistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Ura sulari di Lord Howe",
               "",
               "Ura ligali di Lord Howe",
               "",
               "Ura di Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Ura dî Marchesi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Ura sulari di Mauritius",
               "",
               "Ura ligali di Mauritius",
               "",
               "Ura di Mauritius",
               "",
            };
        final String[] Singapore = new String[] {
               "Ura di Singapuri",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Ura dû Vinizzuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Ura sulari di l’Azerbaijan",
               "",
               "Ura ligali di l’Azerbaijan",
               "",
               "Ura di l’Azerbaijan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Ura sulari dû Bàngladesh",
               "",
               "Ura ligali dû Bàngladesh",
               "",
               "Ura dû Bàngladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Ura sulari di Capu Virdi",
               "",
               "Ura ligali di Capu Virdi",
               "",
               "Ura di Capu Virdi",
               "",
            };
        final String[] East_Timor = new String[] {
               "Ura di Timor di Livanti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Ura dû Kazzàkistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Ura dî Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Ura dû Taggìkistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Ura sulari di l’Uzbèkistan",
               "",
               "Ura ligali di l’Uzbèkistan",
               "",
               "Ura di l’Uzbèkistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Ura di l’Afghànistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Ura sulari di Krasnoyarsk",
               "",
               "Ura ligali di Krasnoyarsk",
               "",
               "Ura di Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Ura sulari dâ Nova Zilannia",
               "NZST",
               "Ura ligali dâ Nova Zilannia",
               "NZDT",
               "Ura dâ Nova Zilannia",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Ura sulari dî Filippini",
               "PST",
               "Ura ligali dî Filippini",
               "PDT",
               "Ura dî Filippini",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Ura sulari di Vladìvustok",
               "",
               "Ura ligali di Vladìvustok",
               "",
               "Ura di Vladìvustok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Ura di l’Ucianu Innianu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Ura di l’Ìsuli Line",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Ura sulari di Tirranova",
               "NST",
               "Ura ligali di Tirranova",
               "NDT",
               "Ura di Tirranova",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Ura sulari dû Turkmènistan",
               "",
               "Ura ligali dû Turkmènistan",
               "",
               "Ura dû Turkmènistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Ura dâ Guiana Francisi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Ura sulari dâ Nova Calidonia",
               "",
               "Ura ligali dâ Nova Calidonia",
               "",
               "Ura dâ Nova Calidonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Ura dâ Giorgia di sciroccu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Ura sulari di Yekatirimmurgu",
               "",
               "Ura ligali di Yekatirimmurgu",
               "",
               "Ura di Yekatirimmurgu",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Ura di l’Àfrica Cintrali",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ura di l’Àfrica di Livanti",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Ura di l’Àfrica di Punenti",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Ura di Dumont d’Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Ura sulari Cintrali Eurupea",
               "CET",
               "Ura ligali Cintrali Eurupea",
               "CEST",
               "Ura Cintrali Eurupea",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Ura sulari di l’Europa di Livanti",
               "EET",
               "Ura ligali di l’Europa di Livanti",
               "EEST",
               "Ura di l’Europa di Livanti",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Ura sulari di l’Europa di Punenti",
               "WET",
               "Ura ligali di l’Europa di Punenti",
               "WEST",
               "Ura di l’Europa di Punenti",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Ura sulari dû Mèssicu Pacìficu",
               "MST",
               "Ura ligali dû Mèssicu Pacìficu",
               "MDT",
               "Ura dû Mèssicu Pacìficu",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Ura Nurmali di l’Àfrica di Sciroccu",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Ura sulari cintrali",
               "CST",
               "Ura ligali cintrali",
               "CDT",
               "Ura cintrali",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Ura sulari livantina",
               "EST",
               "Ura ligali livantina",
               "EDT",
               "Ura livantina",
               "ET",
            };
        final String[] America_Pacific = new String[] {
               "Ura sulari dû Pacìficu",
               "PST",
               "Ura ligali dû Pacìficu",
               "PDT",
               "Ura dû Pacìficu",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Ura Francisi di Sciroccu e di l’Antàrtidi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Ura di l’Ìsuli Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Ura sulari di l’Hawaai",
               "HAST",
               "Ura ligali di l’Hawaai",
               "HADT",
               "Ura di l’Hawaai",
               "HAT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Ura di l’Ìsuli Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Ura sulari di S. Pierre e Miquelon",
               "",
               "Ura ligali di S. Pierre e Miquelon",
               "",
               "Ura di S. Pierre e Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Ura sulari dî muntagni",
               "MST",
               "Ura ligali dî muntagni",
               "MDT",
               "Ura dî muntagni",
               "MT",
            };
        final String[] Marshall_Islands = new String[] {
               "Ura di l’Ìsuli Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Ura dâ Papua Nova Guinìa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Ura sulari di l’Australia cintrali",
               "ACST",
               "Ura ligali di l’Australia cintrali",
               "ACDT",
               "Ura di l’Australia cintrali",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ura sulari di l’Australia di livanti",
               "AEST",
               "Ura ligali di l’Australia di livanti",
               "AEDT",
               "Ura di l’Australia di livanti",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Ura sulari di l’Australia di punenti",
               "AWST",
               "Ura ligali di l’Australia di punenti",
               "AWDT",
               "Ura di l’Australia di punenti",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Ura di l’Innunesia cintrali",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ura di l’Innunesia di livanti",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Ura di l’Innunesia di punenti",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ura sulari di l’Australia cintrali di punenti",
               "",
               "Ura ligali di l’Australia cintrali di punenti",
               "",
               "Ura di l’Australia cintrali di punenti",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Ura Minzana di Greenwich",
                    "GMT",
                    "Ura ligali Britànnica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Ura Curdinata Univirsali",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Ura Minzana di Greenwich",
                    "GMT",
                    "Ura sulari Irlannisi",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Ura Curdinata Univirsali",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Ura Curdinata Univirsali",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Ura Minzana di Greenwich",
                    "GMT",
                    "Ura ligali Britànnica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Ura Curdinata Univirsali",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "Ura Curdinata Univirsali",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "America/Nuuk", Greenland },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Ura Curdinata Univirsali",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Ura Minzana di Greenwich",
                    "GMT",
                    "Ura sulari Irlannisi",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Ura Minzana di Greenwich",
                    "GMT",
                    "Ura ligali Britànnica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Ura Minzana di Greenwich",
                    "GMT",
                    "Ura ligali Britànnica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Ura Minzana di Greenwich",
                    "GMT",
                    "Ura ligali Britànnica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Ura Minzana di Greenwich",
                    "GMT",
                    "Ura ligali Britànnica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Ura Minzana di Greenwich",
                    "GMT",
                    "Ura ligali Britànnica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Scoresbysund", Greenland },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Gaza", "Gazza" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Ammàn" },
            { "timezone.excity.Asia/Dubai", "Dubbai" },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "timezone.excity.Asia/Seoul", "Siul" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Muscat", "Mascati" },
            { "timezone.excity.Etc/Unknown", "Scanusciutu" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Cairu" },
            { "timezone.excity.Africa/Ceuta", "Cèuta" },
            { "timezone.excity.Africa/Tunis", "Tùnisi" },
            { "timezone.excity.Asia/Colombo", "Culummu" },
            { "timezone.excity.Asia/Jakarta", "Giacarta" },
            { "timezone.excity.Asia/Nicosia", "Nicusìa" },
            { "timezone.excity.Europe/Malta", "Mauta" },
            { "timezone.excity.Europe/Paris", "Pariggi" },
            { "timezone.excity.Pacific/Fiji", "Figi" },
            { "timezone.excity.Pacific/Wake", "Ìsula Wake" },
            { "timezone.excity.Asia/Calcutta", "Kurkata" },
            { "timezone.excity.Asia/Damascus", "Damascu" },
            { "timezone.excity.Europe/Athens", "Ateni" },
            { "timezone.excity.Europe/Berlin", "Birlinu" },
            { "timezone.excity.Europe/Dublin", "Dubblinu" },
            { "timezone.excity.Europe/Lisbon", "Lisbona" },
            { "timezone.excity.Europe/London", "Lònnira" },
            { "timezone.excity.Europe/Monaco", "Mònacu" },
            { "timezone.excity.Europe/Moscow", "Mosca" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Warsaw", "Varsavia" },
            { "timezone.excity.Europe/Zagreb", "Zagabbria" },
            { "timezone.excity.Europe/Zurich", "Zurigu" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Algeri" },
            { "timezone.excity.Africa/Nairobi", "Nairobbi" },
            { "timezone.excity.Africa/Tripoli", "Trìpuli" },
            { "timezone.excity.America/Belize", "Bilisi" },
            { "timezone.excity.America/Guyana", "Guiana" },
            { "timezone.excity.America/Panama", "Pànama" },
            { "timezone.excity.America/Regina", "Riggina" },
            { "timezone.excity.Asia/Jerusalem", "Girusalemmi" },
            { "timezone.excity.Asia/Samarkand", "Samarcanna" },
            { "timezone.excity.Asia/Singapore", "Singapuri" },
            { "timezone.excity.Europe/Vatican", "Vaticanu" },
            { "timezone.excity.Pacific/Easter", "Ìsula di Pasca" },
            { "timezone.excity.Pacific/Midway", "Atollu Midway" },
            { "timezone.excity.Pacific/Wallis", "Wallis e Futuna" },
            { "timezone.excity.Africa/Djibouti", "Gibbuti" },
            { "timezone.excity.America/Cordoba", "Còrduba" },
            { "timezone.excity.America/Detroit", "Ditroit" },
            { "timezone.excity.America/Jamaica", "Giamaica" },
            { "timezone.excity.America/Toronto", "Turontu" },
            { "timezone.excity.Atlantic/Azores", "Azzorri" },
            { "timezone.excity.Atlantic/Canary", "Canari" },
            { "timezone.excity.Europe/Belgrade", "Belgradu" },
            { "timezone.excity.Europe/Brussels", "Bruselli" },
            { "timezone.excity.Europe/Helsinki", "Hèlsinki" },
            { "timezone.excity.Europe/Istanbul", "Ìstanbul" },
            { "timezone.excity.Europe/Sarajevo", "Sarajevu" },
            { "timezone.excity.Indian/Maldives", "Mardivi" },
            { "timezone.excity.Africa/Mogadishu", "Mugadisciu" },
            { "timezone.excity.America/Dominica", "Dumìnica" },
            { "timezone.excity.America/New_York", "Nova Jorca" },
            { "timezone.excity.America/St_Lucia", "Santa Lucìa" },
            { "timezone.excity.Antarctica/Casey", "Basi Casey" },
            { "timezone.excity.Antarctica/Syowa", "Basi Showa" },
            { "timezone.excity.Antarctica/Troll", "Basi Troll" },
            { "timezone.excity.Asia/Vladivostok", "Vladìvustok" },
            { "timezone.excity.Atlantic/Bermuda", "Birmuda" },
            { "timezone.excity.Europe/Gibraltar", "Gibbirterra" },
            { "timezone.excity.Europe/Stockholm", "Stuccorma" },
            { "timezone.excity.Europe/Volgograd", "Vòlgugrad" },
            { "timezone.excity.Indian/Christmas", "Natali" },
            { "timezone.excity.Pacific/Pitcairn", "Ìsuli Pitcairn" },
            { "timezone.excity.Africa/Casablanca", "Casabblanca" },
            { "timezone.excity.America/Guatemala", "Guatimala" },
            { "timezone.excity.America/Monterrey", "Muntirrei" },
            { "timezone.excity.America/Sao_Paulo", "San Paulu" },
            { "timezone.excity.Antarctica/Mawson", "Basi Mawson" },
            { "timezone.excity.Antarctica/Palmer", "Terra di Palmer" },
            { "timezone.excity.Antarctica/Vostok", "Basi Vostok" },
            { "timezone.excity.Europe/Luxembourg", "Lussimmurgu" },
            { "timezone.excity.Europe/San_Marino", "San Marinu" },
            { "timezone.excity.Pacific/Galapagos", "Galàpagos" },
            { "timezone.excity.Pacific/Marquesas", "Ìsuli Marchesi" },
            { "timezone.excity.America/Costa_Rica", "Custa Rica" },
            { "timezone.excity.America/Guadeloupe", "Guadalupa" },
            { "timezone.excity.America/Martinique", "Martinica" },
            { "timezone.excity.America/Montserrat", "Munzirratu" },
            { "timezone.excity.Antarctica/McMurdo", "Basi McMurdo" },
            { "timezone.excity.Antarctica/Rothera", "Basi Rothera" },
            { "timezone.excity.Asia/Yekaterinburg", "Yekatirimmurgu" },
            { "timezone.excity.Atlantic/St_Helena", "Sant’Èlina" },
            { "timezone.excity.Australia/Adelaide", "Adilaidi" },
            { "timezone.excity.Europe/Isle_of_Man", "Ìsula di Man" },
            { "timezone.excity.America/Mexico_City", "Cità dû Mèssicu" },
            { "timezone.excity.America/Puerto_Rico", "Portu Ricu" },
            { "timezone.excity.Atlantic/Cape_Verde", "Capu Virdi" },
            { "timezone.excity.America/Campo_Grande", "Campu Granni" },
            { "timezone.excity.America/Port_of_Spain", "Portu di Spagna" },
            { "timezone.excity.America/Santo_Domingo", "Santu Dumingu" },
            { "timezone.excity.Atlantic/South_Georgia", "Giorgia di sciroccu" },
            { "timezone.excity.Antarctica/DumontDUrville", "Basi Dumont d’Urville" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota di Tramuntana" },
            { "timezone.excity.America/North_Dakota/Center", "Centru, Dakota di Tramuntana" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dakota di Tramuntana" },
        };
        return data;
    }
}
