// Code generated by sdkgen-v2. DO NOT EDIT.
package iamsdk

import (
	"context"

	iam "github.com/yandex-cloud/go-genproto/yandex/cloud/iam/v1"
	"github.com/yandex-cloud/go-sdk/v2/pkg/transport"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/reflect/protoreflect"
)

// IamTokenClient provides methods for managing IamToken resources of Yandex.Cloud IAM.
type IamTokenClient interface {
	Create(context.Context, *iam.CreateIamTokenRequest, ...grpc.CallOption) (*iam.CreateIamTokenResponse, error)
	CreateForServiceAccount(context.Context, *iam.CreateIamTokenForServiceAccountRequest, ...grpc.CallOption) (*iam.CreateIamTokenResponse, error)
	Revoke(context.Context, *iam.RevokeIamTokenRequest, ...grpc.CallOption) (*iam.RevokeIamTokenResponse, error)
}

var _ IamTokenClient = iamTokenClient{}

type iamTokenClient struct {
	connector transport.Connector
}

// NewIamTokenClient returns IamTokenClient implementation.
func NewIamTokenClient(connector transport.Connector) IamTokenClient {
	return iamTokenClient{connector}
}

// Create is an operation of Yandex.Cloud IAM IamToken service.
func (c iamTokenClient) Create(ctx context.Context, in *iam.CreateIamTokenRequest, opts ...grpc.CallOption) (*iam.CreateIamTokenResponse, error) {
	connection, err := c.connector.GetConnection(ctx, IamTokenCreate, opts...)
	if err != nil {
		return nil, err
	}
	return iam.NewIamTokenServiceClient(connection).Create(ctx, in, opts...)
}

// CreateForServiceAccount is an operation of Yandex.Cloud IAM IamToken service.
func (c iamTokenClient) CreateForServiceAccount(ctx context.Context, in *iam.CreateIamTokenForServiceAccountRequest, opts ...grpc.CallOption) (*iam.CreateIamTokenResponse, error) {
	connection, err := c.connector.GetConnection(ctx, IamTokenCreateForServiceAccount, opts...)
	if err != nil {
		return nil, err
	}
	return iam.NewIamTokenServiceClient(connection).CreateForServiceAccount(ctx, in, opts...)
}

// Revoke is an operation of Yandex.Cloud IAM IamToken service.
func (c iamTokenClient) Revoke(ctx context.Context, in *iam.RevokeIamTokenRequest, opts ...grpc.CallOption) (*iam.RevokeIamTokenResponse, error) {
	connection, err := c.connector.GetConnection(ctx, IamTokenRevoke, opts...)
	if err != nil {
		return nil, err
	}
	return iam.NewIamTokenServiceClient(connection).Revoke(ctx, in, opts...)
}

var (
	IamTokenCreate                  = protoreflect.FullName("yandex.cloud.iam.v1.IamTokenService.Create")
	IamTokenCreateForServiceAccount = protoreflect.FullName("yandex.cloud.iam.v1.IamTokenService.CreateForServiceAccount")
	IamTokenRevoke                  = protoreflect.FullName("yandex.cloud.iam.v1.IamTokenService.Revoke")
)
