/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.sddp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.net.StandardSocketOptions;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.discovery.AbstractDiscoveryService;
import org.openhab.core.config.discovery.DiscoveryResult;
import org.openhab.core.config.discovery.DiscoveryService;
import org.openhab.core.config.discovery.sddp.SddpDevice;
import org.openhab.core.config.discovery.sddp.SddpDeviceParticipant;
import org.openhab.core.config.discovery.sddp.SddpDiscoveryParticipant;
import org.openhab.core.i18n.LocaleProvider;
import org.openhab.core.i18n.TranslationProvider;
import org.openhab.core.net.CidrAddress;
import org.openhab.core.net.NetworkAddressChangeListener;
import org.openhab.core.net.NetworkAddressService;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.ThingUID;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={DiscoveryService.class}, property={"protocol=sddp"}, configurationPid={"discovery.sddp"})
public class SddpDiscoveryService
extends AbstractDiscoveryService
implements AutoCloseable,
NetworkAddressChangeListener {
    private static final int SDDP_PORT = 1902;
    private static final String SDDP_IP_ADDRESS = "239.255.255.250";
    private static final InetSocketAddress SDDP_GROUP = new InetSocketAddress("239.255.255.250", 1902);
    private static final int READ_BUFFER_SIZE = 1024;
    private static final Duration SOCKET_TIMOUT = Duration.ofMillis(1000L);
    private static final Duration SEARCH_LISTEN_DURATION = Duration.ofSeconds(5L);
    private static final Duration CACHE_PURGE_INTERVAL = Duration.ofSeconds(300L);
    private static final String SEARCH_REQUEST_BODY_FORMAT = "SEARCH * SDDP/1.0\r\nHost: \"%s:%d\"\r\n";
    private static final String SEARCH_RESPONSE_HEADER = "SDDP/1.0 200 OK";
    private static final String NOTIFY_ALIVE_HEADER = "NOTIFY ALIVE SDDP/1.0";
    private static final String NOTIFY_IDENTIFY_HEADER = "NOTIFY IDENTIFY SDDP/1.0";
    private static final String NOTIFY_OFFLINE_HEADER = "NOTIFY OFFLINE SDDP/1.0";
    private final Logger logger = LoggerFactory.getLogger(SddpDiscoveryService.class);
    private final Set<SddpDevice> foundDevicesCache = ConcurrentHashMap.newKeySet();
    private final Set<SddpDiscoveryParticipant> discoveryParticipants = ConcurrentHashMap.newKeySet();
    private final Set<SddpDeviceParticipant> deviceParticipants = ConcurrentHashMap.newKeySet();
    private final NetworkAddressService networkAddressService;
    private boolean closing = false;
    private @Nullable Future<?> listenBackgroundMulticastTask = null;
    private @Nullable Future<?> listenActiveScanUnicastTask = null;
    private @Nullable ScheduledFuture<?> purgeExpiredDevicesTask = null;

    @Activate
    public SddpDiscoveryService(@Nullable Map<String, Object> configProperties, @Reference NetworkAddressService networkAddressService, @Reference TranslationProvider i18nProvider, @Reference LocaleProvider localeProvider) {
        super((int)SEARCH_LISTEN_DURATION.getSeconds());
        this.networkAddressService = networkAddressService;
        this.i18nProvider = i18nProvider;
        this.localeProvider = localeProvider;
        super.activate(configProperties);
        this.purgeExpiredDevicesTask = this.scheduler.scheduleWithFixedDelay(() -> this.purgeExpiredDevices(), CACHE_PURGE_INTERVAL.getSeconds(), CACHE_PURGE_INTERVAL.getSeconds(), TimeUnit.SECONDS);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addSddpDeviceParticipant(SddpDeviceParticipant participant) {
        this.deviceParticipants.add(participant);
        this.foundDevicesCache.stream().filter(d -> !d.isExpired()).forEach(d -> participant.deviceAdded((SddpDevice)d));
        this.startScan();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addSddpDiscoveryParticipant(SddpDiscoveryParticipant participant) {
        this.discoveryParticipants.add(participant);
        this.foundDevicesCache.stream().filter(d -> !d.isExpired()).forEach(d -> {
            DiscoveryResult result = participant.createResult((SddpDevice)d);
            if (result != null) {
                DiscoveryResult localizedResult = this.getLocalizedDiscoveryResult(result, FrameworkUtil.getBundle(participant.getClass()));
                this.thingDiscovered(localizedResult);
            }
        });
    }

    private void cancelTask(@Nullable Future<?> task) {
        if (task != null) {
            task.cancel(true);
        }
    }

    @Override
    public void close() {
        this.deactivate();
    }

    public Optional<SddpDevice> createSddpDevice(String data) {
        String statement;
        boolean offline;
        List<String> lines;
        if (!data.isBlank() && (lines = data.lines().toList()).size() > 1 && ((offline = (statement = lines.getFirst().strip()).startsWith(NOTIFY_OFFLINE_HEADER)) || statement.startsWith(NOTIFY_ALIVE_HEADER) || statement.startsWith(NOTIFY_IDENTIFY_HEADER) || statement.startsWith(SEARCH_RESPONSE_HEADER))) {
            HashMap<String, String> headers = new HashMap<String, String>();
            int i = 1;
            while (i < lines.size()) {
                String[] header = lines.get(i).split(":", 2);
                if (header.length > 1) {
                    headers.put(header[0].strip(), header[1].strip());
                }
                ++i;
            }
            return Optional.of(new SddpDevice(headers, offline));
        }
        return Optional.empty();
    }

    @Deactivate
    protected void deactivate() {
        this.closing = true;
        this.foundDevicesCache.clear();
        this.discoveryParticipants.clear();
        this.deviceParticipants.clear();
        super.deactivate();
        this.cancelTask(this.listenActiveScanUnicastTask);
        this.listenActiveScanUnicastTask = null;
        this.cancelTask(this.purgeExpiredDevicesTask);
        this.purgeExpiredDevicesTask = null;
    }

    public Set<ThingTypeUID> getSupportedThingTypes() {
        HashSet<ThingTypeUID> supportedThingTypes = new HashSet<ThingTypeUID>();
        this.discoveryParticipants.forEach(p -> {
            boolean bl = supportedThingTypes.addAll(p.getSupportedThingTypeUIDs());
        });
        return supportedThingTypes;
    }

    private void listenBackGroundMulticast() {
        block18: {
            MulticastSocket socket = null;
            NetworkInterface networkInterface = null;
            try {
                try {
                    networkInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(this.networkAddressService.getPrimaryIpv4HostAddress()));
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("listenBackGroundMulticast() starting on interface '{}'", (Object)networkInterface.getDisplayName());
                    }
                    socket = new MulticastSocket(1902);
                    socket.joinGroup(SDDP_GROUP, networkInterface);
                    socket.setSoTimeout((int)SOCKET_TIMOUT.toMillis());
                    DatagramPacket packet = null;
                    byte[] buffer = new byte[1024];
                    while (!Thread.currentThread().isInterrupted()) {
                        try {
                            if (packet == null) {
                                packet = new DatagramPacket(buffer, buffer.length);
                            }
                            socket.receive(packet);
                            this.processPacket(packet);
                            packet = null;
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            // empty catch block
                        }
                    }
                }
                catch (IOException e) {
                    block19: {
                        if (!this.closing) {
                            this.logger.warn("listenBackGroundMulticast error '{}'", (Object)e.getMessage());
                        }
                        if (socket == null || networkInterface == null) break block18;
                        try {
                            socket.leaveGroup(SDDP_GROUP, networkInterface);
                        }
                        catch (IOException e2) {
                            if (this.closing) break block19;
                            this.logger.warn("listenBackGroundMulticast() error '{}'", (Object)e2.getMessage());
                        }
                    }
                    socket.close();
                }
            }
            finally {
                if (socket != null && networkInterface != null) {
                    block20: {
                        try {
                            socket.leaveGroup(SDDP_GROUP, networkInterface);
                        }
                        catch (IOException e) {
                            if (this.closing) break block20;
                            this.logger.warn("listenBackGroundMulticast() error '{}'", (Object)e.getMessage());
                        }
                    }
                    socket.close();
                }
            }
        }
    }

    private void listenActiveScanUnicast() {
        block28: {
            int port;
            Object var3_6;
            try {
                Throwable throwable = null;
                var3_6 = null;
                try (ServerSocket portFinder = new ServerSocket(0);){
                    port = portFinder.getLocalPort();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.logger.warn("listenActiveScanUnicast() port finder error '{}'", (Object)e.getMessage());
                return;
            }
            try {
                Throwable e = null;
                var3_6 = null;
                try (DatagramSocket socket = new DatagramSocket(port);){
                    String ipAddress = this.networkAddressService.getPrimaryIpv4HostAddress();
                    NetworkInterface networkInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(ipAddress));
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("listenActiveScanUnicast() starting on '{}:{}' on interface '{}'", new Object[]{ipAddress, port, networkInterface.getDisplayName()});
                    }
                    socket.setOption(StandardSocketOptions.IP_MULTICAST_IF, networkInterface);
                    socket.setSoTimeout((int)SOCKET_TIMOUT.toMillis());
                    String search = String.format(SEARCH_REQUEST_BODY_FORMAT, ipAddress, port);
                    byte[] buffer = search.getBytes(StandardCharsets.UTF_8);
                    DatagramPacket packet = new DatagramPacket(buffer, buffer.length, new InetSocketAddress(SDDP_IP_ADDRESS, 1902));
                    socket.send(packet);
                    this.logger.trace("Packet sent to '{}:{}' content:\r\n{}", new Object[]{SDDP_IP_ADDRESS, 1902, search});
                    Instant listenDoneTime = Instant.now().plus(SEARCH_LISTEN_DURATION);
                    buffer = new byte[1024];
                    packet = null;
                    while (Instant.now().isBefore(listenDoneTime) && !Thread.currentThread().isInterrupted()) {
                        try {
                            if (packet == null) {
                                packet = new DatagramPacket(buffer, buffer.length);
                            }
                            socket.receive(packet);
                            this.processPacket(packet);
                            packet = null;
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                if (this.closing) break block28;
                this.logger.warn("listenActiveScanUnicast() error '{}'", (Object)e.getMessage());
            }
        }
    }

    @Modified
    protected void modified(@Nullable Map<String, Object> configProperties) {
        super.modified(configProperties);
    }

    public synchronized void onChanged(List<CidrAddress> added, List<CidrAddress> removed) {
        Future<?> unicastTask;
        Future<?> multicastTask = this.listenBackgroundMulticastTask;
        if (multicastTask != null && !multicastTask.isDone()) {
            multicastTask.cancel(true);
            this.listenBackgroundMulticastTask = this.scheduler.submit(() -> this.listenBackGroundMulticast());
        }
        if ((unicastTask = this.listenActiveScanUnicastTask) != null && !unicastTask.isDone()) {
            unicastTask.cancel(true);
            this.listenActiveScanUnicastTask = this.scheduler.submit(() -> this.listenActiveScanUnicast());
        }
    }

    private synchronized void processPacket(DatagramPacket packet) {
        Optional<SddpDevice> deviceOptional;
        String content = new String(packet.getData(), 0, packet.getLength(), StandardCharsets.UTF_8);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Packet received from '{}:{}' content:\r\n{}", new Object[]{packet.getAddress().getHostAddress(), packet.getPort(), content});
        }
        if ((deviceOptional = this.createSddpDevice(content)).isPresent()) {
            SddpDevice device = deviceOptional.get();
            this.foundDevicesCache.remove(device);
            if (device.isExpired()) {
                this.discoveryParticipants.forEach(p -> {
                    DiscoveryResult discoveryResult = p.createResult(device);
                    if (discoveryResult != null) {
                        this.thingRemoved(discoveryResult.getThingUID());
                    }
                });
                this.deviceParticipants.forEach(f -> f.deviceRemoved(device));
            } else {
                this.foundDevicesCache.add(device);
                this.discoveryParticipants.forEach(p -> {
                    DiscoveryResult discoveryResult = p.createResult(device);
                    if (discoveryResult != null) {
                        DiscoveryResult localizedResult = this.getLocalizedDiscoveryResult(discoveryResult, FrameworkUtil.getBundle(p.getClass()));
                        this.thingDiscovered(localizedResult);
                    }
                });
                this.deviceParticipants.forEach(f -> f.deviceAdded(device));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("processPacket() foundDevices={}, deviceParticipants={}, discoveryParticipants={}", new Object[]{this.foundDevicesCache.size(), this.deviceParticipants.size(), this.discoveryParticipants.size()});
            }
        }
    }

    private synchronized void purgeExpiredDevices() {
        HashSet<SddpDevice> devices = new HashSet<SddpDevice>(this.foundDevicesCache);
        devices.stream().filter(d -> d.isExpired()).forEach(d -> {
            this.discoveryParticipants.forEach(p -> {
                ThingUID thingUID = p.getThingUID((SddpDevice)d);
                if (thingUID != null) {
                    this.thingRemoved(thingUID);
                }
            });
            this.deviceParticipants.forEach(f -> f.deviceRemoved((SddpDevice)d));
        });
        this.foundDevicesCache.clear();
        this.foundDevicesCache.addAll(devices.stream().filter(d -> !d.isExpired()).collect(Collectors.toSet()));
    }

    public void removeSddpDeviceParticipant(SddpDeviceParticipant participant) {
        this.deviceParticipants.remove(participant);
    }

    public void removeSddpDiscoveryParticipant(SddpDiscoveryParticipant participant) {
        this.discoveryParticipants.remove(participant);
    }

    protected void startBackgroundDiscovery() {
        Future<?> task = this.listenBackgroundMulticastTask;
        if (task == null || task.isDone()) {
            this.listenBackgroundMulticastTask = this.scheduler.submit(() -> this.listenBackGroundMulticast());
        }
    }

    protected void startScan() {
        Future<?> task = this.listenActiveScanUnicastTask;
        if (task == null || task.isDone()) {
            this.listenActiveScanUnicastTask = this.scheduler.submit(() -> this.listenActiveScanUnicast());
        }
    }

    protected void stopBackgroundDiscovery() {
        this.cancelTask(this.listenBackgroundMulticastTask);
        this.listenBackgroundMulticastTask = null;
    }
}

