/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.util.List;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.manager.api.SendMessageResults;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.util.CommandUtil;
import org.asamk.signal.util.SendMessageResultUtils;

public class SendReceiptCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "sendReceipt";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Send a read or viewed receipt to a previously received message.");
        subparser.addArgument(new String[]{"recipient"}).help("Specify the sender's phone number.").required(true);
        subparser.addArgument(new String[]{"-t", "--target-timestamp"}).type(Long.TYPE).nargs("+").required(true).help("Specify the timestamp of the messages for which a receipt should be sent.");
        subparser.addArgument(new String[]{"--type"}).help("Specify the receipt type (default is read receipt).").choices((Object[])new String[]{"read", "viewed"});
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        SendMessageResults results;
        String recipientString = ns.getString("recipient");
        RecipientIdentifier.Single recipient = CommandUtil.getSingleRecipientIdentifier(recipientString, m.getSelfNumber());
        List targetTimestamps = ns.getList("target-timestamp");
        String type = ns.getString("type");
        if (type == null || "read".equals(type)) {
            results = m.sendReadReceipt(recipient, targetTimestamps);
        } else if ("viewed".equals(type)) {
            results = m.sendViewedReceipt(recipient, targetTimestamps);
        } else {
            throw new UserErrorException("Unknown receipt type: " + type);
        }
        SendMessageResultUtils.outputResult(outputWriter, results);
    }
}

