/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.Base64;
import java.util.Objects;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.UnexpectedErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.json.JsonAttachmentData;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.StickerPackId;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriter;
import org.asamk.signal.util.Hex;

public class GetStickerCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "getSticker";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Retrieve the sticker of a sticker pack base64 encoded.");
        subparser.addArgument(new String[]{"--pack-id"}).required(true).help("The ID of the sticker pack.");
        subparser.addArgument(new String[]{"--sticker-id"}).type(Integer.TYPE).required(true).help("The ID of the sticker.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        StickerPackId packId = StickerPackId.deserialize((byte[])Hex.toByteArray(ns.getString("pack-id")));
        Integer stickerId = ns.getInt("sticker-id");
        try (InputStream data = m.retrieveSticker(packId, stickerId.intValue());){
            byte[] bytes = data.readAllBytes();
            String base64 = Base64.getEncoder().encodeToString(bytes);
            OutputWriter outputWriter2 = outputWriter;
            Objects.requireNonNull(outputWriter2);
            OutputWriter outputWriter3 = outputWriter2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlainTextWriter.class, JsonWriter.class}, (Object)outputWriter3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    PlainTextWriter writer = (PlainTextWriter)outputWriter3;
                    writer.println(base64, new Object[0]);
                    return;
                }
                case 1: {
                    JsonWriter writer = (JsonWriter)outputWriter3;
                    writer.write(new JsonAttachmentData(base64));
                    return;
                }
            }
        }
        catch (FileNotFoundException ex) {
            throw new UserErrorException("Could not find sticker with ID: " + stickerId + " in pack " + String.valueOf(packId), ex);
        }
        catch (IOException ex) {
            throw new UnexpectedErrorException("An error occurred reading sticker with ID: " + stickerId + " in pack " + String.valueOf(packId), ex);
        }
    }
}

