# Announce: Rakudo compiler, Release #169 (2024.02)

On behalf of the Rakudo development team, I’m very happy to announce the
February 2024 release of Rakudo #169. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2024.02:

+ Improvements:
    + Better errors for common array parameter mistakes [47fb8c35]
    + Improve stability in heavy async situations [761153bc][5c289878]

+ Additions:
    + Add Int/Real coercing versions of `infix:<div|mod>` [71c0151a]
    + Implement sub form of &trans, mainly to support feed operators [b238fad8]
    + Provide native int coercers to Int/Cool [a67842ac][1eaa9d71][dc5414d6]

+ Fixes:
    + Avoid leaking repo.lock handle [155818f4][e6207699][7ca96bbd][a723c387]

+ Deprecations:

+ Internal:
    * Document and/or streamline dispatchers and related [d176728c][78d4fbc0]
      [344f7978][e6fd943f][02bc10c2][ccbe370a][07049e7f][b151e2d7][35760ceb]
    * Streamline "core" (bootstrap, core, metamodel) [51297879][bae06a2c]
      [6117df24][e93208ce][b0dd4ef4][6b231533][024212cd][8e840a51][19da50e3]
      [88151678][975b6634][1dfd7b4b][9f0d361b][80ac4336][760e7a72][eef53371]
      [02aaf9e9][0b759a7a][614571d2][67153138][4c86ef77][dab2c235][c944dae4]
      [2e4113c5][69877047][d49cd4e0][9a828454][de923f1b][1ce9b4c6][3c9f07a8]
      [24a1e67c][4181d461][2c64cbc7][4f64b487][5585454f][cf773dc2][68cd850f]
      [fd936efe][04229899][3c218265][192d7d0a][3271329c][71dcfd42][52dfda3f]
      [b720babd][9f7a3419]

+ RakuAST Development:
    + RakuAST: some nano optimizations [9478d5c7]

The following people contributed to this release:

Elizabeth Mattijsen, Daniel Green, Vadim Belman, Nick Logan,
Richard Hainsworth, Rajashekar R M, Stefan Seifert, Wenzel P. P. Peppmeyer,
Jan-Olof Hendig, Justin DeVuyst, Stéphane Payrard, Will Coleda, rir

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2024 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on Libera.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#170), is tentatively scheduled for 2024-03-28.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
