#!/bin/bash
# This script automates the process of updating Certbot's dependencies
# including automatically updating the correct file. It is usually run without
# any arguments, but if any are provided, they will be passed to Poetry.
# Dependencies can be pinned to older versions by modifying pyproject.toml in
# the same directory as this file.
set -euo pipefail

WORK_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null && pwd )"
COMMON_DIR="$(dirname "${WORK_DIR}")/common"
REPO_ROOT="$(git rev-parse --show-toplevel)"
if ! RELATIVE_WORK_DIR="$(realpath --relative-to "$REPO_ROOT" "$WORK_DIR")"; then
    echo this script needs GNU coreutils to be first in your PATH rather than macOS/BSD versions
    exit 1
fi
RELATIVE_SCRIPT_PATH="$RELATIVE_WORK_DIR/$(basename "${BASH_SOURCE[0]}")"
CONSTRAINTS_FILE="$REPO_ROOT/tools/oldest_constraints.txt"

PINNINGS=$("${COMMON_DIR}/export-pinned-dependencies.sh" "${WORK_DIR}" "$@")
cat << EOF > "$CONSTRAINTS_FILE"
# This file was generated by $RELATIVE_SCRIPT_PATH and can be updated using
# that script.
EOF
echo "${PINNINGS}" >> "${CONSTRAINTS_FILE}"
