/*
 * Decompiled with CFR 0.152.
 */
package org.hampelratte.svdrp.parsers;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.hampelratte.svdrp.responses.highlevel.EPGEntry;
import org.hampelratte.svdrp.responses.highlevel.Genre;
import org.hampelratte.svdrp.responses.highlevel.GenreTable;
import org.hampelratte.svdrp.responses.highlevel.Stream;

public class EPGParser {
    protected String currentChannelID;
    protected String currentChannelName;
    protected EPGEntry epg;
    protected List<EPGEntry> list;
    private final GenreTable genreTable = new GenreTable();

    public List<EPGEntry> parse(String epgData) {
        this.currentChannelID = null;
        this.currentChannelName = null;
        this.epg = null;
        this.list = new ArrayList<EPGEntry>();
        StringTokenizer st = new StringTokenizer(epgData, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.startsWith("End")) {
                return this.list;
            }
            this.parseLine(line, this.list);
        }
        return this.list;
    }

    protected void parseLine(String line, List<EPGEntry> list) {
        switch (line.charAt(0)) {
            case 'C': {
                int start = line.indexOf(32) + 1;
                int stop = line.indexOf(32, start + 1);
                stop = stop > 0 ? stop : line.length();
                this.currentChannelID = line.substring(start, stop);
                if (stop >= line.length()) break;
                start = stop + 1;
                this.currentChannelName = line.substring(start, line.length());
                break;
            }
            case 'E': {
                this.epg = this.createNewEpgEntry();
                this.epg.setChannelID(this.currentChannelID);
                this.epg.setChannelName(this.currentChannelName);
                StringTokenizer lt = new StringTokenizer(line, " ");
                lt.nextToken();
                this.epg.setEventID(Long.parseLong(lt.nextToken()));
                int startTime = Integer.parseInt(lt.nextToken());
                int duration = Integer.parseInt(lt.nextToken());
                int endTime = startTime + duration;
                this.epg.setStartTime((long)startTime * 1000L);
                this.epg.setEndTime((long)endTime * 1000L);
                this.epg.setTableID(Integer.parseInt(lt.nextToken(), 16));
                if (!lt.hasMoreElements()) break;
                this.epg.setVersion(Integer.parseInt(lt.nextToken(), 16));
                break;
            }
            case 'T': {
                this.epg.setTitle(line.substring(2));
                break;
            }
            case 'S': {
                String shorttext = line.substring(2).replace('|', '\n');
                this.epg.setShortText(shorttext);
                break;
            }
            case 'D': {
                String desc = line.substring(2).replace('|', '\n');
                this.epg.setDescription(desc);
                break;
            }
            case 'V': {
                int vps = Integer.parseInt(line.substring(2));
                this.epg.setVpsTime((long)vps * 1000L);
                break;
            }
            case 'X': {
                StringTokenizer lt = new StringTokenizer(line, " ");
                lt.nextToken();
                int content = Integer.parseInt(lt.nextToken(), 16);
                int type = Integer.parseInt(lt.nextToken(), 16);
                String iso3code = lt.nextToken();
                String desc = "N/A";
                if (lt.hasMoreElements()) {
                    desc = lt.nextToken();
                    while (lt.hasMoreElements()) {
                        desc = desc + ' ' + lt.nextToken();
                    }
                }
                Stream stream = new Stream();
                switch (content) {
                    case 1: {
                        stream.setContent(Stream.CONTENT.MP2V);
                        break;
                    }
                    case 2: {
                        stream.setContent(Stream.CONTENT.MP2A);
                        break;
                    }
                    case 3: {
                        stream.setContent(Stream.CONTENT.SUBTITLE);
                        break;
                    }
                    case 4: {
                        stream.setContent(Stream.CONTENT.AC3);
                        break;
                    }
                    case 5: {
                        stream.setContent(Stream.CONTENT.H264);
                        break;
                    }
                    case 6: {
                        stream.setContent(Stream.CONTENT.HEAAC);
                        break;
                    }
                    default: {
                        stream.setContent(Stream.CONTENT.UNKNOWN);
                    }
                }
                stream.setType(type);
                stream.setLanguage(iso3code);
                stream.setDescription(desc);
                this.epg.getStreams().add(stream);
                break;
            }
            case 'G': {
                StringTokenizer lt = new StringTokenizer(line, " ");
                lt.nextToken();
                while (lt.hasMoreElements()) {
                    int genreCode = Integer.parseInt(lt.nextToken(), 16);
                    Genre genre = (Genre)this.genreTable.get(genreCode);
                    if (genre == null) continue;
                    this.epg.getGenres().add(genre);
                }
                break;
            }
            case 'e': {
                list.add(this.epg);
                this.epg = null;
                break;
            }
            case 'c': {
                break;
            }
        }
    }

    protected EPGEntry createNewEpgEntry() {
        return new EPGEntry();
    }
}

