/*
    SPDX-FileCopyrightText: 2010 Friedrich W. H. Kossebau <kossebau@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef KASTEN_STRUCTURESTOOLVIEWFACTORY_HPP
#define KASTEN_STRUCTURESTOOLVIEWFACTORY_HPP

// lib
#include "oktetakastencontrollers_export.hpp"
// Kasten gui
#include <Kasten/AbstractToolViewFactory>

namespace Kasten {

class OKTETAKASTENCONTROLLERS_EXPORT StructuresToolViewFactory : public AbstractToolViewFactory
{
public:
    StructuresToolViewFactory();
    StructuresToolViewFactory(const StructuresToolViewFactory&) = delete;
    StructuresToolViewFactory(StructuresToolViewFactory&&) = delete;

    ~StructuresToolViewFactory() override;

    StructuresToolViewFactory& operator=(const StructuresToolViewFactory&) = delete;
    StructuresToolViewFactory& operator=(StructuresToolViewFactory&&) = delete;

public: // AbstractToolViewFactory API
    [[nodiscard]]
    std::unique_ptr<AbstractToolView> create(AbstractTool* tool) const override;

    [[nodiscard]]
    QString iconName() const override;
    [[nodiscard]]
    QString title() const override;
    [[nodiscard]]
    QString id() const override;
    [[nodiscard]]
    SidePosition defaultPosition() const override;
};

}

#endif
