// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
//
//  <auto-generated>
//      This code was generated by a tool. DO NOT EDIT
//
//      Changes to this file may cause incorrect behavior and will be lost if
//      the code is regenerated.
//  </auto-generated>

#region StyleCop Suppression - generated code
using System;
using System.Collections;
using System.ComponentModel;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Data;
using System.Windows.Input;

namespace Microsoft.Management.UI.Internal
{

    /// <summary>
    /// This control presents a dropdown listbox with associated organizing actions that can be performed on it.
    /// </summary>
    /// <remarks>
    ///
    ///
    /// If a custom template is provided for this control, then the template MUST provide the following template parts:
    ///
    ///     PART_Picker - A required template part which must be of type PickerBase.  This control provides basic functionality for Picker-like controls.
    ///
    /// </remarks>
    [TemplatePart(Name="PART_Picker", Type=typeof(PickerBase))]
    [Localizability(LocalizationCategory.None)]
    partial class ListOrganizer
    {
        //
        // Fields
        //
        private PickerBase picker;

        //
        // ItemDeleted RoutedEvent
        //
        /// <summary>
        /// Identifies the ItemDeleted RoutedEvent.
        /// </summary>
        public static readonly RoutedEvent ItemDeletedEvent = EventManager.RegisterRoutedEvent("ItemDeleted",RoutingStrategy.Bubble,typeof(EventHandler<DataRoutedEventArgs<object>>),typeof(ListOrganizer));

        /// <summary>
        /// Occurs when an item is deleted from the list.
        /// </summary>
        public event EventHandler<DataRoutedEventArgs<object>> ItemDeleted
        {
            add
            {
                AddHandler(ItemDeletedEvent,value);
            }
            remove
            {
                RemoveHandler(ItemDeletedEvent,value);
            }
        }

        //
        // ItemSelected RoutedEvent
        //
        /// <summary>
        /// Identifies the ItemSelected RoutedEvent.
        /// </summary>
        public static readonly RoutedEvent ItemSelectedEvent = EventManager.RegisterRoutedEvent("ItemSelected",RoutingStrategy.Bubble,typeof(EventHandler<DataRoutedEventArgs<object>>),typeof(ListOrganizer));

        /// <summary>
        /// Occurs when an item is selected in the list.
        /// </summary>
        public event EventHandler<DataRoutedEventArgs<object>> ItemSelected
        {
            add
            {
                AddHandler(ItemSelectedEvent,value);
            }
            remove
            {
                RemoveHandler(ItemSelectedEvent,value);
            }
        }

        //
        // DeleteItem routed command
        //
        /// <summary>
        /// Informs the ListOrganizer that it should delete the item passed.
        /// </summary>
        public static readonly RoutedCommand DeleteItemCommand = new RoutedCommand("DeleteItem",typeof(ListOrganizer));

        static private void DeleteItemCommand_CommandExecuted(object sender, ExecutedRoutedEventArgs e)
        {
            ListOrganizer obj = (ListOrganizer) sender;
            obj.OnDeleteItemExecuted( e );
        }

        /// <summary>
        /// Called when DeleteItem executes.
        /// </summary>
        /// <remarks>
        /// Informs the ListOrganizer that it should delete the item passed.
        /// </remarks>
        protected virtual void OnDeleteItemExecuted(ExecutedRoutedEventArgs e)
        {
            OnDeleteItemExecutedImplementation(e);
        }

        partial void OnDeleteItemExecutedImplementation(ExecutedRoutedEventArgs e);

        //
        // SelectItem routed command
        //
        /// <summary>
        /// Informs the ListOrganizer that it should select the item passed.
        /// </summary>
        public static readonly RoutedCommand SelectItemCommand = new RoutedCommand("SelectItem",typeof(ListOrganizer));

        static private void SelectItemCommand_CommandExecuted(object sender, ExecutedRoutedEventArgs e)
        {
            ListOrganizer obj = (ListOrganizer) sender;
            obj.OnSelectItemExecuted( e );
        }

        /// <summary>
        /// Called when SelectItem executes.
        /// </summary>
        /// <remarks>
        /// Informs the ListOrganizer that it should select the item passed.
        /// </remarks>
        protected virtual void OnSelectItemExecuted(ExecutedRoutedEventArgs e)
        {
            OnSelectItemExecutedImplementation(e);
        }

        partial void OnSelectItemExecutedImplementation(ExecutedRoutedEventArgs e);

        //
        // DropDownButtonTemplate dependency property
        //
        /// <summary>
        /// Identifies the DropDownButtonTemplate dependency property.
        /// </summary>
        public static readonly DependencyProperty DropDownButtonTemplateProperty = DependencyProperty.Register( "DropDownButtonTemplate", typeof(ControlTemplate), typeof(ListOrganizer), new PropertyMetadata( null, DropDownButtonTemplateProperty_PropertyChanged) );

        /// <summary>
        /// Gets or sets a value that controls the visual tree of the DropDown button.
        /// </summary>
        [Bindable(true)]
        [Category("Common Properties")]
        [Description("Gets or sets a value that controls the visual tree of the DropDown button.")]
        [Localizability(LocalizationCategory.None)]
        public ControlTemplate DropDownButtonTemplate
        {
            get
            {
                return (ControlTemplate) GetValue(DropDownButtonTemplateProperty);
            }
            set
            {
                SetValue(DropDownButtonTemplateProperty,value);
            }
        }

        static private void DropDownButtonTemplateProperty_PropertyChanged(DependencyObject o, DependencyPropertyChangedEventArgs e)
        {
            ListOrganizer obj = (ListOrganizer) o;
            obj.OnDropDownButtonTemplateChanged( new PropertyChangedEventArgs<ControlTemplate>((ControlTemplate)e.OldValue, (ControlTemplate)e.NewValue) );
        }

        /// <summary>
        /// Occurs when DropDownButtonTemplate property changes.
        /// </summary>
        public event EventHandler<PropertyChangedEventArgs<ControlTemplate>> DropDownButtonTemplateChanged;

        /// <summary>
        /// Called when DropDownButtonTemplate property changes.
        /// </summary>
        protected virtual void OnDropDownButtonTemplateChanged(PropertyChangedEventArgs<ControlTemplate> e)
        {
            OnDropDownButtonTemplateChangedImplementation(e);
            RaisePropertyChangedEvent(DropDownButtonTemplateChanged, e);
        }

        partial void OnDropDownButtonTemplateChangedImplementation(PropertyChangedEventArgs<ControlTemplate> e);

        //
        // DropDownStyle dependency property
        //
        /// <summary>
        /// Identifies the DropDownStyle dependency property.
        /// </summary>
        public static readonly DependencyProperty DropDownStyleProperty = DependencyProperty.Register( "DropDownStyle", typeof(Style), typeof(ListOrganizer), new PropertyMetadata( null, DropDownStyleProperty_PropertyChanged) );

        /// <summary>
        /// Gets or sets the style of the drop-down.
        /// </summary>
        [Bindable(true)]
        [Category("Common Properties")]
        [Description("Gets or sets the style of the drop-down.")]
        [Localizability(LocalizationCategory.None)]
        public Style DropDownStyle
        {
            get
            {
                return (Style) GetValue(DropDownStyleProperty);
            }
            set
            {
                SetValue(DropDownStyleProperty,value);
            }
        }

        static private void DropDownStyleProperty_PropertyChanged(DependencyObject o, DependencyPropertyChangedEventArgs e)
        {
            ListOrganizer obj = (ListOrganizer) o;
            obj.OnDropDownStyleChanged( new PropertyChangedEventArgs<Style>((Style)e.OldValue, (Style)e.NewValue) );
        }

        /// <summary>
        /// Occurs when DropDownStyle property changes.
        /// </summary>
        public event EventHandler<PropertyChangedEventArgs<Style>> DropDownStyleChanged;

        /// <summary>
        /// Called when DropDownStyle property changes.
        /// </summary>
        protected virtual void OnDropDownStyleChanged(PropertyChangedEventArgs<Style> e)
        {
            OnDropDownStyleChangedImplementation(e);
            RaisePropertyChangedEvent(DropDownStyleChanged, e);
        }

        partial void OnDropDownStyleChangedImplementation(PropertyChangedEventArgs<Style> e);

        //
        // HighlightedItem dependency property
        //
        /// <summary>
        /// Identifies the HighlightedItem dependency property.
        /// </summary>
        public static readonly DependencyProperty HighlightedItemProperty = DependencyProperty.Register( "HighlightedItem", typeof(object), typeof(ListOrganizer), new PropertyMetadata( null, HighlightedItemProperty_PropertyChanged) );

        /// <summary>
        /// Gets or sets a value that controls the highlighted item in the list.
        /// </summary>
        [Bindable(true)]
        [Category("Common Properties")]
        [Description("Gets or sets a value that controls the highlighted item in the list.")]
        [Localizability(LocalizationCategory.None)]
        public object HighlightedItem
        {
            get
            {
                return (object) GetValue(HighlightedItemProperty);
            }
            set
            {
                SetValue(HighlightedItemProperty,value);
            }
        }

        static private void HighlightedItemProperty_PropertyChanged(DependencyObject o, DependencyPropertyChangedEventArgs e)
        {
            ListOrganizer obj = (ListOrganizer) o;
            obj.OnHighlightedItemChanged( new PropertyChangedEventArgs<object>((object)e.OldValue, (object)e.NewValue) );
        }

        /// <summary>
        /// Occurs when HighlightedItem property changes.
        /// </summary>
        public event EventHandler<PropertyChangedEventArgs<object>> HighlightedItemChanged;

        /// <summary>
        /// Called when HighlightedItem property changes.
        /// </summary>
        protected virtual void OnHighlightedItemChanged(PropertyChangedEventArgs<object> e)
        {
            OnHighlightedItemChangedImplementation(e);
            RaisePropertyChangedEvent(HighlightedItemChanged, e);
        }

        partial void OnHighlightedItemChangedImplementation(PropertyChangedEventArgs<object> e);

        //
        // ItemsSource dependency property
        //
        /// <summary>
        /// Identifies the ItemsSource dependency property.
        /// </summary>
        public static readonly DependencyProperty ItemsSourceProperty = DependencyProperty.Register( "ItemsSource", typeof(IEnumerable), typeof(ListOrganizer), new PropertyMetadata( null, ItemsSourceProperty_PropertyChanged) );

        /// <summary>
        /// Gets or sets a value that controls the items in the list.
        /// </summary>
        [Bindable(true)]
        [Category("Common Properties")]
        [Description("Gets or sets a value that controls the items in the list.")]
        [Localizability(LocalizationCategory.None)]
        public IEnumerable ItemsSource
        {
            get
            {
                return (IEnumerable) GetValue(ItemsSourceProperty);
            }
            set
            {
                SetValue(ItemsSourceProperty,value);
            }
        }

        static private void ItemsSourceProperty_PropertyChanged(DependencyObject o, DependencyPropertyChangedEventArgs e)
        {
            ListOrganizer obj = (ListOrganizer) o;
            obj.OnItemsSourceChanged( new PropertyChangedEventArgs<IEnumerable>((IEnumerable)e.OldValue, (IEnumerable)e.NewValue) );
        }

        /// <summary>
        /// Occurs when ItemsSource property changes.
        /// </summary>
        public event EventHandler<PropertyChangedEventArgs<IEnumerable>> ItemsSourceChanged;

        /// <summary>
        /// Called when ItemsSource property changes.
        /// </summary>
        protected virtual void OnItemsSourceChanged(PropertyChangedEventArgs<IEnumerable> e)
        {
            OnItemsSourceChangedImplementation(e);
            RaisePropertyChangedEvent(ItemsSourceChanged, e);
        }

        partial void OnItemsSourceChangedImplementation(PropertyChangedEventArgs<IEnumerable> e);

        //
        // NoItemsText dependency property
        //
        /// <summary>
        /// Identifies the NoItemsText dependency property.
        /// </summary>
        public static readonly DependencyProperty NoItemsTextProperty = DependencyProperty.Register( "NoItemsText", typeof(string), typeof(ListOrganizer), new PropertyMetadata( string.Empty, NoItemsTextProperty_PropertyChanged) );

        /// <summary>
        /// Gets or sets a value that appears to inform the user that there are no items in the list.
        /// </summary>
        [Bindable(true)]
        [Category("Common Properties")]
        [Description("Gets or sets a value that appears to inform the user that there are no items in the list.")]
        [Localizability(LocalizationCategory.Text, Modifiability=Modifiability.Modifiable, Readability=Readability.Readable)]
        public string NoItemsText
        {
            get
            {
                return (string) GetValue(NoItemsTextProperty);
            }
            set
            {
                SetValue(NoItemsTextProperty,value);
            }
        }

        static private void NoItemsTextProperty_PropertyChanged(DependencyObject o, DependencyPropertyChangedEventArgs e)
        {
            ListOrganizer obj = (ListOrganizer) o;
            obj.OnNoItemsTextChanged( new PropertyChangedEventArgs<string>((string)e.OldValue, (string)e.NewValue) );
        }

        /// <summary>
        /// Occurs when NoItemsText property changes.
        /// </summary>
        public event EventHandler<PropertyChangedEventArgs<string>> NoItemsTextChanged;

        /// <summary>
        /// Called when NoItemsText property changes.
        /// </summary>
        protected virtual void OnNoItemsTextChanged(PropertyChangedEventArgs<string> e)
        {
            OnNoItemsTextChangedImplementation(e);
            RaisePropertyChangedEvent(NoItemsTextChanged, e);
        }

        partial void OnNoItemsTextChangedImplementation(PropertyChangedEventArgs<string> e);

        //
        // TextContentPropertyName dependency property
        //
        /// <summary>
        /// Identifies the TextContentPropertyName dependency property.
        /// </summary>
        public static readonly DependencyProperty TextContentPropertyNameProperty = DependencyProperty.Register( "TextContentPropertyName", typeof(string), typeof(ListOrganizer), new PropertyMetadata( string.Empty, TextContentPropertyNameProperty_PropertyChanged) );

        /// <summary>
        /// Gets or sets a value which dictates what binding is used to provide content for the items in the list.
        /// </summary>
        [Bindable(true)]
        [Category("Common Properties")]
        [Description("Gets or sets a value which dictates what binding is used to provide content for the items in the list.")]
        [Localizability(LocalizationCategory.None)]
        public string TextContentPropertyName
        {
            get
            {
                return (string) GetValue(TextContentPropertyNameProperty);
            }
            set
            {
                SetValue(TextContentPropertyNameProperty,value);
            }
        }

        static private void TextContentPropertyNameProperty_PropertyChanged(DependencyObject o, DependencyPropertyChangedEventArgs e)
        {
            ListOrganizer obj = (ListOrganizer) o;
            obj.OnTextContentPropertyNameChanged( new PropertyChangedEventArgs<string>((string)e.OldValue, (string)e.NewValue) );
        }

        /// <summary>
        /// Occurs when TextContentPropertyName property changes.
        /// </summary>
        public event EventHandler<PropertyChangedEventArgs<string>> TextContentPropertyNameChanged;

        /// <summary>
        /// Called when TextContentPropertyName property changes.
        /// </summary>
        protected virtual void OnTextContentPropertyNameChanged(PropertyChangedEventArgs<string> e)
        {
            OnTextContentPropertyNameChangedImplementation(e);
            RaisePropertyChangedEvent(TextContentPropertyNameChanged, e);
        }

        partial void OnTextContentPropertyNameChangedImplementation(PropertyChangedEventArgs<string> e);

        /// <summary>
        /// Called when a property changes.
        /// </summary>
        private void RaisePropertyChangedEvent<T>(EventHandler<PropertyChangedEventArgs<T>> eh, PropertyChangedEventArgs<T> e)
        {
            if (eh != null)
            {
                eh(this,e);
            }
        }

        //
        // OnApplyTemplate
        //

        /// <summary>
        /// Called when ApplyTemplate is called.
        /// </summary>
        public override void OnApplyTemplate()
        {
            PreOnApplyTemplate();
            base.OnApplyTemplate();
            this.picker = WpfHelp.GetTemplateChild<PickerBase>(this,"PART_Picker");
            PostOnApplyTemplate();
        }

        partial void PreOnApplyTemplate();

        partial void PostOnApplyTemplate();

        //
        // Static constructor
        //

        /// <summary>
        /// Called when the type is initialized.
        /// </summary>
        static ListOrganizer()
        {
            DefaultStyleKeyProperty.OverrideMetadata(typeof(ListOrganizer), new FrameworkPropertyMetadata(typeof(ListOrganizer)));
            CommandManager.RegisterClassCommandBinding( typeof(ListOrganizer), new CommandBinding( ListOrganizer.DeleteItemCommand, DeleteItemCommand_CommandExecuted ));
            CommandManager.RegisterClassCommandBinding( typeof(ListOrganizer), new CommandBinding( ListOrganizer.SelectItemCommand, SelectItemCommand_CommandExecuted ));
            StaticConstructorImplementation();
        }

        static partial void StaticConstructorImplementation();

    }
}
#endregion
