// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"


namespace Rivet {


  /// @brief e+ e- > p pbar
  class CMD3_2016_I1385598 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(CMD3_2016_I1385598);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {

      // Initialise and register projections
      declare(FinalState(), "FS");

      // Book histograms
      book(_nproton, 1,1,6);
      for (const string& en : _nproton.binning().edges<0>()) {
        double eval = en=="1900 (2012)"s? 1.9 : stod(en)*MeV;
        if (isCompatibleWithSqrtS(eval)) {
          _sqs = en; break;
        }
      }
      raiseBeamErrorIf(_sqs.empty());
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");
      if (fs.particles().size() != 2) vetoEvent;
      for (const Particle& p : fs.particles()) {
        if (p.abspid() != PID::PROTON) vetoEvent;
      }
      _nproton->fill(_sqs);
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale(_nproton, crossSection()/sumOfWeights()/nanobarn);
    }

    /// @}


    /// @name Histograms
    /// @{
    BinnedHistoPtr<string> _nproton;
    string _sqs = "";
    /// @}


  };


  RIVET_DECLARE_PLUGIN(CMD3_2016_I1385598);
}
