/* daytree.c -- Day tree management.
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,96  Lele Gaifax
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include "tua.h"

static BTREE Root = NULL;

static int
DEFUN(day_compare, (d1, d2),
       CONST day_rec_t * d1 AND CONST day_rec_t * d2)
{
  int ret = 0;

#if TAYLOR_UUCP
  
#if BOTH_OF_THEM
  if (is_taylor_uucp)
#endif
    if (d1->Date.Year < d2->Date.Year)
      ret = -1;
    else if (d1->Date.Year > d2->Date.Year)
      ret = 1;
#endif

  if (ret == 0)
    if (d1->Date.Month < d2->Date.Month)
      ret = -1;
    else if (d1->Date.Month > d2->Date.Month)
      ret = 1;
    else if (d1->Date.Day < d2->Date.Day)
      ret = -1;
    else if (d1->Date.Day > d2->Date.Day)
      ret = 1;

  return ret;
}

static PTR
DEFUN(day_new, (data),
      CONST PTR data)
{
  day_rec_t * dr;
  
  dr = (day_rec_t *) xmalloc (sizeof (day_rec_t));
  dr->Date = ((day_rec_t *) data)->Date;
  dr->Out.Files = dr->In.Files = 0;
  dr->Out.Bytes = dr->In.Bytes = 0.0;
  dr->Out.Time = dr->In.Time = 0.0;
  dr->Commands = NULL;
  
  return (PTR) dr;
}

day_rec_t *
DEFUN (insert_day, (day),
       Date_t day)
{
  day_rec_t dr;
  
  if (Root == NULL)
    Root = (BTREE) btree_new ((compare_func_t) day_compare, (makenew_func_t) day_new);

  dr.Date = day;
  return (day_rec_t *) btree_insert (Root, &dr);
}

void
DEFUN (enquire_days, (funct),
       traverse_func_t funct)
{
  btree_traverse (Root, funct);
}

