#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 329
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 47
#define ALIAS_COUNT 0
#define TOKEN_COUNT 22
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 5
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 18

enum ts_symbol_identifiers {
  anon_sym_DOT = 1,
  sym_escape_sequence = 2,
  anon_sym_STAR = 3,
  anon_sym_PLUS = 4,
  anon_sym_QMARK = 5,
  sym_identifier = 6,
  aux_sym__immediate_identifier_token1 = 7,
  anon_sym__ = 8,
  anon_sym_AT = 9,
  anon_sym_DQUOTE = 10,
  aux_sym_string_content_token1 = 11,
  sym_comment = 12,
  anon_sym_LBRACK = 13,
  anon_sym_RBRACK = 14,
  anon_sym_LPAREN = 15,
  anon_sym_RPAREN = 16,
  anon_sym_SLASH = 17,
  anon_sym_COLON = 18,
  anon_sym_BANG = 19,
  anon_sym_POUND = 20,
  sym_predicate_type = 21,
  sym_program = 22,
  sym_definition = 23,
  sym__group_expression = 24,
  sym__named_node_expression = 25,
  sym_quantifier = 26,
  sym__immediate_identifier = 27,
  sym__node_identifier = 28,
  sym_capture = 29,
  sym_string = 30,
  sym_string_content = 31,
  sym_parameters = 32,
  sym_list = 33,
  sym_grouping = 34,
  sym_anonymous_node = 35,
  sym_named_node = 36,
  sym__field_name = 37,
  sym_field_definition = 38,
  sym_negated_field = 39,
  sym_predicate = 40,
  aux_sym_program_repeat1 = 41,
  aux_sym_string_content_repeat1 = 42,
  aux_sym_parameters_repeat1 = 43,
  aux_sym_list_repeat1 = 44,
  aux_sym_grouping_repeat1 = 45,
  aux_sym_named_node_repeat1 = 46,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_DOT] = ".",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_STAR] = "*",
  [anon_sym_PLUS] = "+",
  [anon_sym_QMARK] = "\?",
  [sym_identifier] = "identifier",
  [aux_sym__immediate_identifier_token1] = "identifier",
  [anon_sym__] = "_",
  [anon_sym_AT] = "@",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_content_token1] = "string_content_token1",
  [sym_comment] = "comment",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_SLASH] = "/",
  [anon_sym_COLON] = ":",
  [anon_sym_BANG] = "!",
  [anon_sym_POUND] = "#",
  [sym_predicate_type] = "predicate_type",
  [sym_program] = "program",
  [sym_definition] = "definition",
  [sym__group_expression] = "_group_expression",
  [sym__named_node_expression] = "_named_node_expression",
  [sym_quantifier] = "quantifier",
  [sym__immediate_identifier] = "_immediate_identifier",
  [sym__node_identifier] = "_node_identifier",
  [sym_capture] = "capture",
  [sym_string] = "string",
  [sym_string_content] = "string_content",
  [sym_parameters] = "parameters",
  [sym_list] = "list",
  [sym_grouping] = "grouping",
  [sym_anonymous_node] = "anonymous_node",
  [sym_named_node] = "named_node",
  [sym__field_name] = "_field_name",
  [sym_field_definition] = "field_definition",
  [sym_negated_field] = "negated_field",
  [sym_predicate] = "predicate",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_string_content_repeat1] = "string_content_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
  [aux_sym_list_repeat1] = "list_repeat1",
  [aux_sym_grouping_repeat1] = "grouping_repeat1",
  [aux_sym_named_node_repeat1] = "named_node_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_DOT] = anon_sym_DOT,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [sym_identifier] = sym_identifier,
  [aux_sym__immediate_identifier_token1] = sym_identifier,
  [anon_sym__] = anon_sym__,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_content_token1] = aux_sym_string_content_token1,
  [sym_comment] = sym_comment,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_POUND] = anon_sym_POUND,
  [sym_predicate_type] = sym_predicate_type,
  [sym_program] = sym_program,
  [sym_definition] = sym_definition,
  [sym__group_expression] = sym__group_expression,
  [sym__named_node_expression] = sym__named_node_expression,
  [sym_quantifier] = sym_quantifier,
  [sym__immediate_identifier] = sym__immediate_identifier,
  [sym__node_identifier] = sym__node_identifier,
  [sym_capture] = sym_capture,
  [sym_string] = sym_string,
  [sym_string_content] = sym_string_content,
  [sym_parameters] = sym_parameters,
  [sym_list] = sym_list,
  [sym_grouping] = sym_grouping,
  [sym_anonymous_node] = sym_anonymous_node,
  [sym_named_node] = sym_named_node,
  [sym__field_name] = sym__field_name,
  [sym_field_definition] = sym_field_definition,
  [sym_negated_field] = sym_negated_field,
  [sym_predicate] = sym_predicate,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_string_content_repeat1] = aux_sym_string_content_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
  [aux_sym_list_repeat1] = aux_sym_list_repeat1,
  [aux_sym_grouping_repeat1] = aux_sym_grouping_repeat1,
  [aux_sym_named_node_repeat1] = aux_sym_named_node_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__immediate_identifier_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_content_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [sym_predicate_type] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_definition] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__group_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__named_node_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_quantifier] = {
    .visible = true,
    .named = true,
  },
  [sym__immediate_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__node_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_capture] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_content] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_grouping] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_node] = {
    .visible = true,
    .named = true,
  },
  [sym_named_node] = {
    .visible = true,
    .named = true,
  },
  [sym__field_name] = {
    .visible = false,
    .named = true,
  },
  [sym_field_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_negated_field] = {
    .visible = true,
    .named = true,
  },
  [sym_predicate] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_grouping_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_node_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_name = 1,
  field_parameters = 2,
  field_quantifier = 3,
  field_supertype = 4,
  field_type = 5,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_name] = "name",
  [field_parameters] = "parameters",
  [field_quantifier] = "quantifier",
  [field_supertype] = "supertype",
  [field_type] = "type",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 1},
  [5] = {.index = 5, .length = 1},
  [6] = {.index = 6, .length = 2},
  [7] = {.index = 8, .length = 2},
  [8] = {.index = 10, .length = 2},
  [9] = {.index = 12, .length = 3},
  [10] = {.index = 15, .length = 4},
  [11] = {.index = 19, .length = 2},
  [12] = {.index = 21, .length = 3},
  [13] = {.index = 24, .length = 2},
  [14] = {.index = 26, .length = 3},
  [15] = {.index = 29, .length = 2},
  [16] = {.index = 31, .length = 3},
  [17] = {.index = 34, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_name, 0},
    {field_quantifier, 1},
  [3] =
    {field_name, 1},
  [4] =
    {field_quantifier, 2},
  [5] =
    {field_quantifier, 3},
  [6] =
    {field_name, 1},
    {field_quantifier, 3},
  [8] =
    {field_name, 3},
    {field_supertype, 1},
  [10] =
    {field_name, 1},
    {field_quantifier, 4},
  [12] =
    {field_name, 3},
    {field_quantifier, 5},
    {field_supertype, 1},
  [15] =
    {field_name, 1},
    {field_name, 2},
    {field_parameters, 4},
    {field_type, 3},
  [19] =
    {field_name, 1},
    {field_quantifier, 5},
  [21] =
    {field_name, 3},
    {field_quantifier, 6},
    {field_supertype, 1},
  [24] =
    {field_name, 1},
    {field_quantifier, 6},
  [26] =
    {field_name, 3},
    {field_quantifier, 7},
    {field_supertype, 1},
  [29] =
    {field_name, 1},
    {field_quantifier, 7},
  [31] =
    {field_name, 3},
    {field_quantifier, 8},
    {field_supertype, 1},
  [34] =
    {field_name, 3},
    {field_quantifier, 9},
    {field_supertype, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 3,
  [5] = 2,
  [6] = 2,
  [7] = 3,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 9,
  [12] = 12,
  [13] = 13,
  [14] = 12,
  [15] = 10,
  [16] = 13,
  [17] = 17,
  [18] = 12,
  [19] = 10,
  [20] = 8,
  [21] = 13,
  [22] = 8,
  [23] = 9,
  [24] = 24,
  [25] = 24,
  [26] = 24,
  [27] = 27,
  [28] = 27,
  [29] = 29,
  [30] = 30,
  [31] = 30,
  [32] = 30,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 29,
  [37] = 34,
  [38] = 33,
  [39] = 39,
  [40] = 35,
  [41] = 27,
  [42] = 33,
  [43] = 39,
  [44] = 34,
  [45] = 29,
  [46] = 35,
  [47] = 39,
  [48] = 48,
  [49] = 49,
  [50] = 48,
  [51] = 48,
  [52] = 52,
  [53] = 53,
  [54] = 53,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 55,
  [59] = 56,
  [60] = 60,
  [61] = 55,
  [62] = 53,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 79,
  [81] = 79,
  [82] = 74,
  [83] = 65,
  [84] = 68,
  [85] = 64,
  [86] = 63,
  [87] = 63,
  [88] = 69,
  [89] = 67,
  [90] = 78,
  [91] = 75,
  [92] = 76,
  [93] = 65,
  [94] = 71,
  [95] = 75,
  [96] = 73,
  [97] = 70,
  [98] = 78,
  [99] = 72,
  [100] = 71,
  [101] = 70,
  [102] = 67,
  [103] = 68,
  [104] = 64,
  [105] = 74,
  [106] = 72,
  [107] = 73,
  [108] = 69,
  [109] = 76,
  [110] = 66,
  [111] = 66,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 113,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 112,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 112,
  [164] = 162,
  [165] = 113,
  [166] = 162,
  [167] = 143,
  [168] = 168,
  [169] = 141,
  [170] = 145,
  [171] = 144,
  [172] = 172,
  [173] = 134,
  [174] = 126,
  [175] = 125,
  [176] = 120,
  [177] = 119,
  [178] = 118,
  [179] = 115,
  [180] = 132,
  [181] = 139,
  [182] = 137,
  [183] = 131,
  [184] = 124,
  [185] = 150,
  [186] = 114,
  [187] = 151,
  [188] = 152,
  [189] = 154,
  [190] = 156,
  [191] = 157,
  [192] = 159,
  [193] = 160,
  [194] = 161,
  [195] = 153,
  [196] = 172,
  [197] = 197,
  [198] = 158,
  [199] = 117,
  [200] = 121,
  [201] = 122,
  [202] = 123,
  [203] = 155,
  [204] = 204,
  [205] = 127,
  [206] = 128,
  [207] = 129,
  [208] = 133,
  [209] = 135,
  [210] = 136,
  [211] = 140,
  [212] = 142,
  [213] = 146,
  [214] = 147,
  [215] = 148,
  [216] = 149,
  [217] = 149,
  [218] = 148,
  [219] = 155,
  [220] = 158,
  [221] = 147,
  [222] = 146,
  [223] = 153,
  [224] = 161,
  [225] = 160,
  [226] = 159,
  [227] = 157,
  [228] = 156,
  [229] = 154,
  [230] = 152,
  [231] = 151,
  [232] = 114,
  [233] = 150,
  [234] = 142,
  [235] = 124,
  [236] = 131,
  [237] = 137,
  [238] = 139,
  [239] = 132,
  [240] = 115,
  [241] = 118,
  [242] = 119,
  [243] = 120,
  [244] = 140,
  [245] = 125,
  [246] = 126,
  [247] = 134,
  [248] = 116,
  [249] = 136,
  [250] = 143,
  [251] = 144,
  [252] = 135,
  [253] = 145,
  [254] = 133,
  [255] = 141,
  [256] = 116,
  [257] = 129,
  [258] = 117,
  [259] = 172,
  [260] = 260,
  [261] = 128,
  [262] = 127,
  [263] = 123,
  [264] = 121,
  [265] = 122,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 266,
  [271] = 267,
  [272] = 272,
  [273] = 204,
  [274] = 267,
  [275] = 275,
  [276] = 266,
  [277] = 277,
  [278] = 268,
  [279] = 272,
  [280] = 280,
  [281] = 281,
  [282] = 281,
  [283] = 268,
  [284] = 280,
  [285] = 285,
  [286] = 281,
  [287] = 287,
  [288] = 280,
  [289] = 272,
  [290] = 290,
  [291] = 197,
  [292] = 197,
  [293] = 293,
  [294] = 204,
  [295] = 295,
  [296] = 287,
  [297] = 285,
  [298] = 287,
  [299] = 290,
  [300] = 285,
  [301] = 290,
  [302] = 302,
  [303] = 302,
  [304] = 302,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 308,
  [310] = 308,
  [311] = 311,
  [312] = 312,
  [313] = 312,
  [314] = 311,
  [315] = 312,
  [316] = 311,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 320,
  [322] = 317,
  [323] = 323,
  [324] = 318,
  [325] = 317,
  [326] = 318,
  [327] = 327,
  [328] = 320,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(16);
      ADVANCE_MAP(
        '!', 39,
        '"', 28,
        '#', 40,
        '(', 35,
        ')', 36,
        '*', 21,
        '+', 22,
        '.', 17,
        '/', 37,
        ':', 38,
        ';', 32,
        '?', 23,
        '@', 27,
        '[', 33,
        '\\', 7,
        ']', 34,
        '_', 26,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(14);
      if (lookahead == '$' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(24);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 39,
        '"', 28,
        '(', 35,
        ')', 36,
        '*', 21,
        '+', 22,
        '.', 17,
        '/', 37,
        ':', 38,
        ';', 32,
        '?', 23,
        '@', 27,
        '[', 33,
        '_', 26,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (lookahead == '$' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(24);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 39,
        '"', 28,
        '(', 35,
        ')', 36,
        '*', 21,
        '+', 22,
        '.', 17,
        ':', 38,
        ';', 32,
        '?', 23,
        '@', 27,
        '[', 33,
        '_', 26,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(24);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(28);
      if (lookahead == ';') ADVANCE(29);
      if (lookahead == '\\') ADVANCE(7);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(30);
      if (lookahead != 0) ADVANCE(31);
      END_STATE();
    case 4:
      if (lookahead == ';') ADVANCE(32);
      if (lookahead == '!' ||
          lookahead == '?') ADVANCE(41);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(25);
      END_STATE();
    case 5:
      if (lookahead == ';') ADVANCE(32);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      END_STATE();
    case 6:
      if (lookahead == ';') ADVANCE(32);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(24);
      END_STATE();
    case 7:
      if (lookahead == 'u') ADVANCE(8);
      if (lookahead == 'x') ADVANCE(13);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(20);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 8:
      if (lookahead == '{') ADVANCE(12);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(10);
      END_STATE();
    case 9:
      if (lookahead == '}') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(9);
      END_STATE();
    case 10:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(13);
      END_STATE();
    case 11:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(18);
      END_STATE();
    case 12:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(9);
      END_STATE();
    case 13:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(11);
      END_STATE();
    case 14:
      if (eof) ADVANCE(16);
      ADVANCE_MAP(
        '!', 39,
        '"', 28,
        '#', 40,
        '(', 35,
        ')', 36,
        '*', 21,
        '+', 22,
        '.', 17,
        ':', 38,
        ';', 32,
        '?', 23,
        '@', 27,
        '[', 33,
        ']', 34,
        '_', 26,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(14);
      if (lookahead == '$' ||
          lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(24);
      END_STATE();
    case 15:
      if (eof) ADVANCE(16);
      ADVANCE_MAP(
        '!', 39,
        '"', 28,
        '#', 40,
        '(', 35,
        ')', 36,
        '*', 21,
        '+', 22,
        ';', 32,
        '?', 23,
        '@', 27,
        '[', 33,
        ']', 34,
        '_', 26,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(15);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(24);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(24);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(18);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(19);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(24);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(aux_sym__immediate_identifier_token1);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(25);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '$' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(24);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(aux_sym_string_content_token1);
      if (lookahead == '\n') ADVANCE(31);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(29);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(aux_sym_string_content_token1);
      if (lookahead == ';') ADVANCE(29);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(30);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(31);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(aux_sym_string_content_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(31);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(32);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym_predicate_type);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 15},
  [2] = {.lex_state = 1},
  [3] = {.lex_state = 1},
  [4] = {.lex_state = 1},
  [5] = {.lex_state = 1},
  [6] = {.lex_state = 1},
  [7] = {.lex_state = 1},
  [8] = {.lex_state = 15},
  [9] = {.lex_state = 15},
  [10] = {.lex_state = 15},
  [11] = {.lex_state = 15},
  [12] = {.lex_state = 15},
  [13] = {.lex_state = 15},
  [14] = {.lex_state = 15},
  [15] = {.lex_state = 15},
  [16] = {.lex_state = 15},
  [17] = {.lex_state = 15},
  [18] = {.lex_state = 15},
  [19] = {.lex_state = 15},
  [20] = {.lex_state = 15},
  [21] = {.lex_state = 15},
  [22] = {.lex_state = 15},
  [23] = {.lex_state = 15},
  [24] = {.lex_state = 15},
  [25] = {.lex_state = 15},
  [26] = {.lex_state = 15},
  [27] = {.lex_state = 15},
  [28] = {.lex_state = 15},
  [29] = {.lex_state = 15},
  [30] = {.lex_state = 15},
  [31] = {.lex_state = 15},
  [32] = {.lex_state = 15},
  [33] = {.lex_state = 15},
  [34] = {.lex_state = 15},
  [35] = {.lex_state = 15},
  [36] = {.lex_state = 15},
  [37] = {.lex_state = 15},
  [38] = {.lex_state = 15},
  [39] = {.lex_state = 15},
  [40] = {.lex_state = 15},
  [41] = {.lex_state = 15},
  [42] = {.lex_state = 15},
  [43] = {.lex_state = 15},
  [44] = {.lex_state = 15},
  [45] = {.lex_state = 15},
  [46] = {.lex_state = 15},
  [47] = {.lex_state = 15},
  [48] = {.lex_state = 15},
  [49] = {.lex_state = 15},
  [50] = {.lex_state = 15},
  [51] = {.lex_state = 15},
  [52] = {.lex_state = 15},
  [53] = {.lex_state = 15},
  [54] = {.lex_state = 15},
  [55] = {.lex_state = 15},
  [56] = {.lex_state = 15},
  [57] = {.lex_state = 15},
  [58] = {.lex_state = 15},
  [59] = {.lex_state = 15},
  [60] = {.lex_state = 15},
  [61] = {.lex_state = 15},
  [62] = {.lex_state = 15},
  [63] = {.lex_state = 1},
  [64] = {.lex_state = 1},
  [65] = {.lex_state = 1},
  [66] = {.lex_state = 1},
  [67] = {.lex_state = 1},
  [68] = {.lex_state = 1},
  [69] = {.lex_state = 1},
  [70] = {.lex_state = 1},
  [71] = {.lex_state = 1},
  [72] = {.lex_state = 1},
  [73] = {.lex_state = 1},
  [74] = {.lex_state = 1},
  [75] = {.lex_state = 1},
  [76] = {.lex_state = 1},
  [77] = {.lex_state = 1},
  [78] = {.lex_state = 1},
  [79] = {.lex_state = 15},
  [80] = {.lex_state = 15},
  [81] = {.lex_state = 15},
  [82] = {.lex_state = 15},
  [83] = {.lex_state = 15},
  [84] = {.lex_state = 15},
  [85] = {.lex_state = 15},
  [86] = {.lex_state = 15},
  [87] = {.lex_state = 15},
  [88] = {.lex_state = 15},
  [89] = {.lex_state = 15},
  [90] = {.lex_state = 15},
  [91] = {.lex_state = 15},
  [92] = {.lex_state = 15},
  [93] = {.lex_state = 15},
  [94] = {.lex_state = 15},
  [95] = {.lex_state = 15},
  [96] = {.lex_state = 15},
  [97] = {.lex_state = 15},
  [98] = {.lex_state = 15},
  [99] = {.lex_state = 15},
  [100] = {.lex_state = 15},
  [101] = {.lex_state = 15},
  [102] = {.lex_state = 15},
  [103] = {.lex_state = 15},
  [104] = {.lex_state = 15},
  [105] = {.lex_state = 15},
  [106] = {.lex_state = 15},
  [107] = {.lex_state = 15},
  [108] = {.lex_state = 15},
  [109] = {.lex_state = 15},
  [110] = {.lex_state = 15},
  [111] = {.lex_state = 15},
  [112] = {.lex_state = 1},
  [113] = {.lex_state = 1},
  [114] = {.lex_state = 1},
  [115] = {.lex_state = 1},
  [116] = {.lex_state = 1},
  [117] = {.lex_state = 1},
  [118] = {.lex_state = 1},
  [119] = {.lex_state = 1},
  [120] = {.lex_state = 1},
  [121] = {.lex_state = 1},
  [122] = {.lex_state = 1},
  [123] = {.lex_state = 1},
  [124] = {.lex_state = 1},
  [125] = {.lex_state = 1},
  [126] = {.lex_state = 1},
  [127] = {.lex_state = 1},
  [128] = {.lex_state = 1},
  [129] = {.lex_state = 1},
  [130] = {.lex_state = 15},
  [131] = {.lex_state = 1},
  [132] = {.lex_state = 1},
  [133] = {.lex_state = 1},
  [134] = {.lex_state = 1},
  [135] = {.lex_state = 1},
  [136] = {.lex_state = 1},
  [137] = {.lex_state = 1},
  [138] = {.lex_state = 15},
  [139] = {.lex_state = 1},
  [140] = {.lex_state = 1},
  [141] = {.lex_state = 1},
  [142] = {.lex_state = 1},
  [143] = {.lex_state = 1},
  [144] = {.lex_state = 1},
  [145] = {.lex_state = 1},
  [146] = {.lex_state = 1},
  [147] = {.lex_state = 1},
  [148] = {.lex_state = 1},
  [149] = {.lex_state = 1},
  [150] = {.lex_state = 1},
  [151] = {.lex_state = 1},
  [152] = {.lex_state = 1},
  [153] = {.lex_state = 1},
  [154] = {.lex_state = 1},
  [155] = {.lex_state = 1},
  [156] = {.lex_state = 1},
  [157] = {.lex_state = 1},
  [158] = {.lex_state = 1},
  [159] = {.lex_state = 1},
  [160] = {.lex_state = 1},
  [161] = {.lex_state = 1},
  [162] = {.lex_state = 1},
  [163] = {.lex_state = 15},
  [164] = {.lex_state = 1},
  [165] = {.lex_state = 15},
  [166] = {.lex_state = 1},
  [167] = {.lex_state = 15},
  [168] = {.lex_state = 15},
  [169] = {.lex_state = 15},
  [170] = {.lex_state = 15},
  [171] = {.lex_state = 15},
  [172] = {.lex_state = 15},
  [173] = {.lex_state = 15},
  [174] = {.lex_state = 15},
  [175] = {.lex_state = 15},
  [176] = {.lex_state = 15},
  [177] = {.lex_state = 15},
  [178] = {.lex_state = 15},
  [179] = {.lex_state = 15},
  [180] = {.lex_state = 15},
  [181] = {.lex_state = 15},
  [182] = {.lex_state = 15},
  [183] = {.lex_state = 15},
  [184] = {.lex_state = 15},
  [185] = {.lex_state = 15},
  [186] = {.lex_state = 15},
  [187] = {.lex_state = 15},
  [188] = {.lex_state = 15},
  [189] = {.lex_state = 15},
  [190] = {.lex_state = 15},
  [191] = {.lex_state = 15},
  [192] = {.lex_state = 15},
  [193] = {.lex_state = 15},
  [194] = {.lex_state = 15},
  [195] = {.lex_state = 15},
  [196] = {.lex_state = 15},
  [197] = {.lex_state = 1},
  [198] = {.lex_state = 15},
  [199] = {.lex_state = 15},
  [200] = {.lex_state = 15},
  [201] = {.lex_state = 15},
  [202] = {.lex_state = 15},
  [203] = {.lex_state = 15},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 15},
  [206] = {.lex_state = 15},
  [207] = {.lex_state = 15},
  [208] = {.lex_state = 15},
  [209] = {.lex_state = 15},
  [210] = {.lex_state = 15},
  [211] = {.lex_state = 15},
  [212] = {.lex_state = 15},
  [213] = {.lex_state = 15},
  [214] = {.lex_state = 15},
  [215] = {.lex_state = 15},
  [216] = {.lex_state = 15},
  [217] = {.lex_state = 15},
  [218] = {.lex_state = 15},
  [219] = {.lex_state = 15},
  [220] = {.lex_state = 15},
  [221] = {.lex_state = 15},
  [222] = {.lex_state = 15},
  [223] = {.lex_state = 15},
  [224] = {.lex_state = 15},
  [225] = {.lex_state = 15},
  [226] = {.lex_state = 15},
  [227] = {.lex_state = 15},
  [228] = {.lex_state = 15},
  [229] = {.lex_state = 15},
  [230] = {.lex_state = 15},
  [231] = {.lex_state = 15},
  [232] = {.lex_state = 15},
  [233] = {.lex_state = 15},
  [234] = {.lex_state = 15},
  [235] = {.lex_state = 15},
  [236] = {.lex_state = 15},
  [237] = {.lex_state = 15},
  [238] = {.lex_state = 15},
  [239] = {.lex_state = 15},
  [240] = {.lex_state = 15},
  [241] = {.lex_state = 15},
  [242] = {.lex_state = 15},
  [243] = {.lex_state = 15},
  [244] = {.lex_state = 15},
  [245] = {.lex_state = 15},
  [246] = {.lex_state = 15},
  [247] = {.lex_state = 15},
  [248] = {.lex_state = 15},
  [249] = {.lex_state = 15},
  [250] = {.lex_state = 15},
  [251] = {.lex_state = 15},
  [252] = {.lex_state = 15},
  [253] = {.lex_state = 15},
  [254] = {.lex_state = 15},
  [255] = {.lex_state = 15},
  [256] = {.lex_state = 15},
  [257] = {.lex_state = 15},
  [258] = {.lex_state = 15},
  [259] = {.lex_state = 15},
  [260] = {.lex_state = 15},
  [261] = {.lex_state = 15},
  [262] = {.lex_state = 15},
  [263] = {.lex_state = 15},
  [264] = {.lex_state = 15},
  [265] = {.lex_state = 15},
  [266] = {.lex_state = 1},
  [267] = {.lex_state = 1},
  [268] = {.lex_state = 1},
  [269] = {.lex_state = 1},
  [270] = {.lex_state = 1},
  [271] = {.lex_state = 1},
  [272] = {.lex_state = 1},
  [273] = {.lex_state = 15},
  [274] = {.lex_state = 1},
  [275] = {.lex_state = 1},
  [276] = {.lex_state = 1},
  [277] = {.lex_state = 1},
  [278] = {.lex_state = 1},
  [279] = {.lex_state = 1},
  [280] = {.lex_state = 1},
  [281] = {.lex_state = 1},
  [282] = {.lex_state = 1},
  [283] = {.lex_state = 1},
  [284] = {.lex_state = 1},
  [285] = {.lex_state = 1},
  [286] = {.lex_state = 1},
  [287] = {.lex_state = 1},
  [288] = {.lex_state = 1},
  [289] = {.lex_state = 1},
  [290] = {.lex_state = 1},
  [291] = {.lex_state = 15},
  [292] = {.lex_state = 15},
  [293] = {.lex_state = 0},
  [294] = {.lex_state = 15},
  [295] = {.lex_state = 0},
  [296] = {.lex_state = 15},
  [297] = {.lex_state = 15},
  [298] = {.lex_state = 15},
  [299] = {.lex_state = 15},
  [300] = {.lex_state = 15},
  [301] = {.lex_state = 15},
  [302] = {.lex_state = 3},
  [303] = {.lex_state = 3},
  [304] = {.lex_state = 3},
  [305] = {.lex_state = 15},
  [306] = {.lex_state = 3},
  [307] = {.lex_state = 3},
  [308] = {.lex_state = 4},
  [309] = {.lex_state = 4},
  [310] = {.lex_state = 4},
  [311] = {.lex_state = 4},
  [312] = {.lex_state = 4},
  [313] = {.lex_state = 4},
  [314] = {.lex_state = 4},
  [315] = {.lex_state = 4},
  [316] = {.lex_state = 4},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 4},
  [319] = {.lex_state = 6},
  [320] = {.lex_state = 0},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 0},
  [323] = {.lex_state = 0},
  [324] = {.lex_state = 4},
  [325] = {.lex_state = 0},
  [326] = {.lex_state = 4},
  [327] = {.lex_state = 0},
  [328] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [sym_predicate_type] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(323),
    [sym_definition] = STATE(57),
    [sym_string] = STATE(84),
    [sym_list] = STATE(301),
    [sym_grouping] = STATE(301),
    [sym_anonymous_node] = STATE(301),
    [sym_named_node] = STATE(301),
    [sym__field_name] = STATE(80),
    [sym_field_definition] = STATE(301),
    [sym_predicate] = STATE(301),
    [aux_sym_program_repeat1] = STATE(57),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym__] = ACTIONS(9),
    [anon_sym_DQUOTE] = ACTIONS(11),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(17), 1,
      anon_sym_DOT,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_RPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    STATE(13), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(266), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [50] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(31), 1,
      anon_sym_DOT,
    ACTIONS(33), 1,
      anon_sym_RPAREN,
    STATE(19), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(286), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [100] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(35), 1,
      anon_sym_DOT,
    ACTIONS(37), 1,
      anon_sym_RPAREN,
    STATE(15), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(281), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [150] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(39), 1,
      anon_sym_DOT,
    ACTIONS(41), 1,
      anon_sym_RPAREN,
    STATE(21), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(270), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [200] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(45), 1,
      anon_sym_RPAREN,
    STATE(16), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(276), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [250] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(47), 1,
      anon_sym_DOT,
    ACTIONS(49), 1,
      anon_sym_RPAREN,
    STATE(10), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(282), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [300] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      sym_identifier,
    ACTIONS(53), 1,
      anon_sym__,
    ACTIONS(55), 1,
      anon_sym_RPAREN,
    ACTIONS(57), 1,
      anon_sym_POUND,
    STATE(4), 1,
      sym__node_identifier,
    STATE(51), 1,
      aux_sym_grouping_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(295), 2,
      sym_definition,
      sym__group_expression,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [349] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(59), 1,
      anon_sym_RPAREN,
    STATE(17), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(274), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [396] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(61), 1,
      anon_sym_RPAREN,
    STATE(17), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(289), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [443] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(63), 1,
      anon_sym_RPAREN,
    STATE(17), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(267), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [490] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(65), 1,
      anon_sym_RPAREN,
    STATE(17), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(284), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [537] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(67), 1,
      anon_sym_RPAREN,
    STATE(17), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(283), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [584] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      anon_sym_RPAREN,
    STATE(17), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(288), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [631] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(71), 1,
      anon_sym_RPAREN,
    STATE(17), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(272), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [678] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(73), 1,
      anon_sym_RPAREN,
    STATE(17), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(268), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [725] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(75), 1,
      sym_identifier,
    ACTIONS(78), 1,
      anon_sym__,
    ACTIONS(81), 1,
      anon_sym_DQUOTE,
    ACTIONS(84), 1,
      anon_sym_LBRACK,
    ACTIONS(87), 1,
      anon_sym_LPAREN,
    ACTIONS(90), 1,
      anon_sym_RPAREN,
    ACTIONS(92), 1,
      anon_sym_BANG,
    STATE(17), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(277), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [772] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_RPAREN,
    STATE(17), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(280), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [819] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(97), 1,
      anon_sym_RPAREN,
    STATE(17), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(279), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [866] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym__,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(101), 1,
      anon_sym_RPAREN,
    ACTIONS(103), 1,
      anon_sym_POUND,
    STATE(7), 1,
      sym__node_identifier,
    STATE(48), 1,
      aux_sym_grouping_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(295), 2,
      sym_definition,
      sym__group_expression,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [915] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(105), 1,
      anon_sym_RPAREN,
    STATE(17), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(278), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [962] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym__,
    ACTIONS(107), 1,
      sym_identifier,
    ACTIONS(109), 1,
      anon_sym_RPAREN,
    ACTIONS(111), 1,
      anon_sym_POUND,
    STATE(3), 1,
      sym__node_identifier,
    STATE(50), 1,
      aux_sym_grouping_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(295), 2,
      sym_definition,
      sym__group_expression,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1011] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(113), 1,
      anon_sym_RPAREN,
    STATE(17), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(271), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1058] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(65), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(275), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1102] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(275), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1146] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(95), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(275), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1190] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(115), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(275), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1234] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(117), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(275), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1278] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(119), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(275), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1322] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(121), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(275), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1366] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(123), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(275), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1410] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(125), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(275), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1454] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(113), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(275), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1498] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    STATE(12), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(278), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1542] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(127), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(275), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1586] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(129), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(275), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1630] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    STATE(18), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(268), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1674] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(59), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(275), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1718] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    STATE(23), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(279), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1762] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(131), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(275), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1806] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(133), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(275), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1850] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(63), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(275), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1894] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    STATE(9), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(272), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1938] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    STATE(14), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(283), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [1982] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(135), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(275), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2026] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    ACTIONS(137), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(275), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2070] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    STATE(11), 1,
      aux_sym_named_node_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(289), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2114] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(139), 1,
      anon_sym_RPAREN,
    STATE(49), 1,
      aux_sym_grouping_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(295), 2,
      sym_definition,
      sym__group_expression,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2157] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(141), 1,
      sym_identifier,
    ACTIONS(144), 1,
      anon_sym__,
    ACTIONS(147), 1,
      anon_sym_DQUOTE,
    ACTIONS(150), 1,
      anon_sym_LBRACK,
    ACTIONS(153), 1,
      anon_sym_LPAREN,
    ACTIONS(156), 1,
      anon_sym_RPAREN,
    STATE(49), 1,
      aux_sym_grouping_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(295), 2,
      sym_definition,
      sym__group_expression,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2200] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(158), 1,
      anon_sym_RPAREN,
    STATE(49), 1,
      aux_sym_grouping_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(295), 2,
      sym_definition,
      sym__group_expression,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2243] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(160), 1,
      anon_sym_RPAREN,
    STATE(49), 1,
      aux_sym_grouping_repeat1,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(295), 2,
      sym_definition,
      sym__group_expression,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2286] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_BANG,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(275), 3,
      sym_definition,
      sym__named_node_expression,
      sym_negated_field,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2327] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(162), 1,
      anon_sym__,
    ACTIONS(164), 1,
      anon_sym_DQUOTE,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_RBRACK,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    STATE(81), 1,
      sym__field_name,
    STATE(103), 1,
      sym_string,
    STATE(58), 2,
      sym_definition,
      aux_sym_program_repeat1,
    STATE(299), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2367] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(162), 1,
      anon_sym__,
    ACTIONS(164), 1,
      anon_sym_DQUOTE,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(172), 1,
      anon_sym_RBRACK,
    STATE(81), 1,
      sym__field_name,
    STATE(103), 1,
      sym_string,
    STATE(61), 2,
      sym_definition,
      aux_sym_program_repeat1,
    STATE(299), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2407] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(162), 1,
      anon_sym__,
    ACTIONS(164), 1,
      anon_sym_DQUOTE,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(174), 1,
      anon_sym_RBRACK,
    STATE(81), 1,
      sym__field_name,
    STATE(103), 1,
      sym_string,
    STATE(59), 2,
      sym_definition,
      aux_sym_program_repeat1,
    STATE(299), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2447] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(176), 1,
      ts_builtin_sym_end,
    ACTIONS(178), 1,
      sym_identifier,
    ACTIONS(181), 1,
      anon_sym__,
    ACTIONS(184), 1,
      anon_sym_DQUOTE,
    ACTIONS(187), 1,
      anon_sym_LBRACK,
    ACTIONS(190), 1,
      anon_sym_LPAREN,
    STATE(80), 1,
      sym__field_name,
    STATE(84), 1,
      sym_string,
    STATE(56), 2,
      sym_definition,
      aux_sym_program_repeat1,
    STATE(301), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2487] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym__,
    ACTIONS(11), 1,
      anon_sym_DQUOTE,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(193), 1,
      ts_builtin_sym_end,
    STATE(80), 1,
      sym__field_name,
    STATE(84), 1,
      sym_string,
    STATE(56), 2,
      sym_definition,
      aux_sym_program_repeat1,
    STATE(301), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2527] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(162), 1,
      anon_sym__,
    ACTIONS(164), 1,
      anon_sym_DQUOTE,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(195), 1,
      anon_sym_RBRACK,
    STATE(81), 1,
      sym__field_name,
    STATE(103), 1,
      sym_string,
    STATE(59), 2,
      sym_definition,
      aux_sym_program_repeat1,
    STATE(299), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2567] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(176), 1,
      anon_sym_RBRACK,
    ACTIONS(178), 1,
      sym_identifier,
    ACTIONS(197), 1,
      anon_sym__,
    ACTIONS(200), 1,
      anon_sym_DQUOTE,
    ACTIONS(203), 1,
      anon_sym_LBRACK,
    ACTIONS(206), 1,
      anon_sym_LPAREN,
    STATE(81), 1,
      sym__field_name,
    STATE(103), 1,
      sym_string,
    STATE(59), 2,
      sym_definition,
      aux_sym_program_repeat1,
    STATE(299), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2607] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    ACTIONS(156), 1,
      anon_sym_RPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(293), 2,
      sym_definition,
      sym__group_expression,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2647] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(162), 1,
      anon_sym__,
    ACTIONS(164), 1,
      anon_sym_DQUOTE,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(209), 1,
      anon_sym_RBRACK,
    STATE(81), 1,
      sym__field_name,
    STATE(103), 1,
      sym_string,
    STATE(59), 2,
      sym_definition,
      aux_sym_program_repeat1,
    STATE(299), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2687] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(162), 1,
      anon_sym__,
    ACTIONS(164), 1,
      anon_sym_DQUOTE,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    ACTIONS(211), 1,
      anon_sym_RBRACK,
    STATE(81), 1,
      sym__field_name,
    STATE(103), 1,
      sym_string,
    STATE(55), 2,
      sym_definition,
      aux_sym_program_repeat1,
    STATE(299), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [2727] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(119), 1,
      sym_quantifier,
    STATE(118), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(213), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(215), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(219), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [2758] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(123), 1,
      sym_quantifier,
    STATE(122), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(215), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(221), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(223), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [2789] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(137), 1,
      sym_quantifier,
    STATE(131), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(215), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(225), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(227), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [2820] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(135), 1,
      sym_quantifier,
    STATE(133), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(215), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(229), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(231), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [2851] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(134), 1,
      sym_quantifier,
    STATE(126), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(215), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(233), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(235), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [2882] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(158), 1,
      sym_quantifier,
    STATE(155), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(215), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(237), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(239), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [2913] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(115), 1,
      sym_quantifier,
    STATE(132), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(215), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(241), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(243), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [2944] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(116), 1,
      sym_quantifier,
    STATE(141), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(215), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(245), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(247), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [2975] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(160), 1,
      sym_quantifier,
    STATE(161), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(215), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(249), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(251), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3006] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(147), 1,
      sym_quantifier,
    STATE(146), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(215), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(253), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(255), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3037] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(142), 1,
      sym_quantifier,
    STATE(140), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(215), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(257), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(259), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3068] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(152), 1,
      sym_quantifier,
    STATE(154), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(215), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(261), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(263), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3099] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(114), 1,
      sym_quantifier,
    STATE(151), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(215), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(265), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(267), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3130] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(128), 1,
      sym_quantifier,
    STATE(127), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(215), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(269), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(271), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3161] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(158), 1,
      sym_quantifier,
    STATE(155), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(215), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(273), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(275), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3192] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(144), 1,
      sym_quantifier,
    STATE(143), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(215), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(277), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(279), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [3223] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(19), 1,
      anon_sym__,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_LPAREN,
    STATE(68), 1,
      sym_string,
    STATE(79), 1,
      sym__field_name,
    STATE(287), 1,
      sym_definition,
    STATE(290), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [3259] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(9), 1,
      anon_sym__,
    ACTIONS(11), 1,
      anon_sym_DQUOTE,
    ACTIONS(13), 1,
      anon_sym_LBRACK,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    STATE(80), 1,
      sym__field_name,
    STATE(84), 1,
      sym_string,
    STATE(296), 1,
      sym_definition,
    STATE(301), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [3295] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(162), 1,
      anon_sym__,
    ACTIONS(164), 1,
      anon_sym_DQUOTE,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(170), 1,
      anon_sym_LPAREN,
    STATE(81), 1,
      sym__field_name,
    STATE(103), 1,
      sym_string,
    STATE(298), 1,
      sym_definition,
    STATE(299), 6,
      sym_list,
      sym_grouping,
      sym_anonymous_node,
      sym_named_node,
      sym_field_definition,
      sym_predicate,
  [3331] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    STATE(230), 1,
      sym_quantifier,
    ACTIONS(261), 2,
      sym_identifier,
      anon_sym__,
    STATE(229), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(263), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [3360] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    STATE(182), 1,
      sym_quantifier,
    ACTIONS(225), 2,
      sym_identifier,
      anon_sym__,
    STATE(183), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(285), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(227), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [3389] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    STATE(198), 1,
      sym_quantifier,
    ACTIONS(237), 2,
      sym_identifier,
      anon_sym__,
    STATE(203), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(239), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [3418] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    STATE(202), 1,
      sym_quantifier,
    ACTIONS(221), 2,
      sym_identifier,
      anon_sym__,
    STATE(201), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(285), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(223), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [3447] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    STATE(242), 1,
      sym_quantifier,
    ACTIONS(213), 2,
      sym_identifier,
      anon_sym__,
    STATE(241), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(219), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [3476] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    STATE(177), 1,
      sym_quantifier,
    ACTIONS(213), 2,
      sym_identifier,
      anon_sym__,
    STATE(178), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(285), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(219), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [3505] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    STATE(240), 1,
      sym_quantifier,
    ACTIONS(241), 2,
      sym_identifier,
      anon_sym__,
    STATE(239), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(243), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [3534] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    STATE(247), 1,
      sym_quantifier,
    ACTIONS(233), 2,
      sym_identifier,
      anon_sym__,
    STATE(246), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(235), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [3563] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    STATE(251), 1,
      sym_quantifier,
    ACTIONS(277), 2,
      sym_identifier,
      anon_sym__,
    STATE(250), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(279), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [3592] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    STATE(186), 1,
      sym_quantifier,
    ACTIONS(265), 2,
      sym_identifier,
      anon_sym__,
    STATE(187), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(285), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(267), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [3621] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    STATE(206), 1,
      sym_quantifier,
    ACTIONS(269), 2,
      sym_identifier,
      anon_sym__,
    STATE(205), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(285), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(271), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [3650] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    STATE(237), 1,
      sym_quantifier,
    ACTIONS(225), 2,
      sym_identifier,
      anon_sym__,
    STATE(236), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(227), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [3679] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    STATE(193), 1,
      sym_quantifier,
    ACTIONS(249), 2,
      sym_identifier,
      anon_sym__,
    STATE(194), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(285), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(251), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [3708] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    STATE(232), 1,
      sym_quantifier,
    ACTIONS(265), 2,
      sym_identifier,
      anon_sym__,
    STATE(231), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(267), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [3737] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    STATE(234), 1,
      sym_quantifier,
    ACTIONS(257), 2,
      sym_identifier,
      anon_sym__,
    STATE(244), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(259), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [3766] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    STATE(248), 1,
      sym_quantifier,
    ACTIONS(245), 2,
      sym_identifier,
      anon_sym__,
    STATE(169), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(285), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(247), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [3795] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    STATE(171), 1,
      sym_quantifier,
    ACTIONS(277), 2,
      sym_identifier,
      anon_sym__,
    STATE(167), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(285), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(279), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [3824] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    STATE(221), 1,
      sym_quantifier,
    ACTIONS(253), 2,
      sym_identifier,
      anon_sym__,
    STATE(222), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(255), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [3853] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    STATE(225), 1,
      sym_quantifier,
    ACTIONS(249), 2,
      sym_identifier,
      anon_sym__,
    STATE(224), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(251), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [3882] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    STATE(256), 1,
      sym_quantifier,
    ACTIONS(245), 2,
      sym_identifier,
      anon_sym__,
    STATE(255), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(247), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [3911] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    STATE(173), 1,
      sym_quantifier,
    ACTIONS(233), 2,
      sym_identifier,
      anon_sym__,
    STATE(174), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(285), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(235), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [3940] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    STATE(220), 1,
      sym_quantifier,
    ACTIONS(237), 2,
      sym_identifier,
      anon_sym__,
    STATE(219), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(285), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(239), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [3969] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    STATE(263), 1,
      sym_quantifier,
    ACTIONS(221), 2,
      sym_identifier,
      anon_sym__,
    STATE(265), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(223), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [3998] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    STATE(188), 1,
      sym_quantifier,
    ACTIONS(261), 2,
      sym_identifier,
      anon_sym__,
    STATE(189), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(285), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(263), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4027] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    STATE(214), 1,
      sym_quantifier,
    ACTIONS(253), 2,
      sym_identifier,
      anon_sym__,
    STATE(213), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(285), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(255), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4056] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    STATE(212), 1,
      sym_quantifier,
    ACTIONS(257), 2,
      sym_identifier,
      anon_sym__,
    STATE(211), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(285), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(259), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4085] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    STATE(179), 1,
      sym_quantifier,
    ACTIONS(241), 2,
      sym_identifier,
      anon_sym__,
    STATE(180), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(285), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(243), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4114] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    STATE(261), 1,
      sym_quantifier,
    ACTIONS(269), 2,
      sym_identifier,
      anon_sym__,
    STATE(262), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(271), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4143] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    STATE(252), 1,
      sym_quantifier,
    ACTIONS(229), 2,
      sym_identifier,
      anon_sym__,
    STATE(254), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(281), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(231), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [4172] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    STATE(209), 1,
      sym_quantifier,
    ACTIONS(229), 2,
      sym_identifier,
      anon_sym__,
    STATE(208), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(285), 3,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
    ACTIONS(231), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [4201] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(291), 9,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4221] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(295), 9,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4241] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(157), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(297), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(299), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4264] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(150), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(301), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(303), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4287] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(125), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(305), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(307), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4310] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(309), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(311), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4333] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(225), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(227), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4356] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(124), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(313), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(315), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4379] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(317), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(319), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4402] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(321), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(323), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4425] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(325), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(327), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4448] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(145), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(329), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(331), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4471] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(333), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(335), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4494] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(337), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(339), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4517] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(241), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(243), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4540] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(245), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(247), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4563] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(117), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(341), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(343), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4586] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(345), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(347), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4609] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(295), 9,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [4628] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(261), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(263), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4651] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(265), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(267), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4674] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(349), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(351), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4697] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(139), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(353), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(355), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4720] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(121), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(357), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(359), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4743] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(361), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(363), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4766] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(156), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(365), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(367), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4789] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(291), 9,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [4808] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(369), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(371), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4831] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(221), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(223), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4854] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(233), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(235), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4877] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(129), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(373), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(375), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4900] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(213), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(219), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4923] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(120), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(377), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(379), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4946] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(381), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(383), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4969] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(229), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(231), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [4992] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(136), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(385), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(387), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5015] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(391), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(389), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(394), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5038] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(396), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(398), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5061] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(400), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(402), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5084] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(404), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(406), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5107] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(159), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(408), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(410), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5130] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(412), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(414), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5153] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(249), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(251), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5176] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(416), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(418), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5199] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(420), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(422), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5222] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(424), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(426), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5245] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(149), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(428), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(430), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5268] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(432), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(434), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5291] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(153), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(436), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(438), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5314] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_AT,
    STATE(148), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(440), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(442), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5337] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(444), 1,
      anon_sym_SLASH,
    ACTIONS(446), 1,
      anon_sym_COLON,
    ACTIONS(273), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(275), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5359] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(291), 8,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5377] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(446), 1,
      anon_sym_COLON,
    ACTIONS(448), 1,
      anon_sym_SLASH,
    ACTIONS(273), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(275), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5399] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(295), 8,
      ts_builtin_sym_end,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_QMARK,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [5417] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(446), 1,
      anon_sym_COLON,
    ACTIONS(450), 1,
      anon_sym_SLASH,
    ACTIONS(273), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(275), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [5439] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(213), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(219), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5460] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(455), 1,
      anon_sym_AT,
    ACTIONS(458), 1,
      anon_sym_DQUOTE,
    ACTIONS(461), 1,
      anon_sym_RPAREN,
    ACTIONS(452), 2,
      sym_identifier,
      anon_sym__,
    STATE(168), 4,
      sym__node_identifier,
      sym_capture,
      sym_string,
      aux_sym_parameters_repeat1,
  [5483] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(233), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(235), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5504] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(381), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(383), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5525] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(377), 2,
      sym_identifier,
      anon_sym__,
    STATE(176), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(379), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5546] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_DQUOTE,
    ACTIONS(287), 1,
      anon_sym_AT,
    STATE(328), 1,
      sym_parameters,
    ACTIONS(463), 2,
      sym_identifier,
      anon_sym__,
    STATE(260), 4,
      sym__node_identifier,
      sym_capture,
      sym_string,
      aux_sym_parameters_repeat1,
  [5569] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(353), 2,
      sym_identifier,
      anon_sym__,
    STATE(181), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(355), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5590] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(241), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(243), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5611] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(337), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(339), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5632] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(317), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(319), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5653] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(313), 2,
      sym_identifier,
      anon_sym__,
    STATE(184), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(315), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5674] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(225), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(227), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5695] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(301), 2,
      sym_identifier,
      anon_sym__,
    STATE(185), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(303), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5716] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(265), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(267), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5737] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(369), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(371), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5758] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(365), 2,
      sym_identifier,
      anon_sym__,
    STATE(190), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(367), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5779] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(261), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(263), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5800] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(333), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(335), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5821] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(400), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(402), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5842] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(297), 2,
      sym_identifier,
      anon_sym__,
    STATE(191), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(299), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5863] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(404), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(406), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5884] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(408), 2,
      sym_identifier,
      anon_sym__,
    STATE(192), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(410), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5905] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(249), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(251), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5926] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(420), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(422), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5947] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(424), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(426), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5968] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(432), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(434), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [5989] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(436), 2,
      sym_identifier,
      anon_sym__,
    STATE(195), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(438), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6010] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(440), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(442), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6031] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(412), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(414), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6052] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_DQUOTE,
    ACTIONS(287), 1,
      anon_sym_AT,
    STATE(320), 1,
      sym_parameters,
    ACTIONS(463), 2,
      sym_identifier,
      anon_sym__,
    STATE(260), 4,
      sym__node_identifier,
      sym_capture,
      sym_string,
      aux_sym_parameters_repeat1,
  [6075] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(465), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(467), 6,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [6092] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(428), 2,
      sym_identifier,
      anon_sym__,
    STATE(217), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(430), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6113] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(309), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(311), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6134] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(321), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(323), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6155] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(325), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(327), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6176] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(329), 2,
      sym_identifier,
      anon_sym__,
    STATE(170), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(331), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6197] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(416), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(418), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6218] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(469), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(471), 6,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [6235] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(245), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(247), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6256] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(341), 2,
      sym_identifier,
      anon_sym__,
    STATE(199), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(343), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6277] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(345), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(347), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6298] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(349), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(351), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6319] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(357), 2,
      sym_identifier,
      anon_sym__,
    STATE(200), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(359), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6340] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(361), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(363), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6361] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(221), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(223), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6382] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(373), 2,
      sym_identifier,
      anon_sym__,
    STATE(207), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(375), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6403] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(229), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(231), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6424] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(385), 2,
      sym_identifier,
      anon_sym__,
    STATE(210), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(387), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6445] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 1,
      anon_sym_AT,
    ACTIONS(389), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(394), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6466] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(396), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(398), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6487] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(396), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(398), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6508] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(476), 1,
      anon_sym_AT,
    ACTIONS(389), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(394), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6529] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(416), 2,
      sym_identifier,
      anon_sym__,
    STATE(215), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(418), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6550] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(428), 2,
      sym_identifier,
      anon_sym__,
    STATE(216), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(430), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [6571] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(385), 2,
      sym_identifier,
      anon_sym__,
    STATE(249), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(387), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6592] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(229), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(231), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6613] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(412), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(414), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6634] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(440), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(442), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6655] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(436), 2,
      sym_identifier,
      anon_sym__,
    STATE(223), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(438), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6676] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(432), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(434), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6697] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(424), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(426), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6718] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(420), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(422), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6739] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(249), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(251), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6760] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(408), 2,
      sym_identifier,
      anon_sym__,
    STATE(226), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(410), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6781] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(404), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(406), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6802] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(297), 2,
      sym_identifier,
      anon_sym__,
    STATE(227), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(299), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6823] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(400), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(402), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6844] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(373), 2,
      sym_identifier,
      anon_sym__,
    STATE(257), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(375), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6865] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(333), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(335), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6886] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(261), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(263), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6907] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(365), 2,
      sym_identifier,
      anon_sym__,
    STATE(228), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(367), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6928] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(369), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(371), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6949] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(265), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(267), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6970] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(301), 2,
      sym_identifier,
      anon_sym__,
    STATE(233), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(303), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [6991] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(225), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(227), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7012] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(313), 2,
      sym_identifier,
      anon_sym__,
    STATE(235), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(315), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7033] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(317), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(319), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7054] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(221), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(223), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7075] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(337), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(339), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7096] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(241), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(243), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7117] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(353), 2,
      sym_identifier,
      anon_sym__,
    STATE(238), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(355), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7138] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(305), 2,
      sym_identifier,
      anon_sym__,
    STATE(175), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(307), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [7159] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(361), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(363), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7180] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(213), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(219), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7201] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(377), 2,
      sym_identifier,
      anon_sym__,
    STATE(243), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(379), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7222] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(357), 2,
      sym_identifier,
      anon_sym__,
    STATE(264), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(359), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7243] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(381), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(383), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7264] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(349), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(351), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7285] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(233), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(235), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7306] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(305), 2,
      sym_identifier,
      anon_sym__,
    STATE(245), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(307), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7327] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(345), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(347), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7348] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(309), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(311), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7369] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_DQUOTE,
    ACTIONS(287), 1,
      anon_sym_AT,
    STATE(321), 1,
      sym_parameters,
    ACTIONS(463), 2,
      sym_identifier,
      anon_sym__,
    STATE(260), 4,
      sym__node_identifier,
      sym_capture,
      sym_string,
      aux_sym_parameters_repeat1,
  [7392] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 1,
      anon_sym_DQUOTE,
    ACTIONS(287), 1,
      anon_sym_AT,
    ACTIONS(481), 1,
      anon_sym_RPAREN,
    ACTIONS(479), 2,
      sym_identifier,
      anon_sym__,
    STATE(168), 4,
      sym__node_identifier,
      sym_capture,
      sym_string,
      aux_sym_parameters_repeat1,
  [7415] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(341), 2,
      sym_identifier,
      anon_sym__,
    STATE(258), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(343), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7436] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(245), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(247), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7457] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(329), 2,
      sym_identifier,
      anon_sym__,
    STATE(253), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(331), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7478] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(321), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(323), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7499] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(283), 1,
      anon_sym_AT,
    ACTIONS(325), 2,
      sym_identifier,
      anon_sym__,
    STATE(218), 2,
      sym_capture,
      aux_sym_list_repeat1,
    ACTIONS(327), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7520] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(483), 1,
      anon_sym_DOT,
    ACTIONS(485), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(487), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7538] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(489), 1,
      anon_sym_DOT,
    ACTIONS(485), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(487), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7556] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(491), 1,
      anon_sym_DOT,
    ACTIONS(485), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(487), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7574] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(493), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(495), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7590] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(497), 1,
      anon_sym_DOT,
    ACTIONS(485), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(487), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7608] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 1,
      anon_sym_DOT,
    ACTIONS(485), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(487), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7626] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 1,
      anon_sym_DOT,
    ACTIONS(485), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(487), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7644] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(469), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(471), 6,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [7660] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 1,
      anon_sym_DOT,
    ACTIONS(485), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(487), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7678] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(505), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(507), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7694] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 1,
      anon_sym_DOT,
    ACTIONS(485), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(487), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7712] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(511), 1,
      anon_sym_DOT,
    ACTIONS(485), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(487), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7730] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 1,
      anon_sym_DOT,
    ACTIONS(485), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(487), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7748] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 1,
      anon_sym_DOT,
    ACTIONS(485), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(487), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7766] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(517), 1,
      anon_sym_DOT,
    ACTIONS(485), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(487), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7784] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(519), 1,
      anon_sym_DOT,
    ACTIONS(485), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(487), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7802] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(521), 1,
      anon_sym_DOT,
    ACTIONS(485), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(487), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7820] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(523), 1,
      anon_sym_DOT,
    ACTIONS(485), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(487), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7838] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(525), 1,
      anon_sym_DOT,
    ACTIONS(485), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(487), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7856] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(527), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(529), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7872] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(531), 1,
      anon_sym_DOT,
    ACTIONS(485), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(487), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7890] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(533), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(535), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7906] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(537), 1,
      anon_sym_DOT,
    ACTIONS(485), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(487), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7924] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(539), 1,
      anon_sym_DOT,
    ACTIONS(485), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(487), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7942] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(541), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(543), 5,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANG,
  [7958] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(465), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(467), 5,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [7973] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(465), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(467), 5,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [7988] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(545), 3,
      anon_sym_DOT,
      sym_identifier,
      anon_sym__,
    ACTIONS(547), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [8003] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(469), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(471), 5,
      ts_builtin_sym_end,
      anon_sym_AT,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [8018] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(549), 1,
      anon_sym_DOT,
    ACTIONS(551), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(553), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
  [8035] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(533), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(535), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [8049] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(527), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(529), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [8063] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(533), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(535), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [8077] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(541), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(543), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [8091] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(527), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(529), 4,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
  [8105] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(541), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(543), 4,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [8119] = 5,
    ACTIONS(557), 1,
      anon_sym_DQUOTE,
    ACTIONS(559), 1,
      sym_comment,
    STATE(306), 1,
      aux_sym_string_content_repeat1,
    STATE(322), 1,
      sym_string_content,
    ACTIONS(555), 2,
      sym_escape_sequence,
      aux_sym_string_content_token1,
  [8136] = 5,
    ACTIONS(559), 1,
      sym_comment,
    ACTIONS(561), 1,
      anon_sym_DQUOTE,
    STATE(306), 1,
      aux_sym_string_content_repeat1,
    STATE(317), 1,
      sym_string_content,
    ACTIONS(555), 2,
      sym_escape_sequence,
      aux_sym_string_content_token1,
  [8153] = 5,
    ACTIONS(559), 1,
      sym_comment,
    ACTIONS(563), 1,
      anon_sym_DQUOTE,
    STATE(306), 1,
      aux_sym_string_content_repeat1,
    STATE(325), 1,
      sym_string_content,
    ACTIONS(555), 2,
      sym_escape_sequence,
      aux_sym_string_content_token1,
  [8170] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(565), 2,
      sym_identifier,
      anon_sym__,
    ACTIONS(567), 3,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
  [8183] = 4,
    ACTIONS(559), 1,
      sym_comment,
    ACTIONS(571), 1,
      anon_sym_DQUOTE,
    STATE(307), 1,
      aux_sym_string_content_repeat1,
    ACTIONS(569), 2,
      sym_escape_sequence,
      aux_sym_string_content_token1,
  [8197] = 4,
    ACTIONS(559), 1,
      sym_comment,
    ACTIONS(576), 1,
      anon_sym_DQUOTE,
    STATE(307), 1,
      aux_sym_string_content_repeat1,
    ACTIONS(573), 2,
      sym_escape_sequence,
      aux_sym_string_content_token1,
  [8211] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(578), 1,
      aux_sym__immediate_identifier_token1,
    STATE(318), 1,
      sym__immediate_identifier,
  [8221] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(580), 1,
      aux_sym__immediate_identifier_token1,
    STATE(326), 1,
      sym__immediate_identifier,
  [8231] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(582), 1,
      aux_sym__immediate_identifier_token1,
    STATE(324), 1,
      sym__immediate_identifier,
  [8241] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(584), 1,
      aux_sym__immediate_identifier_token1,
    STATE(2), 1,
      sym__immediate_identifier,
  [8251] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(586), 1,
      aux_sym__immediate_identifier_token1,
    STATE(294), 1,
      sym__immediate_identifier,
  [8261] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(588), 1,
      aux_sym__immediate_identifier_token1,
    STATE(273), 1,
      sym__immediate_identifier,
  [8271] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(590), 1,
      aux_sym__immediate_identifier_token1,
    STATE(5), 1,
      sym__immediate_identifier,
  [8281] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(592), 1,
      aux_sym__immediate_identifier_token1,
    STATE(204), 1,
      sym__immediate_identifier,
  [8291] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(594), 1,
      aux_sym__immediate_identifier_token1,
    STATE(6), 1,
      sym__immediate_identifier,
  [8301] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(596), 1,
      anon_sym_DQUOTE,
  [8308] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(598), 1,
      sym_predicate_type,
  [8315] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(600), 1,
      sym_identifier,
  [8322] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 1,
      anon_sym_RPAREN,
  [8329] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(604), 1,
      anon_sym_RPAREN,
  [8336] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 1,
      anon_sym_DQUOTE,
  [8343] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(608), 1,
      ts_builtin_sym_end,
  [8350] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(610), 1,
      sym_predicate_type,
  [8357] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(612), 1,
      anon_sym_DQUOTE,
  [8364] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(614), 1,
      sym_predicate_type,
  [8371] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(446), 1,
      anon_sym_COLON,
  [8378] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(616), 1,
      anon_sym_RPAREN,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 50,
  [SMALL_STATE(4)] = 100,
  [SMALL_STATE(5)] = 150,
  [SMALL_STATE(6)] = 200,
  [SMALL_STATE(7)] = 250,
  [SMALL_STATE(8)] = 300,
  [SMALL_STATE(9)] = 349,
  [SMALL_STATE(10)] = 396,
  [SMALL_STATE(11)] = 443,
  [SMALL_STATE(12)] = 490,
  [SMALL_STATE(13)] = 537,
  [SMALL_STATE(14)] = 584,
  [SMALL_STATE(15)] = 631,
  [SMALL_STATE(16)] = 678,
  [SMALL_STATE(17)] = 725,
  [SMALL_STATE(18)] = 772,
  [SMALL_STATE(19)] = 819,
  [SMALL_STATE(20)] = 866,
  [SMALL_STATE(21)] = 915,
  [SMALL_STATE(22)] = 962,
  [SMALL_STATE(23)] = 1011,
  [SMALL_STATE(24)] = 1058,
  [SMALL_STATE(25)] = 1102,
  [SMALL_STATE(26)] = 1146,
  [SMALL_STATE(27)] = 1190,
  [SMALL_STATE(28)] = 1234,
  [SMALL_STATE(29)] = 1278,
  [SMALL_STATE(30)] = 1322,
  [SMALL_STATE(31)] = 1366,
  [SMALL_STATE(32)] = 1410,
  [SMALL_STATE(33)] = 1454,
  [SMALL_STATE(34)] = 1498,
  [SMALL_STATE(35)] = 1542,
  [SMALL_STATE(36)] = 1586,
  [SMALL_STATE(37)] = 1630,
  [SMALL_STATE(38)] = 1674,
  [SMALL_STATE(39)] = 1718,
  [SMALL_STATE(40)] = 1762,
  [SMALL_STATE(41)] = 1806,
  [SMALL_STATE(42)] = 1850,
  [SMALL_STATE(43)] = 1894,
  [SMALL_STATE(44)] = 1938,
  [SMALL_STATE(45)] = 1982,
  [SMALL_STATE(46)] = 2026,
  [SMALL_STATE(47)] = 2070,
  [SMALL_STATE(48)] = 2114,
  [SMALL_STATE(49)] = 2157,
  [SMALL_STATE(50)] = 2200,
  [SMALL_STATE(51)] = 2243,
  [SMALL_STATE(52)] = 2286,
  [SMALL_STATE(53)] = 2327,
  [SMALL_STATE(54)] = 2367,
  [SMALL_STATE(55)] = 2407,
  [SMALL_STATE(56)] = 2447,
  [SMALL_STATE(57)] = 2487,
  [SMALL_STATE(58)] = 2527,
  [SMALL_STATE(59)] = 2567,
  [SMALL_STATE(60)] = 2607,
  [SMALL_STATE(61)] = 2647,
  [SMALL_STATE(62)] = 2687,
  [SMALL_STATE(63)] = 2727,
  [SMALL_STATE(64)] = 2758,
  [SMALL_STATE(65)] = 2789,
  [SMALL_STATE(66)] = 2820,
  [SMALL_STATE(67)] = 2851,
  [SMALL_STATE(68)] = 2882,
  [SMALL_STATE(69)] = 2913,
  [SMALL_STATE(70)] = 2944,
  [SMALL_STATE(71)] = 2975,
  [SMALL_STATE(72)] = 3006,
  [SMALL_STATE(73)] = 3037,
  [SMALL_STATE(74)] = 3068,
  [SMALL_STATE(75)] = 3099,
  [SMALL_STATE(76)] = 3130,
  [SMALL_STATE(77)] = 3161,
  [SMALL_STATE(78)] = 3192,
  [SMALL_STATE(79)] = 3223,
  [SMALL_STATE(80)] = 3259,
  [SMALL_STATE(81)] = 3295,
  [SMALL_STATE(82)] = 3331,
  [SMALL_STATE(83)] = 3360,
  [SMALL_STATE(84)] = 3389,
  [SMALL_STATE(85)] = 3418,
  [SMALL_STATE(86)] = 3447,
  [SMALL_STATE(87)] = 3476,
  [SMALL_STATE(88)] = 3505,
  [SMALL_STATE(89)] = 3534,
  [SMALL_STATE(90)] = 3563,
  [SMALL_STATE(91)] = 3592,
  [SMALL_STATE(92)] = 3621,
  [SMALL_STATE(93)] = 3650,
  [SMALL_STATE(94)] = 3679,
  [SMALL_STATE(95)] = 3708,
  [SMALL_STATE(96)] = 3737,
  [SMALL_STATE(97)] = 3766,
  [SMALL_STATE(98)] = 3795,
  [SMALL_STATE(99)] = 3824,
  [SMALL_STATE(100)] = 3853,
  [SMALL_STATE(101)] = 3882,
  [SMALL_STATE(102)] = 3911,
  [SMALL_STATE(103)] = 3940,
  [SMALL_STATE(104)] = 3969,
  [SMALL_STATE(105)] = 3998,
  [SMALL_STATE(106)] = 4027,
  [SMALL_STATE(107)] = 4056,
  [SMALL_STATE(108)] = 4085,
  [SMALL_STATE(109)] = 4114,
  [SMALL_STATE(110)] = 4143,
  [SMALL_STATE(111)] = 4172,
  [SMALL_STATE(112)] = 4201,
  [SMALL_STATE(113)] = 4221,
  [SMALL_STATE(114)] = 4241,
  [SMALL_STATE(115)] = 4264,
  [SMALL_STATE(116)] = 4287,
  [SMALL_STATE(117)] = 4310,
  [SMALL_STATE(118)] = 4333,
  [SMALL_STATE(119)] = 4356,
  [SMALL_STATE(120)] = 4379,
  [SMALL_STATE(121)] = 4402,
  [SMALL_STATE(122)] = 4425,
  [SMALL_STATE(123)] = 4448,
  [SMALL_STATE(124)] = 4471,
  [SMALL_STATE(125)] = 4494,
  [SMALL_STATE(126)] = 4517,
  [SMALL_STATE(127)] = 4540,
  [SMALL_STATE(128)] = 4563,
  [SMALL_STATE(129)] = 4586,
  [SMALL_STATE(130)] = 4609,
  [SMALL_STATE(131)] = 4628,
  [SMALL_STATE(132)] = 4651,
  [SMALL_STATE(133)] = 4674,
  [SMALL_STATE(134)] = 4697,
  [SMALL_STATE(135)] = 4720,
  [SMALL_STATE(136)] = 4743,
  [SMALL_STATE(137)] = 4766,
  [SMALL_STATE(138)] = 4789,
  [SMALL_STATE(139)] = 4808,
  [SMALL_STATE(140)] = 4831,
  [SMALL_STATE(141)] = 4854,
  [SMALL_STATE(142)] = 4877,
  [SMALL_STATE(143)] = 4900,
  [SMALL_STATE(144)] = 4923,
  [SMALL_STATE(145)] = 4946,
  [SMALL_STATE(146)] = 4969,
  [SMALL_STATE(147)] = 4992,
  [SMALL_STATE(148)] = 5015,
  [SMALL_STATE(149)] = 5038,
  [SMALL_STATE(150)] = 5061,
  [SMALL_STATE(151)] = 5084,
  [SMALL_STATE(152)] = 5107,
  [SMALL_STATE(153)] = 5130,
  [SMALL_STATE(154)] = 5153,
  [SMALL_STATE(155)] = 5176,
  [SMALL_STATE(156)] = 5199,
  [SMALL_STATE(157)] = 5222,
  [SMALL_STATE(158)] = 5245,
  [SMALL_STATE(159)] = 5268,
  [SMALL_STATE(160)] = 5291,
  [SMALL_STATE(161)] = 5314,
  [SMALL_STATE(162)] = 5337,
  [SMALL_STATE(163)] = 5359,
  [SMALL_STATE(164)] = 5377,
  [SMALL_STATE(165)] = 5399,
  [SMALL_STATE(166)] = 5417,
  [SMALL_STATE(167)] = 5439,
  [SMALL_STATE(168)] = 5460,
  [SMALL_STATE(169)] = 5483,
  [SMALL_STATE(170)] = 5504,
  [SMALL_STATE(171)] = 5525,
  [SMALL_STATE(172)] = 5546,
  [SMALL_STATE(173)] = 5569,
  [SMALL_STATE(174)] = 5590,
  [SMALL_STATE(175)] = 5611,
  [SMALL_STATE(176)] = 5632,
  [SMALL_STATE(177)] = 5653,
  [SMALL_STATE(178)] = 5674,
  [SMALL_STATE(179)] = 5695,
  [SMALL_STATE(180)] = 5716,
  [SMALL_STATE(181)] = 5737,
  [SMALL_STATE(182)] = 5758,
  [SMALL_STATE(183)] = 5779,
  [SMALL_STATE(184)] = 5800,
  [SMALL_STATE(185)] = 5821,
  [SMALL_STATE(186)] = 5842,
  [SMALL_STATE(187)] = 5863,
  [SMALL_STATE(188)] = 5884,
  [SMALL_STATE(189)] = 5905,
  [SMALL_STATE(190)] = 5926,
  [SMALL_STATE(191)] = 5947,
  [SMALL_STATE(192)] = 5968,
  [SMALL_STATE(193)] = 5989,
  [SMALL_STATE(194)] = 6010,
  [SMALL_STATE(195)] = 6031,
  [SMALL_STATE(196)] = 6052,
  [SMALL_STATE(197)] = 6075,
  [SMALL_STATE(198)] = 6092,
  [SMALL_STATE(199)] = 6113,
  [SMALL_STATE(200)] = 6134,
  [SMALL_STATE(201)] = 6155,
  [SMALL_STATE(202)] = 6176,
  [SMALL_STATE(203)] = 6197,
  [SMALL_STATE(204)] = 6218,
  [SMALL_STATE(205)] = 6235,
  [SMALL_STATE(206)] = 6256,
  [SMALL_STATE(207)] = 6277,
  [SMALL_STATE(208)] = 6298,
  [SMALL_STATE(209)] = 6319,
  [SMALL_STATE(210)] = 6340,
  [SMALL_STATE(211)] = 6361,
  [SMALL_STATE(212)] = 6382,
  [SMALL_STATE(213)] = 6403,
  [SMALL_STATE(214)] = 6424,
  [SMALL_STATE(215)] = 6445,
  [SMALL_STATE(216)] = 6466,
  [SMALL_STATE(217)] = 6487,
  [SMALL_STATE(218)] = 6508,
  [SMALL_STATE(219)] = 6529,
  [SMALL_STATE(220)] = 6550,
  [SMALL_STATE(221)] = 6571,
  [SMALL_STATE(222)] = 6592,
  [SMALL_STATE(223)] = 6613,
  [SMALL_STATE(224)] = 6634,
  [SMALL_STATE(225)] = 6655,
  [SMALL_STATE(226)] = 6676,
  [SMALL_STATE(227)] = 6697,
  [SMALL_STATE(228)] = 6718,
  [SMALL_STATE(229)] = 6739,
  [SMALL_STATE(230)] = 6760,
  [SMALL_STATE(231)] = 6781,
  [SMALL_STATE(232)] = 6802,
  [SMALL_STATE(233)] = 6823,
  [SMALL_STATE(234)] = 6844,
  [SMALL_STATE(235)] = 6865,
  [SMALL_STATE(236)] = 6886,
  [SMALL_STATE(237)] = 6907,
  [SMALL_STATE(238)] = 6928,
  [SMALL_STATE(239)] = 6949,
  [SMALL_STATE(240)] = 6970,
  [SMALL_STATE(241)] = 6991,
  [SMALL_STATE(242)] = 7012,
  [SMALL_STATE(243)] = 7033,
  [SMALL_STATE(244)] = 7054,
  [SMALL_STATE(245)] = 7075,
  [SMALL_STATE(246)] = 7096,
  [SMALL_STATE(247)] = 7117,
  [SMALL_STATE(248)] = 7138,
  [SMALL_STATE(249)] = 7159,
  [SMALL_STATE(250)] = 7180,
  [SMALL_STATE(251)] = 7201,
  [SMALL_STATE(252)] = 7222,
  [SMALL_STATE(253)] = 7243,
  [SMALL_STATE(254)] = 7264,
  [SMALL_STATE(255)] = 7285,
  [SMALL_STATE(256)] = 7306,
  [SMALL_STATE(257)] = 7327,
  [SMALL_STATE(258)] = 7348,
  [SMALL_STATE(259)] = 7369,
  [SMALL_STATE(260)] = 7392,
  [SMALL_STATE(261)] = 7415,
  [SMALL_STATE(262)] = 7436,
  [SMALL_STATE(263)] = 7457,
  [SMALL_STATE(264)] = 7478,
  [SMALL_STATE(265)] = 7499,
  [SMALL_STATE(266)] = 7520,
  [SMALL_STATE(267)] = 7538,
  [SMALL_STATE(268)] = 7556,
  [SMALL_STATE(269)] = 7574,
  [SMALL_STATE(270)] = 7590,
  [SMALL_STATE(271)] = 7608,
  [SMALL_STATE(272)] = 7626,
  [SMALL_STATE(273)] = 7644,
  [SMALL_STATE(274)] = 7660,
  [SMALL_STATE(275)] = 7678,
  [SMALL_STATE(276)] = 7694,
  [SMALL_STATE(277)] = 7712,
  [SMALL_STATE(278)] = 7730,
  [SMALL_STATE(279)] = 7748,
  [SMALL_STATE(280)] = 7766,
  [SMALL_STATE(281)] = 7784,
  [SMALL_STATE(282)] = 7802,
  [SMALL_STATE(283)] = 7820,
  [SMALL_STATE(284)] = 7838,
  [SMALL_STATE(285)] = 7856,
  [SMALL_STATE(286)] = 7872,
  [SMALL_STATE(287)] = 7890,
  [SMALL_STATE(288)] = 7906,
  [SMALL_STATE(289)] = 7924,
  [SMALL_STATE(290)] = 7942,
  [SMALL_STATE(291)] = 7958,
  [SMALL_STATE(292)] = 7973,
  [SMALL_STATE(293)] = 7988,
  [SMALL_STATE(294)] = 8003,
  [SMALL_STATE(295)] = 8018,
  [SMALL_STATE(296)] = 8035,
  [SMALL_STATE(297)] = 8049,
  [SMALL_STATE(298)] = 8063,
  [SMALL_STATE(299)] = 8077,
  [SMALL_STATE(300)] = 8091,
  [SMALL_STATE(301)] = 8105,
  [SMALL_STATE(302)] = 8119,
  [SMALL_STATE(303)] = 8136,
  [SMALL_STATE(304)] = 8153,
  [SMALL_STATE(305)] = 8170,
  [SMALL_STATE(306)] = 8183,
  [SMALL_STATE(307)] = 8197,
  [SMALL_STATE(308)] = 8211,
  [SMALL_STATE(309)] = 8221,
  [SMALL_STATE(310)] = 8231,
  [SMALL_STATE(311)] = 8241,
  [SMALL_STATE(312)] = 8251,
  [SMALL_STATE(313)] = 8261,
  [SMALL_STATE(314)] = 8271,
  [SMALL_STATE(315)] = 8281,
  [SMALL_STATE(316)] = 8291,
  [SMALL_STATE(317)] = 8301,
  [SMALL_STATE(318)] = 8308,
  [SMALL_STATE(319)] = 8315,
  [SMALL_STATE(320)] = 8322,
  [SMALL_STATE(321)] = 8329,
  [SMALL_STATE(322)] = 8336,
  [SMALL_STATE(323)] = 8343,
  [SMALL_STATE(324)] = 8350,
  [SMALL_STATE(325)] = 8357,
  [SMALL_STATE(326)] = 8364,
  [SMALL_STATE(327)] = 8371,
  [SMALL_STATE(328)] = 8378,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 0, 0, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(327),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(68),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(39),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(43),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(37),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(47),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(164),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(77),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [75] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_named_node_repeat1, 2, 0, 0), SHIFT_REPEAT(327),
  [78] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_named_node_repeat1, 2, 0, 0), SHIFT_REPEAT(68),
  [81] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2, 0, 0), SHIFT_REPEAT(304),
  [84] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2, 0, 0), SHIFT_REPEAT(53),
  [87] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2, 0, 0), SHIFT_REPEAT(22),
  [90] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2, 0, 0),
  [92] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2, 0, 0), SHIFT_REPEAT(319),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [99] = {.entry = {.count = 1, .reusable = false}}, SHIFT(166),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [107] = {.entry = {.count = 1, .reusable = false}}, SHIFT(162),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [141] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_grouping_repeat1, 2, 0, 0), SHIFT_REPEAT(327),
  [144] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_grouping_repeat1, 2, 0, 0), SHIFT_REPEAT(68),
  [147] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_grouping_repeat1, 2, 0, 0), SHIFT_REPEAT(304),
  [150] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_grouping_repeat1, 2, 0, 0), SHIFT_REPEAT(53),
  [153] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_grouping_repeat1, 2, 0, 0), SHIFT_REPEAT(22),
  [156] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_grouping_repeat1, 2, 0, 0),
  [158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [162] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [176] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0),
  [178] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(327),
  [181] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(84),
  [184] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(302),
  [187] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(62),
  [190] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(8),
  [193] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 1, 0, 0),
  [195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [197] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(103),
  [200] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(303),
  [203] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(54),
  [206] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(20),
  [209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [213] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 6, 0, 7),
  [215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [219] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 6, 0, 7),
  [221] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_grouping, 3, 0, 0),
  [223] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_grouping, 3, 0, 0),
  [225] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 7, 0, 7),
  [227] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 7, 0, 7),
  [229] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 3, 0, 0),
  [231] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 3, 0, 0),
  [233] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 5, 0, 3),
  [235] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 5, 0, 3),
  [237] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_node, 1, 0, 1),
  [239] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_node, 1, 0, 1),
  [241] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 6, 0, 3),
  [243] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 6, 0, 3),
  [245] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 4, 0, 3),
  [247] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 4, 0, 3),
  [249] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 9, 0, 7),
  [251] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 9, 0, 7),
  [253] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 2, 0, 0),
  [255] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 2, 0, 0),
  [257] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_grouping, 2, 0, 0),
  [259] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_grouping, 2, 0, 0),
  [261] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 8, 0, 7),
  [263] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 8, 0, 7),
  [265] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 7, 0, 3),
  [267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 7, 0, 3),
  [269] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 3, 0, 3),
  [271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 3, 0, 3),
  [273] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__node_identifier, 1, 0, 0),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__node_identifier, 1, 0, 0),
  [277] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 5, 0, 7),
  [279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 5, 0, 7),
  [281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [289] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3, 0, 0),
  [291] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, 0, 0),
  [293] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2, 0, 0),
  [295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, 0, 0),
  [297] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 8, 0, 15),
  [299] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 8, 0, 15),
  [301] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 7, 0, 13),
  [303] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 7, 0, 13),
  [305] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 5, 0, 8),
  [307] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 5, 0, 8),
  [309] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 5, 0, 6),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 5, 0, 6),
  [313] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 7, 0, 12),
  [315] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 7, 0, 12),
  [317] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 7, 0, 9),
  [319] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 7, 0, 9),
  [321] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 5, 0, 5),
  [323] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 5, 0, 5),
  [325] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_grouping, 4, 0, 0),
  [327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_grouping, 4, 0, 0),
  [329] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_grouping, 4, 0, 5),
  [331] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_grouping, 4, 0, 5),
  [333] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 8, 0, 12),
  [335] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 8, 0, 12),
  [337] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 6, 0, 8),
  [339] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 6, 0, 8),
  [341] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 4, 0, 6),
  [343] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 4, 0, 6),
  [345] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_grouping, 4, 0, 4),
  [347] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_grouping, 4, 0, 4),
  [349] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 4, 0, 0),
  [351] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 4, 0, 0),
  [353] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 6, 0, 11),
  [355] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 6, 0, 11),
  [357] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 4, 0, 5),
  [359] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 4, 0, 5),
  [361] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 4, 0, 4),
  [363] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 4, 0, 4),
  [365] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 8, 0, 14),
  [367] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 8, 0, 14),
  [369] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 7, 0, 11),
  [371] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 7, 0, 11),
  [373] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_grouping, 3, 0, 4),
  [375] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_grouping, 3, 0, 4),
  [377] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 6, 0, 9),
  [379] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 6, 0, 9),
  [381] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_grouping, 5, 0, 5),
  [383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_grouping, 5, 0, 5),
  [385] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 3, 0, 4),
  [387] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 3, 0, 4),
  [389] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0),
  [391] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0), SHIFT_REPEAT(315),
  [394] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0),
  [396] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_node, 3, 0, 2),
  [398] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_node, 3, 0, 2),
  [400] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 8, 0, 13),
  [402] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 8, 0, 13),
  [404] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 8, 0, 3),
  [406] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 8, 0, 3),
  [408] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 9, 0, 16),
  [410] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 9, 0, 16),
  [412] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 11, 0, 17),
  [414] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 11, 0, 17),
  [416] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_node, 2, 0, 1),
  [418] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_node, 2, 0, 1),
  [420] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 9, 0, 14),
  [422] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 9, 0, 14),
  [424] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 9, 0, 15),
  [426] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 9, 0, 15),
  [428] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_node, 2, 0, 2),
  [430] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_node, 2, 0, 2),
  [432] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 10, 0, 16),
  [434] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 10, 0, 16),
  [436] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 10, 0, 17),
  [438] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 10, 0, 17),
  [440] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 10, 0, 7),
  [442] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 10, 0, 7),
  [444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [452] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(168),
  [455] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(313),
  [458] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameters_repeat1, 2, 0, 0), SHIFT_REPEAT(303),
  [461] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameters_repeat1, 2, 0, 0),
  [463] = {.entry = {.count = 1, .reusable = false}}, SHIFT(260),
  [465] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quantifier, 1, 0, 0),
  [467] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quantifier, 1, 0, 0),
  [469] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_capture, 2, 0, 3),
  [471] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_capture, 2, 0, 3),
  [473] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0), SHIFT_REPEAT(313),
  [476] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0), SHIFT_REPEAT(312),
  [479] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [481] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 1, 0, 0),
  [483] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [485] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_named_node_repeat1, 1, 0, 0),
  [487] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 1, 0, 0),
  [489] = {.entry = {.count = 1, .reusable = false}}, SHIFT(45),
  [491] = {.entry = {.count = 1, .reusable = false}}, SHIFT(28),
  [493] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_negated_field, 2, 0, 0),
  [495] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_negated_field, 2, 0, 0),
  [497] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [499] = {.entry = {.count = 1, .reusable = false}}, SHIFT(36),
  [501] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [503] = {.entry = {.count = 1, .reusable = false}}, SHIFT(29),
  [505] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__named_node_expression, 3, 0, 0),
  [507] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_node_expression, 3, 0, 0),
  [509] = {.entry = {.count = 1, .reusable = false}}, SHIFT(26),
  [511] = {.entry = {.count = 1, .reusable = false}}, SHIFT(52),
  [513] = {.entry = {.count = 1, .reusable = false}}, SHIFT(27),
  [515] = {.entry = {.count = 1, .reusable = false}}, SHIFT(31),
  [517] = {.entry = {.count = 1, .reusable = false}}, SHIFT(46),
  [519] = {.entry = {.count = 1, .reusable = false}}, SHIFT(38),
  [521] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [523] = {.entry = {.count = 1, .reusable = false}}, SHIFT(41),
  [525] = {.entry = {.count = 1, .reusable = false}}, SHIFT(35),
  [527] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_predicate, 6, 0, 10),
  [529] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_predicate, 6, 0, 10),
  [531] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [533] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field_definition, 2, 0, 1),
  [535] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_definition, 2, 0, 1),
  [537] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [539] = {.entry = {.count = 1, .reusable = false}}, SHIFT(32),
  [541] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_definition, 1, 0, 0),
  [543] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_definition, 1, 0, 0),
  [545] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__group_expression, 3, 0, 0),
  [547] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__group_expression, 3, 0, 0),
  [549] = {.entry = {.count = 1, .reusable = false}}, SHIFT(60),
  [551] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_grouping_repeat1, 1, 0, 0),
  [553] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_grouping_repeat1, 1, 0, 0),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [557] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [559] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [561] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [563] = {.entry = {.count = 1, .reusable = false}}, SHIFT(113),
  [565] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__field_name, 2, 0, 0),
  [567] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__field_name, 2, 0, 0),
  [569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [571] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string_content, 1, 0, 0),
  [573] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_content_repeat1, 2, 0, 0), SHIFT_REPEAT(307),
  [576] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_content_repeat1, 2, 0, 0),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [608] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_query(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
