-- Topal: GPG/GnuPG and Alpine/Pine integration
-- Copyright (C) 2001--2022  Phillip J. Brooke
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License version 3 as
-- published by the Free Software Foundation.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

with Globals; use Globals;


package Configuration is

   Switch_Parse_Error : exception;
   function Set_Two_Way (S : String) return Boolean;

   Two_Way : constant array (Boolean) of UBS
     := (True => ToUBS("on"),
         False => ToUBS("off"));

   Config_Parse_Error : exception;
   procedure Read_Config_File (Warnings : out Boolean);

   procedure Dump (Overwrite_Config : in Boolean := False);

   procedure Edit_Configuration;

   procedure Edit_Own_Key(SMIME : in Boolean);

   procedure Default_Configuration (C : in out Config_Record);

   -- Deep copy the configuration.  Right is the original; Left is the
   -- newly instantiated configuration.
   procedure Copy_Configuration(Left  : in out Config_Record;
                                Right : in     Config_Record);

end Configuration;

