// Copyright (C) 2023 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only

#ifndef CS_MIPMAP_P_H
#define CS_MIPMAP_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of other Qt classes.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <QtCore/private/qglobal_p.h>

#ifdef Q_OS_WIN

#include <qt_windows.h>

#if 0
//
// Generated by Microsoft (R) HLSL Shader Compiler 10.1
//
//
// Buffer Definitions: 
//
// cbuffer CB0
// {
//
//   uint SrcMipLevel;                  // Offset:    0 Size:     4
//   uint NumMipLevels;                 // Offset:    4 Size:     4
//   float2 TexelSize;                  // Offset:    8 Size:     8
//
// }
//
//
// Resource Bindings:
//
// Name                                 Type  Format         Dim      HLSL Bind  Count
// ------------------------------ ---------- ------- ----------- -------------- ------
// BilinearClamp                     sampler      NA          NA             s0      1 
// SrcMip                            texture  float4          2d             t0      1 
// OutMip1                               UAV  float4          2d             u0      1 
// OutMip2                               UAV  float4          2d             u1      1 
// OutMip3                               UAV  float4          2d             u2      1 
// OutMip4                               UAV  float4          2d             u3      1 
// CB0                               cbuffer      NA          NA            cb0      1 
//
//
//
// Input signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// no Input
//
// Output signature:
//
// Name                 Index   Mask Register SysValue  Format   Used
// -------------------- ----- ------ -------- -------- ------- ------
// no Output
cs_5_0
dcl_globalFlags refactoringAllowed
dcl_constantbuffer CB0[1], immediateIndexed
dcl_sampler s0, mode_default
dcl_resource_texture2d (float,float,float,float) t0
dcl_uav_typed_texture2d (float,float,float,float) u0
dcl_uav_typed_texture2d (float,float,float,float) u1
dcl_uav_typed_texture2d (float,float,float,float) u2
dcl_uav_typed_texture2d (float,float,float,float) u3
dcl_input vThreadIDInGroupFlattened
dcl_input vThreadID.xy
dcl_temps 6
dcl_tgsm_structured g0, 4, 64
dcl_tgsm_structured g1, 4, 64
dcl_tgsm_structured g2, 4, 64
dcl_tgsm_structured g3, 4, 64
dcl_thread_group 8, 8, 1
utof r0.xy, vThreadID.xyxx
add r0.xy, r0.xyxx, l(0.250000, 0.250000, 0.000000, 0.000000)
mul r0.zw, r0.xxxy, cb0[0].zzzw
utof r1.x, cb0[0].x
sample_l_indexable(texture2d)(float,float,float,float) r2.xyzw, r0.zwzz, t0.xyzw, s0, r1.x
mul r3.xyz, cb0[0].zwzz, l(0.500000, 0.500000, 0.500000, 0.000000)
mov r3.w, l(0)
mad r3.xyzw, cb0[0].zwzw, r0.xyxy, r3.zwxy
sample_l_indexable(texture2d)(float,float,float,float) r4.xyzw, r3.xyxx, t0.xyzw, s0, r1.x
add r2.xyzw, r2.xyzw, r4.xyzw
mov r3.x, l(0)
mul r3.y, cb0[0].w, l(0.500000)
mad r0.xy, cb0[0].zwzz, r0.xyxx, r3.xyxx
sample_l_indexable(texture2d)(float,float,float,float) r0.xyzw, r0.xyxx, t0.xyzw, s0, r1.x
add r0.xyzw, r0.xyzw, r2.xyzw
sample_l_indexable(texture2d)(float,float,float,float) r1.xyzw, r3.zwzz, t0.xyzw, s0, r1.x
add r0.xyzw, r0.xyzw, r1.xyzw
mul r1.xyzw, r0.xyzw, l(0.250000, 0.250000, 0.250000, 0.250000)
store_uav_typed u0.xyzw, vThreadID.xyyy, r1.xyzw
ieq r2.x, cb0[0].y, l(1)
if_nz r2.x
  ret 
endif 
store_structured g0.x, vThreadIDInGroupFlattened.x, l(0), r1.x
store_structured g1.x, vThreadIDInGroupFlattened.x, l(0), r1.y
store_structured g2.x, vThreadIDInGroupFlattened.x, l(0), r1.z
store_structured g3.x, vThreadIDInGroupFlattened.x, l(0), r1.w
sync_g_t
and r2.x, vThreadIDInGroupFlattened.x, l(9)
if_z r2.x
  iadd r2.xyz, vThreadIDInGroupFlattened.xxxx, l(1, 8, 9, 0)
  ld_structured r3.x, r2.x, l(0), g0.xxxx
  ld_structured r3.y, r2.x, l(0), g1.xxxx
  ld_structured r3.z, r2.x, l(0), g2.xxxx
  ld_structured r3.w, r2.x, l(0), g3.xxxx
  ld_structured r4.x, r2.y, l(0), g0.xxxx
  ld_structured r4.y, r2.y, l(0), g1.xxxx
  ld_structured r4.z, r2.y, l(0), g2.xxxx
  ld_structured r4.w, r2.y, l(0), g3.xxxx
  ld_structured r5.x, r2.z, l(0), g0.xxxx
  ld_structured r5.y, r2.z, l(0), g1.xxxx
  ld_structured r5.z, r2.z, l(0), g2.xxxx
  ld_structured r5.w, r2.z, l(0), g3.xxxx
  mad r0.xyzw, r0.xyzw, l(0.250000, 0.250000, 0.250000, 0.250000), r3.xyzw
  add r0.xyzw, r4.xyzw, r0.xyzw
  add r0.xyzw, r5.xyzw, r0.xyzw
  mul r1.xyzw, r0.xyzw, l(0.250000, 0.250000, 0.250000, 0.250000)
  ushr r0.xyzw, vThreadID.xyyy, l(1, 1, 1, 1)
  store_uav_typed u1.xyzw, r0.xyzw, r1.xyzw
  store_structured g0.x, vThreadIDInGroupFlattened.x, l(0), r1.x
  store_structured g1.x, vThreadIDInGroupFlattened.x, l(0), r1.y
  store_structured g2.x, vThreadIDInGroupFlattened.x, l(0), r1.z
  store_structured g3.x, vThreadIDInGroupFlattened.x, l(0), r1.w
endif 
ieq r0.x, cb0[0].y, l(2)
if_nz r0.x
  ret 
endif 
sync_g_t
and r0.x, vThreadIDInGroupFlattened.x, l(27)
if_z r0.x
  iadd r0.xyz, vThreadIDInGroupFlattened.xxxx, l(2, 16, 18, 0)
  ld_structured r2.x, r0.x, l(0), g0.xxxx
  ld_structured r2.y, r0.x, l(0), g1.xxxx
  ld_structured r2.z, r0.x, l(0), g2.xxxx
  ld_structured r2.w, r0.x, l(0), g3.xxxx
  ld_structured r3.x, r0.y, l(0), g0.xxxx
  ld_structured r3.y, r0.y, l(0), g1.xxxx
  ld_structured r3.z, r0.y, l(0), g2.xxxx
  ld_structured r3.w, r0.y, l(0), g3.xxxx
  ld_structured r4.x, r0.z, l(0), g0.xxxx
  ld_structured r4.y, r0.z, l(0), g1.xxxx
  ld_structured r4.z, r0.z, l(0), g2.xxxx
  ld_structured r4.w, r0.z, l(0), g3.xxxx
  add r0.xyzw, r1.xyzw, r2.xyzw
  add r0.xyzw, r3.xyzw, r0.xyzw
  add r0.xyzw, r4.xyzw, r0.xyzw
  mul r1.xyzw, r0.xyzw, l(0.250000, 0.250000, 0.250000, 0.250000)
  ushr r0.xyzw, vThreadID.xyyy, l(2, 2, 2, 2)
  store_uav_typed u2.xyzw, r0.xyzw, r1.xyzw
  store_structured g0.x, vThreadIDInGroupFlattened.x, l(0), r1.x
  store_structured g1.x, vThreadIDInGroupFlattened.x, l(0), r1.y
  store_structured g2.x, vThreadIDInGroupFlattened.x, l(0), r1.z
  store_structured g3.x, vThreadIDInGroupFlattened.x, l(0), r1.w
endif 
ieq r0.x, cb0[0].y, l(3)
if_nz r0.x
  ret 
endif 
sync_g_t
if_z vThreadIDInGroupFlattened.x
  ld_structured r0.x, l(4), l(0), g0.xxxx
  ld_structured r0.y, l(4), l(0), g1.xxxx
  ld_structured r0.z, l(4), l(0), g2.xxxx
  ld_structured r0.w, l(4), l(0), g3.xxxx
  ld_structured r2.x, l(32), l(0), g0.xxxx
  ld_structured r2.y, l(32), l(0), g1.xxxx
  ld_structured r2.z, l(32), l(0), g2.xxxx
  ld_structured r2.w, l(32), l(0), g3.xxxx
  ld_structured r3.x, l(36), l(0), g0.xxxx
  ld_structured r3.y, l(36), l(0), g1.xxxx
  ld_structured r3.z, l(36), l(0), g2.xxxx
  ld_structured r3.w, l(36), l(0), g3.xxxx
  add r0.xyzw, r0.xyzw, r1.xyzw
  add r0.xyzw, r2.xyzw, r0.xyzw
  add r0.xyzw, r3.xyzw, r0.xyzw
  mul r0.xyzw, r0.xyzw, l(0.250000, 0.250000, 0.250000, 0.250000)
  ushr r1.xyzw, vThreadID.xyyy, l(3, 3, 3, 3)
  store_uav_typed u3.xyzw, r1.xyzw, r0.xyzw
endif 
ret 
// Approximately 111 instruction slots used
#endif

inline constexpr BYTE g_csMipmap[] =
{
     68,  88,  66,  67, 133, 122, 
      5, 181, 163, 163, 140, 185, 
    158, 179,   4,  65, 180, 238, 
    158,  10,   1,   0,   0,   0, 
     60,  17,   0,   0,   5,   0, 
      0,   0,  52,   0,   0,   0, 
    200,   2,   0,   0, 216,   2, 
      0,   0, 232,   2,   0,   0, 
    160,  16,   0,   0,  82,  68, 
     69,  70, 140,   2,   0,   0, 
      1,   0,   0,   0,  88,   1, 
      0,   0,   7,   0,   0,   0, 
     60,   0,   0,   0,   0,   5, 
     83,  67,   0,   1,   0,   0, 
    100,   2,   0,   0,  82,  68, 
     49,  49,  60,   0,   0,   0, 
     24,   0,   0,   0,  32,   0, 
      0,   0,  40,   0,   0,   0, 
     36,   0,   0,   0,  12,   0, 
      0,   0,   0,   0,   0,   0, 
     28,   1,   0,   0,   3,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   1,   0, 
      0,   0,  42,   1,   0,   0, 
      2,   0,   0,   0,   5,   0, 
      0,   0,   4,   0,   0,   0, 
    255, 255, 255, 255,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     13,   0,   0,   0,  49,   1, 
      0,   0,   4,   0,   0,   0, 
      5,   0,   0,   0,   4,   0, 
      0,   0, 255, 255, 255, 255, 
      0,   0,   0,   0,   1,   0, 
      0,   0,  13,   0,   0,   0, 
     57,   1,   0,   0,   4,   0, 
      0,   0,   5,   0,   0,   0, 
      4,   0,   0,   0, 255, 255, 
    255, 255,   1,   0,   0,   0, 
      1,   0,   0,   0,  13,   0, 
      0,   0,  65,   1,   0,   0, 
      4,   0,   0,   0,   5,   0, 
      0,   0,   4,   0,   0,   0, 
    255, 255, 255, 255,   2,   0, 
      0,   0,   1,   0,   0,   0, 
     13,   0,   0,   0,  73,   1, 
      0,   0,   4,   0,   0,   0, 
      5,   0,   0,   0,   4,   0, 
      0,   0, 255, 255, 255, 255, 
      3,   0,   0,   0,   1,   0, 
      0,   0,  13,   0,   0,   0, 
     81,   1,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,   0,   0,   0,   1,   0, 
      0,   0,  66, 105, 108, 105, 
    110, 101,  97, 114,  67, 108, 
     97, 109, 112,   0,  83, 114, 
     99,  77, 105, 112,   0,  79, 
    117, 116,  77, 105, 112,  49, 
      0,  79, 117, 116,  77, 105, 
    112,  50,   0,  79, 117, 116, 
     77, 105, 112,  51,   0,  79, 
    117, 116,  77, 105, 112,  52, 
      0,  67,  66,  48,   0, 171, 
    171, 171,  81,   1,   0,   0, 
      3,   0,   0,   0, 112,   1, 
      0,   0,  16,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0, 232,   1,   0,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,   2,   0,   0,   0, 
    252,   1,   0,   0,   0,   0, 
      0,   0, 255, 255, 255, 255, 
      0,   0,   0,   0, 255, 255, 
    255, 255,   0,   0,   0,   0, 
     32,   2,   0,   0,   4,   0, 
      0,   0,   4,   0,   0,   0, 
      2,   0,   0,   0, 252,   1, 
      0,   0,   0,   0,   0,   0, 
    255, 255, 255, 255,   0,   0, 
      0,   0, 255, 255, 255, 255, 
      0,   0,   0,   0,  45,   2, 
      0,   0,   8,   0,   0,   0, 
      8,   0,   0,   0,   2,   0, 
      0,   0,  64,   2,   0,   0, 
      0,   0,   0,   0, 255, 255, 
    255, 255,   0,   0,   0,   0, 
    255, 255, 255, 255,   0,   0, 
      0,   0,  83, 114,  99,  77, 
    105, 112,  76, 101, 118, 101, 
    108,   0, 100, 119, 111, 114, 
    100,   0, 171, 171,   0,   0, 
     19,   0,   1,   0,   1,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
    244,   1,   0,   0,  78, 117, 
    109,  77, 105, 112,  76, 101, 
    118, 101, 108, 115,   0,  84, 
    101, 120, 101, 108,  83, 105, 
    122, 101,   0, 102, 108, 111, 
     97, 116,  50,   0, 171, 171, 
      1,   0,   3,   0,   1,   0, 
      2,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  55,   2,   0,   0, 
     77, 105,  99, 114, 111, 115, 
    111, 102, 116,  32,  40,  82, 
     41,  32,  72,  76,  83,  76, 
     32,  83, 104,  97, 100, 101, 
    114,  32,  67, 111, 109, 112, 
    105, 108, 101, 114,  32,  49, 
     48,  46,  49,   0,  73,  83, 
     71,  78,   8,   0,   0,   0, 
      0,   0,   0,   0,   8,   0, 
      0,   0,  79,  83,  71,  78, 
      8,   0,   0,   0,   0,   0, 
      0,   0,   8,   0,   0,   0, 
     83,  72,  69,  88, 176,  13, 
      0,   0,  80,   0,   5,   0, 
    108,   3,   0,   0, 106,   8, 
      0,   1,  89,   0,   0,   4, 
     70, 142,  32,   0,   0,   0, 
      0,   0,   1,   0,   0,   0, 
     90,   0,   0,   3,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     88,  24,   0,   4,   0, 112, 
     16,   0,   0,   0,   0,   0, 
     85,  85,   0,   0, 156,  24, 
      0,   4,   0, 224,  17,   0, 
      0,   0,   0,   0,  85,  85, 
      0,   0, 156,  24,   0,   4, 
      0, 224,  17,   0,   1,   0, 
      0,   0,  85,  85,   0,   0, 
    156,  24,   0,   4,   0, 224, 
     17,   0,   2,   0,   0,   0, 
     85,  85,   0,   0, 156,  24, 
      0,   4,   0, 224,  17,   0, 
      3,   0,   0,   0,  85,  85, 
      0,   0,  95,   0,   0,   2, 
      0,  64,   2,   0,  95,   0, 
      0,   2,  50,   0,   2,   0, 
    104,   0,   0,   2,   6,   0, 
      0,   0, 160,   0,   0,   5, 
      0, 240,  17,   0,   0,   0, 
      0,   0,   4,   0,   0,   0, 
     64,   0,   0,   0, 160,   0, 
      0,   5,   0, 240,  17,   0, 
      1,   0,   0,   0,   4,   0, 
      0,   0,  64,   0,   0,   0, 
    160,   0,   0,   5,   0, 240, 
     17,   0,   2,   0,   0,   0, 
      4,   0,   0,   0,  64,   0, 
      0,   0, 160,   0,   0,   5, 
      0, 240,  17,   0,   3,   0, 
      0,   0,   4,   0,   0,   0, 
     64,   0,   0,   0, 155,   0, 
      0,   4,   8,   0,   0,   0, 
      8,   0,   0,   0,   1,   0, 
      0,   0,  86,   0,   0,   4, 
     50,   0,  16,   0,   0,   0, 
      0,   0,  70,   0,   2,   0, 
      0,   0,   0,  10,  50,   0, 
     16,   0,   0,   0,   0,   0, 
     70,   0,  16,   0,   0,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0, 128,  62,   0,   0, 
    128,  62,   0,   0,   0,   0, 
      0,   0,   0,   0,  56,   0, 
      0,   8, 194,   0,  16,   0, 
      0,   0,   0,   0,   6,   4, 
     16,   0,   0,   0,   0,   0, 
    166, 142,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     86,   0,   0,   6,  18,   0, 
     16,   0,   1,   0,   0,   0, 
     10, 128,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     72,   0,   0, 141, 194,   0, 
      0, 128,  67,  85,  21,   0, 
    242,   0,  16,   0,   2,   0, 
      0,   0, 230,  10,  16,   0, 
      0,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  10,   0,  16,   0, 
      1,   0,   0,   0,  56,   0, 
      0,  11, 114,   0,  16,   0, 
      3,   0,   0,   0, 230, 138, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   2,  64, 
      0,   0,   0,   0,   0,  63, 
      0,   0,   0,  63,   0,   0, 
      0,  63,   0,   0,   0,   0, 
     54,   0,   0,   5, 130,   0, 
     16,   0,   3,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,  50,   0,   0,  10, 
    242,   0,  16,   0,   3,   0, 
      0,   0, 230, 142,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,  70,   4,  16,   0, 
      0,   0,   0,   0, 230,   4, 
     16,   0,   3,   0,   0,   0, 
     72,   0,   0, 141, 194,   0, 
      0, 128,  67,  85,  21,   0, 
    242,   0,  16,   0,   4,   0, 
      0,   0,  70,   0,  16,   0, 
      3,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  10,   0,  16,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   7, 242,   0,  16,   0, 
      2,   0,   0,   0,  70,  14, 
     16,   0,   2,   0,   0,   0, 
     70,  14,  16,   0,   4,   0, 
      0,   0,  54,   0,   0,   5, 
     18,   0,  16,   0,   3,   0, 
      0,   0,   1,  64,   0,   0, 
      0,   0,   0,   0,  56,   0, 
      0,   8,  34,   0,  16,   0, 
      3,   0,   0,   0,  58, 128, 
     32,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   1,  64, 
      0,   0,   0,   0,   0,  63, 
     50,   0,   0,  10,  50,   0, 
     16,   0,   0,   0,   0,   0, 
    230, 138,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
     70,   0,  16,   0,   0,   0, 
      0,   0,  70,   0,  16,   0, 
      3,   0,   0,   0,  72,   0, 
      0, 141, 194,   0,   0, 128, 
     67,  85,  21,   0, 242,   0, 
     16,   0,   0,   0,   0,   0, 
     70,   0,  16,   0,   0,   0, 
      0,   0,  70, 126,  16,   0, 
      0,   0,   0,   0,   0,  96, 
     16,   0,   0,   0,   0,   0, 
     10,   0,  16,   0,   1,   0, 
      0,   0,   0,   0,   0,   7, 
    242,   0,  16,   0,   0,   0, 
      0,   0,  70,  14,  16,   0, 
      0,   0,   0,   0,  70,  14, 
     16,   0,   2,   0,   0,   0, 
     72,   0,   0, 141, 194,   0, 
      0, 128,  67,  85,  21,   0, 
    242,   0,  16,   0,   1,   0, 
      0,   0, 230,  10,  16,   0, 
      3,   0,   0,   0,  70, 126, 
     16,   0,   0,   0,   0,   0, 
      0,  96,  16,   0,   0,   0, 
      0,   0,  10,   0,  16,   0, 
      1,   0,   0,   0,   0,   0, 
      0,   7, 242,   0,  16,   0, 
      0,   0,   0,   0,  70,  14, 
     16,   0,   0,   0,   0,   0, 
     70,  14,  16,   0,   1,   0, 
      0,   0,  56,   0,   0,  10, 
    242,   0,  16,   0,   1,   0, 
      0,   0,  70,  14,  16,   0, 
      0,   0,   0,   0,   2,  64, 
      0,   0,   0,   0, 128,  62, 
      0,   0, 128,  62,   0,   0, 
    128,  62,   0,   0, 128,  62, 
    164,   0,   0,   6, 242, 224, 
     17,   0,   0,   0,   0,   0, 
     70,   5,   2,   0,  70,  14, 
     16,   0,   1,   0,   0,   0, 
     32,   0,   0,   8,  18,   0, 
     16,   0,   2,   0,   0,   0, 
     26, 128,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   1,   0, 
      0,   0,  31,   0,   4,   3, 
     10,   0,  16,   0,   2,   0, 
      0,   0,  62,   0,   0,   1, 
     21,   0,   0,   1, 168,   0, 
      0,   8,  18, 240,  17,   0, 
      0,   0,   0,   0,  10,  64, 
      2,   0,   1,  64,   0,   0, 
      0,   0,   0,   0,  10,   0, 
     16,   0,   1,   0,   0,   0, 
    168,   0,   0,   8,  18, 240, 
     17,   0,   1,   0,   0,   0, 
     10,  64,   2,   0,   1,  64, 
      0,   0,   0,   0,   0,   0, 
     26,   0,  16,   0,   1,   0, 
      0,   0, 168,   0,   0,   8, 
     18, 240,  17,   0,   2,   0, 
      0,   0,  10,  64,   2,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,  42,   0,  16,   0, 
      1,   0,   0,   0, 168,   0, 
      0,   8,  18, 240,  17,   0, 
      3,   0,   0,   0,  10,  64, 
      2,   0,   1,  64,   0,   0, 
      0,   0,   0,   0,  58,   0, 
     16,   0,   1,   0,   0,   0, 
    190,  24,   0,   1,   1,   0, 
      0,   6,  18,   0,  16,   0, 
      2,   0,   0,   0,  10,  64, 
      2,   0,   1,  64,   0,   0, 
      9,   0,   0,   0,  31,   0, 
      0,   3,  10,   0,  16,   0, 
      2,   0,   0,   0,  30,   0, 
      0,   9, 114,   0,  16,   0, 
      2,   0,   0,   0,   6,  64, 
      2,   0,   2,  64,   0,   0, 
      1,   0,   0,   0,   8,   0, 
      0,   0,   9,   0,   0,   0, 
      0,   0,   0,   0, 167,   0, 
      0,   9,  18,   0,  16,   0, 
      3,   0,   0,   0,  10,   0, 
     16,   0,   2,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      0,   0,   0,   0, 167,   0, 
      0,   9,  34,   0,  16,   0, 
      3,   0,   0,   0,  10,   0, 
     16,   0,   2,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      1,   0,   0,   0, 167,   0, 
      0,   9,  66,   0,  16,   0, 
      3,   0,   0,   0,  10,   0, 
     16,   0,   2,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      2,   0,   0,   0, 167,   0, 
      0,   9, 130,   0,  16,   0, 
      3,   0,   0,   0,  10,   0, 
     16,   0,   2,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      3,   0,   0,   0, 167,   0, 
      0,   9,  18,   0,  16,   0, 
      4,   0,   0,   0,  26,   0, 
     16,   0,   2,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      0,   0,   0,   0, 167,   0, 
      0,   9,  34,   0,  16,   0, 
      4,   0,   0,   0,  26,   0, 
     16,   0,   2,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      1,   0,   0,   0, 167,   0, 
      0,   9,  66,   0,  16,   0, 
      4,   0,   0,   0,  26,   0, 
     16,   0,   2,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      2,   0,   0,   0, 167,   0, 
      0,   9, 130,   0,  16,   0, 
      4,   0,   0,   0,  26,   0, 
     16,   0,   2,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      3,   0,   0,   0, 167,   0, 
      0,   9,  18,   0,  16,   0, 
      5,   0,   0,   0,  42,   0, 
     16,   0,   2,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      0,   0,   0,   0, 167,   0, 
      0,   9,  34,   0,  16,   0, 
      5,   0,   0,   0,  42,   0, 
     16,   0,   2,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      1,   0,   0,   0, 167,   0, 
      0,   9,  66,   0,  16,   0, 
      5,   0,   0,   0,  42,   0, 
     16,   0,   2,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      2,   0,   0,   0, 167,   0, 
      0,   9, 130,   0,  16,   0, 
      5,   0,   0,   0,  42,   0, 
     16,   0,   2,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      3,   0,   0,   0,  50,   0, 
      0,  12, 242,   0,  16,   0, 
      0,   0,   0,   0,  70,  14, 
     16,   0,   0,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
    128,  62,   0,   0, 128,  62, 
      0,   0, 128,  62,   0,   0, 
    128,  62,  70,  14,  16,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   7, 242,   0,  16,   0, 
      0,   0,   0,   0,  70,  14, 
     16,   0,   4,   0,   0,   0, 
     70,  14,  16,   0,   0,   0, 
      0,   0,   0,   0,   0,   7, 
    242,   0,  16,   0,   0,   0, 
      0,   0,  70,  14,  16,   0, 
      5,   0,   0,   0,  70,  14, 
     16,   0,   0,   0,   0,   0, 
     56,   0,   0,  10, 242,   0, 
     16,   0,   1,   0,   0,   0, 
     70,  14,  16,   0,   0,   0, 
      0,   0,   2,  64,   0,   0, 
      0,   0, 128,  62,   0,   0, 
    128,  62,   0,   0, 128,  62, 
      0,   0, 128,  62,  85,   0, 
      0,   9, 242,   0,  16,   0, 
      0,   0,   0,   0,  70,   5, 
      2,   0,   2,  64,   0,   0, 
      1,   0,   0,   0,   1,   0, 
      0,   0,   1,   0,   0,   0, 
      1,   0,   0,   0, 164,   0, 
      0,   7, 242, 224,  17,   0, 
      1,   0,   0,   0,  70,  14, 
     16,   0,   0,   0,   0,   0, 
     70,  14,  16,   0,   1,   0, 
      0,   0, 168,   0,   0,   8, 
     18, 240,  17,   0,   0,   0, 
      0,   0,  10,  64,   2,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,  10,   0,  16,   0, 
      1,   0,   0,   0, 168,   0, 
      0,   8,  18, 240,  17,   0, 
      1,   0,   0,   0,  10,  64, 
      2,   0,   1,  64,   0,   0, 
      0,   0,   0,   0,  26,   0, 
     16,   0,   1,   0,   0,   0, 
    168,   0,   0,   8,  18, 240, 
     17,   0,   2,   0,   0,   0, 
     10,  64,   2,   0,   1,  64, 
      0,   0,   0,   0,   0,   0, 
     42,   0,  16,   0,   1,   0, 
      0,   0, 168,   0,   0,   8, 
     18, 240,  17,   0,   3,   0, 
      0,   0,  10,  64,   2,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,  58,   0,  16,   0, 
      1,   0,   0,   0,  21,   0, 
      0,   1,  32,   0,   0,   8, 
     18,   0,  16,   0,   0,   0, 
      0,   0,  26, 128,  32,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   1,  64,   0,   0, 
      2,   0,   0,   0,  31,   0, 
      4,   3,  10,   0,  16,   0, 
      0,   0,   0,   0,  62,   0, 
      0,   1,  21,   0,   0,   1, 
    190,  24,   0,   1,   1,   0, 
      0,   6,  18,   0,  16,   0, 
      0,   0,   0,   0,  10,  64, 
      2,   0,   1,  64,   0,   0, 
     27,   0,   0,   0,  31,   0, 
      0,   3,  10,   0,  16,   0, 
      0,   0,   0,   0,  30,   0, 
      0,   9, 114,   0,  16,   0, 
      0,   0,   0,   0,   6,  64, 
      2,   0,   2,  64,   0,   0, 
      2,   0,   0,   0,  16,   0, 
      0,   0,  18,   0,   0,   0, 
      0,   0,   0,   0, 167,   0, 
      0,   9,  18,   0,  16,   0, 
      2,   0,   0,   0,  10,   0, 
     16,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      0,   0,   0,   0, 167,   0, 
      0,   9,  34,   0,  16,   0, 
      2,   0,   0,   0,  10,   0, 
     16,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      1,   0,   0,   0, 167,   0, 
      0,   9,  66,   0,  16,   0, 
      2,   0,   0,   0,  10,   0, 
     16,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      2,   0,   0,   0, 167,   0, 
      0,   9, 130,   0,  16,   0, 
      2,   0,   0,   0,  10,   0, 
     16,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      3,   0,   0,   0, 167,   0, 
      0,   9,  18,   0,  16,   0, 
      3,   0,   0,   0,  26,   0, 
     16,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      0,   0,   0,   0, 167,   0, 
      0,   9,  34,   0,  16,   0, 
      3,   0,   0,   0,  26,   0, 
     16,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      1,   0,   0,   0, 167,   0, 
      0,   9,  66,   0,  16,   0, 
      3,   0,   0,   0,  26,   0, 
     16,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      2,   0,   0,   0, 167,   0, 
      0,   9, 130,   0,  16,   0, 
      3,   0,   0,   0,  26,   0, 
     16,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      3,   0,   0,   0, 167,   0, 
      0,   9,  18,   0,  16,   0, 
      4,   0,   0,   0,  42,   0, 
     16,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      0,   0,   0,   0, 167,   0, 
      0,   9,  34,   0,  16,   0, 
      4,   0,   0,   0,  42,   0, 
     16,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      1,   0,   0,   0, 167,   0, 
      0,   9,  66,   0,  16,   0, 
      4,   0,   0,   0,  42,   0, 
     16,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      2,   0,   0,   0, 167,   0, 
      0,   9, 130,   0,  16,   0, 
      4,   0,   0,   0,  42,   0, 
     16,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   7, 242,   0,  16,   0, 
      0,   0,   0,   0,  70,  14, 
     16,   0,   1,   0,   0,   0, 
     70,  14,  16,   0,   2,   0, 
      0,   0,   0,   0,   0,   7, 
    242,   0,  16,   0,   0,   0, 
      0,   0,  70,  14,  16,   0, 
      3,   0,   0,   0,  70,  14, 
     16,   0,   0,   0,   0,   0, 
      0,   0,   0,   7, 242,   0, 
     16,   0,   0,   0,   0,   0, 
     70,  14,  16,   0,   4,   0, 
      0,   0,  70,  14,  16,   0, 
      0,   0,   0,   0,  56,   0, 
      0,  10, 242,   0,  16,   0, 
      1,   0,   0,   0,  70,  14, 
     16,   0,   0,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
    128,  62,   0,   0, 128,  62, 
      0,   0, 128,  62,   0,   0, 
    128,  62,  85,   0,   0,   9, 
    242,   0,  16,   0,   0,   0, 
      0,   0,  70,   5,   2,   0, 
      2,  64,   0,   0,   2,   0, 
      0,   0,   2,   0,   0,   0, 
      2,   0,   0,   0,   2,   0, 
      0,   0, 164,   0,   0,   7, 
    242, 224,  17,   0,   2,   0, 
      0,   0,  70,  14,  16,   0, 
      0,   0,   0,   0,  70,  14, 
     16,   0,   1,   0,   0,   0, 
    168,   0,   0,   8,  18, 240, 
     17,   0,   0,   0,   0,   0, 
     10,  64,   2,   0,   1,  64, 
      0,   0,   0,   0,   0,   0, 
     10,   0,  16,   0,   1,   0, 
      0,   0, 168,   0,   0,   8, 
     18, 240,  17,   0,   1,   0, 
      0,   0,  10,  64,   2,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,  26,   0,  16,   0, 
      1,   0,   0,   0, 168,   0, 
      0,   8,  18, 240,  17,   0, 
      2,   0,   0,   0,  10,  64, 
      2,   0,   1,  64,   0,   0, 
      0,   0,   0,   0,  42,   0, 
     16,   0,   1,   0,   0,   0, 
    168,   0,   0,   8,  18, 240, 
     17,   0,   3,   0,   0,   0, 
     10,  64,   2,   0,   1,  64, 
      0,   0,   0,   0,   0,   0, 
     58,   0,  16,   0,   1,   0, 
      0,   0,  21,   0,   0,   1, 
     32,   0,   0,   8,  18,   0, 
     16,   0,   0,   0,   0,   0, 
     26, 128,  32,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      1,  64,   0,   0,   3,   0, 
      0,   0,  31,   0,   4,   3, 
     10,   0,  16,   0,   0,   0, 
      0,   0,  62,   0,   0,   1, 
     21,   0,   0,   1, 190,  24, 
      0,   1,  31,   0,   0,   2, 
     10,  64,   2,   0, 167,   0, 
      0,   9,  18,   0,  16,   0, 
      0,   0,   0,   0,   1,  64, 
      0,   0,   4,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      0,   0,   0,   0, 167,   0, 
      0,   9,  34,   0,  16,   0, 
      0,   0,   0,   0,   1,  64, 
      0,   0,   4,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      1,   0,   0,   0, 167,   0, 
      0,   9,  66,   0,  16,   0, 
      0,   0,   0,   0,   1,  64, 
      0,   0,   4,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      2,   0,   0,   0, 167,   0, 
      0,   9, 130,   0,  16,   0, 
      0,   0,   0,   0,   1,  64, 
      0,   0,   4,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      3,   0,   0,   0, 167,   0, 
      0,   9,  18,   0,  16,   0, 
      2,   0,   0,   0,   1,  64, 
      0,   0,  32,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      0,   0,   0,   0, 167,   0, 
      0,   9,  34,   0,  16,   0, 
      2,   0,   0,   0,   1,  64, 
      0,   0,  32,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      1,   0,   0,   0, 167,   0, 
      0,   9,  66,   0,  16,   0, 
      2,   0,   0,   0,   1,  64, 
      0,   0,  32,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      2,   0,   0,   0, 167,   0, 
      0,   9, 130,   0,  16,   0, 
      2,   0,   0,   0,   1,  64, 
      0,   0,  32,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      3,   0,   0,   0, 167,   0, 
      0,   9,  18,   0,  16,   0, 
      3,   0,   0,   0,   1,  64, 
      0,   0,  36,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      0,   0,   0,   0, 167,   0, 
      0,   9,  34,   0,  16,   0, 
      3,   0,   0,   0,   1,  64, 
      0,   0,  36,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      1,   0,   0,   0, 167,   0, 
      0,   9,  66,   0,  16,   0, 
      3,   0,   0,   0,   1,  64, 
      0,   0,  36,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      2,   0,   0,   0, 167,   0, 
      0,   9, 130,   0,  16,   0, 
      3,   0,   0,   0,   1,  64, 
      0,   0,  36,   0,   0,   0, 
      1,  64,   0,   0,   0,   0, 
      0,   0,   6, 240,  17,   0, 
      3,   0,   0,   0,   0,   0, 
      0,   7, 242,   0,  16,   0, 
      0,   0,   0,   0,  70,  14, 
     16,   0,   0,   0,   0,   0, 
     70,  14,  16,   0,   1,   0, 
      0,   0,   0,   0,   0,   7, 
    242,   0,  16,   0,   0,   0, 
      0,   0,  70,  14,  16,   0, 
      2,   0,   0,   0,  70,  14, 
     16,   0,   0,   0,   0,   0, 
      0,   0,   0,   7, 242,   0, 
     16,   0,   0,   0,   0,   0, 
     70,  14,  16,   0,   3,   0, 
      0,   0,  70,  14,  16,   0, 
      0,   0,   0,   0,  56,   0, 
      0,  10, 242,   0,  16,   0, 
      0,   0,   0,   0,  70,  14, 
     16,   0,   0,   0,   0,   0, 
      2,  64,   0,   0,   0,   0, 
    128,  62,   0,   0, 128,  62, 
      0,   0, 128,  62,   0,   0, 
    128,  62,  85,   0,   0,   9, 
    242,   0,  16,   0,   1,   0, 
      0,   0,  70,   5,   2,   0, 
      2,  64,   0,   0,   3,   0, 
      0,   0,   3,   0,   0,   0, 
      3,   0,   0,   0,   3,   0, 
      0,   0, 164,   0,   0,   7, 
    242, 224,  17,   0,   3,   0, 
      0,   0,  70,  14,  16,   0, 
      1,   0,   0,   0,  70,  14, 
     16,   0,   0,   0,   0,   0, 
     21,   0,   0,   1,  62,   0, 
      0,   1,  83,  84,  65,  84, 
    148,   0,   0,   0, 111,   0, 
      0,   0,   6,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,  22,   0,   0,   0, 
      5,   0,   0,   0,   5,   0, 
      0,   0,   4,   0,   0,   0, 
      6,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   2,   0,   0,   0, 
      0,   0,   0,   0,   2,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0, 
      0,   0,   3,   0,   0,   0, 
      0,   0,   0,   0,   4,   0, 
      0,   0
};

#endif // Q_OS_WIN

#endif // CS_MIPMAP_P_H
