---
channel: release
version: 2.4
date: 2008-08-27
---

## New Features



### User Interface
- Linked highlighting of codon and amino acid from translation and protein products
- Linked highlighting of structure associated with residue mapping to codon position
- Sequence Fetcher provides example accession numbers and 'clear' button
- MemoryMonitor added as an option under Desktop's Tools menu
- Extract score function to parse whitespace separated numeric data in description line
- Column labels in alignment annotation can be centred.
- Tooltip for sequence associated annotation give name of sequence


### Web Services and URL fetching
- JPred3 web service
- Prototype sequence search client (no public services available yet)
- Fetch either seed alignment or full alignment from PFAM
- URL Links created for matching database cross references as well as sequence ID
- URL Links can be created using regular-expressions


### Sequence Database Connectivity
- Retrieval of cross-referenced sequences from other databases
- Generalised database reference retrieval and validation to all fetchable databases
- Fetch sequences from DAS sources supporting the sequence command


### Import and Export
- export annotation rows as CSV for spreadsheet import
- Jalview projects record alignment dataset associations, EMBL products, and cDNA sequence mappings
- Sequence Group colour can be specified in Annotation File
- Ad-hoc colouring of group in Annotation File using RGB triplet as name of colourscheme


### VAMSAS Client capabilities (Experimental)
- treenode binding for VAMSAS tree exchange
- local editing and update of sequences in VAMSAS alignments (experimental)
- Create new or select existing session to join
- load and save of vamsas documents


### Application command line
- -tree parameter to open trees (introduced for passing from applet)
- -fetchfrom command line argument to specify nicknames of DAS servers to query for alignment features
- -dasserver command line argument to add new servers that are also automatically queried for features
- -groovy command line argument executes a given groovy script after all input data has been loaded and parsed


### Applet-Application data exchange
- Trees passed as applet parameters can be passed to application (when using "View in full application")


### Applet Parameters
- feature group display control parameter
- debug parameter
- showbutton parameter


### Applet API methods
- newView public method
- Window (current view) specific get/set public methods
- Feature display control methods
- get list of currently selected sequences


### New Jalview distribution features
- InstallAnywhere Installer upgraded to IA 2008 VP1
- RELEASE file gives build properties for the latest Jalview release.
- Java 1.1 Applet build made easier and donotobfuscate property controls execution of obfuscator
- Build target for generating source distribution
- Debug flag for javacc
- .jalview_properties file is documented (slightly) in jalview.bin.Cache
- Continuous Build Integration for stable and development version of Application, Applet and source distribution


## Issues Resolved

- selected region output includes visible annotations (for certain formats)
- edit label/displaychar contains existing label/char for editing
- update PDBEntries when DBRefEntries change (vamsas)
- shorter peptide product names from EMBL records
- Newick string generator makes compact representations
- bootstrap values parsed correctly for tree files with comments
- pathological filechooser bug avoided by not allowing filenames containing a ':'
- Fixed exception when parsing GFF files containing global sequence features
- Alignment datasets are finalized only when number of references from alignment sequences goes to zero
- Close of tree branch colour box without colour selection causes cascading exceptions
- occasional negative imgwidth exceptions
- better reporting of non-fatal warnings to user when file parsing fails.
- Save works when Jalview project is default format
- Save as dialog opened if current alignment format is not a valid output format
- UniProt canonical names introduced for both das and vamsas
- Histidine should be midblue (not pink!) in Zappo
- error messages passed up and output when data read fails
- edit undo recovers previous dataset sequence when sequence is edited
- allow PDB files without pdb ID HEADER lines (like those generated by MODELLER) to be read in properly
- allow reading of JPred concise files as a normal filetype
- Stockholm annotation parsing and alignment properties import fixed for PFAM records
- Structure view windows have correct name in Desktop window list
- annotation consisting of sequence associated scores can be read and written correctly to annotation file
- Aligned cDNA translation to aligned peptide works correctly
- Fixed display of hidden sequence markers and non-italic font for representatives in Applet
- Applet Menus are always embedded in applet window on Macs.
- Newly shown features appear at top of stack (in Applet)
- Annotations added via parameter not drawn properly due to null pointer exceptions
- Secondary structure lines are drawn starting from first column of alignment
- UniProt XML import updated for new schema release in July 2008
- Sequence feature to sequence ID match for Features file is case-insensitive
- Sequence features read from Features file appended to all sequences with matching IDs
- PDB structure coloured correctly for associated views containing a sub-sequence
- PDB files can be retrieved by applet from Jar files
- feature and annotation file applet parameters referring to different directories are retrieved correctly
- Fixed application hang whilst waiting for splash-screen version check to complete
- Applet properly URLencodes input parameter values when passing them to the launchApp service
- display name and local features preserved in results retrieved from web service
- Visual delay indication for sequence retrieval and sequence fetcher initialisation
- updated Application to use DAS 1.53e version of dasobert DAS client
- Re-instated Full AMSA support and .amsa file association
- Fixed parsing of JNet Concise annotation *sans* sequences
