
#include "atsc_huffman.h"

/*------------------------------------------------------------------------
 * Huffman Text Decompressors - 1 and 2 level routines. Tables defined in
 * atsc_huffman.h
 *------------------------------------------------------------------------*/

struct huffman_table {
    uint16_t m_encodedSequence; // cppcheck-suppress unusedStructMember
    uint8_t  m_character;
    uint8_t  m_numberOfBits;
};

using atsc_table_vec = std::vector<uint8_t>;
using huff2_table_vec = std::vector<huffman_table>;
using huff2_lookup_vec = std::vector<uint8_t>;

// Table C5: English-language Program Title Decode Table
// Optimized for each word starting with initial capital letter.
const atsc_table_vec ATSC_C5
{
    0x01, 0x00, 0x01, 0x3A, 0x01, 0x3C, 0x01, 0x3E,
    0x01, 0x40, 0x01, 0x42, 0x01, 0x44, 0x01, 0x46,
    0x01, 0x48, 0x01, 0x4A, 0x01, 0x4C, 0x01, 0x4E,
    0x01, 0x50, 0x01, 0x52, 0x01, 0x54, 0x01, 0x56,
    0x01, 0x58, 0x01, 0x5A, 0x01, 0x5C, 0x01, 0x5E,
    0x01, 0x60, 0x01, 0x62, 0x01, 0x64, 0x01, 0x66,
    0x01, 0x68, 0x01, 0x6A, 0x01, 0x6C, 0x01, 0x6E,
    0x01, 0x70, 0x01, 0x72, 0x01, 0x74, 0x01, 0x76,
    0x01, 0x78, 0x01, 0xCE, 0x01, 0xD2, 0x01, 0xD4,
    0x01, 0xD6, 0x01, 0xD8, 0x01, 0xDA, 0x01, 0xDC,
    0x01, 0xE6, 0x01, 0xE8, 0x01, 0xEA, 0x01, 0xF0,
    0x01, 0xF2, 0x01, 0xF4, 0x02, 0x06, 0x02, 0x12,
    0x02, 0x14, 0x02, 0x1C, 0x02, 0x28, 0x02, 0x30,
    0x02, 0x34, 0x02, 0x36, 0x02, 0x38, 0x02, 0x3A,
    0x02, 0x3C, 0x02, 0x3E, 0x02, 0x46, 0x02, 0x48,
    0x02, 0x4A, 0x02, 0x4C, 0x02, 0x4E, 0x02, 0x50,
    0x02, 0x52, 0x02, 0x54, 0x02, 0x7E, 0x02, 0x92,
    0x02, 0xAC, 0x02, 0xBA, 0x02, 0xD2, 0x02, 0xE4,
    0x02, 0xFA, 0x03, 0x06, 0x03, 0x1E, 0x03, 0x26,
    0x03, 0x32, 0x03, 0x3E, 0x03, 0x52, 0x03, 0x64,
    0x03, 0x7A, 0x03, 0x94, 0x03, 0x98, 0x03, 0xA4,
    0x03, 0xC8, 0x03, 0xDE, 0x03, 0xE6, 0x03, 0xF4,
    0x04, 0x04, 0x04, 0x06, 0x04, 0x0C, 0x04, 0x10,
    0x04, 0x12, 0x04, 0x14, 0x04, 0x16, 0x04, 0x18,
    0x04, 0x1A, 0x04, 0x1C, 0x04, 0x52, 0x04, 0x6A,
    0x04, 0x8E, 0x04, 0xAE, 0x04, 0xEE, 0x05, 0x06,
    0x05, 0x28, 0x05, 0x44, 0x05, 0x72, 0x05, 0x76,
    0x05, 0x90, 0x05, 0xBE, 0x05, 0xD6, 0x06, 0x0A,
    0x06, 0x44, 0x06, 0x64, 0x06, 0x66, 0x06, 0x9A,
    0x06, 0xD0, 0x06, 0xFC, 0x07, 0x22, 0x07, 0x2C,
    0x07, 0x46, 0x07, 0x54, 0x07, 0x7C, 0x07, 0x8A,
    0x07, 0x8C, 0x07, 0x8E, 0x07, 0x90, 0x07, 0x92,
    0x1B, 0x1C, 0xB4, 0xA4, 0xB2, 0xB7, 0xDA, 0x01,
    0xD1, 0x02, 0x03, 0x9B, 0x04, 0xD5, 0xD9, 0x05,
    0xCB, 0xD6, 0x06, 0xCF, 0x07, 0x08, 0xCA, 0x09,
    0xC9, 0xC5, 0xC6, 0x0A, 0xD2, 0xC4, 0xC7, 0xCC,
    0xD0, 0xC8, 0xD7, 0xCE, 0x0B, 0xC1, 0x0C, 0xC2,
    0xCD, 0xC3, 0x0D, 0x0E, 0x0F, 0x10, 0xD3, 0x11,
    0xD4, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18,
    0x19, 0x1A, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x29, 0x2A, 0xD8, 0xE5, 0xB9, 0x01, 0xA7, 0xB1,
    0xEC, 0xD1, 0x02, 0xAD, 0xB2, 0xDA, 0xE3, 0xB3,
    0x03, 0xE4, 0xE6, 0x04, 0x9B, 0xE2, 0x05, 0x06,
    0x07, 0x08, 0x09, 0xD5, 0x0A, 0xD6, 0x0B, 0xD9,
    0x0C, 0xA6, 0xE9, 0xCB, 0xC5, 0xCF, 0x0D, 0x0E,
    0xCA, 0xC9, 0x0F, 0xC7, 0x10, 0x11, 0xE1, 0x12,
    0x13, 0xC6, 0xD2, 0xC8, 0xCE, 0xC1, 0xC4, 0xD0,
    0xCC, 0x14, 0x15, 0xEF, 0xC2, 0xD7, 0x16, 0xCD,
    0x17, 0xF4, 0xD4, 0x18, 0x19, 0x1A, 0xC3, 0xD3,
    0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20, 0x21, 0x22,
    0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x01, 0x80,
    0xA0, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0xB1, 0x9B,
    0x9B, 0x9B, 0x9B, 0xA0, 0x04, 0xF3, 0xE4, 0xB9,
    0x01, 0xF4, 0xA0, 0x9B, 0x02, 0x03, 0x9B, 0x9B,
    0x9B, 0x9B, 0x01, 0x02, 0x9B, 0xC1, 0xC8, 0xD3,
    0x9B, 0x9B, 0x9B, 0xA0, 0x07, 0x08, 0xB1, 0xD2,
    0xD3, 0xD4, 0xD5, 0xAD, 0xCD, 0xC1, 0x01, 0x02,
    0x03, 0xA0, 0x04, 0x9B, 0x05, 0x06, 0xA0, 0x05,
    0xC9, 0xD7, 0xD3, 0x01, 0x02, 0x9B, 0xAE, 0x80,
    0x03, 0x04, 0x9B, 0x9B, 0x02, 0x03, 0xAD, 0x9B,
    0x01, 0x80, 0xA0, 0xB0, 0x04, 0x05, 0x80, 0x9B,
    0xB1, 0xB2, 0xA0, 0xB0, 0xB9, 0x01, 0x02, 0x03,
    0x02, 0x03, 0xB1, 0xBA, 0x01, 0xB0, 0x9B, 0x80,
    0x80, 0x01, 0xB0, 0x9B, 0x9B, 0xB8, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0xB0, 0x9B, 0xA0, 0x02, 0x03,
    0xB1, 0xB3, 0xB9, 0xB0, 0x01, 0x9B, 0x9B, 0xA0,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x80, 0x9B, 0x9B, 0x13, 0x14, 0xAA, 0xAD,
    0xAE, 0xF6, 0xE7, 0xF4, 0xE2, 0xE9, 0x01, 0x02,
    0xC2, 0xF0, 0x9B, 0xF3, 0xE3, 0xE6, 0xF7, 0x03,
    0xF5, 0x04, 0x05, 0x06, 0xF2, 0x07, 0x08, 0x09,
    0x0A, 0x0B, 0x0C, 0xE4, 0xA0, 0x0D, 0xEC, 0xEE,
    0x0E, 0xED, 0x0F, 0x10, 0x11, 0x12, 0x08, 0x09,
    0xC1, 0xD3, 0x9B, 0x01, 0xC3, 0x02, 0xE9, 0xEC,
    0x03, 0xF2, 0xF5, 0x04, 0xEF, 0xE1, 0x05, 0xE5,
    0x06, 0x07, 0x0B, 0x0C, 0xC1, 0xF9, 0x01, 0xC2,
    0xCF, 0xE5, 0xF5, 0x9B, 0xE9, 0x02, 0xA0, 0x03,
    0x04, 0x05, 0xF2, 0x06, 0xEC, 0x07, 0xE1, 0x08,
    0x09, 0xE8, 0x0A, 0xEF, 0x05, 0x06, 0xF9, 0x9B,
    0x01, 0xF5, 0x02, 0xF2, 0xE9, 0xE5, 0xEF, 0x03,
    0xE1, 0x04, 0x0A, 0x0B, 0xF1, 0xF5, 0xF3, 0x01,
    0xED, 0xF9, 0xC3, 0x02, 0xEC, 0xEE, 0xE4, 0xF8,
    0x03, 0x9B, 0xF6, 0x04, 0x05, 0xE1, 0x06, 0x07,
    0x08, 0x09, 0x07, 0x08, 0xA0, 0x9B, 0xCC, 0x01,
    0xE5, 0x02, 0xEC, 0xF5, 0xEF, 0x03, 0xE9, 0xF2,
    0x04, 0x05, 0xE1, 0x06, 0x09, 0x0A, 0xAE, 0xEC,
    0xF9, 0xC1, 0xE8, 0x01, 0x9B, 0x02, 0x03, 0x04,
    0xE1, 0xF5, 0xE9, 0x05, 0xE5, 0x06, 0xF2, 0xEF,
    0x07, 0x08, 0xEF, 0x05, 0x80, 0x9B, 0xF5, 0x01,
    0x02, 0xE9, 0xE1, 0x03, 0xE5, 0x04, 0xEE, 0x0B,
    0xBA, 0xD4, 0xAE, 0xF2, 0xE3, 0x01, 0xA0, 0x02,
    0x80, 0x9B, 0xED, 0x03, 0xC9, 0xF3, 0xF4, 0x04,
    0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x02, 0x03,
    0x9B, 0xF5, 0x01, 0xE1, 0xEF, 0xE5, 0x05, 0xE9,
    0xE1, 0xEF, 0xF5, 0xEE, 0x9B, 0xE5, 0x01, 0x02,
    0x03, 0x04, 0x04, 0x05, 0xA0, 0x9B, 0x01, 0xF5,
    0x02, 0xE5, 0xEF, 0x03, 0xE1, 0xE9, 0x08, 0x09,
    0xAA, 0xD4, 0x01, 0x9B, 0xE3, 0x02, 0xF2, 0x03,
    0xE5, 0x04, 0xF5, 0xF9, 0xE9, 0x05, 0xEF, 0x06,
    0x07, 0xE1, 0xE5, 0x08, 0xCE, 0xA0, 0xC6, 0xF5,
    0x01, 0x02, 0x9B, 0xC2, 0x03, 0xE1, 0x04, 0xEF,
    0x05, 0xE9, 0x06, 0x07, 0x09, 0x0A, 0xE4, 0xF3,
    0xE6, 0xF6, 0xF7, 0xF0, 0xF2, 0x01, 0xEC, 0x02,
    0x03, 0xA0, 0x9B, 0x04, 0x05, 0xF5, 0x06, 0x07,
    0xEE, 0x08, 0x0B, 0x0C, 0xA0, 0xF3, 0xF9, 0xAE,
    0xD2, 0xC7, 0x01, 0x9B, 0x02, 0xF5, 0x03, 0x04,
    0x05, 0xE9, 0xEC, 0x06, 0xE5, 0x07, 0xEF, 0x08,
    0xE1, 0x09, 0xF2, 0x0A, 0x01, 0xF5, 0x9B, 0xD6,
    0x04, 0x05, 0xE8, 0x9B, 0x01, 0xF5, 0x02, 0xE1,
    0xE9, 0xEF, 0x03, 0xE5, 0x10, 0x11, 0xAA, 0xEC,
    0xF1, 0xAE, 0xA0, 0xF7, 0xED, 0xEE, 0x01, 0x02,
    0x9B, 0xEB, 0x03, 0x04, 0x05, 0x06, 0xE3, 0x07,
    0xEF, 0x08, 0xE9, 0xF5, 0x09, 0xE1, 0xE5, 0xF0,
    0xE8, 0x0A, 0x0B, 0x0C, 0x0D, 0xF4, 0x0E, 0x0F,
    0xE8, 0x0A, 0xAD, 0xCE, 0x9B, 0x01, 0xD6, 0x02,
    0xF5, 0xF7, 0x03, 0x04, 0xE1, 0xE5, 0xE9, 0x05,
    0xF2, 0x06, 0xEF, 0x07, 0x08, 0x09, 0xEE, 0x03,
    0xEC, 0xAE, 0x01, 0x9B, 0x02, 0xF0, 0x06, 0xE9,
    0xA0, 0xC3, 0xEF, 0x9B, 0xE5, 0x01, 0x80, 0x02,
    0x03, 0xE1, 0x04, 0x05, 0x06, 0x07, 0xC6, 0xD7,
    0x01, 0x9B, 0xF2, 0x02, 0x03, 0xE8, 0xE5, 0xE1,
    0x04, 0xE9, 0xEF, 0x05, 0x9B, 0x9B, 0x02, 0xEF,
    0xE1, 0x9B, 0x01, 0xE5, 0x01, 0xEF, 0x9B, 0xE1,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x19, 0x1A, 0x9B, 0xBA,
    0xE5, 0xEA, 0xF8, 0x01, 0x02, 0xE6, 0xA7, 0x03,
    0xFA, 0xE8, 0x04, 0xF7, 0x05, 0xF5, 0xE2, 0x06,
    0xEB, 0x07, 0xF0, 0x08, 0x80, 0xF6, 0xE7, 0x09,
    0xE4, 0x0A, 0xA0, 0xE9, 0x0B, 0xE3, 0xF9, 0x0C,
    0x0D, 0xED, 0x0E, 0x0F, 0xF3, 0x10, 0x11, 0xEC,
    0x12, 0xF4, 0xF2, 0x13, 0xEE, 0x14, 0x15, 0x16,
    0x17, 0x18, 0x0A, 0x0B, 0xF3, 0x9B, 0xF5, 0xE2,
    0x01, 0x80, 0xA0, 0x02, 0xE5, 0xF2, 0xE9, 0x03,
    0xEC, 0x04, 0xF9, 0x05, 0xEF, 0x06, 0xE1, 0x07,
    0x08, 0x09, 0x10, 0x11, 0xC3, 0xCC, 0xC7, 0x9B,
    0xE3, 0x01, 0x80, 0xEC, 0xF9, 0x02, 0xF3, 0x03,
    0xF5, 0x04, 0x05, 0xF2, 0x06, 0xE9, 0xA0, 0x07,
    0x08, 0xEF, 0xF4, 0x09, 0x0A, 0xE1, 0x0B, 0xE8,
    0xEB, 0xE5, 0x0C, 0x0D, 0x0E, 0x0F, 0x0E, 0x0F,
    0xAE, 0xF5, 0xF7, 0x01, 0xEC, 0x02, 0xE4, 0xE7,
    0xF2, 0x03, 0x9B, 0xEF, 0x04, 0xF6, 0x05, 0x06,
    0xF9, 0xF3, 0x07, 0xE9, 0xE1, 0x08, 0x09, 0x80,
    0x0A, 0x0B, 0xE5, 0x0C, 0x0D, 0xA0, 0x1E, 0x1F,
    0x9B, 0xA1, 0xAD, 0xE8, 0xEA, 0xF1, 0xF5, 0xFA,
    0x01, 0x02, 0x03, 0x04, 0xBA, 0xF8, 0xA7, 0xE2,
    0xE9, 0x05, 0x06, 0x07, 0xE6, 0xED, 0xE7, 0xEB,
    0x08, 0x09, 0xF6, 0xF0, 0x0A, 0xEF, 0x0B, 0xE3,
    0x0C, 0x0D, 0x0E, 0xF9, 0x0F, 0xE4, 0xEC, 0x10,
    0xE5, 0x11, 0xF4, 0xF7, 0x12, 0x13, 0xE1, 0x14,
    0x15, 0x16, 0xEE, 0xF3, 0x17, 0x80, 0x18, 0x19,
    0xF2, 0x1A, 0x1B, 0xA0, 0x1C, 0x1D, 0xA0, 0x0B,
    0xF5, 0x9B, 0x01, 0xEC, 0xF3, 0xF2, 0x80, 0xE1,
    0x02, 0x03, 0xF4, 0xE9, 0xEF, 0xE6, 0x04, 0x05,
    0x06, 0x07, 0xE5, 0x08, 0x09, 0x0A, 0x0F, 0x10,
    0xBA, 0xF9, 0xA7, 0xF4, 0x9B, 0x01, 0xE7, 0xEC,
    0x02, 0xEE, 0x03, 0xEF, 0xF5, 0x04, 0xF2, 0x05,
    0x06, 0xE9, 0x07, 0xF3, 0xE1, 0x08, 0x09, 0x0A,
    0x0B, 0xE5, 0x80, 0x0C, 0xE8, 0xA0, 0x0D, 0x0E,
    0xE5, 0x0D, 0xE2, 0xF5, 0xF7, 0x9B, 0xEC, 0x01,
    0xF9, 0xEE, 0x02, 0x03, 0x04, 0xF2, 0x05, 0x80,
    0x06, 0xA0, 0xE1, 0xEF, 0x07, 0xF4, 0xE9, 0x08,
    0x09, 0x0A, 0x0B, 0x0C, 0x15, 0x16, 0xA1, 0xF8,
    0xE9, 0xEB, 0x01, 0x80, 0x9B, 0xFA, 0xE2, 0x02,
    0x03, 0x04, 0xA0, 0xF0, 0x05, 0x06, 0x07, 0xE1,
    0x08, 0xE6, 0xF2, 0xED, 0xF6, 0x09, 0xE4, 0x0A,
    0xEF, 0xF4, 0xEC, 0xF3, 0xE7, 0xE5, 0x0B, 0xE3,
    0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13,
    0xEE, 0x14, 0xEF, 0x01, 0x9B, 0xE1, 0x0B, 0x0C,
    0xD4, 0xEF, 0xE6, 0xEC, 0xF7, 0xE1, 0x01, 0xBA,
    0x02, 0x9B, 0xF9, 0x03, 0x04, 0x05, 0xF3, 0x06,
    0x07, 0x08, 0xE9, 0xA0, 0x09, 0x80, 0xE5, 0x0A,
    0x15, 0x16, 0xA7, 0xBA, 0xE3, 0xF7, 0xF2, 0xAD,
    0xE2, 0x01, 0x02, 0x9B, 0xE6, 0x03, 0xED, 0xF6,
    0x04, 0xEB, 0x05, 0xF4, 0x06, 0x07, 0x08, 0xF3,
    0x09, 0xF5, 0x0A, 0xEF, 0x0B, 0x0C, 0x80, 0xF9,
    0xE1, 0x0D, 0xE4, 0xE9, 0xA0, 0x0E, 0x0F, 0xEC,
    0xE5, 0x10, 0x11, 0x12, 0x13, 0x14, 0x0A, 0x0B,
    0xF9, 0x9B, 0xF5, 0xF3, 0x01, 0x02, 0xE2, 0xED,
    0x80, 0x03, 0xF0, 0xEF, 0x04, 0xA0, 0x05, 0xE9,
    0x06, 0xE1, 0x07, 0x08, 0x09, 0xE5, 0x18, 0x19,
    0xE2, 0xEA, 0xF2, 0xE8, 0xEC, 0xED, 0xFA, 0x9B,
    0x01, 0xF5, 0x02, 0x03, 0xF6, 0x04, 0xBA, 0xE6,
    0x05, 0x06, 0xEB, 0xEF, 0x07, 0xA7, 0xF9, 0x08,
    0x09, 0x0A, 0x0B, 0xE3, 0x0C, 0xEE, 0xE1, 0x0D,
    0xF3, 0x0E, 0xE9, 0x0F, 0x10, 0xF4, 0x80, 0xE4,
    0xE5, 0x11, 0x12, 0xE7, 0xA0, 0x13, 0x14, 0x15,
    0x16, 0x17, 0x1B, 0x1C, 0xAE, 0xFA, 0xBF, 0x01,
    0xA7, 0x9B, 0x02, 0xE9, 0xF8, 0xF9, 0x03, 0xE5,
    0xE8, 0x04, 0xE1, 0xEB, 0x05, 0xE2, 0x06, 0x07,
    0xE3, 0x08, 0xE7, 0xF4, 0x09, 0x80, 0xF6, 0xF0,
    0x0A, 0xE4, 0x0B, 0xF3, 0xF7, 0x0C, 0x0D, 0xEF,
    0xEC, 0xA0, 0x0E, 0x0F, 0xED, 0xE6, 0x10, 0xF5,
    0x11, 0x12, 0x13, 0x14, 0x15, 0xF2, 0x16, 0xEE,
    0x17, 0x18, 0x19, 0x1A, 0x0E, 0x0F, 0xED, 0xA7,
    0x9B, 0xE4, 0x01, 0xF9, 0xF3, 0xF2, 0xF4, 0x02,
    0xE8, 0x03, 0xEC, 0xF0, 0x04, 0xE1, 0xE9, 0x05,
    0x06, 0x80, 0xA0, 0x07, 0x08, 0x09, 0x0A, 0xE5,
    0xEF, 0x0B, 0x0C, 0x0D, 0x9B, 0xF5, 0x18, 0x19,
    0xBA, 0xAC, 0xF6, 0x9B, 0xF0, 0xE2, 0x01, 0xE6,
    0x02, 0xA7, 0xAE, 0xE7, 0x03, 0xE3, 0xF5, 0x04,
    0xED, 0x05, 0x06, 0x07, 0xEB, 0x08, 0x09, 0xEE,
    0xF2, 0x0A, 0xE4, 0x0B, 0xF9, 0xEC, 0x0C, 0x0D,
    0xF4, 0x80, 0x0E, 0xEF, 0xF3, 0xA0, 0xE1, 0x0F,
    0xE9, 0x10, 0x11, 0xE5, 0x12, 0x13, 0x14, 0x15,
    0x16, 0x17, 0x19, 0x1A, 0xA7, 0xAC, 0xBF, 0xC3,
    0xC8, 0xE4, 0xE6, 0xED, 0xF2, 0xAE, 0xEC, 0xEE,
    0xF9, 0x01, 0x02, 0x03, 0x04, 0xBA, 0x05, 0x9B,
    0xF5, 0x06, 0x07, 0x08, 0x09, 0xEB, 0xF0, 0x0A,
    0x0B, 0x0C, 0xE1, 0xE3, 0x0D, 0xE8, 0x0E, 0x0F,
    0xEF, 0x10, 0x11, 0xF3, 0x12, 0xE9, 0x13, 0xE5,
    0x14, 0x15, 0xF4, 0x16, 0x17, 0xA0, 0x18, 0x80,
    0x14, 0x15, 0xBA, 0xBF, 0xE4, 0xF7, 0x9B, 0xA7,
    0x01, 0xEE, 0x02, 0x03, 0x04, 0xE3, 0xE2, 0xED,
    0x05, 0xF9, 0x06, 0xF4, 0x07, 0xEC, 0x08, 0xF5,
    0xF2, 0x09, 0xE1, 0xF3, 0x0A, 0xEF, 0x0B, 0x0C,
    0x0D, 0xE9, 0x80, 0xE5, 0x0E, 0xA0, 0x0F, 0xE8,
    0x10, 0x11, 0x12, 0x13, 0x11, 0x12, 0xEB, 0xFA,
    0x80, 0xE6, 0x9B, 0x01, 0xA0, 0x02, 0x03, 0xE9,
    0xE1, 0x04, 0xE4, 0xF0, 0xED, 0xE2, 0xE3, 0xE7,
    0xEC, 0x05, 0xE5, 0x06, 0x07, 0x08, 0x09, 0xF4,
    0x0A, 0x0B, 0x0C, 0xF3, 0xEE, 0x0D, 0x0E, 0xF2,
    0x0F, 0x10, 0x04, 0xE5, 0xF3, 0xEF, 0x9B, 0x01,
    0xE1, 0x02, 0x03, 0xE9, 0x0B, 0x0C, 0xA7, 0xE2,
    0xEC, 0xE3, 0xF2, 0x01, 0x9B, 0x02, 0x03, 0x04,
    0xE9, 0xEF, 0xEE, 0xE5, 0xE1, 0x80, 0x05, 0xA0,
    0x06, 0x07, 0x08, 0x09, 0xF3, 0x0A, 0x05, 0x06,
    0x9B, 0xA0, 0xE1, 0xE5, 0xE9, 0x01, 0x80, 0xF0,
    0x02, 0xF4, 0x03, 0x04, 0xA0, 0x13, 0xE3, 0xAD,
    0xE4, 0xE9, 0xEE, 0xEF, 0xF0, 0xF4, 0xF6, 0xA1,
    0xE1, 0xED, 0x01, 0xE2, 0x02, 0x03, 0x04, 0xA7,
    0x05, 0x06, 0xF7, 0x07, 0x9B, 0xEC, 0x08, 0xE5,
    0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0xF3, 0x0F,
    0x10, 0x11, 0x80, 0x12, 0x05, 0x06, 0xE5, 0xFA,
    0xA0, 0xF9, 0x9B, 0x01, 0x80, 0xE9, 0x02, 0xE1,
    0x03, 0x04, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B
};

// Table C5: English-language Program Description Decode Table
const atsc_table_vec ATSC_C7
{
    0x01, 0x00, 0x01, 0x2C, 0x01, 0x2E, 0x01, 0x30,
    0x01, 0x32, 0x01, 0x34, 0x01, 0x36, 0x01, 0x38,
    0x01, 0x3A, 0x01, 0x3C, 0x01, 0x3E, 0x01, 0x40,
    0x01, 0x42, 0x01, 0x44, 0x01, 0x46, 0x01, 0x48,
    0x01, 0x4A, 0x01, 0x4C, 0x01, 0x4E, 0x01, 0x50,
    0x01, 0x52, 0x01, 0x54, 0x01, 0x56, 0x01, 0x58,
    0x01, 0x5A, 0x01, 0x5C, 0x01, 0x5E, 0x01, 0x60,
    0x01, 0x62, 0x01, 0x64, 0x01, 0x66, 0x01, 0x68,
    0x01, 0x6A, 0x01, 0xDE, 0x01, 0xE0, 0x01, 0xEA,
    0x01, 0xEC, 0x01, 0xEE, 0x01, 0xF0, 0x01, 0xF2,
    0x01, 0xF8, 0x01, 0xFA, 0x01, 0xFC, 0x01, 0xFE,
    0x02, 0x00, 0x02, 0x04, 0x02, 0x16, 0x02, 0x20,
    0x02, 0x22, 0x02, 0x2C, 0x02, 0x32, 0x02, 0x38,
    0x02, 0x3C, 0x02, 0x40, 0x02, 0x44, 0x02, 0x46,
    0x02, 0x4A, 0x02, 0x4C, 0x02, 0x54, 0x02, 0x56,
    0x02, 0x58, 0x02, 0x5A, 0x02, 0x5C, 0x02, 0x5E,
    0x02, 0x60, 0x02, 0x62, 0x02, 0x76, 0x02, 0x84,
    0x02, 0x94, 0x02, 0xA2, 0x02, 0xB2, 0x02, 0xBA,
    0x02, 0xC8, 0x02, 0xD2, 0x02, 0xDE, 0x02, 0xEA,
    0x02, 0xF2, 0x02, 0xFC, 0x03, 0x08, 0x03, 0x10,
    0x03, 0x1A, 0x03, 0x28, 0x03, 0x2A, 0x03, 0x34,
    0x03, 0x4A, 0x03, 0x5A, 0x03, 0x5E, 0x03, 0x64,
    0x03, 0x6E, 0x03, 0x70, 0x03, 0x72, 0x03, 0x74,
    0x03, 0x76, 0x03, 0x78, 0x03, 0x7A, 0x03, 0x7C,
    0x03, 0x7E, 0x03, 0x80, 0x03, 0xB4, 0x03, 0xCE,
    0x03, 0xF0, 0x04, 0x1A, 0x04, 0x58, 0x04, 0x6E,
    0x04, 0x8E, 0x04, 0xAC, 0x04, 0xD8, 0x04, 0xE0,
    0x04, 0xF4, 0x05, 0x24, 0x05, 0x40, 0x05, 0x76,
    0x05, 0xAE, 0x05, 0xCE, 0x05, 0xD0, 0x06, 0x06,
    0x06, 0x34, 0x06, 0x60, 0x06, 0x86, 0x06, 0x92,
    0x06, 0xAA, 0x06, 0xB8, 0x06, 0xDC, 0x06, 0xEC,
    0x06, 0xEE, 0x06, 0xF0, 0x06, 0xF2, 0x06, 0xF4,
    0x14, 0x15, 0x9B, 0xD6, 0xC9, 0xCF, 0xD7, 0xC7,
    0x01, 0xA2, 0xCE, 0xCB, 0x02, 0x03, 0xC5, 0xCC,
    0xC6, 0xC8, 0x04, 0xC4, 0x05, 0xC2, 0x06, 0xC3,
    0xD2, 0x07, 0xD3, 0x08, 0xCA, 0xD4, 0x09, 0xCD,
    0xD0, 0x0A, 0xC1, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
    0x10, 0x11, 0x12, 0x13, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x38, 0x39, 0xAD, 0xAF, 0xB7, 0xDA,
    0xA8, 0xB3, 0xB5, 0x01, 0x02, 0x9B, 0xB4, 0xF1,
    0xA2, 0xD5, 0xD6, 0xD9, 0x03, 0x04, 0x05, 0xCF,
    0x06, 0xC9, 0xF9, 0xEA, 0xEB, 0xF5, 0xF6, 0x07,
    0x08, 0x09, 0xB2, 0xC5, 0xC6, 0xB1, 0x0A, 0xEE,
    0xCB, 0x0B, 0xD4, 0x0C, 0xC4, 0xC8, 0xD2, 0x0D,
    0x0E, 0x0F, 0xC7, 0xCA, 0xCE, 0xD0, 0xD7, 0x10,
    0xC2, 0x11, 0xCC, 0xEC, 0xE5, 0xE7, 0x12, 0xCD,
    0x13, 0x14, 0xC3, 0x15, 0x16, 0x17, 0xED, 0x18,
    0x19, 0xF2, 0x1A, 0xD3, 0x1B, 0x1C, 0xE4, 0x1D,
    0xC1, 0xE3, 0x1E, 0xE9, 0xF0, 0xE2, 0xF7, 0x1F,
    0xF3, 0xE6, 0x20, 0x21, 0x22, 0xE8, 0xEF, 0x23,
    0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0xF4,
    0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0xE1, 0x30, 0x31,
    0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x9B, 0x9B,
    0x03, 0x04, 0x80, 0xAE, 0xC8, 0xD4, 0x01, 0x02,
    0x9B, 0xA0, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x02, 0xF3, 0xA0, 0xF4, 0x9B, 0x01,
    0x9B, 0x9B, 0xAC, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x01, 0xA0, 0x9B, 0xA2, 0x07, 0x08, 0xE2, 0xE4,
    0xE5, 0xE6, 0xA0, 0xF2, 0xE1, 0x01, 0x02, 0xF3,
    0xE3, 0x03, 0x04, 0x05, 0x9B, 0x06, 0x04, 0x80,
    0xCA, 0xD3, 0xA2, 0x01, 0x9B, 0x02, 0x03, 0xA0,
    0x9B, 0xA0, 0x03, 0x04, 0x9B, 0xB7, 0xF4, 0xA0,
    0xB0, 0xF3, 0x01, 0x02, 0xB9, 0x02, 0xB8, 0x9B,
    0xA0, 0x01, 0xAE, 0x02, 0xB6, 0x9B, 0x01, 0xA0,
    0xA0, 0x01, 0x9B, 0xB0, 0xAE, 0x01, 0x9B, 0xA0,
    0xAE, 0x01, 0xA0, 0x9B, 0x9B, 0x9B, 0x9B, 0x01,
    0xAC, 0xAE, 0x9B, 0x9B, 0x02, 0x03, 0x9B, 0xA0,
    0xB5, 0xB6, 0xB8, 0x01, 0x9B, 0xA0, 0x9B, 0xA0,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0xA0,
    0x9B, 0x9B, 0x08, 0x09, 0xE6, 0xF5, 0xF3, 0xF4,
    0x9B, 0xE4, 0x01, 0xED, 0x02, 0x03, 0x04, 0xF2,
    0x05, 0x06, 0xEC, 0xEE, 0x07, 0xA0, 0x05, 0x06,
    0x9B, 0xEC, 0xF5, 0x01, 0x02, 0xE1, 0xEF, 0xE5,
    0xE9, 0xF2, 0x03, 0x04, 0x06, 0x07, 0x9B, 0xE9,
    0xF9, 0xF2, 0xF5, 0x01, 0x02, 0x03, 0xEC, 0xEF,
    0xE1, 0x04, 0xE8, 0x05, 0x05, 0x06, 0xF9, 0xF2,
    0xF5, 0x9B, 0xE5, 0xEF, 0x01, 0x02, 0xE9, 0xE1,
    0x03, 0x04, 0x06, 0x07, 0xE1, 0xE9, 0xEE, 0xF6,
    0xE4, 0xEC, 0xF3, 0x01, 0x02, 0xF2, 0x03, 0x04,
    0x9B, 0x05, 0x02, 0x03, 0xE5, 0xEC, 0x9B, 0xEF,
    0x01, 0xF2, 0x05, 0x06, 0xF5, 0xEF, 0x9B, 0xEC,
    0xE9, 0x01, 0xE1, 0xF2, 0x02, 0xE5, 0x03, 0x04,
    0x03, 0x04, 0x9B, 0xE5, 0xE9, 0xF5, 0xE1, 0x01,
    0xEF, 0x02, 0x04, 0x05, 0xA0, 0xC9, 0xF3, 0x9B,
    0xAE, 0xF2, 0x01, 0x02, 0x03, 0xEE, 0xEF, 0x05,
    0x9B, 0xAE, 0xE9, 0xE5, 0x01, 0xF5, 0x02, 0xE1,
    0x03, 0x04, 0xE5, 0x03, 0xE1, 0xE9, 0xF2, 0x9B,
    0x01, 0x02, 0x03, 0x04, 0x9B, 0xE9, 0xF5, 0x01,
    0xE5, 0x02, 0xEF, 0xE1, 0xE1, 0x05, 0x9B, 0xE3,
    0xEF, 0x01, 0xF5, 0xE5, 0x02, 0x03, 0xE9, 0x04,
    0xE5, 0x03, 0x9B, 0xE9, 0x01, 0xE1, 0xEF, 0x02,
    0x03, 0x04, 0xA7, 0xEE, 0xEC, 0xF2, 0xF3, 0x01,
    0x9B, 0x02, 0xE1, 0x06, 0x9B, 0xE8, 0xE9, 0x01,
    0xF2, 0xEC, 0x02, 0xEF, 0x03, 0xE5, 0x04, 0x05,
    0x9B, 0x9B, 0x03, 0x04, 0x9B, 0xAE, 0x01, 0xE9,
    0x02, 0xE1, 0xE5, 0xEF, 0x09, 0x0A, 0xF6, 0xF9,
    0x01, 0xAE, 0xE3, 0xE9, 0xF5, 0x9B, 0xE5, 0xEF,
    0x02, 0x03, 0xE1, 0x04, 0xE8, 0x05, 0x06, 0xF4,
    0x07, 0x08, 0xE8, 0x07, 0xE5, 0xF7, 0xD6, 0xE1,
    0x9B, 0xE9, 0xF2, 0x01, 0x02, 0x03, 0x04, 0xEF,
    0x05, 0x06, 0xAE, 0x01, 0x9B, 0xEE, 0xE9, 0x02,
    0xE5, 0x9B, 0xA0, 0x01, 0x03, 0x04, 0x9B, 0xE8,
    0xE5, 0xE1, 0xEF, 0x01, 0xE9, 0x02, 0x9B, 0x9B,
    0x9B, 0xEF, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B,
    0x18, 0x19, 0xE8, 0xEF, 0xF8, 0x9B, 0xA7, 0xF7,
    0xFA, 0x01, 0x02, 0x03, 0x04, 0xE5, 0xAE, 0x05,
    0xE6, 0xE2, 0x06, 0xF6, 0xEB, 0xF5, 0xE9, 0x07,
    0xF0, 0xF9, 0xE7, 0x08, 0x09, 0xE4, 0x0A, 0xE3,
    0x0B, 0xED, 0x0C, 0xF3, 0x0D, 0x0E, 0x0F, 0xEC,
    0x10, 0xF4, 0x11, 0x12, 0xF2, 0xA0, 0x13, 0x14,
    0x15, 0xEE, 0x16, 0x17, 0x0B, 0x0C, 0xE4, 0xF3,
    0x9B, 0xAE, 0xE2, 0x01, 0x02, 0x03, 0xEC, 0xA0,
    0x04, 0xE9, 0xF2, 0xF5, 0x05, 0xF9, 0xE1, 0x06,
    0xEF, 0x07, 0xE5, 0x08, 0x09, 0x0A, 0x0F, 0x10,
    0xF1, 0xAE, 0xC4, 0xF9, 0xAC, 0x01, 0xE3, 0x02,
    0x9B, 0xF2, 0x03, 0x04, 0xA0, 0xEC, 0xF5, 0x05,
    0x06, 0xE9, 0x07, 0xEB, 0x08, 0xF4, 0x09, 0xE5,
    0x0A, 0xEF, 0xE1, 0xE8, 0x0B, 0x0C, 0x0D, 0x0E,
    0x13, 0x14, 0xA7, 0xBB, 0xE6, 0xED, 0xF7, 0xE7,
    0xF6, 0x01, 0x02, 0x9B, 0xEE, 0x03, 0x04, 0xEC,
    0x05, 0xF5, 0x06, 0xAC, 0xE4, 0xF9, 0xF2, 0x07,
    0x08, 0x09, 0xAE, 0x0A, 0xEF, 0x0B, 0xE1, 0xF3,
    0x0C, 0xE9, 0x0D, 0x0E, 0x0F, 0x10, 0xE5, 0x11,
    0x12, 0xA0, 0x1D, 0x1E, 0xA9, 0xE8, 0xF5, 0x9B,
    0x01, 0xAD, 0xBB, 0xEB, 0xFA, 0x02, 0xA7, 0xE6,
    0xE2, 0xE7, 0x03, 0x04, 0x05, 0x06, 0xE9, 0xF8,
    0x07, 0xAC, 0xEF, 0xF0, 0x08, 0xED, 0xF6, 0xF9,
    0x09, 0xF7, 0x0A, 0x0B, 0xAE, 0x0C, 0xE3, 0x0D,
    0xE5, 0xF4, 0x0E, 0x0F, 0xE4, 0x10, 0xEC, 0x11,
    0xE1, 0x12, 0x13, 0x14, 0x15, 0x16, 0xEE, 0xF3,
    0x17, 0x18, 0xF2, 0xA0, 0x19, 0x1A, 0x1B, 0x1C,
    0x09, 0x0A, 0xAE, 0x9B, 0xEC, 0x01, 0xF5, 0x02,
    0xF4, 0xE6, 0x03, 0xE1, 0xE5, 0xE9, 0x04, 0xF2,
    0xEF, 0x05, 0x06, 0x07, 0xA0, 0x08, 0x0E, 0x0F,
    0xAD, 0xE7, 0x9B, 0xA7, 0xF9, 0x01, 0xEC, 0x02,
    0xAC, 0xF2, 0x03, 0xAE, 0xF3, 0xF5, 0x04, 0x05,
    0xEF, 0x06, 0x07, 0xE9, 0xE1, 0x08, 0x09, 0xE8,
    0x0A, 0x0B, 0xE5, 0x0C, 0xA0, 0x0D, 0x0D, 0x0E,
    0xA7, 0xAC, 0xF3, 0xAD, 0x01, 0x02, 0x9B, 0xF9,
    0xF5, 0xAE, 0x03, 0xEE, 0x04, 0xF2, 0x05, 0x06,
    0xF4, 0x07, 0x08, 0x09, 0xEF, 0xE1, 0xA0, 0x0A,
    0xE9, 0x0B, 0x0C, 0xE5, 0x14, 0x15, 0xAC, 0xE2,
    0xF8, 0x9B, 0xAE, 0xFA, 0x01, 0xEB, 0x02, 0xA0,
    0x03, 0x04, 0xF0, 0x05, 0x06, 0xE6, 0xF6, 0x07,
    0xE4, 0xED, 0xE7, 0x08, 0xE1, 0xEF, 0xF2, 0x09,
    0x0A, 0x0B, 0xEC, 0x0C, 0xE5, 0xE3, 0x0D, 0xF4,
    0x0E, 0xF3, 0x0F, 0x10, 0x11, 0xEE, 0x12, 0x13,
    0x03, 0xEF, 0x9B, 0xE1, 0xE5, 0xF5, 0x01, 0x02,
    0x08, 0x09, 0xEC, 0xF9, 0xA7, 0xEE, 0x01, 0xAC,
    0x9B, 0xAE, 0x02, 0x03, 0x04, 0xF3, 0x05, 0xE9,
    0x06, 0xA0, 0x07, 0xE5, 0x16, 0x17, 0xA7, 0xAD,
    0xEE, 0xE3, 0xEB, 0xF2, 0x9B, 0xE2, 0x01, 0x02,
    0xF5, 0x03, 0xF4, 0xAC, 0x04, 0x05, 0xE6, 0xED,
    0xF6, 0x06, 0xAE, 0xF0, 0x07, 0x08, 0xF3, 0x09,
    0x0A, 0xE4, 0x0B, 0x0C, 0xF9, 0x0D, 0xEF, 0x0E,
    0xE1, 0x0F, 0x10, 0xE9, 0xEC, 0x11, 0xA0, 0xE5,
    0x12, 0x13, 0x14, 0x15, 0x0C, 0x0D, 0xA7, 0xBB,
    0x9B, 0x01, 0xF9, 0xAE, 0xE2, 0x02, 0xED, 0xF3,
    0x03, 0xF5, 0xEF, 0xF0, 0x04, 0x05, 0xE9, 0x06,
    0x07, 0x08, 0x09, 0xA0, 0xE1, 0xE5, 0x0A, 0x0B,
    0x19, 0x1A, 0xAD, 0xBB, 0xE2, 0xEA, 0xED, 0xF2,
    0xFA, 0xE6, 0xEC, 0x01, 0x02, 0x03, 0x9B, 0xF5,
    0x04, 0xA7, 0xF6, 0xF9, 0x05, 0x06, 0xEB, 0xEF,
    0x07, 0x08, 0x09, 0x0A, 0xAC, 0x0B, 0x0C, 0xE3,
    0xAE, 0x0D, 0xEE, 0xE9, 0x0E, 0xE1, 0x0F, 0xF3,
    0x10, 0x11, 0xF4, 0x12, 0xE7, 0xE5, 0x13, 0x14,
    0xE4, 0x15, 0x16, 0x17, 0xA0, 0x18, 0x1A, 0x1B,
    0xC2, 0x9B, 0xAD, 0xAC, 0xF8, 0x01, 0xAE, 0x02,
    0x03, 0xE5, 0xE7, 0xE8, 0xF9, 0xE9, 0xEB, 0x04,
    0xE3, 0xE1, 0x05, 0xF6, 0x06, 0xE4, 0x07, 0xE2,
    0xF0, 0x08, 0x09, 0xF3, 0xF4, 0xF7, 0xEF, 0x0A,
    0x0B, 0x0C, 0x0D, 0xEC, 0x0E, 0x0F, 0x10, 0xF5,
    0xED, 0x11, 0xE6, 0xA0, 0x12, 0xF2, 0x13, 0x14,
    0x15, 0xEE, 0x16, 0x17, 0x18, 0x19, 0x0E, 0x0F,
    0xAD, 0xED, 0xF9, 0x9B, 0xAE, 0x01, 0xF3, 0x02,
    0x03, 0xF5, 0xF4, 0xF0, 0x04, 0xEF, 0x05, 0xE9,
    0x06, 0xE8, 0xA0, 0xE1, 0xEC, 0x07, 0xF2, 0x08,
    0xE5, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x9B, 0xF5,
    0x19, 0x1A, 0xA9, 0xBB, 0xF6, 0xE6, 0x01, 0x9B,
    0xAD, 0xE2, 0xF0, 0x02, 0xA7, 0x03, 0x04, 0x05,
    0xF5, 0xE3, 0xAC, 0xE7, 0xF2, 0x06, 0xEB, 0x07,
    0xEC, 0xED, 0xEE, 0xF9, 0x08, 0xAE, 0x09, 0x0A,
    0xE4, 0x0B, 0x0C, 0xF4, 0x0D, 0xF3, 0x0E, 0x0F,
    0x10, 0xE1, 0xEF, 0x11, 0xE9, 0x12, 0x13, 0xE5,
    0x14, 0xA0, 0x15, 0x16, 0x17, 0x18, 0xA0, 0x16,
    0xA2, 0xA7, 0xE2, 0xEB, 0xED, 0xEE, 0x9B, 0xF7,
    0x01, 0x02, 0x03, 0xBB, 0xF9, 0xF0, 0x04, 0x05,
    0xEC, 0x06, 0x07, 0x08, 0xF5, 0xE1, 0x09, 0xAC,
    0xE3, 0x0A, 0xE8, 0x0B, 0xE9, 0x0C, 0xEF, 0xF3,
    0xAE, 0x0D, 0x0E, 0xE5, 0x0F, 0x10, 0x11, 0xF4,
    0x12, 0x13, 0x14, 0x15, 0x14, 0x15, 0xBB, 0xE2,
    0xAD, 0xED, 0x01, 0x9B, 0xA7, 0xE3, 0xAC, 0xEC,
    0xEE, 0x02, 0xF7, 0x03, 0x04, 0xF9, 0x05, 0x06,
    0x07, 0x08, 0xF4, 0xAE, 0xF5, 0x09, 0x0A, 0xF2,
    0xE1, 0xF3, 0x0B, 0x0C, 0x0D, 0xE9, 0x0E, 0x0F,
    0xEF, 0xE5, 0x10, 0xA0, 0xE8, 0x11, 0x12, 0x13,
    0x11, 0x12, 0xEF, 0xF6, 0x9B, 0xEB, 0xF9, 0x01,
    0xA0, 0xE2, 0x02, 0xE1, 0x03, 0xED, 0x04, 0xE3,
    0xE9, 0x05, 0xE4, 0xE5, 0xE7, 0x06, 0xEC, 0xF0,
    0x07, 0x08, 0x09, 0x0A, 0x0B, 0xF3, 0x0C, 0xF4,
    0xEE, 0x0D, 0xF2, 0x0E, 0x0F, 0x10, 0x05, 0xE5,
    0xF3, 0xF9, 0x9B, 0x01, 0xEF, 0x02, 0x03, 0xE1,
    0x04, 0xE9, 0x0A, 0x0B, 0xAE, 0x9B, 0xEC, 0xED,
    0x01, 0x02, 0xF3, 0xEE, 0xF2, 0x03, 0xE5, 0x04,
    0xE8, 0xA0, 0xE1, 0x05, 0xEF, 0x06, 0x07, 0x08,
    0xE9, 0x09, 0x05, 0x06, 0xA0, 0xAC, 0xAD, 0xF4,
    0xE9, 0x01, 0x02, 0xE1, 0xE5, 0x03, 0x9B, 0x04,
    0x11, 0xA0, 0xBF, 0xE1, 0xE2, 0xE6, 0xED, 0xE4,
    0xE9, 0xF7, 0xA7, 0x01, 0x02, 0xBB, 0x03, 0x04,
    0xEC, 0x05, 0x9B, 0xEE, 0x06, 0xEF, 0x07, 0xAC,
    0xE5, 0xF3, 0x08, 0x09, 0x0A, 0xAE, 0x0B, 0x0C,
    0x0D, 0x0E, 0x0F, 0x10, 0x06, 0x07, 0xA0, 0xAE,
    0xE1, 0xE5, 0xEC, 0xFA, 0x9B, 0xEF, 0xE9, 0x01,
    0x02, 0x03, 0x04, 0x05, 0x9B, 0x9B, 0x9B, 0x9B,
    0x9B, 0x9B, 0x9B, 0x9B, 0x9B, 0x9B
};

const std::array<const atsc_table_vec,2> atsc_tables
{
    ATSC_C5,
    ATSC_C7,
};

const huff2_table_vec Table128
{
    { 0x0000, 0x20, 0x03, },  // ' ' duplicate entry makes 1st lookup non zero
    { 0x0000, 0x20, 0x03, },  // ' '
    { 0x0002, 0x65, 0x04, },  // 'e'
    { 0x0003, 0x74, 0x04, },  // 't'
    { 0x0004, 0x61, 0x04, },  // 'a'
    { 0x0005, 0x6F, 0x04, },  // 'o'
    { 0x0006, 0x73, 0x04, },  // 's'
    { 0x0007, 0x6E, 0x04, },  // 'n'
    { 0x0020, 0x72, 0x06, },  // 'r'
    { 0x0021, 0x69, 0x06, },  // 'i'
    { 0x0022, 0x6C, 0x06, },  // 'l'
    { 0x0023, 0x63, 0x06, },  // 'c'
    { 0x0024, 0x68, 0x06, },  // 'h'
    { 0x0025, 0x75, 0x06, },  // 'u'
    { 0x0026, 0x64, 0x06, },  // 'd'
    { 0x0027, 0x70, 0x06, },  // 'p'
    { 0x0028, 0x6D, 0x06, },  // 'm'
    { 0x0029, 0x67, 0x06, },  // 'g'
    { 0x002A, 0x79, 0x06, },  // 'y'
    { 0x002B, 0x76, 0x06, },  // 'v'
    { 0x002C, 0x0A, 0x06, },  // '''
    { 0x002D, 0x2E, 0x06, },  // '.'
    { 0x002E, 0x77, 0x06, },  // 'w'
    { 0x002F, 0x66, 0x06, },  // 'f'
    { 0x0060, 0x53, 0x07, },  // 'S'
    { 0x0061, 0x62, 0x07, },  // 'b'
    { 0x0062, 0x54, 0x07, },  // 'T'
    { 0x0063, 0x22, 0x07, },  // '"'
    { 0x0064, 0x6B, 0x07, },  // 'k'
    { 0x0065, 0x50, 0x07, },  // 'P'
    { 0x0066, 0x41, 0x07, },  // 'A'
    { 0x0067, 0x43, 0x07, },  // 'C'
    { 0x0068, 0x44, 0x07, },  // 'D'
    { 0x0069, 0x4C, 0x07, },  // 'L'
    { 0x006A, 0x4D, 0x07, },  // 'M'
    { 0x006B, 0x49, 0x07, },  // 'I'
    { 0x006C, 0x4E, 0x07, },  // 'N'
    { 0x006D, 0x3A, 0x07, },  // ':'
    { 0x006E, 0x52, 0x07, },  // 'R'
    { 0x006F, 0x2C, 0x07, },  // ','
    { 0x00E0, 0x45, 0x08, },  // 'E'
    { 0x00E1, 0x55, 0x08, },  // 'U'
    { 0x00E2, 0x46, 0x08, },  // 'F'
    { 0x00E3, 0x48, 0x08, },  // 'H'
    { 0x00E4, 0x59, 0x08, },  // 'Y'
    { 0x00E5, 0x56, 0x08, },  // 'V'
    { 0x00E6, 0x2D, 0x08, },  // '-'
    { 0x00E7, 0x7A, 0x08, },  // 'z'
    { 0x00E8, 0x78, 0x08, },  // 'x'
    { 0x00E9, 0x2F, 0x08, },  // '/'
    { 0x00EA, 0x4F, 0x08, },  // 'O'
    { 0x00EB, 0x3F, 0x08, },  // '?'
    { 0x00EC, 0x57, 0x08, },  // 'W'
    { 0x00ED, 0x47, 0x08, },  // 'G'
    { 0x00EE, 0x42, 0x08, },  // 'B'
    { 0x00EF, 0x33, 0x08, },  // '3'
    { 0x01E0, 0x31, 0x09, },  // '1'
    { 0x01E1, 0x71, 0x09, },  // 'q'
    { 0x01E2, 0x30, 0x09, },  // '0'
    { 0x01E3, 0x21, 0x09, },  // '!'
    { 0x01E4, 0x6A, 0x09, },  // 'j'
    { 0x01E5, 0x5A, 0x09, },  // 'Z'
    { 0x01E6, 0x39, 0x09, },  // '9'
    { 0x01E7, 0x34, 0x09, },  // '4'
    { 0x01E8, 0x4B, 0x09, },  // 'K'
    { 0x01E9, 0x2A, 0x09, },  // '*'
    { 0x01EA, 0x37, 0x09, },  // '7'
    { 0x01EB, 0x36, 0x09, },  // '6'
    { 0x01EC, 0x35, 0x09, },  // '5'
    { 0x01ED, 0x4A, 0x09, },  // 'J'
    { 0x01EE, 0x38, 0x09, },  // '8'
    { 0x01EF, 0x29, 0x09, },  // ')'
    { 0x03E0, 0x28, 0x0A, },  // '('
    { 0x03E1, 0x58, 0x0A, },  // 'X'
    { 0x03E2, 0x51, 0x0A, },  // 'Q'
    { 0x03E3, 0x3C, 0x0A, },  // '<'
    { 0x03E4, 0x32, 0x0A, },  // '2'
    { 0x03E5, 0x27, 0x0A, },  // '''
    { 0x03E6, 0x26, 0x0A, },  // '&'
    { 0x07CE, 0x7F, 0x0B, },  // '
    { 0x07CF, 0x7E, 0x0B, },  // '~'
    { 0x07D0, 0x7D, 0x0B, },  // '}'
    { 0x07D1, 0x7C, 0x0B, },  // '|'
    { 0x07D2, 0x7B, 0x0B, },  // '{'
    { 0x07D3, 0x60, 0x0B, },  // '`'
    { 0x07D4, 0x5F, 0x0B, },  // '_'
    { 0x07D5, 0x5E, 0x0B, },  // '^'
    { 0x07D6, 0x5D, 0x0B, },  // ']'
    { 0x07D7, 0x5C, 0x0B, },  // '\'
    { 0x07D8, 0x5B, 0x0B, },  // '['
    { 0x07D9, 0x40, 0x0B, },  // '@'
    { 0x07DA, 0x3E, 0x0B, },  // '>'
    { 0x07DB, 0x3D, 0x0B, },  // '='
    { 0x07DC, 0x3B, 0x0B, },  // ';'
    { 0x07DD, 0x2B, 0x0B, },  // '+'
    { 0x07DE, 0x25, 0x0B, },  // '%'
    { 0x07DF, 0x24, 0x0B, },  // '$'
    { 0x07E0, 0x23, 0x0B, },  // '#'
    { 0x07E1, 0x1F, 0x0B, },  // ''
    { 0x07E2, 0x1E, 0x0B, },  // ''
    { 0x07E3, 0x1D, 0x0B, },  // ''
    { 0x07E4, 0x1C, 0x0B, },  // ''
    { 0x07E5, 0x1B, 0x0B, },  // ''
    { 0x07E6, 0x1A, 0x0B, },  // ''
    { 0x07E7, 0x19, 0x0B, },  // ''
    { 0x07E8, 0x18, 0x0B, },  // ''
    { 0x07E9, 0x17, 0x0B, },  // ''
    { 0x07EA, 0x16, 0x0B, },  // ''
    { 0x07EB, 0x15, 0x0B, },  // ''
    { 0x07EC, 0x14, 0x0B, },  // ''
    { 0x07ED, 0x13, 0x0B, },  // ''
    { 0x07EE, 0x12, 0x0B, },  // ''
    { 0x07EF, 0x11, 0x0B, },  // ''
    { 0x07F0, 0x10, 0x0B, },  // ''
    { 0x07F1, 0x0F, 0x0B, },  // ''
    { 0x07F2, 0x0E, 0x0B, },  // ''
    { 0x07F3, 0x0D, 0x0B, },  // ''
    { 0x07F4, 0x0C, 0x0B, },  // ''
    { 0x07F5, 0x0B, 0x0B, },  // ''
    { 0x07F6, 0x09, 0x0B, },  // ''
    { 0x07F7, 0x08, 0x0B, },  // ''
    { 0x07F8, 0x07, 0x0B, },  // ''
    { 0x07F9, 0x06, 0x0B, },  // ''
    { 0x07FA, 0x05, 0x0B, },  // ''
    { 0x07FB, 0x04, 0x0B, },  // ''
    { 0x07FC, 0x03, 0x0B, },  // ''
    { 0x07FD, 0x02, 0x0B, },  // ''
    { 0x07FE, 0x01, 0x0B, },  // ''
    { 0x07FF, 0x00, 0x0B, },  // ''
} ;

const huff2_table_vec Table255
{
    { 0x0000, 0x20, 0x02, },  // ' ' duplicate entry makes 1st lookup non zero
    { 0x0000, 0x20, 0x02, },  // ' '
    { 0x0004, 0x65, 0x04, },  // 'e'
    { 0x0005, 0x72, 0x04, },  // 'r'
    { 0x0006, 0x6E, 0x04, },  // 'n'
    { 0x0007, 0x61, 0x04, },  // 'a'
    { 0x0010, 0x74, 0x05, },  // 't'
    { 0x0011, 0x6F, 0x05, },  // 'o'
    { 0x0012, 0x73, 0x05, },  // 's'
    { 0x0013, 0x69, 0x05, },  // 'i'
    { 0x0014, 0x6C, 0x05, },  // 'l'
    { 0x0015, 0x75, 0x05, },  // 'u'
    { 0x0016, 0x63, 0x05, },  // 'c'
    { 0x0017, 0x64, 0x05, },  // 'd'
    { 0x0060, 0x70, 0x07, },  // 'p'
    { 0x0061, 0x6D, 0x07, },  // 'm'
    { 0x0062, 0x76, 0x07, },  // 'v'
    { 0x0063, 0x67, 0x07, },  // 'g'
    { 0x0064, 0x68, 0x07, },  // 'h'
    { 0x0065, 0x2E, 0x07, },  // '.'
    { 0x0066, 0x66, 0x07, },  // 'f'
    { 0x0067, 0x0A, 0x07, },  // ''
    { 0x0068, 0x53, 0x07, },  // 'S'
    { 0x0069, 0x41, 0x07, },  // 'A'
    { 0x006A, 0x45, 0x07, },  // 'E'
    { 0x006B, 0x43, 0x07, },  // 'C'
    { 0x006C, 0x27, 0x07, },  // '''
    { 0x006D, 0x7A, 0x07, },  // 'z'
    { 0x006E, 0x52, 0x07, },  // 'R'
    { 0x006F, 0x22, 0x07, },  // '"'
    { 0x00E0, 0x4C, 0x08, },  // 'L'
    { 0x00E1, 0x49, 0x08, },  // 'I'
    { 0x00E2, 0x4F, 0x08, },  // 'O'
    { 0x00E3, 0x62, 0x08, },  // 'b'
    { 0x00E4, 0x54, 0x08, },  // 'T'
    { 0x00E5, 0x4E, 0x08, },  // 'N'
    { 0x00E6, 0x55, 0x08, },  // 'U'
    { 0x00E7, 0x79, 0x08, },  // 'y'
    { 0x00E8, 0x44, 0x08, },  // 'D'
    { 0x00E9, 0x50, 0x08, },  // 'P'
    { 0x00EA, 0x71, 0x08, },  // 'q'
    { 0x00EB, 0x56, 0x08, },  // 'V'
    { 0x00EC, 0x2D, 0x08, },  // '-'
    { 0x00ED, 0x3A, 0x08, },  // ':'
    { 0x00EE, 0x2C, 0x08, },  // ','
    { 0x00EF, 0x48, 0x08, },  // 'H'
    { 0x01E0, 0x4D, 0x09, },  // 'M'
    { 0x01E1, 0x78, 0x09, },  // 'x'
    { 0x01E2, 0x77, 0x09, },  // 'w'
    { 0x01E3, 0x42, 0x09, },  // 'B'
    { 0x01E4, 0x47, 0x09, },  // 'G'
    { 0x01E5, 0x46, 0x09, },  // 'F'
    { 0x01E6, 0x30, 0x09, },  // '0'
    { 0x01E7, 0x3F, 0x09, },  // '?'
    { 0x01E8, 0x33, 0x09, },  // '3'
    { 0x01E9, 0x2F, 0x09, },  // '/'
    { 0x01EA, 0x39, 0x09, },  // '9'
    { 0x01EB, 0x31, 0x09, },  // '1'
    { 0x01EC, 0x38, 0x09, },  // '8'
    { 0x01ED, 0x6B, 0x09, },  // 'k'
    { 0x01EE, 0x6A, 0x09, },  // 'j'
    { 0x01EF, 0x21, 0x09, },  // '!'
    { 0x03E0, 0x36, 0x0A, },  // '6'
    { 0x03E1, 0x35, 0x0A, },  // '5'
    { 0x03E2, 0x59, 0x0A, },  // 'Y'
    { 0x03E3, 0x51, 0x0A, },  // 'Q'
    { 0x07C8, 0x34, 0x0B, },  // '4'
    { 0x07C9, 0x58, 0x0B, },  // 'X'
    { 0x07CA, 0x32, 0x0B, },  // '2'
    { 0x07CB, 0x2B, 0x0B, },  // '+'
    { 0x07CC, 0x2A, 0x0B, },  // '*'
    { 0x07CD, 0x5A, 0x0B, },  // 'Z'
    { 0x07CE, 0x4A, 0x0B, },  // 'J'
    { 0x07CF, 0x29, 0x0B, },  // ')'
    { 0x0FA0, 0x28, 0x0C, },  // '('
    { 0x0FA1, 0x23, 0x0C, },  // '#'
    { 0x0FA2, 0x57, 0x0C, },  // 'W'
    { 0x0FA3, 0x4B, 0x0C, },  // 'K'
    { 0x0FA4, 0x3C, 0x0C, },  // '<'
    { 0x0FA5, 0x37, 0x0C, },  // '7'
    { 0x0FA6, 0x7D, 0x0C, },  // '}'
    { 0x0FA7, 0x7B, 0x0C, },  // '{'
    { 0x0FA8, 0x60, 0x0C, },  // '`'
    { 0x0FA9, 0x26, 0x0C, },  // '&'
    { 0x1F54, 0xFE, 0x0D, },  // 'ὔ'
    { 0x1F55, 0xFD, 0x0D, },  // 'ὕ'
    { 0x1F56, 0xFC, 0x0D, },  // 'ὖ'
    { 0x1F57, 0xFB, 0x0D, },  // 'ὗ'
    { 0x1F58, 0xFA, 0x0D, },  // '὘'
    { 0x1F59, 0xF9, 0x0D, },  // 'Ὑ'
    { 0x1F5A, 0xF8, 0x0D, },  // '὚'
    { 0x1F5B, 0xF7, 0x0D, },  // 'Ὓ'
    { 0x1F5C, 0xF6, 0x0D, },  // '὜'
    { 0x1F5D, 0xF5, 0x0D, },  // 'Ὕ'
    { 0x1F5E, 0xF4, 0x0D, },  // '὞'
    { 0x1F5F, 0xF3, 0x0D, },  // 'Ὗ'
    { 0x1F60, 0xF2, 0x0D, },  // 'ὠ'
    { 0x1F61, 0xF1, 0x0D, },  // 'ὡ'
    { 0x1F62, 0xF0, 0x0D, },  // 'ὢ'
    { 0x1F63, 0xEF, 0x0D, },  // 'ὣ'
    { 0x1F64, 0xEE, 0x0D, },  // 'ὤ'
    { 0x1F65, 0xED, 0x0D, },  // 'ὥ'
    { 0x1F66, 0xEC, 0x0D, },  // 'ὦ'
    { 0x1F67, 0xEB, 0x0D, },  // 'ὧ'
    { 0x1F68, 0xEA, 0x0D, },  // 'Ὠ'
    { 0x1F69, 0xE9, 0x0D, },  // 'Ὡ'
    { 0x1F6A, 0xE8, 0x0D, },  // 'Ὢ'
    { 0x1F6B, 0xE7, 0x0D, },  // 'Ὣ'
    { 0x1F6C, 0xE6, 0x0D, },  // 'Ὤ'
    { 0x1F6D, 0xE5, 0x0D, },  // 'Ὥ'
    { 0x1F6E, 0xE4, 0x0D, },  // 'Ὦ'
    { 0x1F6F, 0xE3, 0x0D, },  // 'Ὧ'
    { 0x1F70, 0xE2, 0x0D, },  // 'ὰ'
    { 0x1F71, 0xE1, 0x0D, },  // 'ά'
    { 0x1F72, 0xE0, 0x0D, },  // 'ὲ'
    { 0x1F73, 0xDF, 0x0D, },  // 'έ'
    { 0x1F74, 0xDE, 0x0D, },  // 'ὴ'
    { 0x1F75, 0xDD, 0x0D, },  // 'ή'
    { 0x1F76, 0xDC, 0x0D, },  // 'ὶ'
    { 0x1F77, 0xDB, 0x0D, },  // 'ί'
    { 0x1F78, 0xDA, 0x0D, },  // 'ὸ'
    { 0x1F79, 0xD9, 0x0D, },  // 'ό'
    { 0x1F7A, 0xD8, 0x0D, },  // 'ὺ'
    { 0x1F7B, 0xD7, 0x0D, },  // 'ύ'
    { 0x1F7C, 0xD6, 0x0D, },  // 'ὼ'
    { 0x1F7D, 0xD5, 0x0D, },  // 'ώ'
    { 0x1F7E, 0xD4, 0x0D, },  // '὾'
    { 0x1F7F, 0xD3, 0x0D, },  // '὿'
    { 0x1F80, 0xD2, 0x0D, },  // 'ᾀ'
    { 0x1F81, 0xD1, 0x0D, },  // 'ᾁ'
    { 0x1F82, 0xD0, 0x0D, },  // 'ᾂ'
    { 0x1F83, 0xCF, 0x0D, },  // 'ᾃ'
    { 0x1F84, 0xCE, 0x0D, },  // 'ᾄ'
    { 0x1F85, 0xCD, 0x0D, },  // 'ᾅ'
    { 0x1F86, 0xCC, 0x0D, },  // 'ᾆ'
    { 0x1F87, 0xCB, 0x0D, },  // 'ᾇ'
    { 0x1F88, 0xCA, 0x0D, },  // 'ᾈ'
    { 0x1F89, 0xC9, 0x0D, },  // 'ᾉ'
    { 0x1F8A, 0xC8, 0x0D, },  // 'ᾊ'
    { 0x1F8B, 0xC7, 0x0D, },  // 'ᾋ'
    { 0x1F8C, 0xC6, 0x0D, },  // 'ᾌ'
    { 0x1F8D, 0xC5, 0x0D, },  // 'ᾍ'
    { 0x1F8E, 0xC4, 0x0D, },  // 'ᾎ'
    { 0x1F8F, 0xC3, 0x0D, },  // 'ᾏ'
    { 0x1F90, 0xC2, 0x0D, },  // 'ᾐ'
    { 0x1F91, 0xC1, 0x0D, },  // 'ᾑ'
    { 0x1F92, 0xC0, 0x0D, },  // 'ᾒ'
    { 0x1F93, 0xBF, 0x0D, },  // 'ᾓ'
    { 0x1F94, 0xBE, 0x0D, },  // 'ᾔ'
    { 0x1F95, 0xBD, 0x0D, },  // 'ᾕ'
    { 0x1F96, 0xBC, 0x0D, },  // 'ᾖ'
    { 0x1F97, 0xBB, 0x0D, },  // 'ᾗ'
    { 0x1F98, 0xBA, 0x0D, },  // 'ᾘ'
    { 0x1F99, 0xB9, 0x0D, },  // 'ᾙ'
    { 0x1F9A, 0xB8, 0x0D, },  // 'ᾚ'
    { 0x1F9B, 0xB7, 0x0D, },  // 'ᾛ'
    { 0x1F9C, 0xB6, 0x0D, },  // 'ᾜ'
    { 0x1F9D, 0xB5, 0x0D, },  // 'ᾝ'
    { 0x1F9E, 0xB4, 0x0D, },  // 'ᾞ'
    { 0x1F9F, 0xB3, 0x0D, },  // 'ᾟ'
    { 0x1FA0, 0xB2, 0x0D, },  // 'ᾠ'
    { 0x1FA1, 0xB1, 0x0D, },  // 'ᾡ'
    { 0x1FA2, 0xB0, 0x0D, },  // 'ᾢ'
    { 0x1FA3, 0xAF, 0x0D, },  // 'ᾣ'
    { 0x1FA4, 0xAE, 0x0D, },  // 'ᾤ'
    { 0x1FA5, 0xAD, 0x0D, },  // 'ᾥ'
    { 0x1FA6, 0xAC, 0x0D, },  // 'ᾦ'
    { 0x1FA7, 0xAB, 0x0D, },  // 'ᾧ'
    { 0x1FA8, 0xAA, 0x0D, },  // 'ᾨ'
    { 0x1FA9, 0xA9, 0x0D, },  // 'ᾩ'
    { 0x1FAA, 0xA8, 0x0D, },  // 'ᾪ'
    { 0x1FAB, 0xA7, 0x0D, },  // 'ᾫ'
    { 0x1FAC, 0xA6, 0x0D, },  // 'ᾬ'
    { 0x1FAD, 0xA5, 0x0D, },  // 'ᾭ'
    { 0x1FAE, 0xA4, 0x0D, },  // 'ᾮ'
    { 0x1FAF, 0xA3, 0x0D, },  // 'ᾯ'
    { 0x1FB0, 0xA2, 0x0D, },  // 'ᾰ'
    { 0x1FB1, 0xA1, 0x0D, },  // 'ᾱ'
    { 0x1FB2, 0xA0, 0x0D, },  // 'ᾲ'
    { 0x1FB3, 0x9F, 0x0D, },  // 'ᾳ'
    { 0x1FB4, 0x9E, 0x0D, },  // 'ᾴ'
    { 0x1FB5, 0x9D, 0x0D, },  // '᾵'
    { 0x1FB6, 0x9C, 0x0D, },  // 'ᾶ'
    { 0x1FB7, 0x9B, 0x0D, },  // 'ᾷ'
    { 0x1FB8, 0x9A, 0x0D, },  // 'Ᾰ'
    { 0x1FB9, 0x99, 0x0D, },  // 'Ᾱ'
    { 0x1FBA, 0x98, 0x0D, },  // 'Ὰ'
    { 0x1FBB, 0x97, 0x0D, },  // 'Ά'
    { 0x1FBC, 0x96, 0x0D, },  // 'ᾼ'
    { 0x1FBD, 0x95, 0x0D, },  // '᾽'
    { 0x1FBE, 0x94, 0x0D, },  // 'ι'
    { 0x1FBF, 0x93, 0x0D, },  // '᾿'
    { 0x1FC0, 0x92, 0x0D, },  // '῀'
    { 0x1FC1, 0x91, 0x0D, },  // '῁'
    { 0x1FC2, 0x90, 0x0D, },  // 'ῂ'
    { 0x1FC3, 0x8F, 0x0D, },  // 'ῃ'
    { 0x1FC4, 0x8E, 0x0D, },  // 'ῄ'
    { 0x1FC5, 0x8D, 0x0D, },  // '῅'
    { 0x1FC6, 0x8C, 0x0D, },  // 'ῆ'
    { 0x1FC7, 0x8B, 0x0D, },  // 'ῇ'
    { 0x1FC8, 0x8A, 0x0D, },  // 'Ὲ'
    { 0x1FC9, 0x89, 0x0D, },  // 'Έ'
    { 0x1FCA, 0x88, 0x0D, },  // 'Ὴ'
    { 0x1FCB, 0x87, 0x0D, },  // 'Ή'
    { 0x1FCC, 0x86, 0x0D, },  // 'ῌ'
    { 0x1FCD, 0x85, 0x0D, },  // '῍'
    { 0x1FCE, 0x84, 0x0D, },  // '῎'
    { 0x1FCF, 0x83, 0x0D, },  // '῏'
    { 0x1FD0, 0x82, 0x0D, },  // 'ῐ'
    { 0x1FD1, 0x81, 0x0D, },  // 'ῑ'
    { 0x1FD2, 0x80, 0x0D, },  // 'ῒ'
    { 0x1FD3, 0x7F, 0x0D, },  // 'ΐ'
    { 0x1FD4, 0x7E, 0x0D, },  // '῔'
    { 0x1FD5, 0x7C, 0x0D, },  // '῕'
    { 0x1FD6, 0x5F, 0x0D, },  // 'ῖ'
    { 0x1FD7, 0x5E, 0x0D, },  // 'ῗ'
    { 0x1FD8, 0x5D, 0x0D, },  // 'Ῐ'
    { 0x1FD9, 0x5C, 0x0D, },  // 'Ῑ'
    { 0x1FDA, 0x5B, 0x0D, },  // 'Ὶ'
    { 0x1FDB, 0x40, 0x0D, },  // 'Ί'
    { 0x1FDC, 0x3E, 0x0D, },  // '῜'
    { 0x1FDD, 0x3D, 0x0D, },  // '῝'
    { 0x1FDE, 0x3B, 0x0D, },  // '῞'
    { 0x1FDF, 0x25, 0x0D, },  // '῟'
    { 0x1FE0, 0x24, 0x0D, },  // 'ῠ'
    { 0x1FE1, 0x1F, 0x0D, },  // 'ῡ'
    { 0x1FE2, 0x1E, 0x0D, },  // 'ῢ'
    { 0x1FE3, 0x1D, 0x0D, },  // 'ΰ'
    { 0x1FE4, 0x1C, 0x0D, },  // 'ῤ'
    { 0x1FE5, 0x1B, 0x0D, },  // 'ῥ'
    { 0x1FE6, 0x1A, 0x0D, },  // 'ῦ'
    { 0x1FE7, 0x19, 0x0D, },  // 'ῧ'
    { 0x1FE8, 0x18, 0x0D, },  // 'Ῠ'
    { 0x1FE9, 0x17, 0x0D, },  // 'Ῡ'
    { 0x1FEA, 0x16, 0x0D, },  // 'Ὺ'
    { 0x1FEB, 0x15, 0x0D, },  // 'Ύ'
    { 0x1FEC, 0x14, 0x0D, },  // 'Ῥ'
    { 0x1FED, 0x13, 0x0D, },  // '῭'
    { 0x1FEE, 0x12, 0x0D, },  // '΅'
    { 0x1FEF, 0x11, 0x0D, },  // '`'
    { 0x1FF0, 0x10, 0x0D, },  // '῰'
    { 0x1FF1, 0x0F, 0x0D, },  // '῱'
    { 0x1FF2, 0x0E, 0x0D, },  // 'ῲ'
    { 0x1FF3, 0x0D, 0x0D, },  // 'ῳ'
    { 0x1FF4, 0x0C, 0x0D, },  // 'ῴ'
    { 0x1FF5, 0x0B, 0x0D, },  // '῵'
    { 0x1FF6, 0x09, 0x0D, },  // 'ῶ'
    { 0x1FF7, 0x08, 0x0D, },  // 'ῷ'
    { 0x1FF8, 0x07, 0x0D, },  // 'Ὸ'
    { 0x1FF9, 0x06, 0x0D, },  // 'Ό'
    { 0x1FFA, 0x05, 0x0D, },  // 'Ὼ'
    { 0x1FFB, 0x04, 0x0D, },  // 'Ώ'
    { 0x1FFC, 0x03, 0x0D, },  // 'ῼ'
    { 0x1FFD, 0x02, 0x0D, },  // '´'
    { 0x1FFE, 0x01, 0x0D, },  // '῾'
    { 0x1FFF, 0x00, 0x0D, },  // '῿'
};

const huff2_lookup_vec Huff2Lookup128
{
    0x01, 0x00, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
    0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
    0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4f, 0x50,
    0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58,
    0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60,
    0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,
    0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f, 0x70,
    0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78,
    0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, 0x80,
};

const huff2_lookup_vec Huff2Lookup256
{
    0x01, 0x00, 0x00, 0x00, 0x02, 0x03, 0x04, 0x05,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15,
    0x16, 0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x1e, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25,
    0x26, 0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35,
    0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x3e, 0x3f, 0x40, 0x41, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51,
    0x52, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
    0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
    0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
    0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f,
    0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
    0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
    0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
    0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
    0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
    0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
    0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
    0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
    0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
    0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
    0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
    0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
    0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
    0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
    0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
    0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
};

struct huff2_parts {
    const huff2_table_vec  table;
    const huff2_lookup_vec lookup;
    uint                   min_size; // cppcheck-suppress unusedStructMember
    uint                   max_size; // cppcheck-suppress unusedStructMember
};

const std::array<const huff2_parts,2> huff2_tables
{{
        {Table128, Huff2Lookup128, 3, 12},
        {Table255, Huff2Lookup256, 2, 14}
}};


/* returns the root for character input from table Table[] */
static inline int huffman1_get_root(size_t input, const atsc_table_vec &table)
{
    if (input > 127)
        return -1;
    return (table[input * 2] << 8) | table[(input * 2) + 1];
}

/* Returns the bit number bit from string test[] */
static inline bool huffman1_get_bit(const unsigned char *src, uint bit)
{
    return ((src[(bit - (bit & 0x7)) >> 3] >> (7 - (bit & 0x7))) & 0x01) != 0;
}

QString atsc_huffman1_to_string(const unsigned char *compressed,
                                uint size, uint table_index)
{
    QString retval = "";

    if (table_index < 1 || table_index > 2)
        return {""};
    table_index -= 1;

    const atsc_table_vec &table = atsc_tables[table_index];
    int totalbits = size * 8;
    int bit = 0;
    int root = huffman1_get_root(0, table);
    int node = 0;

    while (bit < totalbits)
    {
        bool thebit = huffman1_get_bit(compressed, bit);
        unsigned char val = (thebit) ? table[root + (node*2) + 1] : table[root + (node*2)];

        if (val & 0x80)
        {
            /* Got a Null Character so return */
            if ((val & 0x7F) == 0)
            {
                return retval;
            }
            /* Escape character so next character is uncompressed */
            if ((val & 0x7F) == 27)
            {
                unsigned char val2 = 0;
                for (int i = 0 ; i < 7 ; i++)
                {
                    val2 |=
                        static_cast<int>(huffman1_get_bit(compressed, bit + i + 2)) << (6 - i);
                }
                retval += QChar(val2);
                bit += 8;
                root = huffman1_get_root(val2, table);
            }
            /* Standard Character */
            else
            {
                root = huffman1_get_root(val & 0x7F, table);
                retval += QChar(val & 0x7F);
            }
            node = 0;
        }
        else
        {
            node = val;
        }
        bit++;
    }
    /* If you get here something went wrong so just return a blank string */
    return {""};
}

static inline int huffman2_get_bit(unsigned char &bitpos,
                                   const unsigned char **bufptr)
{
   int ret = static_cast<int>((**bufptr & bitpos) != 0);
   bitpos >>= 1;
   if (!bitpos)
   {
       bitpos = 0x80;
       (*bufptr)++;
   }
   return ret;
}

static inline void huffman2_set_pos(unsigned char &bitpos,
                                    const unsigned char **bufptr,
                                    const unsigned char *buffer,
                                    uint pos)
{
    *bufptr = buffer + (pos >> 3);
    bitpos  = 0x80 >> (pos & 0x7);
}

QString atsc_huffman2_to_string(const unsigned char *compressed,
                                uint length, uint table)
{
    QString decompressed = "";

    if (table < 1 || table > 2)
        return "";
    table -= 1;

    unsigned char        bitpos = 0;
    const unsigned char *bufptr = nullptr;
    huffman2_set_pos(bitpos, &bufptr, compressed, 0);

    // Determine which huffman table to use
    const auto & [ptrTable, lookup, min_size, max_size] = huff2_tables[table];

    // walk thru all the bits in the byte array, finding each sequence in the
    // list and decoding it to a character.
    uint total_bits  = length << 3;
    uint current_bit = 0;

    while (current_bit + 3 < total_bits)
    {
        uint cur_size = 0;
        uint bits     = 0;

        for (; cur_size < min_size; cur_size++)
            bits = (bits << 1) | huffman2_get_bit(bitpos, &bufptr);

        while (cur_size < max_size)
        {
            uint key = lookup[bits];
            if (key && (ptrTable[key].m_numberOfBits == cur_size))
            {
                decompressed += QChar(ptrTable[key].m_character);
                current_bit += cur_size;
                break;
            }
            bits = (bits << 1) | huffman2_get_bit(bitpos, &bufptr);
            cur_size++;
        }

        if (cur_size == max_size)
            huffman2_set_pos(bitpos, &bufptr, compressed, ++current_bit);
    }

    return decompressed;
}
