; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -loop-idiom < %s -S | FileCheck %s

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64"

; This only tests various forms of loop control-flow.
; These tests are fully identical to bcmp()==0 otherwise.

; #include <algorithm>
;
; bool pointer_iteration_const_size_no_overlap(char const* ptr) {
;   return std::equal(ptr, ptr + 8, ptr + 8);
; }
; bool pointer_iteration_const_size_partial_overlap(char const* ptr) {
;   return std::equal(ptr, ptr + 16, ptr + 8);
; }
; bool pointer_iteration_const_size_overlap_unknown(char const* ptr0, char const* ptr1) {
;   return std::equal(ptr0, ptr0 + 8, ptr1);
; }
;
; bool pointer_iteration_variable_size_no_overlap(char const* ptr, size_t count) {
;   return std::equal(ptr, ptr + count, ptr + count);
; }
; bool pointer_iteration_variable_size_partial_overlap(char const* ptr, size_t count) {
;   return std::equal(ptr, ptr + 2 * count, ptr + count);
; }
; bool pointer_iteration_variable_size_overlap_unknown(char const* ptr0, char const* ptr1, size_t count) {
;   return std::equal(ptr0, ptr0 + count, ptr1);
; }
;
; bool index_iteration_eq_const_size_no_overlap(char const* ptr) {
;   char const* ptr0 = ptr;
;   char const* ptr1 = ptr + 8;
;   for(size_t i = 0; i < 8; i++) {
;     if(ptr0[i] != ptr1[i])
;       return false;
;   }
;   return true;
; }
; bool index_iteration_eq_const_size_partial_overlap(char const* ptr) {
;   char const* ptr0 = ptr;
;   char const* ptr1 = ptr + 8;
;   for(size_t i = 0; i < 16; i++) {
;     if(ptr0[i] != ptr1[i])
;       return false;
;   }
;   return true;
; }
; bool index_iteration_eq_const_size_overlap_unknown(char const* ptr0, char const* ptr1) {
;   for(size_t i = 0; i < 8; i++) {
;     if(ptr0[i] != ptr1[i])
;       return false;
;   }
;   return true;
; }
;
; bool index_iteration_eq_variable_size_no_overlap(char const* ptr, size_t count) {
;   char const* ptr0 = ptr;
;   char const* ptr1 = ptr + count;
;   for(size_t i = 0; i < count; i++) {
;     if(ptr0[i] != ptr1[i])
;       return false;
;   }
;   return true;
; }
; bool index_iteration_eq_variable_size_partial_overlap(char const* ptr, size_t count) {
;   char const* ptr0 = ptr;
;   char const* ptr1 = ptr + count;
;   for(size_t i = 0; i < 2 * count; i++) {
;     if(ptr0[i] != ptr1[i])
;       return false;
;   }
;   return true;
; }
; bool index_iteration_eq_variable_size_overlap_unknown(char const* ptr0, char const* ptr1, size_t count) {
;   for(size_t i = 0; i < count; i++) {
;     if(ptr0[i] != ptr1[i])
;       return false;
;   }
;   return true;
; }
;
; bool index_iteration_starting_from_negative(char const* ptr0, char const* ptr1) {
;   for(int i = -4; i < 4; i++) {
;     if(ptr0[i] != ptr1[i])
;       return false;
;   }
;   return true;
; }
;
; bool combined_iteration_eq_const_size_no_overlap(char const* ptr) {
;   char const* ptr0 = ptr;
;   char const* ptr1 = ptr + 8;
;   for(size_t i = 0; i < 8; i++, ++ptr0, ++ptr1) {
;     if(*ptr0 != *ptr1)
;       return false;
;   }
;   return true;
; }
; bool combined_iteration_eq_const_size_partial_overlap(char const* ptr) {
;   char const* ptr0 = ptr;
;   char const* ptr1 = ptr + 8;
;   for(size_t i = 0; i < 16; i++, ++ptr0, ++ptr1) {
;     if(*ptr0 != *ptr1)
;       return false;
;   }
;   return true;
; }
; bool combined_iteration_eq_const_size_overlap_unknown(char const* ptr0, char const* ptr1) {
;   for(size_t i = 0; i < 8; i++, ++ptr0, ++ptr1) {
;     if(*ptr0 != *ptr1)
;       return false;
;   }
;   return true;
; }
;
; bool combined_iteration_eq_variable_size_no_overlap(char const* ptr, size_t count) {
;   char const* ptr0 = ptr;
;   char const* ptr1 = ptr + count;
;   for(size_t i = 0; i < count; i++, ++ptr0, ++ptr1) {
;     if(*ptr0 != *ptr1)
;       return false;
;   }
;   return true;
; }
; bool combined_iteration_eq_variable_size_partial_overlap(char const* ptr, size_t count) {
;   char const* ptr0 = ptr;
;   char const* ptr1 = ptr + count;
;   for(size_t i = 0; i < 2 * count; i++, ++ptr0, ++ptr1) {
;     if(*ptr0 != *ptr1)
;       return false;
;   }
;   return true;
; }
; bool combined_iteration_eq_variable_size_overlap_unknown(char const* ptr0, char const* ptr1, size_t count) {
;   for(size_t i = 0; i < count; i++, ++ptr0, ++ptr1) {
;     if(*ptr0 != *ptr1)
;       return false;
;   }
;   return true;
; }
;
; bool negated_pointer_iteration_variable_size_overlap_unknown(char const* ptr0, char const* ptr1, size_t count) {
;   return !std::equal(ptr0, ptr0 + count, ptr1);
; }
;
; bool integer_pointer_iteration_variable_size_overlap_unknown(int const* ptr0, int const* ptr1, size_t count) {
;   return std::equal(ptr0, ptr0 + count, ptr1);
; }
;
; bool small_index_iteration(char const* ptr0, char const* ptr1, int count) {
;   for(int i = 0; i < count; i++, ++ptr0, ++ptr1) {
;     if(*ptr0 != *ptr1)
;       return false;
;   }
;   return true;
; }
;
; bool three_pointer_iteration(char const* ptr0, char const* ptr0_end, char const* ptr1) {
;   return std::equal(ptr0, ptr0_end, ptr1);
; }
;
; int value_propagation(char const* ptr0, char const* ptr1, size_t count, int on_equal, int on_unequal) {
;   if(std::equal(ptr0, ptr0 + count, ptr1))
;     return on_equal;
;   return on_unequal;
; }
;
; void callee_on_unequal();
; void callee_on_success();
; void multiple_exit_blocks(char const* ptr0, char const* ptr1, size_t count) {
;   if(!std::equal(ptr0, ptr0 + count, ptr1)) {
;     callee_on_unequal();
;     return;
;   }
;   callee_on_success();
; }
;
; void multiple_phis(char const* ptr0, char const* ptr1, size_t count, char const* v0, char const* v1, char const* v2, char const* v3, char const** out0, char const** out1) {
;   char const *o0, *o1;
;   if(std::equal(ptr0, ptr0 + count, ptr1)) {
;     o0 = v0;
;     o1 = v1;
;   } else {
;     o0 = v2;
;     o1 = v3;
;   }
;   *out0 = o0;
;   *out1 = o1;
; }
;
; void sink(bool);
; void loop_within_loop(size_t outer_count, char const** ptr0, char const** ptr1, size_t* count) {
;   for(size_t i = 0; i != outer_count; ++i)
;     sink(std::equal(ptr0[i], ptr0[i] + count[i], ptr1[i]));
; }
;
; void loop_within_loop_with_multiple_exit_blocks(size_t outer_count, char const** ptr0, char const** ptr1, size_t* count) {
;   for(size_t i = 0; i != outer_count; ++i) {
;     if(!std::equal(ptr0[i], ptr0[i] + count[i], ptr1[i])) {
;       callee_on_unequal();
;       return;
;     }
;     callee_on_success();
;   }
; }
;
; void endless_loop_if_equal(int *a, int *b) {
;   for (;;) {
;     for (int c = 0; c < 4; c++) {
;       if (a[c] != b[c])
;         return;
;     }
;   }
; }
;
; bool load_of_bitcasts(char const* ptr0, float const* ptr1, size_t count) {
;   for(size_t i = 0; i < count; i++, ptr0 += sizeof(float), ptr1++) {
;     int v0, v1;
;     memcpy(&v0, ptr0, sizeof(float));
;     memcpy(&v1, ptr1, sizeof(float));
;     if(v0 != v1)
;       return false;
;   }
;   return true;
; }
;
; // FIXME
; bool overlapping_loads(char const* ptr0, char const* ptr1, size_t count) {
;   for(size_t i = 0; i < count; i++, ptr0++, ptr1++) {
;     int v0, v1;
;     memcpy(&v0, ptr0, sizeof(float));
;     memcpy(&v1, ptr1, sizeof(float));
;     if(v0 != v1)
;       return false;
;   }
;   return true;
; }

define i1 @_Z39pointer_iteration_const_size_no_overlapPKc(i8* %ptr) {
; CHECK-LABEL: @_Z39pointer_iteration_const_size_no_overlapPKc(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, i8* [[PTR:%.*]], i64 8
; CHECK-NEXT:    br label [[FOR_BODY_I_I:%.*]]
; CHECK:       for.body.i.i:
; CHECK-NEXT:    [[__FIRST2_ADDR_07_I_I:%.*]] = phi i8* [ [[INCDEC_PTR1_I_I:%.*]], [[FOR_INC_I_I:%.*]] ], [ [[ADD_PTR]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I_IDX:%.*]] = phi i64 [ [[__FIRST1_ADDR_06_I_I_ADD:%.*]], [[FOR_INC_I_I]] ], [ 0, [[ENTRY]] ]
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I_PTR:%.*]] = getelementptr inbounds i8, i8* [[PTR]], i64 [[__FIRST1_ADDR_06_I_I_IDX]]
; CHECK-NEXT:    [[V0:%.*]] = load i8, i8* [[__FIRST1_ADDR_06_I_I_PTR]]
; CHECK-NEXT:    [[V1:%.*]] = load i8, i8* [[__FIRST2_ADDR_07_I_I]]
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp eq i8 [[V0]], [[V1]]
; CHECK-NEXT:    br i1 [[CMP_I_I_I]], label [[FOR_INC_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT:%.*]]
; CHECK:       for.inc.i.i:
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I_ADD]] = add nuw nsw i64 [[__FIRST1_ADDR_06_I_I_IDX]], 1
; CHECK-NEXT:    [[INCDEC_PTR1_I_I]] = getelementptr inbounds i8, i8* [[__FIRST2_ADDR_07_I_I]], i64 1
; CHECK-NEXT:    [[CMP_I_I:%.*]] = icmp eq i64 [[__FIRST1_ADDR_06_I_I_ADD]], 8
; CHECK-NEXT:    br i1 [[CMP_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT]], label [[FOR_BODY_I_I]]
; CHECK:       _ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:
; CHECK-NEXT:    [[RETVAL_0_I_I:%.*]] = phi i1 [ false, [[FOR_BODY_I_I]] ], [ true, [[FOR_INC_I_I]] ]
; CHECK-NEXT:    ret i1 [[RETVAL_0_I_I]]
;
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  br label %for.body.i.i

for.body.i.i:                                     ; preds = %for.inc.i.i, %entry
  %__first2.addr.07.i.i = phi i8* [ %incdec.ptr1.i.i, %for.inc.i.i ], [ %add.ptr, %entry ]
  %__first1.addr.06.i.i.idx = phi i64 [ %__first1.addr.06.i.i.add, %for.inc.i.i ], [ 0, %entry ]
  %__first1.addr.06.i.i.ptr = getelementptr inbounds i8, i8* %ptr, i64 %__first1.addr.06.i.i.idx
  %v0 = load i8, i8* %__first1.addr.06.i.i.ptr
  %v1 = load i8, i8* %__first2.addr.07.i.i
  %cmp.i.i.i = icmp eq i8 %v0, %v1
  br i1 %cmp.i.i.i, label %for.inc.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit

for.inc.i.i:                                      ; preds = %for.body.i.i
  %__first1.addr.06.i.i.add = add nuw nsw i64 %__first1.addr.06.i.i.idx, 1
  %incdec.ptr1.i.i = getelementptr inbounds i8, i8* %__first2.addr.07.i.i, i64 1
  %cmp.i.i = icmp eq i64 %__first1.addr.06.i.i.add, 8
  br i1 %cmp.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, label %for.body.i.i

_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:           ; preds = %for.body.i.i, %for.inc.i.i
  %retval.0.i.i = phi i1 [ false, %for.body.i.i ], [ true, %for.inc.i.i ]
  ret i1 %retval.0.i.i
}

define i1 @_Z44pointer_iteration_const_size_partial_overlapPKc(i8* %ptr) {
; CHECK-LABEL: @_Z44pointer_iteration_const_size_partial_overlapPKc(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR1:%.*]] = getelementptr inbounds i8, i8* [[PTR:%.*]], i64 8
; CHECK-NEXT:    br label [[FOR_BODY_I_I:%.*]]
; CHECK:       for.body.i.i:
; CHECK-NEXT:    [[__FIRST2_ADDR_07_I_I:%.*]] = phi i8* [ [[INCDEC_PTR1_I_I:%.*]], [[FOR_INC_I_I:%.*]] ], [ [[ADD_PTR1]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I_IDX:%.*]] = phi i64 [ [[__FIRST1_ADDR_06_I_I_ADD:%.*]], [[FOR_INC_I_I]] ], [ 0, [[ENTRY]] ]
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I_PTR:%.*]] = getelementptr inbounds i8, i8* [[PTR]], i64 [[__FIRST1_ADDR_06_I_I_IDX]]
; CHECK-NEXT:    [[V0:%.*]] = load i8, i8* [[__FIRST1_ADDR_06_I_I_PTR]]
; CHECK-NEXT:    [[V1:%.*]] = load i8, i8* [[__FIRST2_ADDR_07_I_I]]
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp eq i8 [[V0]], [[V1]]
; CHECK-NEXT:    br i1 [[CMP_I_I_I]], label [[FOR_INC_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT:%.*]]
; CHECK:       for.inc.i.i:
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I_ADD]] = add nuw nsw i64 [[__FIRST1_ADDR_06_I_I_IDX]], 1
; CHECK-NEXT:    [[INCDEC_PTR1_I_I]] = getelementptr inbounds i8, i8* [[__FIRST2_ADDR_07_I_I]], i64 1
; CHECK-NEXT:    [[CMP_I_I:%.*]] = icmp eq i64 [[__FIRST1_ADDR_06_I_I_ADD]], 16
; CHECK-NEXT:    br i1 [[CMP_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT]], label [[FOR_BODY_I_I]]
; CHECK:       _ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:
; CHECK-NEXT:    [[RETVAL_0_I_I:%.*]] = phi i1 [ false, [[FOR_BODY_I_I]] ], [ true, [[FOR_INC_I_I]] ]
; CHECK-NEXT:    ret i1 [[RETVAL_0_I_I]]
;
entry:
  %add.ptr1 = getelementptr inbounds i8, i8* %ptr, i64 8
  br label %for.body.i.i

for.body.i.i:                                     ; preds = %for.inc.i.i, %entry
  %__first2.addr.07.i.i = phi i8* [ %incdec.ptr1.i.i, %for.inc.i.i ], [ %add.ptr1, %entry ]
  %__first1.addr.06.i.i.idx = phi i64 [ %__first1.addr.06.i.i.add, %for.inc.i.i ], [ 0, %entry ]
  %__first1.addr.06.i.i.ptr = getelementptr inbounds i8, i8* %ptr, i64 %__first1.addr.06.i.i.idx
  %v0 = load i8, i8* %__first1.addr.06.i.i.ptr
  %v1 = load i8, i8* %__first2.addr.07.i.i
  %cmp.i.i.i = icmp eq i8 %v0, %v1
  br i1 %cmp.i.i.i, label %for.inc.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit

for.inc.i.i:                                      ; preds = %for.body.i.i
  %__first1.addr.06.i.i.add = add nuw nsw i64 %__first1.addr.06.i.i.idx, 1
  %incdec.ptr1.i.i = getelementptr inbounds i8, i8* %__first2.addr.07.i.i, i64 1
  %cmp.i.i = icmp eq i64 %__first1.addr.06.i.i.add, 16
  br i1 %cmp.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, label %for.body.i.i

_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:           ; preds = %for.body.i.i, %for.inc.i.i
  %retval.0.i.i = phi i1 [ false, %for.body.i.i ], [ true, %for.inc.i.i ]
  ret i1 %retval.0.i.i
}

define i1 @_Z44pointer_iteration_const_size_overlap_unknownPKcS0_(i8* %ptr0, i8* %ptr1) {
; CHECK-LABEL: @_Z44pointer_iteration_const_size_overlap_unknownPKcS0_(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY_I_I:%.*]]
; CHECK:       for.body.i.i:
; CHECK-NEXT:    [[__FIRST2_ADDR_07_I_I:%.*]] = phi i8* [ [[INCDEC_PTR1_I_I:%.*]], [[FOR_INC_I_I:%.*]] ], [ [[PTR1:%.*]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I_IDX:%.*]] = phi i64 [ [[__FIRST1_ADDR_06_I_I_ADD:%.*]], [[FOR_INC_I_I]] ], [ 0, [[ENTRY]] ]
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I_PTR:%.*]] = getelementptr inbounds i8, i8* [[PTR0:%.*]], i64 [[__FIRST1_ADDR_06_I_I_IDX]]
; CHECK-NEXT:    [[V0:%.*]] = load i8, i8* [[__FIRST1_ADDR_06_I_I_PTR]]
; CHECK-NEXT:    [[V1:%.*]] = load i8, i8* [[__FIRST2_ADDR_07_I_I]]
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp eq i8 [[V0]], [[V1]]
; CHECK-NEXT:    br i1 [[CMP_I_I_I]], label [[FOR_INC_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT:%.*]]
; CHECK:       for.inc.i.i:
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I_ADD]] = add nuw nsw i64 [[__FIRST1_ADDR_06_I_I_IDX]], 1
; CHECK-NEXT:    [[INCDEC_PTR1_I_I]] = getelementptr inbounds i8, i8* [[__FIRST2_ADDR_07_I_I]], i64 1
; CHECK-NEXT:    [[CMP_I_I:%.*]] = icmp eq i64 [[__FIRST1_ADDR_06_I_I_ADD]], 8
; CHECK-NEXT:    br i1 [[CMP_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT]], label [[FOR_BODY_I_I]]
; CHECK:       _ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:
; CHECK-NEXT:    [[RETVAL_0_I_I:%.*]] = phi i1 [ false, [[FOR_BODY_I_I]] ], [ true, [[FOR_INC_I_I]] ]
; CHECK-NEXT:    ret i1 [[RETVAL_0_I_I]]
;
entry:
  br label %for.body.i.i

for.body.i.i:                                     ; preds = %for.inc.i.i, %entry
  %__first2.addr.07.i.i = phi i8* [ %incdec.ptr1.i.i, %for.inc.i.i ], [ %ptr1, %entry ]
  %__first1.addr.06.i.i.idx = phi i64 [ %__first1.addr.06.i.i.add, %for.inc.i.i ], [ 0, %entry ]
  %__first1.addr.06.i.i.ptr = getelementptr inbounds i8, i8* %ptr0, i64 %__first1.addr.06.i.i.idx
  %v0 = load i8, i8* %__first1.addr.06.i.i.ptr
  %v1 = load i8, i8* %__first2.addr.07.i.i
  %cmp.i.i.i = icmp eq i8 %v0, %v1
  br i1 %cmp.i.i.i, label %for.inc.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit

for.inc.i.i:                                      ; preds = %for.body.i.i
  %__first1.addr.06.i.i.add = add nuw nsw i64 %__first1.addr.06.i.i.idx, 1
  %incdec.ptr1.i.i = getelementptr inbounds i8, i8* %__first2.addr.07.i.i, i64 1
  %cmp.i.i = icmp eq i64 %__first1.addr.06.i.i.add, 8
  br i1 %cmp.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, label %for.body.i.i

_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:           ; preds = %for.body.i.i, %for.inc.i.i
  %retval.0.i.i = phi i1 [ false, %for.body.i.i ], [ true, %for.inc.i.i ]
  ret i1 %retval.0.i.i
}

define i1 @_Z42pointer_iteration_variable_size_no_overlapPKcm(i8* %ptr, i64 %count) {
; CHECK-LABEL: @_Z42pointer_iteration_variable_size_no_overlapPKcm(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, i8* [[PTR:%.*]], i64 [[COUNT:%.*]]
; CHECK-NEXT:    [[CMP5_I_I:%.*]] = icmp eq i64 [[COUNT]], 0
; CHECK-NEXT:    br i1 [[CMP5_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT:%.*]], label [[FOR_BODY_I_I_PREHEADER:%.*]]
; CHECK:       for.body.i.i.preheader:
; CHECK-NEXT:    br label [[FOR_BODY_I_I:%.*]]
; CHECK:       for.body.i.i:
; CHECK-NEXT:    [[__FIRST2_ADDR_07_I_I:%.*]] = phi i8* [ [[INCDEC_PTR1_I_I:%.*]], [[FOR_INC_I_I:%.*]] ], [ [[ADD_PTR]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I:%.*]] = phi i8* [ [[INCDEC_PTR_I_I:%.*]], [[FOR_INC_I_I]] ], [ [[PTR]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[V0:%.*]] = load i8, i8* [[__FIRST1_ADDR_06_I_I]]
; CHECK-NEXT:    [[V1:%.*]] = load i8, i8* [[__FIRST2_ADDR_07_I_I]]
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp eq i8 [[V0]], [[V1]]
; CHECK-NEXT:    br i1 [[CMP_I_I_I]], label [[FOR_INC_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT:%.*]]
; CHECK:       for.inc.i.i:
; CHECK-NEXT:    [[INCDEC_PTR_I_I]] = getelementptr inbounds i8, i8* [[__FIRST1_ADDR_06_I_I]], i64 1
; CHECK-NEXT:    [[INCDEC_PTR1_I_I]] = getelementptr inbounds i8, i8* [[__FIRST2_ADDR_07_I_I]], i64 1
; CHECK-NEXT:    [[CMP_I_I:%.*]] = icmp eq i8* [[INCDEC_PTR_I_I]], [[ADD_PTR]]
; CHECK-NEXT:    br i1 [[CMP_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT]], label [[FOR_BODY_I_I]]
; CHECK:       _ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit.loopexit:
; CHECK-NEXT:    [[RETVAL_0_I_I_PH:%.*]] = phi i1 [ false, [[FOR_BODY_I_I]] ], [ true, [[FOR_INC_I_I]] ]
; CHECK-NEXT:    br label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT]]
; CHECK:       _ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:
; CHECK-NEXT:    [[RETVAL_0_I_I:%.*]] = phi i1 [ true, [[ENTRY:%.*]] ], [ [[RETVAL_0_I_I_PH]], [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT]] ]
; CHECK-NEXT:    ret i1 [[RETVAL_0_I_I]]
;
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %count
  %cmp5.i.i = icmp eq i64 %count, 0
  br i1 %cmp5.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, label %for.body.i.i

for.body.i.i:                                     ; preds = %entry, %for.inc.i.i
  %__first2.addr.07.i.i = phi i8* [ %incdec.ptr1.i.i, %for.inc.i.i ], [ %add.ptr, %entry ]
  %__first1.addr.06.i.i = phi i8* [ %incdec.ptr.i.i, %for.inc.i.i ], [ %ptr, %entry ]
  %v0 = load i8, i8* %__first1.addr.06.i.i
  %v1 = load i8, i8* %__first2.addr.07.i.i
  %cmp.i.i.i = icmp eq i8 %v0, %v1
  br i1 %cmp.i.i.i, label %for.inc.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit

for.inc.i.i:                                      ; preds = %for.body.i.i
  %incdec.ptr.i.i = getelementptr inbounds i8, i8* %__first1.addr.06.i.i, i64 1
  %incdec.ptr1.i.i = getelementptr inbounds i8, i8* %__first2.addr.07.i.i, i64 1
  %cmp.i.i = icmp eq i8* %incdec.ptr.i.i, %add.ptr
  br i1 %cmp.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, label %for.body.i.i

_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:           ; preds = %for.body.i.i, %for.inc.i.i, %entry
  %retval.0.i.i = phi i1 [ true, %entry ], [ true, %for.inc.i.i ], [ false, %for.body.i.i ]
  ret i1 %retval.0.i.i
}

define i1 @_Z47pointer_iteration_variable_size_partial_overlapPKcm(i8* %ptr, i64 %count) {
; CHECK-LABEL: @_Z47pointer_iteration_variable_size_partial_overlapPKcm(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[MUL:%.*]] = shl i64 [[COUNT:%.*]], 1
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, i8* [[PTR:%.*]], i64 [[MUL]]
; CHECK-NEXT:    [[CMP5_I_I:%.*]] = icmp eq i64 [[MUL]], 0
; CHECK-NEXT:    br i1 [[CMP5_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT:%.*]], label [[FOR_BODY_I_I_PREHEADER:%.*]]
; CHECK:       for.body.i.i.preheader:
; CHECK-NEXT:    [[ADD_PTR1:%.*]] = getelementptr inbounds i8, i8* [[PTR]], i64 [[COUNT]]
; CHECK-NEXT:    br label [[FOR_BODY_I_I:%.*]]
; CHECK:       for.body.i.i:
; CHECK-NEXT:    [[__FIRST2_ADDR_07_I_I:%.*]] = phi i8* [ [[INCDEC_PTR1_I_I:%.*]], [[FOR_INC_I_I:%.*]] ], [ [[ADD_PTR1]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I:%.*]] = phi i8* [ [[INCDEC_PTR_I_I:%.*]], [[FOR_INC_I_I]] ], [ [[PTR]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[V0:%.*]] = load i8, i8* [[__FIRST1_ADDR_06_I_I]]
; CHECK-NEXT:    [[V1:%.*]] = load i8, i8* [[__FIRST2_ADDR_07_I_I]]
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp eq i8 [[V0]], [[V1]]
; CHECK-NEXT:    br i1 [[CMP_I_I_I]], label [[FOR_INC_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT:%.*]]
; CHECK:       for.inc.i.i:
; CHECK-NEXT:    [[INCDEC_PTR_I_I]] = getelementptr inbounds i8, i8* [[__FIRST1_ADDR_06_I_I]], i64 1
; CHECK-NEXT:    [[INCDEC_PTR1_I_I]] = getelementptr inbounds i8, i8* [[__FIRST2_ADDR_07_I_I]], i64 1
; CHECK-NEXT:    [[CMP_I_I:%.*]] = icmp eq i8* [[INCDEC_PTR_I_I]], [[ADD_PTR]]
; CHECK-NEXT:    br i1 [[CMP_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT]], label [[FOR_BODY_I_I]]
; CHECK:       _ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit.loopexit:
; CHECK-NEXT:    [[RETVAL_0_I_I_PH:%.*]] = phi i1 [ false, [[FOR_BODY_I_I]] ], [ true, [[FOR_INC_I_I]] ]
; CHECK-NEXT:    br label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT]]
; CHECK:       _ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:
; CHECK-NEXT:    [[RETVAL_0_I_I:%.*]] = phi i1 [ true, [[ENTRY:%.*]] ], [ [[RETVAL_0_I_I_PH]], [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT]] ]
; CHECK-NEXT:    ret i1 [[RETVAL_0_I_I]]
;
entry:
  %mul = shl i64 %count, 1
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %mul
  %cmp5.i.i = icmp eq i64 %mul, 0
  br i1 %cmp5.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, label %for.body.i.i.preheader

for.body.i.i.preheader:                           ; preds = %entry
  %add.ptr1 = getelementptr inbounds i8, i8* %ptr, i64 %count
  br label %for.body.i.i

for.body.i.i:                                     ; preds = %for.body.i.i.preheader, %for.inc.i.i
  %__first2.addr.07.i.i = phi i8* [ %incdec.ptr1.i.i, %for.inc.i.i ], [ %add.ptr1, %for.body.i.i.preheader ]
  %__first1.addr.06.i.i = phi i8* [ %incdec.ptr.i.i, %for.inc.i.i ], [ %ptr, %for.body.i.i.preheader ]
  %v0 = load i8, i8* %__first1.addr.06.i.i
  %v1 = load i8, i8* %__first2.addr.07.i.i
  %cmp.i.i.i = icmp eq i8 %v0, %v1
  br i1 %cmp.i.i.i, label %for.inc.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit

for.inc.i.i:                                      ; preds = %for.body.i.i
  %incdec.ptr.i.i = getelementptr inbounds i8, i8* %__first1.addr.06.i.i, i64 1
  %incdec.ptr1.i.i = getelementptr inbounds i8, i8* %__first2.addr.07.i.i, i64 1
  %cmp.i.i = icmp eq i8* %incdec.ptr.i.i, %add.ptr
  br i1 %cmp.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, label %for.body.i.i

_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:           ; preds = %for.body.i.i, %for.inc.i.i, %entry
  %retval.0.i.i = phi i1 [ true, %entry ], [ true, %for.inc.i.i ], [ false, %for.body.i.i ]
  ret i1 %retval.0.i.i
}

define i1 @_Z47pointer_iteration_variable_size_overlap_unknownPKcS0_m(i8* %ptr0, i8* %ptr1, i64 %count) {
; CHECK-LABEL: @_Z47pointer_iteration_variable_size_overlap_unknownPKcS0_m(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, i8* [[PTR0:%.*]], i64 [[COUNT:%.*]]
; CHECK-NEXT:    [[CMP5_I_I:%.*]] = icmp eq i64 [[COUNT]], 0
; CHECK-NEXT:    br i1 [[CMP5_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT:%.*]], label [[FOR_BODY_I_I_PREHEADER:%.*]]
; CHECK:       for.body.i.i.preheader:
; CHECK-NEXT:    br label [[FOR_BODY_I_I:%.*]]
; CHECK:       for.body.i.i:
; CHECK-NEXT:    [[__FIRST2_ADDR_07_I_I:%.*]] = phi i8* [ [[INCDEC_PTR1_I_I:%.*]], [[FOR_INC_I_I:%.*]] ], [ [[PTR1:%.*]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I:%.*]] = phi i8* [ [[INCDEC_PTR_I_I:%.*]], [[FOR_INC_I_I]] ], [ [[PTR0]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[V0:%.*]] = load i8, i8* [[__FIRST1_ADDR_06_I_I]]
; CHECK-NEXT:    [[V1:%.*]] = load i8, i8* [[__FIRST2_ADDR_07_I_I]]
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp eq i8 [[V0]], [[V1]]
; CHECK-NEXT:    br i1 [[CMP_I_I_I]], label [[FOR_INC_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT:%.*]]
; CHECK:       for.inc.i.i:
; CHECK-NEXT:    [[INCDEC_PTR_I_I]] = getelementptr inbounds i8, i8* [[__FIRST1_ADDR_06_I_I]], i64 1
; CHECK-NEXT:    [[INCDEC_PTR1_I_I]] = getelementptr inbounds i8, i8* [[__FIRST2_ADDR_07_I_I]], i64 1
; CHECK-NEXT:    [[CMP_I_I:%.*]] = icmp eq i8* [[INCDEC_PTR_I_I]], [[ADD_PTR]]
; CHECK-NEXT:    br i1 [[CMP_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT]], label [[FOR_BODY_I_I]]
; CHECK:       _ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit.loopexit:
; CHECK-NEXT:    [[RETVAL_0_I_I_PH:%.*]] = phi i1 [ false, [[FOR_BODY_I_I]] ], [ true, [[FOR_INC_I_I]] ]
; CHECK-NEXT:    br label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT]]
; CHECK:       _ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:
; CHECK-NEXT:    [[RETVAL_0_I_I:%.*]] = phi i1 [ true, [[ENTRY:%.*]] ], [ [[RETVAL_0_I_I_PH]], [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT]] ]
; CHECK-NEXT:    ret i1 [[RETVAL_0_I_I]]
;
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr0, i64 %count
  %cmp5.i.i = icmp eq i64 %count, 0
  br i1 %cmp5.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, label %for.body.i.i

for.body.i.i:                                     ; preds = %entry, %for.inc.i.i
  %__first2.addr.07.i.i = phi i8* [ %incdec.ptr1.i.i, %for.inc.i.i ], [ %ptr1, %entry ]
  %__first1.addr.06.i.i = phi i8* [ %incdec.ptr.i.i, %for.inc.i.i ], [ %ptr0, %entry ]
  %v0 = load i8, i8* %__first1.addr.06.i.i
  %v1 = load i8, i8* %__first2.addr.07.i.i
  %cmp.i.i.i = icmp eq i8 %v0, %v1
  br i1 %cmp.i.i.i, label %for.inc.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit

for.inc.i.i:                                      ; preds = %for.body.i.i
  %incdec.ptr.i.i = getelementptr inbounds i8, i8* %__first1.addr.06.i.i, i64 1
  %incdec.ptr1.i.i = getelementptr inbounds i8, i8* %__first2.addr.07.i.i, i64 1
  %cmp.i.i = icmp eq i8* %incdec.ptr.i.i, %add.ptr
  br i1 %cmp.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, label %for.body.i.i

_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:           ; preds = %for.body.i.i, %for.inc.i.i, %entry
  %retval.0.i.i = phi i1 [ true, %entry ], [ true, %for.inc.i.i ], [ false, %for.body.i.i ]
  ret i1 %retval.0.i.i
}

define i1 @_Z40index_iteration_eq_const_size_no_overlapPKc(i8* %ptr) {
; CHECK-LABEL: @_Z40index_iteration_eq_const_size_no_overlapPKc(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, i8* [[PTR:%.*]], i64 8
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i64 [[INC:%.*]], 8
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[CLEANUP:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[I_013:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INC]], [[FOR_COND:%.*]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, i8* [[PTR]], i64 [[I_013]]
; CHECK-NEXT:    [[V0:%.*]] = load i8, i8* [[ARRAYIDX]]
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i8, i8* [[ADD_PTR]], i64 [[I_013]]
; CHECK-NEXT:    [[V1:%.*]] = load i8, i8* [[ARRAYIDX1]]
; CHECK-NEXT:    [[CMP3:%.*]] = icmp eq i8 [[V0]], [[V1]]
; CHECK-NEXT:    [[INC]] = add nuw nsw i64 [[I_013]], 1
; CHECK-NEXT:    br i1 [[CMP3]], label [[FOR_COND]], label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[RES:%.*]] = phi i1 [ false, [[FOR_BODY]] ], [ true, [[FOR_COND]] ]
; CHECK-NEXT:    ret i1 [[RES]]
;
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  br label %for.body

for.cond:                                         ; preds = %for.body
  %cmp = icmp ult i64 %inc, 8
  br i1 %cmp, label %for.body, label %cleanup

for.body:                                         ; preds = %entry, %for.cond
  %i.013 = phi i64 [ 0, %entry ], [ %inc, %for.cond ]
  %arrayidx = getelementptr inbounds i8, i8* %ptr, i64 %i.013
  %v0 = load i8, i8* %arrayidx
  %arrayidx1 = getelementptr inbounds i8, i8* %add.ptr, i64 %i.013
  %v1 = load i8, i8* %arrayidx1
  %cmp3 = icmp eq i8 %v0, %v1
  %inc = add nuw nsw i64 %i.013, 1
  br i1 %cmp3, label %for.cond, label %cleanup

cleanup:                                          ; preds = %for.cond, %for.body
  %res = phi i1 [ false, %for.body ], [ true, %for.cond ]
  ret i1 %res
}

define i1 @_Z45index_iteration_eq_const_size_partial_overlapPKc(i8* %ptr) {
; CHECK-LABEL: @_Z45index_iteration_eq_const_size_partial_overlapPKc(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, i8* [[PTR:%.*]], i64 8
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i64 [[INC:%.*]], 16
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[CLEANUP:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[I_013:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INC]], [[FOR_COND:%.*]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, i8* [[PTR]], i64 [[I_013]]
; CHECK-NEXT:    [[V0:%.*]] = load i8, i8* [[ARRAYIDX]]
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i8, i8* [[ADD_PTR]], i64 [[I_013]]
; CHECK-NEXT:    [[V1:%.*]] = load i8, i8* [[ARRAYIDX1]]
; CHECK-NEXT:    [[CMP3:%.*]] = icmp eq i8 [[V0]], [[V1]]
; CHECK-NEXT:    [[INC]] = add nuw nsw i64 [[I_013]], 1
; CHECK-NEXT:    br i1 [[CMP3]], label [[FOR_COND]], label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[RES:%.*]] = phi i1 [ false, [[FOR_BODY]] ], [ true, [[FOR_COND]] ]
; CHECK-NEXT:    ret i1 [[RES]]
;
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  br label %for.body

for.cond:                                         ; preds = %for.body
  %cmp = icmp ult i64 %inc, 16
  br i1 %cmp, label %for.body, label %cleanup

for.body:                                         ; preds = %entry, %for.cond
  %i.013 = phi i64 [ 0, %entry ], [ %inc, %for.cond ]
  %arrayidx = getelementptr inbounds i8, i8* %ptr, i64 %i.013
  %v0 = load i8, i8* %arrayidx
  %arrayidx1 = getelementptr inbounds i8, i8* %add.ptr, i64 %i.013
  %v1 = load i8, i8* %arrayidx1
  %cmp3 = icmp eq i8 %v0, %v1
  %inc = add nuw nsw i64 %i.013, 1
  br i1 %cmp3, label %for.cond, label %cleanup

cleanup:                                          ; preds = %for.cond, %for.body
  %res = phi i1 [ false, %for.body ], [ true, %for.cond ]
  ret i1 %res
}

define i1 @_Z45index_iteration_eq_const_size_overlap_unknownPKcS0_(i8* %ptr0, i8* %ptr1) {
; CHECK-LABEL: @_Z45index_iteration_eq_const_size_overlap_unknownPKcS0_(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i64 [[INC:%.*]], 8
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[CLEANUP:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[I_08:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INC]], [[FOR_COND:%.*]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, i8* [[PTR0:%.*]], i64 [[I_08]]
; CHECK-NEXT:    [[V0:%.*]] = load i8, i8* [[ARRAYIDX]]
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i8, i8* [[PTR1:%.*]], i64 [[I_08]]
; CHECK-NEXT:    [[V1:%.*]] = load i8, i8* [[ARRAYIDX1]]
; CHECK-NEXT:    [[CMP3:%.*]] = icmp eq i8 [[V0]], [[V1]]
; CHECK-NEXT:    [[INC]] = add nuw nsw i64 [[I_08]], 1
; CHECK-NEXT:    br i1 [[CMP3]], label [[FOR_COND]], label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[RES:%.*]] = phi i1 [ false, [[FOR_BODY]] ], [ true, [[FOR_COND]] ]
; CHECK-NEXT:    ret i1 [[RES]]
;
entry:
  br label %for.body

for.cond:                                         ; preds = %for.body
  %cmp = icmp ult i64 %inc, 8
  br i1 %cmp, label %for.body, label %cleanup

for.body:                                         ; preds = %entry, %for.cond
  %i.08 = phi i64 [ 0, %entry ], [ %inc, %for.cond ]
  %arrayidx = getelementptr inbounds i8, i8* %ptr0, i64 %i.08
  %v0 = load i8, i8* %arrayidx
  %arrayidx1 = getelementptr inbounds i8, i8* %ptr1, i64 %i.08
  %v1 = load i8, i8* %arrayidx1
  %cmp3 = icmp eq i8 %v0, %v1
  %inc = add nuw nsw i64 %i.08, 1
  br i1 %cmp3, label %for.cond, label %cleanup

cleanup:                                          ; preds = %for.cond, %for.body
  %res = phi i1 [ false, %for.body ], [ true, %for.cond ]
  ret i1 %res
}

define i1 @_Z43index_iteration_eq_variable_size_no_overlapPKcm(i8* %ptr, i64 %count) {
; CHECK-LABEL: @_Z43index_iteration_eq_variable_size_no_overlapPKcm(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, i8* [[PTR:%.*]], i64 [[COUNT:%.*]]
; CHECK-NEXT:    [[CMP14:%.*]] = icmp eq i64 [[COUNT]], 0
; CHECK-NEXT:    br i1 [[CMP14]], label [[CLEANUP:%.*]], label [[FOR_BODY_PREHEADER:%.*]]
; CHECK:       for.body.preheader:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i64 [[INC:%.*]], [[COUNT]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[CLEANUP_LOOPEXIT:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[I_015:%.*]] = phi i64 [ [[INC]], [[FOR_COND:%.*]] ], [ 0, [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, i8* [[PTR]], i64 [[I_015]]
; CHECK-NEXT:    [[V0:%.*]] = load i8, i8* [[ARRAYIDX]]
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i8, i8* [[ADD_PTR]], i64 [[I_015]]
; CHECK-NEXT:    [[V1:%.*]] = load i8, i8* [[ARRAYIDX1]]
; CHECK-NEXT:    [[CMP3:%.*]] = icmp eq i8 [[V0]], [[V1]]
; CHECK-NEXT:    [[INC]] = add nuw i64 [[I_015]], 1
; CHECK-NEXT:    br i1 [[CMP3]], label [[FOR_COND]], label [[CLEANUP_LOOPEXIT]]
; CHECK:       cleanup.loopexit:
; CHECK-NEXT:    [[RES_PH:%.*]] = phi i1 [ false, [[FOR_BODY]] ], [ true, [[FOR_COND]] ]
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[RES:%.*]] = phi i1 [ true, [[ENTRY:%.*]] ], [ [[RES_PH]], [[CLEANUP_LOOPEXIT]] ]
; CHECK-NEXT:    ret i1 [[RES]]
;
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %count
  %cmp14 = icmp eq i64 %count, 0
  br i1 %cmp14, label %cleanup, label %for.body

for.cond:                                         ; preds = %for.body
  %cmp = icmp ult i64 %inc, %count
  br i1 %cmp, label %for.body, label %cleanup

for.body:                                         ; preds = %entry, %for.cond
  %i.015 = phi i64 [ %inc, %for.cond ], [ 0, %entry ]
  %arrayidx = getelementptr inbounds i8, i8* %ptr, i64 %i.015
  %v0 = load i8, i8* %arrayidx
  %arrayidx1 = getelementptr inbounds i8, i8* %add.ptr, i64 %i.015
  %v1 = load i8, i8* %arrayidx1
  %cmp3 = icmp eq i8 %v0, %v1
  %inc = add nuw i64 %i.015, 1
  br i1 %cmp3, label %for.cond, label %cleanup

cleanup:                                          ; preds = %for.body, %for.cond, %entry
  %res = phi i1 [ true, %entry ], [ true, %for.cond ], [ false, %for.body ]
  ret i1 %res
}

define i1 @_Z48index_iteration_eq_variable_size_partial_overlapPKcm(i8* %ptr, i64 %count) {
; CHECK-LABEL: @_Z48index_iteration_eq_variable_size_partial_overlapPKcm(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, i8* [[PTR:%.*]], i64 [[COUNT:%.*]]
; CHECK-NEXT:    [[MUL:%.*]] = shl i64 [[COUNT]], 1
; CHECK-NEXT:    [[CMP14:%.*]] = icmp eq i64 [[MUL]], 0
; CHECK-NEXT:    br i1 [[CMP14]], label [[CLEANUP:%.*]], label [[FOR_BODY_PREHEADER:%.*]]
; CHECK:       for.body.preheader:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i64 [[INC:%.*]], [[MUL]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[CLEANUP_LOOPEXIT:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[I_015:%.*]] = phi i64 [ [[INC]], [[FOR_COND:%.*]] ], [ 0, [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, i8* [[PTR]], i64 [[I_015]]
; CHECK-NEXT:    [[V0:%.*]] = load i8, i8* [[ARRAYIDX]]
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i8, i8* [[ADD_PTR]], i64 [[I_015]]
; CHECK-NEXT:    [[V1:%.*]] = load i8, i8* [[ARRAYIDX1]]
; CHECK-NEXT:    [[CMP3:%.*]] = icmp eq i8 [[V0]], [[V1]]
; CHECK-NEXT:    [[INC]] = add nuw i64 [[I_015]], 1
; CHECK-NEXT:    br i1 [[CMP3]], label [[FOR_COND]], label [[CLEANUP_LOOPEXIT]]
; CHECK:       cleanup.loopexit:
; CHECK-NEXT:    [[RES_PH:%.*]] = phi i1 [ false, [[FOR_BODY]] ], [ true, [[FOR_COND]] ]
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[RES:%.*]] = phi i1 [ true, [[ENTRY:%.*]] ], [ [[RES_PH]], [[CLEANUP_LOOPEXIT]] ]
; CHECK-NEXT:    ret i1 [[RES]]
;
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %count
  %mul = shl i64 %count, 1
  %cmp14 = icmp eq i64 %mul, 0
  br i1 %cmp14, label %cleanup, label %for.body

for.cond:                                         ; preds = %for.body
  %cmp = icmp ult i64 %inc, %mul
  br i1 %cmp, label %for.body, label %cleanup

for.body:                                         ; preds = %entry, %for.cond
  %i.015 = phi i64 [ %inc, %for.cond ], [ 0, %entry ]
  %arrayidx = getelementptr inbounds i8, i8* %ptr, i64 %i.015
  %v0 = load i8, i8* %arrayidx
  %arrayidx1 = getelementptr inbounds i8, i8* %add.ptr, i64 %i.015
  %v1 = load i8, i8* %arrayidx1
  %cmp3 = icmp eq i8 %v0, %v1
  %inc = add nuw i64 %i.015, 1
  br i1 %cmp3, label %for.cond, label %cleanup

cleanup:                                          ; preds = %for.body, %for.cond, %entry
  %res = phi i1 [ true, %entry ], [ true, %for.cond ], [ false, %for.body ]
  ret i1 %res
}

define i1 @_Z48index_iteration_eq_variable_size_overlap_unknownPKcS0_m(i8* %ptr0, i8* %ptr1, i64 %count) {
; CHECK-LABEL: @_Z48index_iteration_eq_variable_size_overlap_unknownPKcS0_m(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP8:%.*]] = icmp eq i64 [[COUNT:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP8]], label [[CLEANUP:%.*]], label [[FOR_BODY_PREHEADER:%.*]]
; CHECK:       for.body.preheader:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i64 [[INC:%.*]], [[COUNT]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[CLEANUP_LOOPEXIT:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[I_09:%.*]] = phi i64 [ [[INC]], [[FOR_COND:%.*]] ], [ 0, [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, i8* [[PTR0:%.*]], i64 [[I_09]]
; CHECK-NEXT:    [[V0:%.*]] = load i8, i8* [[ARRAYIDX]]
; CHECK-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i8, i8* [[PTR1:%.*]], i64 [[I_09]]
; CHECK-NEXT:    [[V1:%.*]] = load i8, i8* [[ARRAYIDX1]]
; CHECK-NEXT:    [[CMP3:%.*]] = icmp eq i8 [[V0]], [[V1]]
; CHECK-NEXT:    [[INC]] = add nuw i64 [[I_09]], 1
; CHECK-NEXT:    br i1 [[CMP3]], label [[FOR_COND]], label [[CLEANUP_LOOPEXIT]]
; CHECK:       cleanup.loopexit:
; CHECK-NEXT:    [[RES_PH:%.*]] = phi i1 [ false, [[FOR_BODY]] ], [ true, [[FOR_COND]] ]
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[RES:%.*]] = phi i1 [ true, [[ENTRY:%.*]] ], [ [[RES_PH]], [[CLEANUP_LOOPEXIT]] ]
; CHECK-NEXT:    ret i1 [[RES]]
;
entry:
  %cmp8 = icmp eq i64 %count, 0
  br i1 %cmp8, label %cleanup, label %for.body

for.cond:                                         ; preds = %for.body
  %cmp = icmp ult i64 %inc, %count
  br i1 %cmp, label %for.body, label %cleanup

for.body:                                         ; preds = %entry, %for.cond
  %i.09 = phi i64 [ %inc, %for.cond ], [ 0, %entry ]
  %arrayidx = getelementptr inbounds i8, i8* %ptr0, i64 %i.09
  %v0 = load i8, i8* %arrayidx
  %arrayidx1 = getelementptr inbounds i8, i8* %ptr1, i64 %i.09
  %v1 = load i8, i8* %arrayidx1
  %cmp3 = icmp eq i8 %v0, %v1
  %inc = add nuw i64 %i.09, 1
  br i1 %cmp3, label %for.cond, label %cleanup

cleanup:                                          ; preds = %for.body, %for.cond, %entry
  %res = phi i1 [ true, %entry ], [ true, %for.cond ], [ false, %for.body ]
  ret i1 %res
}

define i1 @_Z38index_iteration_starting_from_negativePKcS0_(i8* %ptr0, i8* %ptr1) {
; CHECK-LABEL: @_Z38index_iteration_starting_from_negativePKcS0_(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i64 [[INDVARS_IV_NEXT:%.*]], 4
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[CLEANUP:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ -4, [[ENTRY:%.*]] ], [ [[INDVARS_IV_NEXT]], [[FOR_COND:%.*]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, i8* [[PTR0:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[V0:%.*]] = load i8, i8* [[ARRAYIDX]]
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i8, i8* [[PTR1:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[V1:%.*]] = load i8, i8* [[ARRAYIDX2]]
; CHECK-NEXT:    [[CMP4:%.*]] = icmp eq i8 [[V0]], [[V1]]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    br i1 [[CMP4]], label [[FOR_COND]], label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[RET:%.*]] = phi i1 [ false, [[FOR_BODY]] ], [ true, [[FOR_COND]] ]
; CHECK-NEXT:    ret i1 [[RET]]
;
entry:
  br label %for.body

for.cond:                                         ; preds = %for.body
  %cmp = icmp slt i64 %indvars.iv.next, 4
  br i1 %cmp, label %for.body, label %cleanup

for.body:                                         ; preds = %entry, %for.cond
  %indvars.iv = phi i64 [ -4, %entry ], [ %indvars.iv.next, %for.cond ]
  %arrayidx = getelementptr inbounds i8, i8* %ptr0, i64 %indvars.iv
  %v0 = load i8, i8* %arrayidx
  %arrayidx2 = getelementptr inbounds i8, i8* %ptr1, i64 %indvars.iv
  %v1 = load i8, i8* %arrayidx2
  %cmp4 = icmp eq i8 %v0, %v1
  %indvars.iv.next = add nsw i64 %indvars.iv, 1
  br i1 %cmp4, label %for.cond, label %cleanup

cleanup:                                          ; preds = %for.cond, %for.body
  %ret = phi i1 [ false, %for.body ], [ true, %for.cond ]
  ret i1 %ret
}

define i1 @_Z43combined_iteration_eq_const_size_no_overlapPKc(i8* %ptr) {
; CHECK-LABEL: @_Z43combined_iteration_eq_const_size_no_overlapPKc(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, i8* [[PTR:%.*]], i64 8
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[I_015:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INC:%.*]], [[FOR_INC:%.*]] ]
; CHECK-NEXT:    [[PTR1_014:%.*]] = phi i8* [ [[ADD_PTR]], [[ENTRY]] ], [ [[INCDEC_PTR3:%.*]], [[FOR_INC]] ]
; CHECK-NEXT:    [[PTR0_013:%.*]] = phi i8* [ [[PTR]], [[ENTRY]] ], [ [[INCDEC_PTR:%.*]], [[FOR_INC]] ]
; CHECK-NEXT:    [[V0:%.*]] = load i8, i8* [[PTR0_013]]
; CHECK-NEXT:    [[V1:%.*]] = load i8, i8* [[PTR1_014]]
; CHECK-NEXT:    [[CMP2:%.*]] = icmp eq i8 [[V0]], [[V1]]
; CHECK-NEXT:    br i1 [[CMP2]], label [[FOR_INC]], label [[CLEANUP:%.*]]
; CHECK:       for.inc:
; CHECK-NEXT:    [[INC]] = add nuw nsw i64 [[I_015]], 1
; CHECK-NEXT:    [[INCDEC_PTR]] = getelementptr inbounds i8, i8* [[PTR0_013]], i64 1
; CHECK-NEXT:    [[INCDEC_PTR3]] = getelementptr inbounds i8, i8* [[PTR1_014]], i64 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i64 [[INC]], 8
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[RES:%.*]] = phi i1 [ false, [[FOR_BODY]] ], [ true, [[FOR_INC]] ]
; CHECK-NEXT:    ret i1 [[RES]]
;
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  br label %for.body

for.body:                                         ; preds = %entry, %for.inc
  %i.015 = phi i64 [ 0, %entry ], [ %inc, %for.inc ]
  %ptr1.014 = phi i8* [ %add.ptr, %entry ], [ %incdec.ptr3, %for.inc ]
  %ptr0.013 = phi i8* [ %ptr, %entry ], [ %incdec.ptr, %for.inc ]
  %v0 = load i8, i8* %ptr0.013
  %v1 = load i8, i8* %ptr1.014
  %cmp2 = icmp eq i8 %v0, %v1
  br i1 %cmp2, label %for.inc, label %cleanup

for.inc:                                          ; preds = %for.body
  %inc = add nuw nsw i64 %i.015, 1
  %incdec.ptr = getelementptr inbounds i8, i8* %ptr0.013, i64 1
  %incdec.ptr3 = getelementptr inbounds i8, i8* %ptr1.014, i64 1
  %cmp = icmp ult i64 %inc, 8
  br i1 %cmp, label %for.body, label %cleanup

cleanup:                                          ; preds = %for.inc, %for.body
  %res = phi i1 [ false, %for.body ], [ true, %for.inc ]
  ret i1 %res
}

define i1 @_Z48combined_iteration_eq_const_size_partial_overlapPKc(i8* %ptr) {
; CHECK-LABEL: @_Z48combined_iteration_eq_const_size_partial_overlapPKc(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, i8* [[PTR:%.*]], i64 8
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[I_015:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INC:%.*]], [[FOR_INC:%.*]] ]
; CHECK-NEXT:    [[PTR1_014:%.*]] = phi i8* [ [[ADD_PTR]], [[ENTRY]] ], [ [[INCDEC_PTR3:%.*]], [[FOR_INC]] ]
; CHECK-NEXT:    [[PTR0_013:%.*]] = phi i8* [ [[PTR]], [[ENTRY]] ], [ [[INCDEC_PTR:%.*]], [[FOR_INC]] ]
; CHECK-NEXT:    [[V0:%.*]] = load i8, i8* [[PTR0_013]]
; CHECK-NEXT:    [[V1:%.*]] = load i8, i8* [[PTR1_014]]
; CHECK-NEXT:    [[CMP2:%.*]] = icmp eq i8 [[V0]], [[V1]]
; CHECK-NEXT:    br i1 [[CMP2]], label [[FOR_INC]], label [[CLEANUP:%.*]]
; CHECK:       for.inc:
; CHECK-NEXT:    [[INC]] = add nuw nsw i64 [[I_015]], 1
; CHECK-NEXT:    [[INCDEC_PTR]] = getelementptr inbounds i8, i8* [[PTR0_013]], i64 1
; CHECK-NEXT:    [[INCDEC_PTR3]] = getelementptr inbounds i8, i8* [[PTR1_014]], i64 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i64 [[INC]], 16
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[RES:%.*]] = phi i1 [ false, [[FOR_BODY]] ], [ true, [[FOR_INC]] ]
; CHECK-NEXT:    ret i1 [[RES]]
;
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  br label %for.body

for.body:                                         ; preds = %entry, %for.inc
  %i.015 = phi i64 [ 0, %entry ], [ %inc, %for.inc ]
  %ptr1.014 = phi i8* [ %add.ptr, %entry ], [ %incdec.ptr3, %for.inc ]
  %ptr0.013 = phi i8* [ %ptr, %entry ], [ %incdec.ptr, %for.inc ]
  %v0 = load i8, i8* %ptr0.013
  %v1 = load i8, i8* %ptr1.014
  %cmp2 = icmp eq i8 %v0, %v1
  br i1 %cmp2, label %for.inc, label %cleanup

for.inc:                                          ; preds = %for.body
  %inc = add nuw nsw i64 %i.015, 1
  %incdec.ptr = getelementptr inbounds i8, i8* %ptr0.013, i64 1
  %incdec.ptr3 = getelementptr inbounds i8, i8* %ptr1.014, i64 1
  %cmp = icmp ult i64 %inc, 16
  br i1 %cmp, label %for.body, label %cleanup

cleanup:                                          ; preds = %for.inc, %for.body
  %res = phi i1 [ false, %for.body ], [ true, %for.inc ]
  ret i1 %res
}

define i1 @_Z48combined_iteration_eq_const_size_overlap_unknownPKcS0_(i8* %ptr0, i8* %ptr1) {
; CHECK-LABEL: @_Z48combined_iteration_eq_const_size_overlap_unknownPKcS0_(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[I_010:%.*]] = phi i64 [ 0, [[ENTRY:%.*]] ], [ [[INC:%.*]], [[FOR_INC:%.*]] ]
; CHECK-NEXT:    [[PTR1_ADDR_09:%.*]] = phi i8* [ [[PTR1:%.*]], [[ENTRY]] ], [ [[INCDEC_PTR3:%.*]], [[FOR_INC]] ]
; CHECK-NEXT:    [[PTR0_ADDR_08:%.*]] = phi i8* [ [[PTR0:%.*]], [[ENTRY]] ], [ [[INCDEC_PTR:%.*]], [[FOR_INC]] ]
; CHECK-NEXT:    [[V0:%.*]] = load i8, i8* [[PTR0_ADDR_08]]
; CHECK-NEXT:    [[V1:%.*]] = load i8, i8* [[PTR1_ADDR_09]]
; CHECK-NEXT:    [[CMP2:%.*]] = icmp eq i8 [[V0]], [[V1]]
; CHECK-NEXT:    br i1 [[CMP2]], label [[FOR_INC]], label [[CLEANUP:%.*]]
; CHECK:       for.inc:
; CHECK-NEXT:    [[INC]] = add nuw nsw i64 [[I_010]], 1
; CHECK-NEXT:    [[INCDEC_PTR]] = getelementptr inbounds i8, i8* [[PTR0_ADDR_08]], i64 1
; CHECK-NEXT:    [[INCDEC_PTR3]] = getelementptr inbounds i8, i8* [[PTR1_ADDR_09]], i64 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i64 [[INC]], 8
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[RES:%.*]] = phi i1 [ false, [[FOR_BODY]] ], [ true, [[FOR_INC]] ]
; CHECK-NEXT:    ret i1 [[RES]]
;
entry:
  br label %for.body

for.body:                                         ; preds = %entry, %for.inc
  %i.010 = phi i64 [ 0, %entry ], [ %inc, %for.inc ]
  %ptr1.addr.09 = phi i8* [ %ptr1, %entry ], [ %incdec.ptr3, %for.inc ]
  %ptr0.addr.08 = phi i8* [ %ptr0, %entry ], [ %incdec.ptr, %for.inc ]
  %v0 = load i8, i8* %ptr0.addr.08
  %v1 = load i8, i8* %ptr1.addr.09
  %cmp2 = icmp eq i8 %v0, %v1
  br i1 %cmp2, label %for.inc, label %cleanup

for.inc:                                          ; preds = %for.body
  %inc = add nuw nsw i64 %i.010, 1
  %incdec.ptr = getelementptr inbounds i8, i8* %ptr0.addr.08, i64 1
  %incdec.ptr3 = getelementptr inbounds i8, i8* %ptr1.addr.09, i64 1
  %cmp = icmp ult i64 %inc, 8
  br i1 %cmp, label %for.body, label %cleanup

cleanup:                                          ; preds = %for.inc, %for.body
  %res = phi i1 [ false, %for.body ], [ true, %for.inc ]
  ret i1 %res
}

define i1 @_Z46combined_iteration_eq_variable_size_no_overlapPKcm(i8* %ptr, i64 %count) {
; CHECK-LABEL: @_Z46combined_iteration_eq_variable_size_no_overlapPKcm(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP14:%.*]] = icmp eq i64 [[COUNT:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP14]], label [[CLEANUP:%.*]], label [[FOR_BODY_PREHEADER:%.*]]
; CHECK:       for.body.preheader:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, i8* [[PTR:%.*]], i64 [[COUNT]]
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[I_017:%.*]] = phi i64 [ [[INC:%.*]], [[FOR_INC:%.*]] ], [ 0, [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[PTR1_016:%.*]] = phi i8* [ [[INCDEC_PTR3:%.*]], [[FOR_INC]] ], [ [[ADD_PTR]], [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[PTR0_015:%.*]] = phi i8* [ [[INCDEC_PTR:%.*]], [[FOR_INC]] ], [ [[PTR]], [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[V0:%.*]] = load i8, i8* [[PTR0_015]]
; CHECK-NEXT:    [[V1:%.*]] = load i8, i8* [[PTR1_016]]
; CHECK-NEXT:    [[CMP2:%.*]] = icmp eq i8 [[V0]], [[V1]]
; CHECK-NEXT:    br i1 [[CMP2]], label [[FOR_INC]], label [[CLEANUP_LOOPEXIT:%.*]]
; CHECK:       for.inc:
; CHECK-NEXT:    [[INC]] = add nuw i64 [[I_017]], 1
; CHECK-NEXT:    [[INCDEC_PTR]] = getelementptr inbounds i8, i8* [[PTR0_015]], i64 1
; CHECK-NEXT:    [[INCDEC_PTR3]] = getelementptr inbounds i8, i8* [[PTR1_016]], i64 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i64 [[INC]], [[COUNT]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[CLEANUP_LOOPEXIT]]
; CHECK:       cleanup.loopexit:
; CHECK-NEXT:    [[RES_PH:%.*]] = phi i1 [ false, [[FOR_BODY]] ], [ true, [[FOR_INC]] ]
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[RES:%.*]] = phi i1 [ true, [[ENTRY:%.*]] ], [ [[RES_PH]], [[CLEANUP_LOOPEXIT]] ]
; CHECK-NEXT:    ret i1 [[RES]]
;
entry:
  %cmp14 = icmp eq i64 %count, 0
  br i1 %cmp14, label %cleanup, label %for.body.preheader

for.body.preheader:                               ; preds = %entry
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %count
  br label %for.body

for.body:                                         ; preds = %for.body.preheader, %for.inc
  %i.017 = phi i64 [ %inc, %for.inc ], [ 0, %for.body.preheader ]
  %ptr1.016 = phi i8* [ %incdec.ptr3, %for.inc ], [ %add.ptr, %for.body.preheader ]
  %ptr0.015 = phi i8* [ %incdec.ptr, %for.inc ], [ %ptr, %for.body.preheader ]
  %v0 = load i8, i8* %ptr0.015
  %v1 = load i8, i8* %ptr1.016
  %cmp2 = icmp eq i8 %v0, %v1
  br i1 %cmp2, label %for.inc, label %cleanup

for.inc:                                          ; preds = %for.body
  %inc = add nuw i64 %i.017, 1
  %incdec.ptr = getelementptr inbounds i8, i8* %ptr0.015, i64 1
  %incdec.ptr3 = getelementptr inbounds i8, i8* %ptr1.016, i64 1
  %cmp = icmp ult i64 %inc, %count
  br i1 %cmp, label %for.body, label %cleanup

cleanup:                                          ; preds = %for.body, %for.inc, %entry
  %res = phi i1 [ true, %entry ], [ true, %for.inc ], [ false, %for.body ]
  ret i1 %res
}

define i1 @_Z51combined_iteration_eq_variable_size_partial_overlapPKcm(i8* %ptr, i64 %count) {
; CHECK-LABEL: @_Z51combined_iteration_eq_variable_size_partial_overlapPKcm(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[MUL:%.*]] = shl i64 [[COUNT:%.*]], 1
; CHECK-NEXT:    [[CMP14:%.*]] = icmp eq i64 [[MUL]], 0
; CHECK-NEXT:    br i1 [[CMP14]], label [[CLEANUP:%.*]], label [[FOR_BODY_PREHEADER:%.*]]
; CHECK:       for.body.preheader:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, i8* [[PTR:%.*]], i64 [[COUNT]]
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[I_017:%.*]] = phi i64 [ [[INC:%.*]], [[FOR_INC:%.*]] ], [ 0, [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[PTR1_016:%.*]] = phi i8* [ [[INCDEC_PTR3:%.*]], [[FOR_INC]] ], [ [[ADD_PTR]], [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[PTR0_015:%.*]] = phi i8* [ [[INCDEC_PTR:%.*]], [[FOR_INC]] ], [ [[PTR]], [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[V0:%.*]] = load i8, i8* [[PTR0_015]]
; CHECK-NEXT:    [[V1:%.*]] = load i8, i8* [[PTR1_016]]
; CHECK-NEXT:    [[CMP2:%.*]] = icmp eq i8 [[V0]], [[V1]]
; CHECK-NEXT:    br i1 [[CMP2]], label [[FOR_INC]], label [[CLEANUP_LOOPEXIT:%.*]]
; CHECK:       for.inc:
; CHECK-NEXT:    [[INC]] = add nuw i64 [[I_017]], 1
; CHECK-NEXT:    [[INCDEC_PTR]] = getelementptr inbounds i8, i8* [[PTR0_015]], i64 1
; CHECK-NEXT:    [[INCDEC_PTR3]] = getelementptr inbounds i8, i8* [[PTR1_016]], i64 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i64 [[INC]], [[MUL]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[CLEANUP_LOOPEXIT]]
; CHECK:       cleanup.loopexit:
; CHECK-NEXT:    [[RES_PH:%.*]] = phi i1 [ false, [[FOR_BODY]] ], [ true, [[FOR_INC]] ]
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[RES:%.*]] = phi i1 [ true, [[ENTRY:%.*]] ], [ [[RES_PH]], [[CLEANUP_LOOPEXIT]] ]
; CHECK-NEXT:    ret i1 [[RES]]
;
entry:
  %mul = shl i64 %count, 1
  %cmp14 = icmp eq i64 %mul, 0
  br i1 %cmp14, label %cleanup, label %for.body.preheader

for.body.preheader:                               ; preds = %entry
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %count
  br label %for.body

for.body:                                         ; preds = %for.body.preheader, %for.inc
  %i.017 = phi i64 [ %inc, %for.inc ], [ 0, %for.body.preheader ]
  %ptr1.016 = phi i8* [ %incdec.ptr3, %for.inc ], [ %add.ptr, %for.body.preheader ]
  %ptr0.015 = phi i8* [ %incdec.ptr, %for.inc ], [ %ptr, %for.body.preheader ]
  %v0 = load i8, i8* %ptr0.015
  %v1 = load i8, i8* %ptr1.016
  %cmp2 = icmp eq i8 %v0, %v1
  br i1 %cmp2, label %for.inc, label %cleanup

for.inc:                                          ; preds = %for.body
  %inc = add nuw i64 %i.017, 1
  %incdec.ptr = getelementptr inbounds i8, i8* %ptr0.015, i64 1
  %incdec.ptr3 = getelementptr inbounds i8, i8* %ptr1.016, i64 1
  %cmp = icmp ult i64 %inc, %mul
  br i1 %cmp, label %for.body, label %cleanup

cleanup:                                          ; preds = %for.body, %for.inc, %entry
  %res = phi i1 [ true, %entry ], [ true, %for.inc ], [ false, %for.body ]
  ret i1 %res
}

define i1 @_Z51combined_iteration_eq_variable_size_overlap_unknownPKcS0_m(i8* %ptr0, i8* %ptr1, i64 %count) {
; CHECK-LABEL: @_Z51combined_iteration_eq_variable_size_overlap_unknownPKcS0_m(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP8:%.*]] = icmp eq i64 [[COUNT:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP8]], label [[CLEANUP:%.*]], label [[FOR_BODY_PREHEADER:%.*]]
; CHECK:       for.body.preheader:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[I_011:%.*]] = phi i64 [ [[INC:%.*]], [[FOR_INC:%.*]] ], [ 0, [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[PTR1_ADDR_010:%.*]] = phi i8* [ [[INCDEC_PTR3:%.*]], [[FOR_INC]] ], [ [[PTR1:%.*]], [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[PTR0_ADDR_09:%.*]] = phi i8* [ [[INCDEC_PTR:%.*]], [[FOR_INC]] ], [ [[PTR0:%.*]], [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[V0:%.*]] = load i8, i8* [[PTR0_ADDR_09]]
; CHECK-NEXT:    [[V1:%.*]] = load i8, i8* [[PTR1_ADDR_010]]
; CHECK-NEXT:    [[CMP2:%.*]] = icmp eq i8 [[V0]], [[V1]]
; CHECK-NEXT:    br i1 [[CMP2]], label [[FOR_INC]], label [[CLEANUP_LOOPEXIT:%.*]]
; CHECK:       for.inc:
; CHECK-NEXT:    [[INC]] = add nuw i64 [[I_011]], 1
; CHECK-NEXT:    [[INCDEC_PTR]] = getelementptr inbounds i8, i8* [[PTR0_ADDR_09]], i64 1
; CHECK-NEXT:    [[INCDEC_PTR3]] = getelementptr inbounds i8, i8* [[PTR1_ADDR_010]], i64 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i64 [[INC]], [[COUNT]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[CLEANUP_LOOPEXIT]]
; CHECK:       cleanup.loopexit:
; CHECK-NEXT:    [[RES_PH:%.*]] = phi i1 [ false, [[FOR_BODY]] ], [ true, [[FOR_INC]] ]
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[RES:%.*]] = phi i1 [ true, [[ENTRY:%.*]] ], [ [[RES_PH]], [[CLEANUP_LOOPEXIT]] ]
; CHECK-NEXT:    ret i1 [[RES]]
;
entry:
  %cmp8 = icmp eq i64 %count, 0
  br i1 %cmp8, label %cleanup, label %for.body

for.body:                                         ; preds = %entry, %for.inc
  %i.011 = phi i64 [ %inc, %for.inc ], [ 0, %entry ]
  %ptr1.addr.010 = phi i8* [ %incdec.ptr3, %for.inc ], [ %ptr1, %entry ]
  %ptr0.addr.09 = phi i8* [ %incdec.ptr, %for.inc ], [ %ptr0, %entry ]
  %v0 = load i8, i8* %ptr0.addr.09
  %v1 = load i8, i8* %ptr1.addr.010
  %cmp2 = icmp eq i8 %v0, %v1
  br i1 %cmp2, label %for.inc, label %cleanup

for.inc:                                          ; preds = %for.body
  %inc = add nuw i64 %i.011, 1
  %incdec.ptr = getelementptr inbounds i8, i8* %ptr0.addr.09, i64 1
  %incdec.ptr3 = getelementptr inbounds i8, i8* %ptr1.addr.010, i64 1
  %cmp = icmp ult i64 %inc, %count
  br i1 %cmp, label %for.body, label %cleanup

cleanup:                                          ; preds = %for.body, %for.inc, %entry
  %res = phi i1 [ true, %entry ], [ true, %for.inc ], [ false, %for.body ]
  ret i1 %res
}

define i1 @_Z55negated_pointer_iteration_variable_size_overlap_unknownPKcS0_m(i8* %ptr0, i8* %ptr1, i64 %count) {
; CHECK-LABEL: @_Z55negated_pointer_iteration_variable_size_overlap_unknownPKcS0_m(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, i8* [[PTR0:%.*]], i64 [[COUNT:%.*]]
; CHECK-NEXT:    [[CMP5_I_I:%.*]] = icmp eq i64 [[COUNT]], 0
; CHECK-NEXT:    br i1 [[CMP5_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT:%.*]], label [[FOR_BODY_I_I_PREHEADER:%.*]]
; CHECK:       for.body.i.i.preheader:
; CHECK-NEXT:    br label [[FOR_BODY_I_I:%.*]]
; CHECK:       for.body.i.i:
; CHECK-NEXT:    [[__FIRST2_ADDR_07_I_I:%.*]] = phi i8* [ [[INCDEC_PTR1_I_I:%.*]], [[FOR_INC_I_I:%.*]] ], [ [[PTR1:%.*]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I:%.*]] = phi i8* [ [[INCDEC_PTR_I_I:%.*]], [[FOR_INC_I_I]] ], [ [[PTR0]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[T0:%.*]] = load i8, i8* [[__FIRST1_ADDR_06_I_I]]
; CHECK-NEXT:    [[T1:%.*]] = load i8, i8* [[__FIRST2_ADDR_07_I_I]]
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp eq i8 [[T0]], [[T1]]
; CHECK-NEXT:    br i1 [[CMP_I_I_I]], label [[FOR_INC_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT:%.*]]
; CHECK:       for.inc.i.i:
; CHECK-NEXT:    [[INCDEC_PTR_I_I]] = getelementptr inbounds i8, i8* [[__FIRST1_ADDR_06_I_I]], i64 1
; CHECK-NEXT:    [[INCDEC_PTR1_I_I]] = getelementptr inbounds i8, i8* [[__FIRST2_ADDR_07_I_I]], i64 1
; CHECK-NEXT:    [[CMP_I_I:%.*]] = icmp eq i8* [[INCDEC_PTR_I_I]], [[ADD_PTR]]
; CHECK-NEXT:    br i1 [[CMP_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT]], label [[FOR_BODY_I_I]]
; CHECK:       _ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit.loopexit:
; CHECK-NEXT:    [[RETVAL_0_I_I_PH:%.*]] = phi i1 [ true, [[FOR_BODY_I_I]] ], [ false, [[FOR_INC_I_I]] ]
; CHECK-NEXT:    br label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT]]
; CHECK:       _ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:
; CHECK-NEXT:    [[RETVAL_0_I_I:%.*]] = phi i1 [ false, [[ENTRY:%.*]] ], [ [[RETVAL_0_I_I_PH]], [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT]] ]
; CHECK-NEXT:    ret i1 [[RETVAL_0_I_I]]
;
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr0, i64 %count
  %cmp5.i.i = icmp eq i64 %count, 0
  br i1 %cmp5.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, label %for.body.i.i

for.body.i.i:                                     ; preds = %entry, %for.inc.i.i
  %__first2.addr.07.i.i = phi i8* [ %incdec.ptr1.i.i, %for.inc.i.i ], [ %ptr1, %entry ]
  %__first1.addr.06.i.i = phi i8* [ %incdec.ptr.i.i, %for.inc.i.i ], [ %ptr0, %entry ]
  %t0 = load i8, i8* %__first1.addr.06.i.i
  %t1 = load i8, i8* %__first2.addr.07.i.i
  %cmp.i.i.i = icmp eq i8 %t0, %t1
  br i1 %cmp.i.i.i, label %for.inc.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit

for.inc.i.i:                                      ; preds = %for.body.i.i
  %incdec.ptr.i.i = getelementptr inbounds i8, i8* %__first1.addr.06.i.i, i64 1
  %incdec.ptr1.i.i = getelementptr inbounds i8, i8* %__first2.addr.07.i.i, i64 1
  %cmp.i.i = icmp eq i8* %incdec.ptr.i.i, %add.ptr
  br i1 %cmp.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, label %for.body.i.i

_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:           ; preds = %for.body.i.i, %for.inc.i.i, %entry
  %retval.0.i.i = phi i1 [ false, %entry ], [ false, %for.inc.i.i ], [ true, %for.body.i.i ]
  ret i1 %retval.0.i.i
}

define i1 @_Z55integer_pointer_iteration_variable_size_overlap_unknownPKiS0_m(i32* %ptr0, i32* %ptr1, i64 %count) {
; CHECK-LABEL: @_Z55integer_pointer_iteration_variable_size_overlap_unknownPKiS0_m(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i32, i32* [[PTR0:%.*]], i64 [[COUNT:%.*]]
; CHECK-NEXT:    [[CMP5_I_I:%.*]] = icmp eq i64 [[COUNT]], 0
; CHECK-NEXT:    br i1 [[CMP5_I_I]], label [[_ZNST3__15EQUALIPKIS2_EEBT_S3_T0__EXIT:%.*]], label [[FOR_BODY_I_I_PREHEADER:%.*]]
; CHECK:       for.body.i.i.preheader:
; CHECK-NEXT:    br label [[FOR_BODY_I_I:%.*]]
; CHECK:       for.body.i.i:
; CHECK-NEXT:    [[__FIRST2_ADDR_07_I_I:%.*]] = phi i32* [ [[INCDEC_PTR1_I_I:%.*]], [[FOR_INC_I_I:%.*]] ], [ [[PTR1:%.*]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I:%.*]] = phi i32* [ [[INCDEC_PTR_I_I:%.*]], [[FOR_INC_I_I]] ], [ [[PTR0]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[T0:%.*]] = load i32, i32* [[__FIRST1_ADDR_06_I_I]]
; CHECK-NEXT:    [[T1:%.*]] = load i32, i32* [[__FIRST2_ADDR_07_I_I]]
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp eq i32 [[T0]], [[T1]]
; CHECK-NEXT:    br i1 [[CMP_I_I_I]], label [[FOR_INC_I_I]], label [[_ZNST3__15EQUALIPKIS2_EEBT_S3_T0__EXIT_LOOPEXIT:%.*]]
; CHECK:       for.inc.i.i:
; CHECK-NEXT:    [[INCDEC_PTR_I_I]] = getelementptr inbounds i32, i32* [[__FIRST1_ADDR_06_I_I]], i64 1
; CHECK-NEXT:    [[INCDEC_PTR1_I_I]] = getelementptr inbounds i32, i32* [[__FIRST2_ADDR_07_I_I]], i64 1
; CHECK-NEXT:    [[CMP_I_I:%.*]] = icmp eq i32* [[INCDEC_PTR_I_I]], [[ADD_PTR]]
; CHECK-NEXT:    br i1 [[CMP_I_I]], label [[_ZNST3__15EQUALIPKIS2_EEBT_S3_T0__EXIT_LOOPEXIT]], label [[FOR_BODY_I_I]]
; CHECK:       _ZNSt3__15equalIPKiS2_EEbT_S3_T0_.exit.loopexit:
; CHECK-NEXT:    [[RETVAL_0_I_I_PH:%.*]] = phi i1 [ false, [[FOR_BODY_I_I]] ], [ true, [[FOR_INC_I_I]] ]
; CHECK-NEXT:    br label [[_ZNST3__15EQUALIPKIS2_EEBT_S3_T0__EXIT]]
; CHECK:       _ZNSt3__15equalIPKiS2_EEbT_S3_T0_.exit:
; CHECK-NEXT:    [[RETVAL_0_I_I:%.*]] = phi i1 [ true, [[ENTRY:%.*]] ], [ [[RETVAL_0_I_I_PH]], [[_ZNST3__15EQUALIPKIS2_EEBT_S3_T0__EXIT_LOOPEXIT]] ]
; CHECK-NEXT:    ret i1 [[RETVAL_0_I_I]]
;
entry:
  %add.ptr = getelementptr inbounds i32, i32* %ptr0, i64 %count
  %cmp5.i.i = icmp eq i64 %count, 0
  br i1 %cmp5.i.i, label %_ZNSt3__15equalIPKiS2_EEbT_S3_T0_.exit, label %for.body.i.i

for.body.i.i:                                     ; preds = %entry, %for.inc.i.i
  %__first2.addr.07.i.i = phi i32* [ %incdec.ptr1.i.i, %for.inc.i.i ], [ %ptr1, %entry ]
  %__first1.addr.06.i.i = phi i32* [ %incdec.ptr.i.i, %for.inc.i.i ], [ %ptr0, %entry ]
  %t0 = load i32, i32* %__first1.addr.06.i.i
  %t1 = load i32, i32* %__first2.addr.07.i.i
  %cmp.i.i.i = icmp eq i32 %t0, %t1
  br i1 %cmp.i.i.i, label %for.inc.i.i, label %_ZNSt3__15equalIPKiS2_EEbT_S3_T0_.exit

for.inc.i.i:                                      ; preds = %for.body.i.i
  %incdec.ptr.i.i = getelementptr inbounds i32, i32* %__first1.addr.06.i.i, i64 1
  %incdec.ptr1.i.i = getelementptr inbounds i32, i32* %__first2.addr.07.i.i, i64 1
  %cmp.i.i = icmp eq i32* %incdec.ptr.i.i, %add.ptr
  br i1 %cmp.i.i, label %_ZNSt3__15equalIPKiS2_EEbT_S3_T0_.exit, label %for.body.i.i

_ZNSt3__15equalIPKiS2_EEbT_S3_T0_.exit:           ; preds = %for.body.i.i, %for.inc.i.i, %entry
  %retval.0.i.i = phi i1 [ true, %entry ], [ true, %for.inc.i.i ], [ false, %for.body.i.i ]
  ret i1 %retval.0.i.i
}

define i1 @_Z21small_index_iterationPKcS0_i(i8* %ptr0, i8* %ptr1, i32 %count) {
; CHECK-LABEL: @_Z21small_index_iterationPKcS0_i(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP8:%.*]] = icmp sgt i32 [[COUNT:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP8]], label [[FOR_BODY_PREHEADER:%.*]], label [[CLEANUP:%.*]]
; CHECK:       for.body.preheader:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[I_011:%.*]] = phi i32 [ [[INC:%.*]], [[FOR_INC:%.*]] ], [ 0, [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[PTR1_ADDR_010:%.*]] = phi i8* [ [[INCDEC_PTR3:%.*]], [[FOR_INC]] ], [ [[PTR1:%.*]], [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[PTR0_ADDR_09:%.*]] = phi i8* [ [[INCDEC_PTR:%.*]], [[FOR_INC]] ], [ [[PTR0:%.*]], [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[T0:%.*]] = load i8, i8* [[PTR0_ADDR_09]]
; CHECK-NEXT:    [[T1:%.*]] = load i8, i8* [[PTR1_ADDR_010]]
; CHECK-NEXT:    [[CMP2:%.*]] = icmp eq i8 [[T0]], [[T1]]
; CHECK-NEXT:    br i1 [[CMP2]], label [[FOR_INC]], label [[CLEANUP_LOOPEXIT:%.*]]
; CHECK:       for.inc:
; CHECK-NEXT:    [[INC]] = add nuw nsw i32 [[I_011]], 1
; CHECK-NEXT:    [[INCDEC_PTR]] = getelementptr inbounds i8, i8* [[PTR0_ADDR_09]], i64 1
; CHECK-NEXT:    [[INCDEC_PTR3]] = getelementptr inbounds i8, i8* [[PTR1_ADDR_010]], i64 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[INC]], [[COUNT]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[CLEANUP_LOOPEXIT]]
; CHECK:       cleanup.loopexit:
; CHECK-NEXT:    [[T2_PH:%.*]] = phi i1 [ false, [[FOR_BODY]] ], [ true, [[FOR_INC]] ]
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    [[T2:%.*]] = phi i1 [ true, [[ENTRY:%.*]] ], [ [[T2_PH]], [[CLEANUP_LOOPEXIT]] ]
; CHECK-NEXT:    ret i1 [[T2]]
;
entry:
  %cmp8 = icmp sgt i32 %count, 0
  br i1 %cmp8, label %for.body, label %cleanup

for.body:                                         ; preds = %entry, %for.inc
  %i.011 = phi i32 [ %inc, %for.inc ], [ 0, %entry ]
  %ptr1.addr.010 = phi i8* [ %incdec.ptr3, %for.inc ], [ %ptr1, %entry ]
  %ptr0.addr.09 = phi i8* [ %incdec.ptr, %for.inc ], [ %ptr0, %entry ]
  %t0 = load i8, i8* %ptr0.addr.09
  %t1 = load i8, i8* %ptr1.addr.010
  %cmp2 = icmp eq i8 %t0, %t1
  br i1 %cmp2, label %for.inc, label %cleanup

for.inc:                                          ; preds = %for.body
  %inc = add nuw nsw i32 %i.011, 1
  %incdec.ptr = getelementptr inbounds i8, i8* %ptr0.addr.09, i64 1
  %incdec.ptr3 = getelementptr inbounds i8, i8* %ptr1.addr.010, i64 1
  %cmp = icmp slt i32 %inc, %count
  br i1 %cmp, label %for.body, label %cleanup

cleanup:                                          ; preds = %for.body, %for.inc, %entry
  %t2 = phi i1 [ true, %entry ], [ true, %for.inc ], [ false, %for.body ]
  ret i1 %t2
}

define i1 @_Z23three_pointer_iterationPKcS0_S0_(i8* %ptr0, i8* %ptr0_end, i8* %ptr1) {
; CHECK-LABEL: @_Z23three_pointer_iterationPKcS0_S0_(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP5_I_I:%.*]] = icmp eq i8* [[PTR0:%.*]], [[PTR0_END:%.*]]
; CHECK-NEXT:    br i1 [[CMP5_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT:%.*]], label [[FOR_BODY_I_I_PREHEADER:%.*]]
; CHECK:       for.body.i.i.preheader:
; CHECK-NEXT:    br label [[FOR_BODY_I_I:%.*]]
; CHECK:       for.body.i.i:
; CHECK-NEXT:    [[__FIRST2_ADDR_07_I_I:%.*]] = phi i8* [ [[INCDEC_PTR1_I_I:%.*]], [[FOR_INC_I_I:%.*]] ], [ [[PTR1:%.*]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I:%.*]] = phi i8* [ [[INCDEC_PTR_I_I:%.*]], [[FOR_INC_I_I]] ], [ [[PTR0]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[T0:%.*]] = load i8, i8* [[__FIRST1_ADDR_06_I_I]]
; CHECK-NEXT:    [[T1:%.*]] = load i8, i8* [[__FIRST2_ADDR_07_I_I]]
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp eq i8 [[T0]], [[T1]]
; CHECK-NEXT:    br i1 [[CMP_I_I_I]], label [[FOR_INC_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT:%.*]]
; CHECK:       for.inc.i.i:
; CHECK-NEXT:    [[INCDEC_PTR_I_I]] = getelementptr inbounds i8, i8* [[__FIRST1_ADDR_06_I_I]], i64 1
; CHECK-NEXT:    [[INCDEC_PTR1_I_I]] = getelementptr inbounds i8, i8* [[__FIRST2_ADDR_07_I_I]], i64 1
; CHECK-NEXT:    [[CMP_I_I:%.*]] = icmp eq i8* [[INCDEC_PTR_I_I]], [[PTR0_END]]
; CHECK-NEXT:    br i1 [[CMP_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT]], label [[FOR_BODY_I_I]]
; CHECK:       _ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit.loopexit:
; CHECK-NEXT:    [[RETVAL_0_I_I_PH:%.*]] = phi i1 [ false, [[FOR_BODY_I_I]] ], [ true, [[FOR_INC_I_I]] ]
; CHECK-NEXT:    br label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT]]
; CHECK:       _ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:
; CHECK-NEXT:    [[RETVAL_0_I_I:%.*]] = phi i1 [ true, [[ENTRY:%.*]] ], [ [[RETVAL_0_I_I_PH]], [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT]] ]
; CHECK-NEXT:    ret i1 [[RETVAL_0_I_I]]
;
entry:
  %cmp5.i.i = icmp eq i8* %ptr0, %ptr0_end
  br i1 %cmp5.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, label %for.body.i.i

for.body.i.i:                                     ; preds = %entry, %for.inc.i.i
  %__first2.addr.07.i.i = phi i8* [ %incdec.ptr1.i.i, %for.inc.i.i ], [ %ptr1, %entry ]
  %__first1.addr.06.i.i = phi i8* [ %incdec.ptr.i.i, %for.inc.i.i ], [ %ptr0, %entry ]
  %t0 = load i8, i8* %__first1.addr.06.i.i
  %t1 = load i8, i8* %__first2.addr.07.i.i
  %cmp.i.i.i = icmp eq i8 %t0, %t1
  br i1 %cmp.i.i.i, label %for.inc.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit

for.inc.i.i:                                      ; preds = %for.body.i.i
  %incdec.ptr.i.i = getelementptr inbounds i8, i8* %__first1.addr.06.i.i, i64 1
  %incdec.ptr1.i.i = getelementptr inbounds i8, i8* %__first2.addr.07.i.i, i64 1
  %cmp.i.i = icmp eq i8* %incdec.ptr.i.i, %ptr0_end
  br i1 %cmp.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, label %for.body.i.i

_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:           ; preds = %for.body.i.i, %for.inc.i.i, %entry
  %retval.0.i.i = phi i1 [ true, %entry ], [ true, %for.inc.i.i ], [ false, %for.body.i.i ]
  ret i1 %retval.0.i.i
}

define i32 @_Z17value_propagationPKcS0_mii(i8* %ptr0, i8* %ptr1, i64 %count, i32 %on_equal, i32 %on_unequal) {
; CHECK-LABEL: @_Z17value_propagationPKcS0_mii(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, i8* [[PTR0:%.*]], i64 [[COUNT:%.*]]
; CHECK-NEXT:    [[CMP5_I_I:%.*]] = icmp eq i64 [[COUNT]], 0
; CHECK-NEXT:    br i1 [[CMP5_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT:%.*]], label [[FOR_BODY_I_I_PREHEADER:%.*]]
; CHECK:       for.body.i.i.preheader:
; CHECK-NEXT:    br label [[FOR_BODY_I_I:%.*]]
; CHECK:       for.body.i.i:
; CHECK-NEXT:    [[__FIRST2_ADDR_07_I_I:%.*]] = phi i8* [ [[INCDEC_PTR1_I_I:%.*]], [[FOR_INC_I_I:%.*]] ], [ [[PTR1:%.*]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I:%.*]] = phi i8* [ [[INCDEC_PTR_I_I:%.*]], [[FOR_INC_I_I]] ], [ [[PTR0]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[T0:%.*]] = load i8, i8* [[__FIRST1_ADDR_06_I_I]]
; CHECK-NEXT:    [[T1:%.*]] = load i8, i8* [[__FIRST2_ADDR_07_I_I]]
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp eq i8 [[T0]], [[T1]]
; CHECK-NEXT:    br i1 [[CMP_I_I_I]], label [[FOR_INC_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT:%.*]]
; CHECK:       for.inc.i.i:
; CHECK-NEXT:    [[INCDEC_PTR_I_I]] = getelementptr inbounds i8, i8* [[__FIRST1_ADDR_06_I_I]], i64 1
; CHECK-NEXT:    [[INCDEC_PTR1_I_I]] = getelementptr inbounds i8, i8* [[__FIRST2_ADDR_07_I_I]], i64 1
; CHECK-NEXT:    [[CMP_I_I:%.*]] = icmp eq i8* [[INCDEC_PTR_I_I]], [[ADD_PTR]]
; CHECK-NEXT:    br i1 [[CMP_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT]], label [[FOR_BODY_I_I]]
; CHECK:       _ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit.loopexit:
; CHECK-NEXT:    [[T2_PH:%.*]] = phi i32 [ [[ON_UNEQUAL:%.*]], [[FOR_BODY_I_I]] ], [ [[ON_EQUAL:%.*]], [[FOR_INC_I_I]] ]
; CHECK-NEXT:    br label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT]]
; CHECK:       _ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:
; CHECK-NEXT:    [[T2:%.*]] = phi i32 [ [[ON_EQUAL]], [[ENTRY:%.*]] ], [ [[T2_PH]], [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT]] ]
; CHECK-NEXT:    ret i32 [[T2]]
;
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr0, i64 %count
  %cmp5.i.i = icmp eq i64 %count, 0
  br i1 %cmp5.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, label %for.body.i.i

for.body.i.i:                                     ; preds = %entry, %for.inc.i.i
  %__first2.addr.07.i.i = phi i8* [ %incdec.ptr1.i.i, %for.inc.i.i ], [ %ptr1, %entry ]
  %__first1.addr.06.i.i = phi i8* [ %incdec.ptr.i.i, %for.inc.i.i ], [ %ptr0, %entry ]
  %t0 = load i8, i8* %__first1.addr.06.i.i
  %t1 = load i8, i8* %__first2.addr.07.i.i
  %cmp.i.i.i = icmp eq i8 %t0, %t1
  br i1 %cmp.i.i.i, label %for.inc.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit

for.inc.i.i:                                      ; preds = %for.body.i.i
  %incdec.ptr.i.i = getelementptr inbounds i8, i8* %__first1.addr.06.i.i, i64 1
  %incdec.ptr1.i.i = getelementptr inbounds i8, i8* %__first2.addr.07.i.i, i64 1
  %cmp.i.i = icmp eq i8* %incdec.ptr.i.i, %add.ptr
  br i1 %cmp.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, label %for.body.i.i

_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:           ; preds = %for.inc.i.i, %for.body.i.i, %entry
  %t2 = phi i32 [ %on_equal, %entry ], [ %on_equal, %for.inc.i.i ], [ %on_unequal, %for.body.i.i ]
  ret i32 %t2
}

define void @_Z20multiple_exit_blocksPKcS0_m(i8* %ptr0, i8* %ptr1, i64 %count) {
; CHECK-LABEL: @_Z20multiple_exit_blocksPKcS0_m(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, i8* [[PTR0:%.*]], i64 [[COUNT:%.*]]
; CHECK-NEXT:    [[CMP5_I_I:%.*]] = icmp eq i64 [[COUNT]], 0
; CHECK-NEXT:    br i1 [[CMP5_I_I]], label [[IF_END:%.*]], label [[FOR_BODY_I_I_PREHEADER:%.*]]
; CHECK:       for.body.i.i.preheader:
; CHECK-NEXT:    br label [[FOR_BODY_I_I:%.*]]
; CHECK:       for.body.i.i:
; CHECK-NEXT:    [[__FIRST2_ADDR_07_I_I:%.*]] = phi i8* [ [[INCDEC_PTR1_I_I:%.*]], [[FOR_INC_I_I:%.*]] ], [ [[PTR1:%.*]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I:%.*]] = phi i8* [ [[INCDEC_PTR_I_I:%.*]], [[FOR_INC_I_I]] ], [ [[PTR0]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[T0:%.*]] = load i8, i8* [[__FIRST1_ADDR_06_I_I]]
; CHECK-NEXT:    [[T1:%.*]] = load i8, i8* [[__FIRST2_ADDR_07_I_I]]
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp eq i8 [[T0]], [[T1]]
; CHECK-NEXT:    br i1 [[CMP_I_I_I]], label [[FOR_INC_I_I]], label [[IF_THEN:%.*]]
; CHECK:       for.inc.i.i:
; CHECK-NEXT:    [[INCDEC_PTR_I_I]] = getelementptr inbounds i8, i8* [[__FIRST1_ADDR_06_I_I]], i64 1
; CHECK-NEXT:    [[INCDEC_PTR1_I_I]] = getelementptr inbounds i8, i8* [[__FIRST2_ADDR_07_I_I]], i64 1
; CHECK-NEXT:    [[CMP_I_I:%.*]] = icmp eq i8* [[INCDEC_PTR_I_I]], [[ADD_PTR]]
; CHECK-NEXT:    br i1 [[CMP_I_I]], label [[IF_END_LOOPEXIT:%.*]], label [[FOR_BODY_I_I]]
; CHECK:       if.then:
; CHECK-NEXT:    tail call void @_Z17callee_on_unequalv()
; CHECK-NEXT:    br label [[RETURN:%.*]]
; CHECK:       if.end.loopexit:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    tail call void @_Z17callee_on_successv()
; CHECK-NEXT:    br label [[RETURN]]
; CHECK:       return:
; CHECK-NEXT:    ret void
;
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr0, i64 %count
  %cmp5.i.i = icmp eq i64 %count, 0
  br i1 %cmp5.i.i, label %if.end, label %for.body.i.i

for.body.i.i:                                     ; preds = %entry, %for.inc.i.i
  %__first2.addr.07.i.i = phi i8* [ %incdec.ptr1.i.i, %for.inc.i.i ], [ %ptr1, %entry ]
  %__first1.addr.06.i.i = phi i8* [ %incdec.ptr.i.i, %for.inc.i.i ], [ %ptr0, %entry ]
  %t0 = load i8, i8* %__first1.addr.06.i.i
  %t1 = load i8, i8* %__first2.addr.07.i.i
  %cmp.i.i.i = icmp eq i8 %t0, %t1
  br i1 %cmp.i.i.i, label %for.inc.i.i, label %if.then

for.inc.i.i:                                      ; preds = %for.body.i.i
  %incdec.ptr.i.i = getelementptr inbounds i8, i8* %__first1.addr.06.i.i, i64 1
  %incdec.ptr1.i.i = getelementptr inbounds i8, i8* %__first2.addr.07.i.i, i64 1
  %cmp.i.i = icmp eq i8* %incdec.ptr.i.i, %add.ptr
  br i1 %cmp.i.i, label %if.end, label %for.body.i.i

if.then:                                          ; preds = %for.body.i.i
  tail call void @_Z17callee_on_unequalv()
  br label %return

if.end:                                           ; preds = %for.inc.i.i, %entry
  tail call void @_Z17callee_on_successv()
  br label %return

return:                                           ; preds = %if.end, %if.then
  ret void
}
declare void @_Z17callee_on_unequalv()
declare void @_Z17callee_on_successv()

define void @_Z13multiple_phisPKcS0_mS0_S0_S0_S0_PS0_S1_(i8* %ptr0, i8* %ptr1, i64 %count, i8* %v0, i8* %v1, i8* %v2, i8* %v3, i8** %out0, i8** %out1) {
; CHECK-LABEL: @_Z13multiple_phisPKcS0_mS0_S0_S0_S0_PS0_S1_(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, i8* [[PTR0:%.*]], i64 [[COUNT:%.*]]
; CHECK-NEXT:    [[CMP5_I_I:%.*]] = icmp eq i64 [[COUNT]], 0
; CHECK-NEXT:    br i1 [[CMP5_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT:%.*]], label [[FOR_BODY_I_I_PREHEADER:%.*]]
; CHECK:       for.body.i.i.preheader:
; CHECK-NEXT:    br label [[FOR_BODY_I_I:%.*]]
; CHECK:       for.body.i.i:
; CHECK-NEXT:    [[__FIRST2_ADDR_07_I_I:%.*]] = phi i8* [ [[INCDEC_PTR1_I_I:%.*]], [[FOR_INC_I_I:%.*]] ], [ [[PTR1:%.*]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I:%.*]] = phi i8* [ [[INCDEC_PTR_I_I:%.*]], [[FOR_INC_I_I]] ], [ [[PTR0]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[T0:%.*]] = load i8, i8* [[__FIRST1_ADDR_06_I_I]]
; CHECK-NEXT:    [[T1:%.*]] = load i8, i8* [[__FIRST2_ADDR_07_I_I]]
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp eq i8 [[T0]], [[T1]]
; CHECK-NEXT:    br i1 [[CMP_I_I_I]], label [[FOR_INC_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT:%.*]]
; CHECK:       for.inc.i.i:
; CHECK-NEXT:    [[INCDEC_PTR_I_I]] = getelementptr inbounds i8, i8* [[__FIRST1_ADDR_06_I_I]], i64 1
; CHECK-NEXT:    [[INCDEC_PTR1_I_I]] = getelementptr inbounds i8, i8* [[__FIRST2_ADDR_07_I_I]], i64 1
; CHECK-NEXT:    [[CMP_I_I:%.*]] = icmp eq i8* [[INCDEC_PTR_I_I]], [[ADD_PTR]]
; CHECK-NEXT:    br i1 [[CMP_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT]], label [[FOR_BODY_I_I]]
; CHECK:       _ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit.loopexit:
; CHECK-NEXT:    [[T2_PH:%.*]] = phi i8* [ [[V2:%.*]], [[FOR_BODY_I_I]] ], [ [[V0:%.*]], [[FOR_INC_I_I]] ]
; CHECK-NEXT:    [[T3_PH:%.*]] = phi i8* [ [[V3:%.*]], [[FOR_BODY_I_I]] ], [ [[V1:%.*]], [[FOR_INC_I_I]] ]
; CHECK-NEXT:    br label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT]]
; CHECK:       _ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:
; CHECK-NEXT:    [[T2:%.*]] = phi i8* [ [[V0]], [[ENTRY:%.*]] ], [ [[T2_PH]], [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT]] ]
; CHECK-NEXT:    [[T3:%.*]] = phi i8* [ [[V1]], [[ENTRY]] ], [ [[T3_PH]], [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT]] ]
; CHECK-NEXT:    store i8* [[T2]], i8** [[OUT0:%.*]]
; CHECK-NEXT:    store i8* [[T3]], i8** [[OUT1:%.*]]
; CHECK-NEXT:    ret void
;
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr0, i64 %count
  %cmp5.i.i = icmp eq i64 %count, 0
  br i1 %cmp5.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, label %for.body.i.i

for.body.i.i:                                     ; preds = %entry, %for.inc.i.i
  %__first2.addr.07.i.i = phi i8* [ %incdec.ptr1.i.i, %for.inc.i.i ], [ %ptr1, %entry ]
  %__first1.addr.06.i.i = phi i8* [ %incdec.ptr.i.i, %for.inc.i.i ], [ %ptr0, %entry ]
  %t0 = load i8, i8* %__first1.addr.06.i.i
  %t1 = load i8, i8* %__first2.addr.07.i.i
  %cmp.i.i.i = icmp eq i8 %t0, %t1
  br i1 %cmp.i.i.i, label %for.inc.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit

for.inc.i.i:                                      ; preds = %for.body.i.i
  %incdec.ptr.i.i = getelementptr inbounds i8, i8* %__first1.addr.06.i.i, i64 1
  %incdec.ptr1.i.i = getelementptr inbounds i8, i8* %__first2.addr.07.i.i, i64 1
  %cmp.i.i = icmp eq i8* %incdec.ptr.i.i, %add.ptr
  br i1 %cmp.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, label %for.body.i.i

_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:           ; preds = %for.inc.i.i, %for.body.i.i, %entry
  %t2 = phi i8* [ %v0, %entry ], [ %v0, %for.inc.i.i ], [ %v2, %for.body.i.i ]
  %t3 = phi i8* [ %v1, %entry ], [ %v1, %for.inc.i.i ], [ %v3, %for.body.i.i ]
  store i8* %t2, i8** %out0
  store i8* %t3, i8** %out1
  ret void
}

define void @_Z16loop_within_loopmPPKcS1_Pm(i64 %outer_count, i8** %ptr0, i8** %ptr1, i64* %count) {
; CHECK-LABEL: @_Z16loop_within_loopmPPKcS1_Pm(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP11:%.*]] = icmp eq i64 [[OUTER_COUNT:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP11]], label [[FOR_COND_CLEANUP:%.*]], label [[FOR_BODY_PREHEADER:%.*]]
; CHECK:       for.body.preheader:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.cond.cleanup.loopexit:
; CHECK-NEXT:    br label [[FOR_COND_CLEANUP]]
; CHECK:       for.cond.cleanup:
; CHECK-NEXT:    ret void
; CHECK:       for.body:
; CHECK-NEXT:    [[I_012:%.*]] = phi i64 [ [[INC:%.*]], [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT:%.*]] ], [ 0, [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8*, i8** [[PTR0:%.*]], i64 [[I_012]]
; CHECK-NEXT:    [[T0:%.*]] = load i8*, i8** [[ARRAYIDX]]
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i64, i64* [[COUNT:%.*]], i64 [[I_012]]
; CHECK-NEXT:    [[T1:%.*]] = load i64, i64* [[ARRAYIDX2]]
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, i8* [[T0]], i64 [[T1]]
; CHECK-NEXT:    [[CMP5_I_I:%.*]] = icmp eq i64 [[T1]], 0
; CHECK-NEXT:    br i1 [[CMP5_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT]], label [[FOR_BODY_I_I_PREHEADER:%.*]]
; CHECK:       for.body.i.i.preheader:
; CHECK-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds i8*, i8** [[PTR1:%.*]], i64 [[I_012]]
; CHECK-NEXT:    [[T2:%.*]] = load i8*, i8** [[ARRAYIDX3]]
; CHECK-NEXT:    br label [[FOR_BODY_I_I:%.*]]
; CHECK:       for.body.i.i:
; CHECK-NEXT:    [[__FIRST2_ADDR_07_I_I:%.*]] = phi i8* [ [[INCDEC_PTR1_I_I:%.*]], [[FOR_INC_I_I:%.*]] ], [ [[T2]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I:%.*]] = phi i8* [ [[INCDEC_PTR_I_I:%.*]], [[FOR_INC_I_I]] ], [ [[T0]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[T3:%.*]] = load i8, i8* [[__FIRST1_ADDR_06_I_I]]
; CHECK-NEXT:    [[T4:%.*]] = load i8, i8* [[__FIRST2_ADDR_07_I_I]]
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp eq i8 [[T3]], [[T4]]
; CHECK-NEXT:    br i1 [[CMP_I_I_I]], label [[FOR_INC_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT:%.*]]
; CHECK:       for.inc.i.i:
; CHECK-NEXT:    [[INCDEC_PTR_I_I]] = getelementptr inbounds i8, i8* [[__FIRST1_ADDR_06_I_I]], i64 1
; CHECK-NEXT:    [[INCDEC_PTR1_I_I]] = getelementptr inbounds i8, i8* [[__FIRST2_ADDR_07_I_I]], i64 1
; CHECK-NEXT:    [[CMP_I_I:%.*]] = icmp eq i8* [[INCDEC_PTR_I_I]], [[ADD_PTR]]
; CHECK-NEXT:    br i1 [[CMP_I_I]], label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT]], label [[FOR_BODY_I_I]]
; CHECK:       _ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit.loopexit:
; CHECK-NEXT:    [[RETVAL_0_I_I_PH:%.*]] = phi i1 [ false, [[FOR_BODY_I_I]] ], [ true, [[FOR_INC_I_I]] ]
; CHECK-NEXT:    br label [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT]]
; CHECK:       _ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:
; CHECK-NEXT:    [[RETVAL_0_I_I:%.*]] = phi i1 [ true, [[FOR_BODY]] ], [ [[RETVAL_0_I_I_PH]], [[_ZNST3__15EQUALIPKCS2_EEBT_S3_T0__EXIT_LOOPEXIT]] ]
; CHECK-NEXT:    tail call void @_Z4sinkb(i1 [[RETVAL_0_I_I]])
; CHECK-NEXT:    [[INC]] = add nuw i64 [[I_012]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[INC]], [[OUTER_COUNT]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_COND_CLEANUP_LOOPEXIT:%.*]], label [[FOR_BODY]]
;
entry:
  %cmp11 = icmp eq i64 %outer_count, 0
  br i1 %cmp11, label %for.cond.cleanup, label %for.body

for.cond.cleanup:                                 ; preds = %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, %entry
  ret void

for.body:                                         ; preds = %entry, %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit
  %i.012 = phi i64 [ %inc, %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit ], [ 0, %entry ]
  %arrayidx = getelementptr inbounds i8*, i8** %ptr0, i64 %i.012
  %t0 = load i8*, i8** %arrayidx
  %arrayidx2 = getelementptr inbounds i64, i64* %count, i64 %i.012
  %t1 = load i64, i64* %arrayidx2
  %add.ptr = getelementptr inbounds i8, i8* %t0, i64 %t1
  %cmp5.i.i = icmp eq i64 %t1, 0
  br i1 %cmp5.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, label %for.body.i.i.preheader

for.body.i.i.preheader:                           ; preds = %for.body
  %arrayidx3 = getelementptr inbounds i8*, i8** %ptr1, i64 %i.012
  %t2 = load i8*, i8** %arrayidx3
  br label %for.body.i.i

for.body.i.i:                                     ; preds = %for.body.i.i.preheader, %for.inc.i.i
  %__first2.addr.07.i.i = phi i8* [ %incdec.ptr1.i.i, %for.inc.i.i ], [ %t2, %for.body.i.i.preheader ]
  %__first1.addr.06.i.i = phi i8* [ %incdec.ptr.i.i, %for.inc.i.i ], [ %t0, %for.body.i.i.preheader ]
  %t3 = load i8, i8* %__first1.addr.06.i.i
  %t4 = load i8, i8* %__first2.addr.07.i.i
  %cmp.i.i.i = icmp eq i8 %t3, %t4
  br i1 %cmp.i.i.i, label %for.inc.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit

for.inc.i.i:                                      ; preds = %for.body.i.i
  %incdec.ptr.i.i = getelementptr inbounds i8, i8* %__first1.addr.06.i.i, i64 1
  %incdec.ptr1.i.i = getelementptr inbounds i8, i8* %__first2.addr.07.i.i, i64 1
  %cmp.i.i = icmp eq i8* %incdec.ptr.i.i, %add.ptr
  br i1 %cmp.i.i, label %_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit, label %for.body.i.i

_ZNSt3__15equalIPKcS2_EEbT_S3_T0_.exit:           ; preds = %for.body.i.i, %for.inc.i.i, %for.body
  %retval.0.i.i = phi i1 [ true, %for.body ], [ true, %for.inc.i.i ], [ false, %for.body.i.i ]
  tail call void @_Z4sinkb(i1 %retval.0.i.i)
  %inc = add nuw i64 %i.012, 1
  %cmp = icmp eq i64 %inc, %outer_count
  br i1 %cmp, label %for.cond.cleanup, label %for.body
}
declare void @_Z4sinkb(i1)

define void @_Z42loop_within_loop_with_multiple_exit_blocksmPPKcS1_Pm(i64 %outer_count, i8** %ptr0, i8** %ptr1, i64* %count) {
; CHECK-LABEL: @_Z42loop_within_loop_with_multiple_exit_blocksmPPKcS1_Pm(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP11:%.*]] = icmp eq i64 [[OUTER_COUNT:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP11]], label [[CLEANUP:%.*]], label [[FOR_BODY_PREHEADER:%.*]]
; CHECK:       for.body.preheader:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[I_012:%.*]] = phi i64 [ [[INC:%.*]], [[IF_END:%.*]] ], [ 0, [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8*, i8** [[PTR0:%.*]], i64 [[I_012]]
; CHECK-NEXT:    [[T0:%.*]] = load i8*, i8** [[ARRAYIDX]]
; CHECK-NEXT:    [[ARRAYIDX2:%.*]] = getelementptr inbounds i64, i64* [[COUNT:%.*]], i64 [[I_012]]
; CHECK-NEXT:    [[T1:%.*]] = load i64, i64* [[ARRAYIDX2]]
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds i8, i8* [[T0]], i64 [[T1]]
; CHECK-NEXT:    [[CMP5_I_I:%.*]] = icmp eq i64 [[T1]], 0
; CHECK-NEXT:    br i1 [[CMP5_I_I]], label [[IF_END]], label [[FOR_BODY_I_I_PREHEADER:%.*]]
; CHECK:       for.body.i.i.preheader:
; CHECK-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds i8*, i8** [[PTR1:%.*]], i64 [[I_012]]
; CHECK-NEXT:    [[T2:%.*]] = load i8*, i8** [[ARRAYIDX3]]
; CHECK-NEXT:    br label [[FOR_BODY_I_I:%.*]]
; CHECK:       for.body.i.i:
; CHECK-NEXT:    [[__FIRST2_ADDR_07_I_I:%.*]] = phi i8* [ [[INCDEC_PTR1_I_I:%.*]], [[FOR_INC_I_I:%.*]] ], [ [[T2]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[__FIRST1_ADDR_06_I_I:%.*]] = phi i8* [ [[INCDEC_PTR_I_I:%.*]], [[FOR_INC_I_I]] ], [ [[T0]], [[FOR_BODY_I_I_PREHEADER]] ]
; CHECK-NEXT:    [[T3:%.*]] = load i8, i8* [[__FIRST1_ADDR_06_I_I]]
; CHECK-NEXT:    [[T4:%.*]] = load i8, i8* [[__FIRST2_ADDR_07_I_I]]
; CHECK-NEXT:    [[CMP_I_I_I:%.*]] = icmp eq i8 [[T3]], [[T4]]
; CHECK-NEXT:    br i1 [[CMP_I_I_I]], label [[FOR_INC_I_I]], label [[IF_THEN:%.*]]
; CHECK:       for.inc.i.i:
; CHECK-NEXT:    [[INCDEC_PTR_I_I]] = getelementptr inbounds i8, i8* [[__FIRST1_ADDR_06_I_I]], i64 1
; CHECK-NEXT:    [[INCDEC_PTR1_I_I]] = getelementptr inbounds i8, i8* [[__FIRST2_ADDR_07_I_I]], i64 1
; CHECK-NEXT:    [[CMP_I_I:%.*]] = icmp eq i8* [[INCDEC_PTR_I_I]], [[ADD_PTR]]
; CHECK-NEXT:    br i1 [[CMP_I_I]], label [[IF_END_LOOPEXIT:%.*]], label [[FOR_BODY_I_I]]
; CHECK:       if.then:
; CHECK-NEXT:    tail call void @_Z17callee_on_unequalv()
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       if.end.loopexit:
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    tail call void @_Z17callee_on_successv()
; CHECK-NEXT:    [[INC]] = add nuw i64 [[I_012]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[INC]], [[OUTER_COUNT]]
; CHECK-NEXT:    br i1 [[CMP]], label [[CLEANUP_LOOPEXIT:%.*]], label [[FOR_BODY]]
; CHECK:       cleanup.loopexit:
; CHECK-NEXT:    br label [[CLEANUP]]
; CHECK:       cleanup:
; CHECK-NEXT:    ret void
;
entry:
  %cmp11 = icmp eq i64 %outer_count, 0
  br i1 %cmp11, label %cleanup, label %for.body

for.body:                                         ; preds = %entry, %if.end
  %i.012 = phi i64 [ %inc, %if.end ], [ 0, %entry ]
  %arrayidx = getelementptr inbounds i8*, i8** %ptr0, i64 %i.012
  %t0 = load i8*, i8** %arrayidx
  %arrayidx2 = getelementptr inbounds i64, i64* %count, i64 %i.012
  %t1 = load i64, i64* %arrayidx2
  %add.ptr = getelementptr inbounds i8, i8* %t0, i64 %t1
  %cmp5.i.i = icmp eq i64 %t1, 0
  br i1 %cmp5.i.i, label %if.end, label %for.body.i.i.preheader

for.body.i.i.preheader:                           ; preds = %for.body
  %arrayidx3 = getelementptr inbounds i8*, i8** %ptr1, i64 %i.012
  %t2 = load i8*, i8** %arrayidx3
  br label %for.body.i.i

for.body.i.i:                                     ; preds = %for.body.i.i.preheader, %for.inc.i.i
  %__first2.addr.07.i.i = phi i8* [ %incdec.ptr1.i.i, %for.inc.i.i ], [ %t2, %for.body.i.i.preheader ]
  %__first1.addr.06.i.i = phi i8* [ %incdec.ptr.i.i, %for.inc.i.i ], [ %t0, %for.body.i.i.preheader ]
  %t3 = load i8, i8* %__first1.addr.06.i.i
  %t4 = load i8, i8* %__first2.addr.07.i.i
  %cmp.i.i.i = icmp eq i8 %t3, %t4
  br i1 %cmp.i.i.i, label %for.inc.i.i, label %if.then

for.inc.i.i:                                      ; preds = %for.body.i.i
  %incdec.ptr.i.i = getelementptr inbounds i8, i8* %__first1.addr.06.i.i, i64 1
  %incdec.ptr1.i.i = getelementptr inbounds i8, i8* %__first2.addr.07.i.i, i64 1
  %cmp.i.i = icmp eq i8* %incdec.ptr.i.i, %add.ptr
  br i1 %cmp.i.i, label %if.end, label %for.body.i.i

if.then:                                          ; preds = %for.body.i.i
  tail call void @_Z17callee_on_unequalv()
  br label %cleanup

if.end:                                           ; preds = %for.inc.i.i, %for.body
  tail call void @_Z17callee_on_successv()
  %inc = add nuw i64 %i.012, 1
  %cmp = icmp eq i64 %inc, %outer_count
  br i1 %cmp, label %cleanup, label %for.body

cleanup:                                          ; preds = %if.end, %entry, %if.then
  ret void
}

define void @_Z21endless_loop_if_equalPiS_(i32* %a, i32* %b) {
; CHECK-LABEL: @_Z21endless_loop_if_equalPiS_(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_COND:%.*]]
; CHECK:       for.cond.loopexit:
; CHECK-NEXT:    br label [[FOR_COND]]
; CHECK:       for.cond:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.cond1:
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i64 [[INDVARS_IV_NEXT:%.*]], 4
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_COND_LOOPEXIT:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[FOR_COND]] ], [ [[INDVARS_IV_NEXT]], [[FOR_COND1:%.*]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, i32* [[A:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, i32* [[ARRAYIDX]]
; CHECK-NEXT:    [[ARRAYIDX3:%.*]] = getelementptr inbounds i32, i32* [[B:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, i32* [[ARRAYIDX3]]
; CHECK-NEXT:    [[CMP4:%.*]] = icmp eq i32 [[TMP0]], [[TMP1]]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    br i1 [[CMP4]], label [[FOR_COND1]], label [[RETURN:%.*]]
; CHECK:       return:
; CHECK-NEXT:    ret void
;
entry:
  br label %for.cond

for.cond:                                         ; preds = %for.cond1, %entry
  br label %for.body

for.cond1:                                        ; preds = %for.body
  %cmp = icmp ult i64 %indvars.iv.next, 4
  br i1 %cmp, label %for.body, label %for.cond

for.body:                                         ; preds = %for.cond, %for.cond1
  %indvars.iv = phi i64 [ 0, %for.cond ], [ %indvars.iv.next, %for.cond1 ]
  %arrayidx = getelementptr inbounds i32, i32* %a, i64 %indvars.iv
  %0 = load i32, i32* %arrayidx
  %arrayidx3 = getelementptr inbounds i32, i32* %b, i64 %indvars.iv
  %1 = load i32, i32* %arrayidx3
  %cmp4 = icmp eq i32 %0, %1
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  br i1 %cmp4, label %for.cond1, label %return

return:                                           ; preds = %for.body
  ret void
}

define i1 @_Z21load_of_bitcastsPKcPKfm(i8* %ptr0, float* %ptr1, i64 %count) {
; CHECK-LABEL: @_Z21load_of_bitcastsPKcPKfm(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP13:%.*]] = icmp eq i64 [[COUNT:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP13]], label [[CLEANUP3:%.*]], label [[FOR_BODY_PREHEADER:%.*]]
; CHECK:       for.body.preheader:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[PTR0_ADDR_016:%.*]] = phi i8* [ [[ADD_PTR:%.*]], [[FOR_INC:%.*]] ], [ [[PTR0:%.*]], [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[I_015:%.*]] = phi i64 [ [[INC:%.*]], [[FOR_INC]] ], [ 0, [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[PTR1_ADDR_014:%.*]] = phi float* [ [[INCDEC_PTR:%.*]], [[FOR_INC]] ], [ [[PTR1:%.*]], [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[V0_0__SROA_CAST:%.*]] = bitcast i8* [[PTR0_ADDR_016]] to i32*
; CHECK-NEXT:    [[V0_0_COPYLOAD:%.*]] = load i32, i32* [[V0_0__SROA_CAST]]
; CHECK-NEXT:    [[V1_0__SROA_CAST:%.*]] = bitcast float* [[PTR1_ADDR_014]] to i32*
; CHECK-NEXT:    [[V1_0_COPYLOAD:%.*]] = load i32, i32* [[V1_0__SROA_CAST]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i32 [[V0_0_COPYLOAD]], [[V1_0_COPYLOAD]]
; CHECK-NEXT:    br i1 [[CMP1]], label [[FOR_INC]], label [[CLEANUP3_LOOPEXIT:%.*]]
; CHECK:       for.inc:
; CHECK-NEXT:    [[INC]] = add nuw i64 [[I_015]], 1
; CHECK-NEXT:    [[ADD_PTR]] = getelementptr inbounds i8, i8* [[PTR0_ADDR_016]], i64 4
; CHECK-NEXT:    [[INCDEC_PTR]] = getelementptr inbounds float, float* [[PTR1_ADDR_014]], i64 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i64 [[INC]], [[COUNT]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[CLEANUP3_LOOPEXIT]]
; CHECK:       cleanup3.loopexit:
; CHECK-NEXT:    [[RES_PH:%.*]] = phi i1 [ false, [[FOR_BODY]] ], [ true, [[FOR_INC]] ]
; CHECK-NEXT:    br label [[CLEANUP3]]
; CHECK:       cleanup3:
; CHECK-NEXT:    [[RES:%.*]] = phi i1 [ true, [[ENTRY:%.*]] ], [ [[RES_PH]], [[CLEANUP3_LOOPEXIT]] ]
; CHECK-NEXT:    ret i1 [[RES]]
;
entry:
  %cmp13 = icmp eq i64 %count, 0
  br i1 %cmp13, label %cleanup3, label %for.body

for.body:                                         ; preds = %entry, %for.inc
  %ptr0.addr.016 = phi i8* [ %add.ptr, %for.inc ], [ %ptr0, %entry ]
  %i.015 = phi i64 [ %inc, %for.inc ], [ 0, %entry ]
  %ptr1.addr.014 = phi float* [ %incdec.ptr, %for.inc ], [ %ptr1, %entry ]
  %v0.0..sroa_cast = bitcast i8* %ptr0.addr.016 to i32*
  %v0.0.copyload = load i32, i32* %v0.0..sroa_cast
  %v1.0..sroa_cast = bitcast float* %ptr1.addr.014 to i32*
  %v1.0.copyload = load i32, i32* %v1.0..sroa_cast
  %cmp1 = icmp eq i32 %v0.0.copyload, %v1.0.copyload
  br i1 %cmp1, label %for.inc, label %cleanup3

for.inc:                                          ; preds = %for.body
  %inc = add nuw i64 %i.015, 1
  %add.ptr = getelementptr inbounds i8, i8* %ptr0.addr.016, i64 4
  %incdec.ptr = getelementptr inbounds float, float* %ptr1.addr.014, i64 1
  %cmp = icmp ult i64 %inc, %count
  br i1 %cmp, label %for.body, label %cleanup3

cleanup3:                                         ; preds = %for.body, %for.inc, %entry
  %res = phi i1 [ true, %entry ], [ true, %for.inc ], [ false, %for.body ]
  ret i1 %res
}

; FIXME
define i1 @_Z17overlapping_loadsPKcS0_m(i8* %ptr0, i8* %ptr1, i64 %count) {
; CHECK-LABEL: @_Z17overlapping_loadsPKcS0_m(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP14:%.*]] = icmp eq i64 [[COUNT:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP14]], label [[CLEANUP4:%.*]], label [[FOR_BODY_PREHEADER:%.*]]
; CHECK:       for.body.preheader:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[PTR0_ADDR_017:%.*]] = phi i8* [ [[INCDEC_PTR:%.*]], [[FOR_INC:%.*]] ], [ [[PTR0:%.*]], [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[I_016:%.*]] = phi i64 [ [[INC:%.*]], [[FOR_INC]] ], [ 0, [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[PTR1_ADDR_015:%.*]] = phi i8* [ [[INCDEC_PTR3:%.*]], [[FOR_INC]] ], [ [[PTR1:%.*]], [[FOR_BODY_PREHEADER]] ]
; CHECK-NEXT:    [[V0_0__SROA_CAST:%.*]] = bitcast i8* [[PTR0_ADDR_017]] to i32*
; CHECK-NEXT:    [[V0_0_COPYLOAD:%.*]] = load i32, i32* [[V0_0__SROA_CAST]]
; CHECK-NEXT:    [[V1_0__SROA_CAST:%.*]] = bitcast i8* [[PTR1_ADDR_015]] to i32*
; CHECK-NEXT:    [[V1_0_COPYLOAD:%.*]] = load i32, i32* [[V1_0__SROA_CAST]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i32 [[V0_0_COPYLOAD]], [[V1_0_COPYLOAD]]
; CHECK-NEXT:    br i1 [[CMP1]], label [[FOR_INC]], label [[CLEANUP4_LOOPEXIT:%.*]]
; CHECK:       for.inc:
; CHECK-NEXT:    [[INC]] = add nuw i64 [[I_016]], 1
; CHECK-NEXT:    [[INCDEC_PTR]] = getelementptr inbounds i8, i8* [[PTR0_ADDR_017]], i64 1
; CHECK-NEXT:    [[INCDEC_PTR3]] = getelementptr inbounds i8, i8* [[PTR1_ADDR_015]], i64 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp ult i64 [[INC]], [[COUNT]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[CLEANUP4_LOOPEXIT]]
; CHECK:       cleanup4.loopexit:
; CHECK-NEXT:    [[RES_PH:%.*]] = phi i1 [ false, [[FOR_BODY]] ], [ true, [[FOR_INC]] ]
; CHECK-NEXT:    br label [[CLEANUP4]]
; CHECK:       cleanup4:
; CHECK-NEXT:    [[RES:%.*]] = phi i1 [ true, [[ENTRY:%.*]] ], [ [[RES_PH]], [[CLEANUP4_LOOPEXIT]] ]
; CHECK-NEXT:    ret i1 [[RES]]
;
entry:
  %cmp14 = icmp eq i64 %count, 0
  br i1 %cmp14, label %cleanup4, label %for.body

for.body:                                         ; preds = %entry, %for.inc
  %ptr0.addr.017 = phi i8* [ %incdec.ptr, %for.inc ], [ %ptr0, %entry ]
  %i.016 = phi i64 [ %inc, %for.inc ], [ 0, %entry ]
  %ptr1.addr.015 = phi i8* [ %incdec.ptr3, %for.inc ], [ %ptr1, %entry ]
  %v0.0..sroa_cast = bitcast i8* %ptr0.addr.017 to i32*
  %v0.0.copyload = load i32, i32* %v0.0..sroa_cast
  %v1.0..sroa_cast = bitcast i8* %ptr1.addr.015 to i32*
  %v1.0.copyload = load i32, i32* %v1.0..sroa_cast
  %cmp1 = icmp eq i32 %v0.0.copyload, %v1.0.copyload
  br i1 %cmp1, label %for.inc, label %cleanup4

for.inc:                                          ; preds = %for.body
  %inc = add nuw i64 %i.016, 1
  %incdec.ptr = getelementptr inbounds i8, i8* %ptr0.addr.017, i64 1
  %incdec.ptr3 = getelementptr inbounds i8, i8* %ptr1.addr.015, i64 1
  %cmp = icmp ult i64 %inc, %count
  br i1 %cmp, label %for.body, label %cleanup4

cleanup4:                                         ; preds = %for.body, %for.inc, %entry
  %res = phi i1 [ true, %entry ], [ true, %for.inc ], [ false, %for.body ]
  ret i1 %res
}
