// REQUIRES: x86
// RUN: llvm-mc -filetype=obj -triple=x86_64-pc-linux %s -o %t.o
// RUN: ld.lld %t.o -shared -o %t.so
// RUN: llvm-readelf -S %t.so | FileCheck %s -check-prefix=SECTION
// RUN: llvm-objdump -d %t.so | FileCheck %s

// SECTION: .dynamic DYNAMIC 0000000000003000
// SECTION: .got PROGBITS 0000000000003070 003070 000000

// All the _GLOBAL_OFFSET_TABLE_ occurrences below refer to the address
// of GOT base, not the address of the symbol _GLOBAL_OFFSET_TABLE_. These
// instructions are special and produce GOT base relative relocations. We
// currently use .got end as the GOT base, which is not equal to
// the address of the special symbol _GLOBAL_OFFSET_TABLE_.

// The assembly is generated by
// gcc -O2 -S -mcmodel=medium -fPIC a.c
// This computes the pc-relative address (runtime address) of _DYNAMIC.
//
// extern long _DYNAMIC[] __attribute__((visibility("hidden")));
// long* dynamic() { return _DYNAMIC; }

// 0x3070 (.got end) - 0x1007 = 8297
// 0x3000 (_DYNAMIC) - 0x3070 (.got end) = -112
// CHECK:      1000: {{.*}} leaq 8297(%rip), %rdx
// CHECK-NEXT: 1007: {{.*}} movabsq $-112, %rax
.global dynamic
dynamic:
  leaq _GLOBAL_OFFSET_TABLE_(%rip), %rdx
  movabsq $_DYNAMIC@GOTOFF, %rax
  addq %rdx, %rax
  ret
