; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -disable-peephole -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=ALL,NOVL,NODQ,NOVLDQ,KNL
; RUN: llc < %s -disable-peephole -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512vl,+avx512dq | FileCheck %s --check-prefixes=ALL,VL,VLDQ,VLBW
; RUN: llc < %s -disable-peephole -mtriple=x86_64-unknown-unknown -mattr=avx512vl  | FileCheck %s --check-prefixes=ALL,NODQ,VL,VLNODQ,VLNOBW
; RUN: llc < %s -disable-peephole -mtriple=x86_64-unknown-unknown -mattr=avx512dq  | FileCheck %s --check-prefixes=ALL,NOVL,DQNOVL
; RUN: llc < %s -disable-peephole -mtriple=x86_64-unknown-unknown -mattr=avx512bw  | FileCheck %s --check-prefixes=ALL,NOVL,NODQ,NOVLDQ,AVX512BW
; RUN: llc < %s -disable-peephole -mtriple=x86_64-unknown-unknown -mattr=avx512vl,avx512dq  | FileCheck %s --check-prefixes=ALL,VL,VLDQ,VLNOBW
; RUN: llc < %s -disable-peephole -mtriple=x86_64-unknown-unknown -mattr=avx512vl,avx512bw  | FileCheck %s --check-prefixes=ALL,NODQ,VL,VLNODQ,VLBW


define <16 x float> @sitof32(<16 x i32> %a) nounwind {
; ALL-LABEL: sitof32:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvtdq2ps %zmm0, %zmm0
; ALL-NEXT:    retq
  %b = sitofp <16 x i32> %a to <16 x float>
  ret <16 x float> %b
}

define <8 x double> @sltof864(<8 x i64> %a) {
; NODQ-LABEL: sltof864:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; NODQ-NEXT:    vpextrq $1, %xmm1, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm2, %xmm2
; NODQ-NEXT:    vmovq %xmm1, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm1
; NODQ-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; NODQ-NEXT:    vextracti32x4 $2, %zmm0, %xmm2
; NODQ-NEXT:    vpextrq $1, %xmm2, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm3
; NODQ-NEXT:    vmovq %xmm2, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm4, %xmm2
; NODQ-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; NODQ-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; NODQ-NEXT:    vextracti128 $1, %ymm0, %xmm2
; NODQ-NEXT:    vpextrq $1, %xmm2, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm4, %xmm3
; NODQ-NEXT:    vmovq %xmm2, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm4, %xmm2
; NODQ-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; NODQ-NEXT:    vpextrq $1, %xmm0, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm4, %xmm3
; NODQ-NEXT:    vmovq %xmm0, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm4, %xmm0
; NODQ-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm3[0]
; NODQ-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; NODQ-NEXT:    vinsertf64x4 $1, %ymm1, %zmm0, %zmm0
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: sltof864:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvtqq2pd %zmm0, %zmm0
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: sltof864:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vcvtqq2pd %zmm0, %zmm0
; DQNOVL-NEXT:    retq
  %b = sitofp <8 x i64> %a to <8 x double>
  ret <8 x double> %b
}

define <4 x double> @slto4f64(<4 x i64> %a) {
; NODQ-LABEL: slto4f64:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vextracti128 $1, %ymm0, %xmm1
; NODQ-NEXT:    vpextrq $1, %xmm1, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm2, %xmm2
; NODQ-NEXT:    vmovq %xmm1, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm1
; NODQ-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; NODQ-NEXT:    vpextrq $1, %xmm0, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm2
; NODQ-NEXT:    vmovq %xmm0, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm0
; NODQ-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm2[0]
; NODQ-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: slto4f64:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvtqq2pd %ymm0, %ymm0
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: slto4f64:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; DQNOVL-NEXT:    vcvtqq2pd %zmm0, %zmm0
; DQNOVL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; DQNOVL-NEXT:    retq
  %b = sitofp <4 x i64> %a to <4 x double>
  ret <4 x double> %b
}

define <2 x double> @slto2f64(<2 x i64> %a) {
; NODQ-LABEL: slto2f64:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vpextrq $1, %xmm0, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm1, %xmm1
; NODQ-NEXT:    vmovq %xmm0, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm2, %xmm0
; NODQ-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: slto2f64:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvtqq2pd %xmm0, %xmm0
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: slto2f64:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; DQNOVL-NEXT:    vcvtqq2pd %zmm0, %zmm0
; DQNOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; DQNOVL-NEXT:    vzeroupper
; DQNOVL-NEXT:    retq
  %b = sitofp <2 x i64> %a to <2 x double>
  ret <2 x double> %b
}

define <2 x float> @sltof2f32(<2 x i64> %a) {
; NODQ-LABEL: sltof2f32:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vpextrq $1, %xmm0, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm1, %xmm1
; NODQ-NEXT:    vmovq %xmm0, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm2, %xmm0
; NODQ-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm1[0],zero,zero
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: sltof2f32:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvtqq2ps %xmm0, %xmm0
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: sltof2f32:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; DQNOVL-NEXT:    vcvtqq2ps %zmm0, %ymm0
; DQNOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; DQNOVL-NEXT:    vzeroupper
; DQNOVL-NEXT:    retq
  %b = sitofp <2 x i64> %a to <2 x float>
  ret <2 x float>%b
}

define <4 x float> @slto4f32_mem(<4 x i64>* %a) {
; NODQ-LABEL: slto4f32_mem:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vmovdqu (%rdi), %xmm0
; NODQ-NEXT:    vmovdqu 16(%rdi), %xmm1
; NODQ-NEXT:    vpextrq $1, %xmm0, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm2, %xmm2
; NODQ-NEXT:    vmovq %xmm0, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm0
; NODQ-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[2,3]
; NODQ-NEXT:    vmovq %xmm1, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm2
; NODQ-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],xmm2[0],xmm0[3]
; NODQ-NEXT:    vpextrq $1, %xmm1, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm1
; NODQ-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1,2],xmm1[0]
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: slto4f32_mem:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvtqq2psy (%rdi), %xmm0
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: slto4f32_mem:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vmovups (%rdi), %ymm0
; DQNOVL-NEXT:    vcvtqq2ps %zmm0, %ymm0
; DQNOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; DQNOVL-NEXT:    vzeroupper
; DQNOVL-NEXT:    retq
  %a1 = load <4 x i64>, <4 x i64>* %a, align 8
  %b = sitofp <4 x i64> %a1 to <4 x float>
  ret <4 x float>%b
}

define <4 x i64> @f64to4sl(<4 x double> %a) {
; NODQ-LABEL: f64to4sl:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vextractf128 $1, %ymm0, %xmm1
; NODQ-NEXT:    vcvttsd2si %xmm1, %rax
; NODQ-NEXT:    vmovq %rax, %xmm2
; NODQ-NEXT:    vpermilpd {{.*#+}} xmm1 = xmm1[1,0]
; NODQ-NEXT:    vcvttsd2si %xmm1, %rax
; NODQ-NEXT:    vmovq %rax, %xmm1
; NODQ-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; NODQ-NEXT:    vcvttsd2si %xmm0, %rax
; NODQ-NEXT:    vmovq %rax, %xmm2
; NODQ-NEXT:    vpermilpd {{.*#+}} xmm0 = xmm0[1,0]
; NODQ-NEXT:    vcvttsd2si %xmm0, %rax
; NODQ-NEXT:    vmovq %rax, %xmm0
; NODQ-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; NODQ-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: f64to4sl:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvttpd2qq %ymm0, %ymm0
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: f64to4sl:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; DQNOVL-NEXT:    vcvttpd2qq %zmm0, %zmm0
; DQNOVL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; DQNOVL-NEXT:    retq
  %b = fptosi <4 x double> %a to <4 x i64>
  ret <4 x i64> %b
}

define <4 x i64> @f32to4sl(<4 x float> %a) {
; NODQ-LABEL: f32to4sl:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vpermilps {{.*#+}} xmm1 = xmm0[3,3,3,3]
; NODQ-NEXT:    vcvttss2si %xmm1, %rax
; NODQ-NEXT:    vmovq %rax, %xmm1
; NODQ-NEXT:    vpermilpd {{.*#+}} xmm2 = xmm0[1,0]
; NODQ-NEXT:    vcvttss2si %xmm2, %rax
; NODQ-NEXT:    vmovq %rax, %xmm2
; NODQ-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; NODQ-NEXT:    vcvttss2si %xmm0, %rax
; NODQ-NEXT:    vmovq %rax, %xmm2
; NODQ-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; NODQ-NEXT:    vcvttss2si %xmm0, %rax
; NODQ-NEXT:    vmovq %rax, %xmm0
; NODQ-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm2[0],xmm0[0]
; NODQ-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: f32to4sl:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvttps2qq %xmm0, %ymm0
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: f32to4sl:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; DQNOVL-NEXT:    vcvttps2qq %ymm0, %zmm0
; DQNOVL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; DQNOVL-NEXT:    retq
  %b = fptosi <4 x float> %a to <4 x i64>
  ret <4 x i64> %b
}

define <4 x float> @slto4f32(<4 x i64> %a) {
; NODQ-LABEL: slto4f32:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vpextrq $1, %xmm0, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm1, %xmm1
; NODQ-NEXT:    vmovq %xmm0, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm2, %xmm2
; NODQ-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[2,3]
; NODQ-NEXT:    vextracti128 $1, %ymm0, %xmm0
; NODQ-NEXT:    vmovq %xmm0, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm2
; NODQ-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm2[0],xmm1[3]
; NODQ-NEXT:    vpextrq $1, %xmm0, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm0
; NODQ-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; NODQ-NEXT:    vzeroupper
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: slto4f32:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvtqq2ps %ymm0, %xmm0
; VLDQ-NEXT:    vzeroupper
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: slto4f32:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; DQNOVL-NEXT:    vcvtqq2ps %zmm0, %ymm0
; DQNOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; DQNOVL-NEXT:    vzeroupper
; DQNOVL-NEXT:    retq
  %b = sitofp <4 x i64> %a to <4 x float>
  ret <4 x float> %b
}

define <4 x float> @ulto4f32(<4 x i64> %a) {
; NODQ-LABEL: ulto4f32:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vpextrq $1, %xmm0, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm1, %xmm1
; NODQ-NEXT:    vmovq %xmm0, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm2, %xmm2
; NODQ-NEXT:    vinsertps {{.*#+}} xmm1 = xmm2[0],xmm1[0],xmm2[2,3]
; NODQ-NEXT:    vextracti128 $1, %ymm0, %xmm0
; NODQ-NEXT:    vmovq %xmm0, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm3, %xmm2
; NODQ-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm2[0],xmm1[3]
; NODQ-NEXT:    vpextrq $1, %xmm0, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm3, %xmm0
; NODQ-NEXT:    vinsertps {{.*#+}} xmm0 = xmm1[0,1,2],xmm0[0]
; NODQ-NEXT:    vzeroupper
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: ulto4f32:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvtuqq2ps %ymm0, %xmm0
; VLDQ-NEXT:    vzeroupper
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: ulto4f32:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; DQNOVL-NEXT:    vcvtuqq2ps %zmm0, %ymm0
; DQNOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; DQNOVL-NEXT:    vzeroupper
; DQNOVL-NEXT:    retq
  %b = uitofp <4 x i64> %a to <4 x float>
  ret <4 x float> %b
}

define <8 x double> @ulto8f64(<8 x i64> %a) {
; NODQ-LABEL: ulto8f64:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vpbroadcastq {{.*#+}} zmm1 = [4841369599423283200,4841369599423283200,4841369599423283200,4841369599423283200,4841369599423283200,4841369599423283200,4841369599423283200,4841369599423283200]
; NODQ-NEXT:    vpternlogq $248, {{.*}}(%rip){1to8}, %zmm0, %zmm1
; NODQ-NEXT:    vpsrlq $32, %zmm0, %zmm0
; NODQ-NEXT:    vporq {{.*}}(%rip){1to8}, %zmm0, %zmm0
; NODQ-NEXT:    vsubpd {{.*}}(%rip){1to8}, %zmm0, %zmm0
; NODQ-NEXT:    vaddpd %zmm0, %zmm1, %zmm0
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: ulto8f64:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvtuqq2pd %zmm0, %zmm0
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: ulto8f64:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vcvtuqq2pd %zmm0, %zmm0
; DQNOVL-NEXT:    retq
  %b = uitofp <8 x i64> %a to <8 x double>
  ret <8 x double> %b
}

define <16 x double> @ulto16f64(<16 x i64> %a) {
; NODQ-LABEL: ulto16f64:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vpbroadcastq {{.*#+}} zmm2 = [4294967295,4294967295,4294967295,4294967295,4294967295,4294967295,4294967295,4294967295]
; NODQ-NEXT:    vpbroadcastq {{.*#+}} zmm3 = [4841369599423283200,4841369599423283200,4841369599423283200,4841369599423283200,4841369599423283200,4841369599423283200,4841369599423283200,4841369599423283200]
; NODQ-NEXT:    vmovdqa64 %zmm3, %zmm4
; NODQ-NEXT:    vpternlogq $248, %zmm2, %zmm0, %zmm4
; NODQ-NEXT:    vpsrlq $32, %zmm0, %zmm0
; NODQ-NEXT:    vpbroadcastq {{.*#+}} zmm5 = [4985484787499139072,4985484787499139072,4985484787499139072,4985484787499139072,4985484787499139072,4985484787499139072,4985484787499139072,4985484787499139072]
; NODQ-NEXT:    vporq %zmm5, %zmm0, %zmm0
; NODQ-NEXT:    vbroadcastsd {{.*#+}} zmm6 = [1.9342813118337666E+25,1.9342813118337666E+25,1.9342813118337666E+25,1.9342813118337666E+25,1.9342813118337666E+25,1.9342813118337666E+25,1.9342813118337666E+25,1.9342813118337666E+25]
; NODQ-NEXT:    vsubpd %zmm6, %zmm0, %zmm0
; NODQ-NEXT:    vaddpd %zmm0, %zmm4, %zmm0
; NODQ-NEXT:    vpternlogq $248, %zmm2, %zmm1, %zmm3
; NODQ-NEXT:    vpsrlq $32, %zmm1, %zmm1
; NODQ-NEXT:    vporq %zmm5, %zmm1, %zmm1
; NODQ-NEXT:    vsubpd %zmm6, %zmm1, %zmm1
; NODQ-NEXT:    vaddpd %zmm1, %zmm3, %zmm1
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: ulto16f64:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvtuqq2pd %zmm0, %zmm0
; VLDQ-NEXT:    vcvtuqq2pd %zmm1, %zmm1
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: ulto16f64:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vcvtuqq2pd %zmm0, %zmm0
; DQNOVL-NEXT:    vcvtuqq2pd %zmm1, %zmm1
; DQNOVL-NEXT:    retq
  %b = uitofp <16 x i64> %a to <16 x double>
  ret <16 x double> %b
}

define <16 x i32> @f64to16si(<16 x float> %a) nounwind {
; ALL-LABEL: f64to16si:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvttps2dq %zmm0, %zmm0
; ALL-NEXT:    retq
  %b = fptosi <16 x float> %a to <16 x i32>
  ret <16 x i32> %b
}

define <16 x i8> @f32to16sc(<16 x float> %f) {
; ALL-LABEL: f32to16sc:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvttps2dq %zmm0, %zmm0
; ALL-NEXT:    vpmovdb %zmm0, %xmm0
; ALL-NEXT:    vzeroupper
; ALL-NEXT:    retq
  %res = fptosi <16 x float> %f to <16 x i8>
  ret <16 x i8> %res
}

define <16 x i16> @f32to16ss(<16 x float> %f) {
; ALL-LABEL: f32to16ss:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvttps2dq %zmm0, %zmm0
; ALL-NEXT:    vpmovdw %zmm0, %ymm0
; ALL-NEXT:    retq
  %res = fptosi <16 x float> %f to <16 x i16>
  ret <16 x i16> %res
}

define <16 x i32> @f32to16ui(<16 x float> %a) nounwind {
; ALL-LABEL: f32to16ui:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvttps2udq %zmm0, %zmm0
; ALL-NEXT:    retq
  %b = fptoui <16 x float> %a to <16 x i32>
  ret <16 x i32> %b
}

define <16 x i8> @f32to16uc(<16 x float> %f) {
; ALL-LABEL: f32to16uc:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvttps2dq %zmm0, %zmm0
; ALL-NEXT:    vpmovdb %zmm0, %xmm0
; ALL-NEXT:    vzeroupper
; ALL-NEXT:    retq
  %res = fptoui <16 x float> %f to <16 x i8>
  ret <16 x i8> %res
}

define <16 x i16> @f32to16us(<16 x float> %f) {
; ALL-LABEL: f32to16us:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvttps2dq %zmm0, %zmm0
; ALL-NEXT:    vpmovdw %zmm0, %ymm0
; ALL-NEXT:    retq
  %res = fptoui <16 x float> %f to <16 x i16>
  ret <16 x i16> %res
}

define <8 x i32> @f32to8ui(<8 x float> %a) nounwind {
; NOVL-LABEL: f32to8ui:
; NOVL:       # %bb.0:
; NOVL-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; NOVL-NEXT:    vcvttps2udq %zmm0, %zmm0
; NOVL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; NOVL-NEXT:    retq
;
; VL-LABEL: f32to8ui:
; VL:       # %bb.0:
; VL-NEXT:    vcvttps2udq %ymm0, %ymm0
; VL-NEXT:    retq
  %b = fptoui <8 x float> %a to <8 x i32>
  ret <8 x i32> %b
}

define <4 x i32> @f32to4ui(<4 x float> %a) nounwind {
; NOVL-LABEL: f32to4ui:
; NOVL:       # %bb.0:
; NOVL-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; NOVL-NEXT:    vcvttps2udq %zmm0, %zmm0
; NOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; NOVL-NEXT:    vzeroupper
; NOVL-NEXT:    retq
;
; VL-LABEL: f32to4ui:
; VL:       # %bb.0:
; VL-NEXT:    vcvttps2udq %xmm0, %xmm0
; VL-NEXT:    retq
  %b = fptoui <4 x float> %a to <4 x i32>
  ret <4 x i32> %b
}

define <8 x i32> @f64to8ui(<8 x double> %a) nounwind {
; ALL-LABEL: f64to8ui:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvttpd2udq %zmm0, %ymm0
; ALL-NEXT:    retq
  %b = fptoui <8 x double> %a to <8 x i32>
  ret <8 x i32> %b
}

define <8 x i16> @f64to8us(<8 x double> %f) {
; NOVL-LABEL: f64to8us:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vcvttpd2dq %zmm0, %ymm0
; NOVL-NEXT:    vpmovdw %zmm0, %ymm0
; NOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; NOVL-NEXT:    vzeroupper
; NOVL-NEXT:    retq
;
; VL-LABEL: f64to8us:
; VL:       # %bb.0:
; VL-NEXT:    vcvttpd2dq %zmm0, %ymm0
; VL-NEXT:    vpmovdw %ymm0, %xmm0
; VL-NEXT:    vzeroupper
; VL-NEXT:    retq
  %res = fptoui <8 x double> %f to <8 x i16>
  ret <8 x i16> %res
}

define <8 x i8> @f64to8uc(<8 x double> %f) {
; NOVL-LABEL: f64to8uc:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vcvttpd2dq %zmm0, %ymm0
; NOVL-NEXT:    vpmovdb %zmm0, %xmm0
; NOVL-NEXT:    vzeroupper
; NOVL-NEXT:    retq
;
; VL-LABEL: f64to8uc:
; VL:       # %bb.0:
; VL-NEXT:    vcvttpd2dq %zmm0, %ymm0
; VL-NEXT:    vpmovdb %ymm0, %xmm0
; VL-NEXT:    vzeroupper
; VL-NEXT:    retq
  %res = fptoui <8 x double> %f to <8 x i8>
  ret <8 x i8> %res
}

define <4 x i32> @f64to4ui(<4 x double> %a) nounwind {
; NOVL-LABEL: f64to4ui:
; NOVL:       # %bb.0:
; NOVL-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; NOVL-NEXT:    vcvttpd2udq %zmm0, %ymm0
; NOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; NOVL-NEXT:    vzeroupper
; NOVL-NEXT:    retq
;
; VL-LABEL: f64to4ui:
; VL:       # %bb.0:
; VL-NEXT:    vcvttpd2udq %ymm0, %xmm0
; VL-NEXT:    vzeroupper
; VL-NEXT:    retq
  %b = fptoui <4 x double> %a to <4 x i32>
  ret <4 x i32> %b
}

define <8 x double> @sito8f64(<8 x i32> %a) {
; ALL-LABEL: sito8f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvtdq2pd %ymm0, %zmm0
; ALL-NEXT:    retq
  %b = sitofp <8 x i32> %a to <8 x double>
  ret <8 x double> %b
}
define <8 x double> @i32to8f64_mask(<8 x double> %a, <8 x i32> %b, i8 %c) nounwind {
; KNL-LABEL: i32to8f64_mask:
; KNL:       # %bb.0:
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vcvtdq2pd %ymm1, %zmm0 {%k1}
; KNL-NEXT:    retq
;
; VLBW-LABEL: i32to8f64_mask:
; VLBW:       # %bb.0:
; VLBW-NEXT:    kmovd %edi, %k1
; VLBW-NEXT:    vcvtdq2pd %ymm1, %zmm0 {%k1}
; VLBW-NEXT:    retq
;
; VLNOBW-LABEL: i32to8f64_mask:
; VLNOBW:       # %bb.0:
; VLNOBW-NEXT:    kmovw %edi, %k1
; VLNOBW-NEXT:    vcvtdq2pd %ymm1, %zmm0 {%k1}
; VLNOBW-NEXT:    retq
;
; DQNOVL-LABEL: i32to8f64_mask:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    kmovw %edi, %k1
; DQNOVL-NEXT:    vcvtdq2pd %ymm1, %zmm0 {%k1}
; DQNOVL-NEXT:    retq
;
; AVX512BW-LABEL: i32to8f64_mask:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vcvtdq2pd %ymm1, %zmm0 {%k1}
; AVX512BW-NEXT:    retq
  %1 = bitcast i8 %c to <8 x i1>
  %2 = sitofp <8 x i32> %b to <8 x double>
  %3 = select <8 x i1> %1, <8 x double> %2, <8 x double> %a
  ret <8 x double> %3
}
define <8 x double> @sito8f64_maskz(<8 x i32> %a, i8 %b) nounwind {
; KNL-LABEL: sito8f64_maskz:
; KNL:       # %bb.0:
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vcvtdq2pd %ymm0, %zmm0 {%k1} {z}
; KNL-NEXT:    retq
;
; VLBW-LABEL: sito8f64_maskz:
; VLBW:       # %bb.0:
; VLBW-NEXT:    kmovd %edi, %k1
; VLBW-NEXT:    vcvtdq2pd %ymm0, %zmm0 {%k1} {z}
; VLBW-NEXT:    retq
;
; VLNOBW-LABEL: sito8f64_maskz:
; VLNOBW:       # %bb.0:
; VLNOBW-NEXT:    kmovw %edi, %k1
; VLNOBW-NEXT:    vcvtdq2pd %ymm0, %zmm0 {%k1} {z}
; VLNOBW-NEXT:    retq
;
; DQNOVL-LABEL: sito8f64_maskz:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    kmovw %edi, %k1
; DQNOVL-NEXT:    vcvtdq2pd %ymm0, %zmm0 {%k1} {z}
; DQNOVL-NEXT:    retq
;
; AVX512BW-LABEL: sito8f64_maskz:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vcvtdq2pd %ymm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
  %1 = bitcast i8 %b to <8 x i1>
  %2 = sitofp <8 x i32> %a to <8 x double>
  %3 = select <8 x i1> %1, <8 x double> %2, <8 x double> zeroinitializer
  ret <8 x double> %3
}

define <8 x i32> @f64to8si(<8 x double> %a) {
; ALL-LABEL: f64to8si:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvttpd2dq %zmm0, %ymm0
; ALL-NEXT:    retq
  %b = fptosi <8 x double> %a to <8 x i32>
  ret <8 x i32> %b
}

define <8 x i16> @f64to8ss(<8 x double> %f) {
; NOVL-LABEL: f64to8ss:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vcvttpd2dq %zmm0, %ymm0
; NOVL-NEXT:    vpmovdw %zmm0, %ymm0
; NOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; NOVL-NEXT:    vzeroupper
; NOVL-NEXT:    retq
;
; VL-LABEL: f64to8ss:
; VL:       # %bb.0:
; VL-NEXT:    vcvttpd2dq %zmm0, %ymm0
; VL-NEXT:    vpmovdw %ymm0, %xmm0
; VL-NEXT:    vzeroupper
; VL-NEXT:    retq
  %res = fptosi <8 x double> %f to <8 x i16>
  ret <8 x i16> %res
}

define <8 x i8> @f64to8sc(<8 x double> %f) {
; NOVL-LABEL: f64to8sc:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vcvttpd2dq %zmm0, %ymm0
; NOVL-NEXT:    vpmovdb %zmm0, %xmm0
; NOVL-NEXT:    vzeroupper
; NOVL-NEXT:    retq
;
; VL-LABEL: f64to8sc:
; VL:       # %bb.0:
; VL-NEXT:    vcvttpd2dq %zmm0, %ymm0
; VL-NEXT:    vpmovdb %ymm0, %xmm0
; VL-NEXT:    vzeroupper
; VL-NEXT:    retq
  %res = fptosi <8 x double> %f to <8 x i8>
  ret <8 x i8> %res
}

define <4 x i32> @f64to4si(<4 x double> %a) {
; ALL-LABEL: f64to4si:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvttpd2dq %ymm0, %xmm0
; ALL-NEXT:    vzeroupper
; ALL-NEXT:    retq
  %b = fptosi <4 x double> %a to <4 x i32>
  ret <4 x i32> %b
}

define <16 x float> @f64to16f32(<16 x double> %b) nounwind {
; ALL-LABEL: f64to16f32:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvtpd2ps %zmm0, %ymm0
; ALL-NEXT:    vcvtpd2ps %zmm1, %ymm1
; ALL-NEXT:    vinsertf64x4 $1, %ymm1, %zmm0, %zmm0
; ALL-NEXT:    retq
  %a = fptrunc <16 x double> %b to <16 x float>
  ret <16 x float> %a
}

define <4 x float> @f64to4f32(<4 x double> %b) {
; ALL-LABEL: f64to4f32:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvtpd2ps %ymm0, %xmm0
; ALL-NEXT:    vzeroupper
; ALL-NEXT:    retq
  %a = fptrunc <4 x double> %b to <4 x float>
  ret <4 x float> %a
}

define <4 x float> @f64to4f32_mask(<4 x double> %b, <4 x i1> %mask) {
; NOVLDQ-LABEL: f64to4f32_mask:
; NOVLDQ:       # %bb.0:
; NOVLDQ-NEXT:    vpslld $31, %xmm1, %xmm1
; NOVLDQ-NEXT:    vptestmd %zmm1, %zmm1, %k1
; NOVLDQ-NEXT:    vcvtpd2ps %ymm0, %xmm0
; NOVLDQ-NEXT:    vmovaps %zmm0, %zmm0 {%k1} {z}
; NOVLDQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; NOVLDQ-NEXT:    vzeroupper
; NOVLDQ-NEXT:    retq
;
; VLDQ-LABEL: f64to4f32_mask:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vpslld $31, %xmm1, %xmm1
; VLDQ-NEXT:    vpmovd2m %xmm1, %k1
; VLDQ-NEXT:    vcvtpd2ps %ymm0, %xmm0 {%k1} {z}
; VLDQ-NEXT:    vzeroupper
; VLDQ-NEXT:    retq
;
; VLNODQ-LABEL: f64to4f32_mask:
; VLNODQ:       # %bb.0:
; VLNODQ-NEXT:    vpslld $31, %xmm1, %xmm1
; VLNODQ-NEXT:    vptestmd %xmm1, %xmm1, %k1
; VLNODQ-NEXT:    vcvtpd2ps %ymm0, %xmm0 {%k1} {z}
; VLNODQ-NEXT:    vzeroupper
; VLNODQ-NEXT:    retq
;
; DQNOVL-LABEL: f64to4f32_mask:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vpslld $31, %xmm1, %xmm1
; DQNOVL-NEXT:    vpmovd2m %zmm1, %k1
; DQNOVL-NEXT:    vcvtpd2ps %ymm0, %xmm0
; DQNOVL-NEXT:    vmovaps %zmm0, %zmm0 {%k1} {z}
; DQNOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; DQNOVL-NEXT:    vzeroupper
; DQNOVL-NEXT:    retq
  %a = fptrunc <4 x double> %b to <4 x float>
  %c = select <4 x i1>%mask, <4 x float>%a, <4 x float> zeroinitializer
  ret <4 x float> %c
}

define <4 x float> @f64tof32_inreg(<2 x double> %a0, <4 x float> %a1) nounwind {
; ALL-LABEL: f64tof32_inreg:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvtsd2ss %xmm0, %xmm1, %xmm0
; ALL-NEXT:    retq
  %ext = extractelement <2 x double> %a0, i32 0
  %cvt = fptrunc double %ext to float
  %res = insertelement <4 x float> %a1, float %cvt, i32 0
  ret <4 x float> %res
}

define <8 x double> @f32to8f64(<8 x float> %b) nounwind {
; ALL-LABEL: f32to8f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvtps2pd %ymm0, %zmm0
; ALL-NEXT:    retq
  %a = fpext <8 x float> %b to <8 x double>
  ret <8 x double> %a
}

define <4 x double> @f32to4f64_mask(<4 x float> %b, <4 x double> %b1, <4 x double> %a1) {
; NOVL-LABEL: f32to4f64_mask:
; NOVL:       # %bb.0:
; NOVL-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; NOVL-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; NOVL-NEXT:    vcvtps2pd %xmm0, %ymm0
; NOVL-NEXT:    vcmpltpd %zmm2, %zmm1, %k1
; NOVL-NEXT:    vmovapd %zmm0, %zmm0 {%k1} {z}
; NOVL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; NOVL-NEXT:    retq
;
; VL-LABEL: f32to4f64_mask:
; VL:       # %bb.0:
; VL-NEXT:    vcmpltpd %ymm2, %ymm1, %k1
; VL-NEXT:    vcvtps2pd %xmm0, %ymm0 {%k1} {z}
; VL-NEXT:    retq
  %a = fpext <4 x float> %b to <4 x double>
  %mask = fcmp ogt <4 x double> %a1, %b1
  %c = select <4 x i1> %mask, <4 x double> %a, <4 x double> zeroinitializer
  ret <4 x double> %c
}

define <4 x double> @f32to4f64_mask_load(<4 x float>* %p, <4 x double> %b1, <4 x double> %a1, <4 x double> %passthru) {
; NOVL-LABEL: f32to4f64_mask_load:
; NOVL:       # %bb.0:
; NOVL-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; NOVL-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; NOVL-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; NOVL-NEXT:    vcvtps2pd (%rdi), %ymm3
; NOVL-NEXT:    vcmpltpd %zmm1, %zmm0, %k1
; NOVL-NEXT:    vblendmpd %zmm3, %zmm2, %zmm0 {%k1}
; NOVL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; NOVL-NEXT:    retq
;
; VL-LABEL: f32to4f64_mask_load:
; VL:       # %bb.0:
; VL-NEXT:    vcmpltpd %ymm1, %ymm0, %k1
; VL-NEXT:    vcvtps2pd (%rdi), %ymm2 {%k1}
; VL-NEXT:    vmovaps %ymm2, %ymm0
; VL-NEXT:    retq
  %b = load <4 x float>, <4 x float>* %p
  %a = fpext <4 x float> %b to <4 x double>
  %mask = fcmp ogt <4 x double> %a1, %b1
  %c = select <4 x i1> %mask, <4 x double> %a, <4 x double> %passthru
  ret <4 x double> %c
}

define <4 x double> @f32to4f64_maskz_load(<4 x float>* %p, <4 x double> %b1, <4 x double> %a1) {
; NOVL-LABEL: f32to4f64_maskz_load:
; NOVL:       # %bb.0:
; NOVL-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; NOVL-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; NOVL-NEXT:    vcvtps2pd (%rdi), %ymm2
; NOVL-NEXT:    vcmpltpd %zmm1, %zmm0, %k1
; NOVL-NEXT:    vmovapd %zmm2, %zmm0 {%k1} {z}
; NOVL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; NOVL-NEXT:    retq
;
; VL-LABEL: f32to4f64_maskz_load:
; VL:       # %bb.0:
; VL-NEXT:    vcmpltpd %ymm1, %ymm0, %k1
; VL-NEXT:    vcvtps2pd (%rdi), %ymm0 {%k1} {z}
; VL-NEXT:    retq
  %b = load <4 x float>, <4 x float>* %p
  %a = fpext <4 x float> %b to <4 x double>
  %mask = fcmp ogt <4 x double> %a1, %b1
  %c = select <4 x i1> %mask, <4 x double> %a, <4 x double> zeroinitializer
  ret <4 x double> %c
}

define <2 x double> @f32tof64_inreg(<2 x double> %a0, <4 x float> %a1) nounwind {
; ALL-LABEL: f32tof64_inreg:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvtss2sd %xmm1, %xmm0, %xmm0
; ALL-NEXT:    retq
  %ext = extractelement <4 x float> %a1, i32 0
  %cvt = fpext float %ext to double
  %res = insertelement <2 x double> %a0, double %cvt, i32 0
  ret <2 x double> %res
}

define double @sltof64_load(i64* nocapture %e) {
; ALL-LABEL: sltof64_load:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    vcvtsi2sdq (%rdi), %xmm0, %xmm0
; ALL-NEXT:    retq
entry:
  %tmp1 = load i64, i64* %e, align 8
  %conv = sitofp i64 %tmp1 to double
  ret double %conv
}

define double @sitof64_load(i32* %e) {
; ALL-LABEL: sitof64_load:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    vcvtsi2sdl (%rdi), %xmm0, %xmm0
; ALL-NEXT:    retq
entry:
  %tmp1 = load i32, i32* %e, align 4
  %conv = sitofp i32 %tmp1 to double
  ret double %conv
}

define float @sitof32_load(i32* %e) {
; ALL-LABEL: sitof32_load:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    vcvtsi2ssl (%rdi), %xmm0, %xmm0
; ALL-NEXT:    retq
entry:
  %tmp1 = load i32, i32* %e, align 4
  %conv = sitofp i32 %tmp1 to float
  ret float %conv
}

define float @sltof32_load(i64* %e) {
; ALL-LABEL: sltof32_load:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    vcvtsi2ssq (%rdi), %xmm0, %xmm0
; ALL-NEXT:    retq
entry:
  %tmp1 = load i64, i64* %e, align 8
  %conv = sitofp i64 %tmp1 to float
  ret float %conv
}

define void @f32tof64_loadstore() {
; ALL-LABEL: f32tof64_loadstore:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    vmovss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; ALL-NEXT:    vcvtss2sd %xmm0, %xmm0, %xmm0
; ALL-NEXT:    vmovsd %xmm0, -{{[0-9]+}}(%rsp)
; ALL-NEXT:    retq
entry:
  %f = alloca float, align 4
  %d = alloca double, align 8
  %tmp = load float, float* %f, align 4
  %conv = fpext float %tmp to double
  store double %conv, double* %d, align 8
  ret void
}

define void @f64tof32_loadstore() nounwind uwtable {
; ALL-LABEL: f64tof32_loadstore:
; ALL:       # %bb.0: # %entry
; ALL-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; ALL-NEXT:    vcvtsd2ss %xmm0, %xmm0, %xmm0
; ALL-NEXT:    vmovss %xmm0, -{{[0-9]+}}(%rsp)
; ALL-NEXT:    retq
entry:
  %f = alloca float, align 4
  %d = alloca double, align 8
  %tmp = load double, double* %d, align 8
  %conv = fptrunc double %tmp to float
  store float %conv, float* %f, align 4
  ret void
}

define double @long_to_double(i64 %x) {
; ALL-LABEL: long_to_double:
; ALL:       # %bb.0:
; ALL-NEXT:    vmovq %rdi, %xmm0
; ALL-NEXT:    retq
   %res = bitcast i64 %x to double
   ret double %res
}

define i64 @double_to_long(double %x) {
; ALL-LABEL: double_to_long:
; ALL:       # %bb.0:
; ALL-NEXT:    vmovq %xmm0, %rax
; ALL-NEXT:    retq
   %res = bitcast double %x to i64
   ret i64 %res
}

define float @int_to_float(i32 %x) {
; ALL-LABEL: int_to_float:
; ALL:       # %bb.0:
; ALL-NEXT:    vmovd %edi, %xmm0
; ALL-NEXT:    retq
   %res = bitcast i32 %x to float
   ret float %res
}

define i32 @float_to_int(float %x) {
; ALL-LABEL: float_to_int:
; ALL:       # %bb.0:
; ALL-NEXT:    vmovd %xmm0, %eax
; ALL-NEXT:    retq
   %res = bitcast float %x to i32
   ret i32 %res
}

define <16 x double> @uito16f64(<16 x i32> %a) nounwind {
; ALL-LABEL: uito16f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvtudq2pd %ymm0, %zmm2
; ALL-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; ALL-NEXT:    vcvtudq2pd %ymm0, %zmm1
; ALL-NEXT:    vmovaps %zmm2, %zmm0
; ALL-NEXT:    retq
  %b = uitofp <16 x i32> %a to <16 x double>
  ret <16 x double> %b
}

define <8 x float> @slto8f32(<8 x i64> %a) {
; NODQ-LABEL: slto8f32:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vextracti32x4 $2, %zmm0, %xmm1
; NODQ-NEXT:    vpextrq $1, %xmm1, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm2, %xmm2
; NODQ-NEXT:    vmovq %xmm1, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm1
; NODQ-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[2,3]
; NODQ-NEXT:    vextracti32x4 $3, %zmm0, %xmm2
; NODQ-NEXT:    vmovq %xmm2, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm3
; NODQ-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm3[0],xmm1[3]
; NODQ-NEXT:    vpextrq $1, %xmm2, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm4, %xmm2
; NODQ-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm2[0]
; NODQ-NEXT:    vpextrq $1, %xmm0, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm4, %xmm2
; NODQ-NEXT:    vmovq %xmm0, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm4, %xmm3
; NODQ-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; NODQ-NEXT:    vextracti128 $1, %ymm0, %xmm0
; NODQ-NEXT:    vmovq %xmm0, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm4, %xmm3
; NODQ-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],xmm3[0],xmm2[3]
; NODQ-NEXT:    vpextrq $1, %xmm0, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm4, %xmm0
; NODQ-NEXT:    vinsertps {{.*#+}} xmm0 = xmm2[0,1,2],xmm0[0]
; NODQ-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: slto8f32:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvtqq2ps %zmm0, %ymm0
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: slto8f32:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vcvtqq2ps %zmm0, %ymm0
; DQNOVL-NEXT:    retq
  %b = sitofp <8 x i64> %a to <8 x float>
  ret <8 x float> %b
}

define <16 x float> @slto16f32(<16 x i64> %a) {
; NODQ-LABEL: slto16f32:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vextracti32x4 $2, %zmm1, %xmm2
; NODQ-NEXT:    vpextrq $1, %xmm2, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm3, %xmm3
; NODQ-NEXT:    vmovq %xmm2, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm4, %xmm2
; NODQ-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[2,3]
; NODQ-NEXT:    vextracti32x4 $3, %zmm1, %xmm3
; NODQ-NEXT:    vmovq %xmm3, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm4, %xmm4
; NODQ-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],xmm4[0],xmm2[3]
; NODQ-NEXT:    vpextrq $1, %xmm3, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm5, %xmm3
; NODQ-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],xmm3[0]
; NODQ-NEXT:    vpextrq $1, %xmm1, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm5, %xmm3
; NODQ-NEXT:    vmovq %xmm1, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm5, %xmm4
; NODQ-NEXT:    vinsertps {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[2,3]
; NODQ-NEXT:    vextracti128 $1, %ymm1, %xmm1
; NODQ-NEXT:    vmovq %xmm1, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm5, %xmm4
; NODQ-NEXT:    vinsertps {{.*#+}} xmm3 = xmm3[0,1],xmm4[0],xmm3[3]
; NODQ-NEXT:    vpextrq $1, %xmm1, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm5, %xmm1
; NODQ-NEXT:    vinsertps {{.*#+}} xmm1 = xmm3[0,1,2],xmm1[0]
; NODQ-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; NODQ-NEXT:    vextractf32x4 $2, %zmm0, %xmm2
; NODQ-NEXT:    vpextrq $1, %xmm2, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm5, %xmm3
; NODQ-NEXT:    vmovq %xmm2, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm5, %xmm2
; NODQ-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[2,3]
; NODQ-NEXT:    vextractf32x4 $3, %zmm0, %xmm3
; NODQ-NEXT:    vmovq %xmm3, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm5, %xmm4
; NODQ-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],xmm4[0],xmm2[3]
; NODQ-NEXT:    vpextrq $1, %xmm3, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm5, %xmm3
; NODQ-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],xmm3[0]
; NODQ-NEXT:    vpextrq $1, %xmm0, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm5, %xmm3
; NODQ-NEXT:    vmovq %xmm0, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm5, %xmm4
; NODQ-NEXT:    vinsertps {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[2,3]
; NODQ-NEXT:    vextracti128 $1, %ymm0, %xmm0
; NODQ-NEXT:    vmovq %xmm0, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm5, %xmm4
; NODQ-NEXT:    vinsertps {{.*#+}} xmm3 = xmm3[0,1],xmm4[0],xmm3[3]
; NODQ-NEXT:    vpextrq $1, %xmm0, %rax
; NODQ-NEXT:    vcvtsi2ss %rax, %xmm5, %xmm0
; NODQ-NEXT:    vinsertps {{.*#+}} xmm0 = xmm3[0,1,2],xmm0[0]
; NODQ-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; NODQ-NEXT:    vinsertf64x4 $1, %ymm1, %zmm0, %zmm0
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: slto16f32:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvtqq2ps %zmm0, %ymm0
; VLDQ-NEXT:    vcvtqq2ps %zmm1, %ymm1
; VLDQ-NEXT:    vinsertf64x4 $1, %ymm1, %zmm0, %zmm0
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: slto16f32:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vcvtqq2ps %zmm0, %ymm0
; DQNOVL-NEXT:    vcvtqq2ps %zmm1, %ymm1
; DQNOVL-NEXT:    vinsertf64x4 $1, %ymm1, %zmm0, %zmm0
; DQNOVL-NEXT:    retq
  %b = sitofp <16 x i64> %a to <16 x float>
  ret <16 x float> %b
}

define <8 x double> @slto8f64(<8 x i64> %a) {
; NODQ-LABEL: slto8f64:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vextracti32x4 $3, %zmm0, %xmm1
; NODQ-NEXT:    vpextrq $1, %xmm1, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm2, %xmm2
; NODQ-NEXT:    vmovq %xmm1, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm1
; NODQ-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; NODQ-NEXT:    vextracti32x4 $2, %zmm0, %xmm2
; NODQ-NEXT:    vpextrq $1, %xmm2, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm3
; NODQ-NEXT:    vmovq %xmm2, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm4, %xmm2
; NODQ-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; NODQ-NEXT:    vinsertf128 $1, %xmm1, %ymm2, %ymm1
; NODQ-NEXT:    vextracti128 $1, %ymm0, %xmm2
; NODQ-NEXT:    vpextrq $1, %xmm2, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm4, %xmm3
; NODQ-NEXT:    vmovq %xmm2, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm4, %xmm2
; NODQ-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; NODQ-NEXT:    vpextrq $1, %xmm0, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm4, %xmm3
; NODQ-NEXT:    vmovq %xmm0, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm4, %xmm0
; NODQ-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm3[0]
; NODQ-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; NODQ-NEXT:    vinsertf64x4 $1, %ymm1, %zmm0, %zmm0
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: slto8f64:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvtqq2pd %zmm0, %zmm0
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: slto8f64:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vcvtqq2pd %zmm0, %zmm0
; DQNOVL-NEXT:    retq
  %b = sitofp <8 x i64> %a to <8 x double>
  ret <8 x double> %b
}

define <16 x double> @slto16f64(<16 x i64> %a) {
; NODQ-LABEL: slto16f64:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vextracti32x4 $3, %zmm0, %xmm2
; NODQ-NEXT:    vpextrq $1, %xmm2, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm3, %xmm3
; NODQ-NEXT:    vmovq %xmm2, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm4, %xmm2
; NODQ-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; NODQ-NEXT:    vextracti32x4 $2, %zmm0, %xmm3
; NODQ-NEXT:    vpextrq $1, %xmm3, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm4, %xmm4
; NODQ-NEXT:    vmovq %xmm3, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm5, %xmm3
; NODQ-NEXT:    vunpcklpd {{.*#+}} xmm3 = xmm3[0],xmm4[0]
; NODQ-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; NODQ-NEXT:    vextracti128 $1, %ymm0, %xmm3
; NODQ-NEXT:    vpextrq $1, %xmm3, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm5, %xmm4
; NODQ-NEXT:    vmovq %xmm3, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm5, %xmm3
; NODQ-NEXT:    vunpcklpd {{.*#+}} xmm3 = xmm3[0],xmm4[0]
; NODQ-NEXT:    vpextrq $1, %xmm0, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm5, %xmm4
; NODQ-NEXT:    vmovq %xmm0, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm5, %xmm0
; NODQ-NEXT:    vunpcklpd {{.*#+}} xmm0 = xmm0[0],xmm4[0]
; NODQ-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm0
; NODQ-NEXT:    vinsertf64x4 $1, %ymm2, %zmm0, %zmm0
; NODQ-NEXT:    vextracti32x4 $3, %zmm1, %xmm2
; NODQ-NEXT:    vpextrq $1, %xmm2, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm5, %xmm3
; NODQ-NEXT:    vmovq %xmm2, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm5, %xmm2
; NODQ-NEXT:    vunpcklpd {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; NODQ-NEXT:    vextracti32x4 $2, %zmm1, %xmm3
; NODQ-NEXT:    vpextrq $1, %xmm3, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm5, %xmm4
; NODQ-NEXT:    vmovq %xmm3, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm5, %xmm3
; NODQ-NEXT:    vunpcklpd {{.*#+}} xmm3 = xmm3[0],xmm4[0]
; NODQ-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; NODQ-NEXT:    vextracti128 $1, %ymm1, %xmm3
; NODQ-NEXT:    vpextrq $1, %xmm3, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm5, %xmm4
; NODQ-NEXT:    vmovq %xmm3, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm5, %xmm3
; NODQ-NEXT:    vunpcklpd {{.*#+}} xmm3 = xmm3[0],xmm4[0]
; NODQ-NEXT:    vpextrq $1, %xmm1, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm5, %xmm4
; NODQ-NEXT:    vmovq %xmm1, %rax
; NODQ-NEXT:    vcvtsi2sd %rax, %xmm5, %xmm1
; NODQ-NEXT:    vunpcklpd {{.*#+}} xmm1 = xmm1[0],xmm4[0]
; NODQ-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; NODQ-NEXT:    vinsertf64x4 $1, %ymm2, %zmm1, %zmm1
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: slto16f64:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvtqq2pd %zmm0, %zmm0
; VLDQ-NEXT:    vcvtqq2pd %zmm1, %zmm1
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: slto16f64:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vcvtqq2pd %zmm0, %zmm0
; DQNOVL-NEXT:    vcvtqq2pd %zmm1, %zmm1
; DQNOVL-NEXT:    retq
  %b = sitofp <16 x i64> %a to <16 x double>
  ret <16 x double> %b
}

define <8 x float> @ulto8f32(<8 x i64> %a) {
; NODQ-LABEL: ulto8f32:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vextracti32x4 $2, %zmm0, %xmm1
; NODQ-NEXT:    vpextrq $1, %xmm1, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm2, %xmm2
; NODQ-NEXT:    vmovq %xmm1, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm3, %xmm1
; NODQ-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[2,3]
; NODQ-NEXT:    vextracti32x4 $3, %zmm0, %xmm2
; NODQ-NEXT:    vmovq %xmm2, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm3, %xmm3
; NODQ-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1],xmm3[0],xmm1[3]
; NODQ-NEXT:    vpextrq $1, %xmm2, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm4, %xmm2
; NODQ-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm2[0]
; NODQ-NEXT:    vpextrq $1, %xmm0, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm4, %xmm2
; NODQ-NEXT:    vmovq %xmm0, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm4, %xmm3
; NODQ-NEXT:    vinsertps {{.*#+}} xmm2 = xmm3[0],xmm2[0],xmm3[2,3]
; NODQ-NEXT:    vextracti128 $1, %ymm0, %xmm0
; NODQ-NEXT:    vmovq %xmm0, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm4, %xmm3
; NODQ-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],xmm3[0],xmm2[3]
; NODQ-NEXT:    vpextrq $1, %xmm0, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm4, %xmm0
; NODQ-NEXT:    vinsertps {{.*#+}} xmm0 = xmm2[0,1,2],xmm0[0]
; NODQ-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: ulto8f32:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvtuqq2ps %zmm0, %ymm0
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: ulto8f32:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vcvtuqq2ps %zmm0, %ymm0
; DQNOVL-NEXT:    retq
  %b = uitofp <8 x i64> %a to <8 x float>
  ret <8 x float> %b
}

define <16 x float> @ulto16f32(<16 x i64> %a) {
; NODQ-LABEL: ulto16f32:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vextracti32x4 $2, %zmm1, %xmm2
; NODQ-NEXT:    vpextrq $1, %xmm2, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm3, %xmm3
; NODQ-NEXT:    vmovq %xmm2, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm4, %xmm2
; NODQ-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[2,3]
; NODQ-NEXT:    vextracti32x4 $3, %zmm1, %xmm3
; NODQ-NEXT:    vmovq %xmm3, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm4, %xmm4
; NODQ-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],xmm4[0],xmm2[3]
; NODQ-NEXT:    vpextrq $1, %xmm3, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm5, %xmm3
; NODQ-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],xmm3[0]
; NODQ-NEXT:    vpextrq $1, %xmm1, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm5, %xmm3
; NODQ-NEXT:    vmovq %xmm1, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm5, %xmm4
; NODQ-NEXT:    vinsertps {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[2,3]
; NODQ-NEXT:    vextracti128 $1, %ymm1, %xmm1
; NODQ-NEXT:    vmovq %xmm1, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm5, %xmm4
; NODQ-NEXT:    vinsertps {{.*#+}} xmm3 = xmm3[0,1],xmm4[0],xmm3[3]
; NODQ-NEXT:    vpextrq $1, %xmm1, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm5, %xmm1
; NODQ-NEXT:    vinsertps {{.*#+}} xmm1 = xmm3[0,1,2],xmm1[0]
; NODQ-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; NODQ-NEXT:    vextractf32x4 $2, %zmm0, %xmm2
; NODQ-NEXT:    vpextrq $1, %xmm2, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm5, %xmm3
; NODQ-NEXT:    vmovq %xmm2, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm5, %xmm2
; NODQ-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[2,3]
; NODQ-NEXT:    vextractf32x4 $3, %zmm0, %xmm3
; NODQ-NEXT:    vmovq %xmm3, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm5, %xmm4
; NODQ-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1],xmm4[0],xmm2[3]
; NODQ-NEXT:    vpextrq $1, %xmm3, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm5, %xmm3
; NODQ-NEXT:    vinsertps {{.*#+}} xmm2 = xmm2[0,1,2],xmm3[0]
; NODQ-NEXT:    vpextrq $1, %xmm0, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm5, %xmm3
; NODQ-NEXT:    vmovq %xmm0, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm5, %xmm4
; NODQ-NEXT:    vinsertps {{.*#+}} xmm3 = xmm4[0],xmm3[0],xmm4[2,3]
; NODQ-NEXT:    vextracti128 $1, %ymm0, %xmm0
; NODQ-NEXT:    vmovq %xmm0, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm5, %xmm4
; NODQ-NEXT:    vinsertps {{.*#+}} xmm3 = xmm3[0,1],xmm4[0],xmm3[3]
; NODQ-NEXT:    vpextrq $1, %xmm0, %rax
; NODQ-NEXT:    vcvtusi2ss %rax, %xmm5, %xmm0
; NODQ-NEXT:    vinsertps {{.*#+}} xmm0 = xmm3[0,1,2],xmm0[0]
; NODQ-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; NODQ-NEXT:    vinsertf64x4 $1, %ymm1, %zmm0, %zmm0
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: ulto16f32:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvtuqq2ps %zmm0, %ymm0
; VLDQ-NEXT:    vcvtuqq2ps %zmm1, %ymm1
; VLDQ-NEXT:    vinsertf64x4 $1, %ymm1, %zmm0, %zmm0
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: ulto16f32:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vcvtuqq2ps %zmm0, %ymm0
; DQNOVL-NEXT:    vcvtuqq2ps %zmm1, %ymm1
; DQNOVL-NEXT:    vinsertf64x4 $1, %ymm1, %zmm0, %zmm0
; DQNOVL-NEXT:    retq
  %b = uitofp <16 x i64> %a to <16 x float>
  ret <16 x float> %b
}

define <8 x double> @uito8f64_mask(<8 x double> %a, <8 x i32> %b, i8 %c) nounwind {
; KNL-LABEL: uito8f64_mask:
; KNL:       # %bb.0:
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vcvtudq2pd %ymm1, %zmm0 {%k1}
; KNL-NEXT:    retq
;
; VLBW-LABEL: uito8f64_mask:
; VLBW:       # %bb.0:
; VLBW-NEXT:    kmovd %edi, %k1
; VLBW-NEXT:    vcvtudq2pd %ymm1, %zmm0 {%k1}
; VLBW-NEXT:    retq
;
; VLNOBW-LABEL: uito8f64_mask:
; VLNOBW:       # %bb.0:
; VLNOBW-NEXT:    kmovw %edi, %k1
; VLNOBW-NEXT:    vcvtudq2pd %ymm1, %zmm0 {%k1}
; VLNOBW-NEXT:    retq
;
; DQNOVL-LABEL: uito8f64_mask:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    kmovw %edi, %k1
; DQNOVL-NEXT:    vcvtudq2pd %ymm1, %zmm0 {%k1}
; DQNOVL-NEXT:    retq
;
; AVX512BW-LABEL: uito8f64_mask:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vcvtudq2pd %ymm1, %zmm0 {%k1}
; AVX512BW-NEXT:    retq
  %1 = bitcast i8 %c to <8 x i1>
  %2 = uitofp <8 x i32> %b to <8 x double>
  %3 = select <8 x i1> %1, <8 x double> %2, <8 x double> %a
  ret <8 x double> %3
}
define <8 x double> @uito8f64_maskz(<8 x i32> %a, i8 %b) nounwind {
; KNL-LABEL: uito8f64_maskz:
; KNL:       # %bb.0:
; KNL-NEXT:    kmovw %edi, %k1
; KNL-NEXT:    vcvtudq2pd %ymm0, %zmm0 {%k1} {z}
; KNL-NEXT:    retq
;
; VLBW-LABEL: uito8f64_maskz:
; VLBW:       # %bb.0:
; VLBW-NEXT:    kmovd %edi, %k1
; VLBW-NEXT:    vcvtudq2pd %ymm0, %zmm0 {%k1} {z}
; VLBW-NEXT:    retq
;
; VLNOBW-LABEL: uito8f64_maskz:
; VLNOBW:       # %bb.0:
; VLNOBW-NEXT:    kmovw %edi, %k1
; VLNOBW-NEXT:    vcvtudq2pd %ymm0, %zmm0 {%k1} {z}
; VLNOBW-NEXT:    retq
;
; DQNOVL-LABEL: uito8f64_maskz:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    kmovw %edi, %k1
; DQNOVL-NEXT:    vcvtudq2pd %ymm0, %zmm0 {%k1} {z}
; DQNOVL-NEXT:    retq
;
; AVX512BW-LABEL: uito8f64_maskz:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    kmovd %edi, %k1
; AVX512BW-NEXT:    vcvtudq2pd %ymm0, %zmm0 {%k1} {z}
; AVX512BW-NEXT:    retq
  %1 = bitcast i8 %b to <8 x i1>
  %2 = uitofp <8 x i32> %a to <8 x double>
  %3 = select <8 x i1> %1, <8 x double> %2, <8 x double> zeroinitializer
  ret <8 x double> %3
}

define <4 x double> @uito4f64(<4 x i32> %a) nounwind {
; NOVL-LABEL: uito4f64:
; NOVL:       # %bb.0:
; NOVL-NEXT:    # kill: def $xmm0 killed $xmm0 def $ymm0
; NOVL-NEXT:    vcvtudq2pd %ymm0, %zmm0
; NOVL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; NOVL-NEXT:    retq
;
; VL-LABEL: uito4f64:
; VL:       # %bb.0:
; VL-NEXT:    vcvtudq2pd %xmm0, %ymm0
; VL-NEXT:    retq
  %b = uitofp <4 x i32> %a to <4 x double>
  ret <4 x double> %b
}

define <16 x float> @uito16f32(<16 x i32> %a) nounwind {
; ALL-LABEL: uito16f32:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvtudq2ps %zmm0, %zmm0
; ALL-NEXT:    retq
  %b = uitofp <16 x i32> %a to <16 x float>
  ret <16 x float> %b
}

define <8 x double> @uito8f64(<8 x i32> %a) {
; ALL-LABEL: uito8f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvtudq2pd %ymm0, %zmm0
; ALL-NEXT:    retq
  %b = uitofp <8 x i32> %a to <8 x double>
  ret <8 x double> %b
}

define <8 x float> @uito8f32(<8 x i32> %a) nounwind {
; NOVL-LABEL: uito8f32:
; NOVL:       # %bb.0:
; NOVL-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; NOVL-NEXT:    vcvtudq2ps %zmm0, %zmm0
; NOVL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; NOVL-NEXT:    retq
;
; VL-LABEL: uito8f32:
; VL:       # %bb.0:
; VL-NEXT:    vcvtudq2ps %ymm0, %ymm0
; VL-NEXT:    retq
  %b = uitofp <8 x i32> %a to <8 x float>
  ret <8 x float> %b
}

define <4 x float> @uito4f32(<4 x i32> %a) nounwind {
; NOVL-LABEL: uito4f32:
; NOVL:       # %bb.0:
; NOVL-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; NOVL-NEXT:    vcvtudq2ps %zmm0, %zmm0
; NOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; NOVL-NEXT:    vzeroupper
; NOVL-NEXT:    retq
;
; VL-LABEL: uito4f32:
; VL:       # %bb.0:
; VL-NEXT:    vcvtudq2ps %xmm0, %xmm0
; VL-NEXT:    retq
  %b = uitofp <4 x i32> %a to <4 x float>
  ret <4 x float> %b
}

define i32 @fptosi(float %a) nounwind {
; ALL-LABEL: fptosi:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvttss2si %xmm0, %eax
; ALL-NEXT:    retq
  %b = fptosi float %a to i32
  ret i32 %b
}

define i32 @fptoui(float %a) nounwind {
; ALL-LABEL: fptoui:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvttss2usi %xmm0, %eax
; ALL-NEXT:    retq
  %b = fptoui float %a to i32
  ret i32 %b
}

define float @uitof32(i32 %a) nounwind {
; ALL-LABEL: uitof32:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvtusi2ss %edi, %xmm0, %xmm0
; ALL-NEXT:    retq
  %b = uitofp i32 %a to float
  ret float %b
}

define double @uitof64(i32 %a) nounwind {
; ALL-LABEL: uitof64:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvtusi2sd %edi, %xmm0, %xmm0
; ALL-NEXT:    retq
  %b = uitofp i32 %a to double
  ret double %b
}

define <16 x float> @sbto16f32(<16 x i32> %a) {
; NODQ-LABEL: sbto16f32:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; NODQ-NEXT:    vpcmpgtd %zmm0, %zmm1, %k1
; NODQ-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; NODQ-NEXT:    vcvtdq2ps %zmm0, %zmm0
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: sbto16f32:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vpmovd2m %zmm0, %k0
; VLDQ-NEXT:    vpmovm2d %k0, %zmm0
; VLDQ-NEXT:    vcvtdq2ps %zmm0, %zmm0
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: sbto16f32:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vpmovd2m %zmm0, %k0
; DQNOVL-NEXT:    vpmovm2d %k0, %zmm0
; DQNOVL-NEXT:    vcvtdq2ps %zmm0, %zmm0
; DQNOVL-NEXT:    retq
  %mask = icmp slt <16 x i32> %a, zeroinitializer
  %1 = sitofp <16 x i1> %mask to <16 x float>
  ret <16 x float> %1
}

define <16 x float> @scto16f32(<16 x i8> %a) {
; ALL-LABEL: scto16f32:
; ALL:       # %bb.0:
; ALL-NEXT:    vpmovsxbd %xmm0, %zmm0
; ALL-NEXT:    vcvtdq2ps %zmm0, %zmm0
; ALL-NEXT:    retq
  %1 = sitofp <16 x i8> %a to <16 x float>
  ret <16 x float> %1
}

define <16 x float> @ssto16f32(<16 x i16> %a) {
; ALL-LABEL: ssto16f32:
; ALL:       # %bb.0:
; ALL-NEXT:    vpmovsxwd %ymm0, %zmm0
; ALL-NEXT:    vcvtdq2ps %zmm0, %zmm0
; ALL-NEXT:    retq
  %1 = sitofp <16 x i16> %a to <16 x float>
  ret <16 x float> %1
}

define <8 x double> @ssto16f64(<8 x i16> %a) {
; ALL-LABEL: ssto16f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vpmovsxwd %xmm0, %ymm0
; ALL-NEXT:    vcvtdq2pd %ymm0, %zmm0
; ALL-NEXT:    retq
  %1 = sitofp <8 x i16> %a to <8 x double>
  ret <8 x double> %1
}

define <8 x double> @scto8f64(<8 x i8> %a) {
; ALL-LABEL: scto8f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vpmovsxbd %xmm0, %ymm0
; ALL-NEXT:    vcvtdq2pd %ymm0, %zmm0
; ALL-NEXT:    retq
  %1 = sitofp <8 x i8> %a to <8 x double>
  ret <8 x double> %1
}

define <16 x double> @scto16f64(<16 x i8> %a) {
; ALL-LABEL: scto16f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vpmovsxbd %xmm0, %zmm1
; ALL-NEXT:    vcvtdq2pd %ymm1, %zmm0
; ALL-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; ALL-NEXT:    vcvtdq2pd %ymm1, %zmm1
; ALL-NEXT:    retq
  %b = sitofp <16 x i8> %a to <16 x double>
  ret <16 x double> %b
}

define <16 x double> @sbto16f64(<16 x double> %a) {
; NODQ-LABEL: sbto16f64:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vxorpd %xmm2, %xmm2, %xmm2
; NODQ-NEXT:    vcmpltpd %zmm0, %zmm2, %k0
; NODQ-NEXT:    vcmpltpd %zmm1, %zmm2, %k1
; NODQ-NEXT:    kunpckbw %k0, %k1, %k1
; NODQ-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1 {%k1} {z}
; NODQ-NEXT:    vcvtdq2pd %ymm1, %zmm0
; NODQ-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; NODQ-NEXT:    vcvtdq2pd %ymm1, %zmm1
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: sbto16f64:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vxorpd %xmm2, %xmm2, %xmm2
; VLDQ-NEXT:    vcmpltpd %zmm0, %zmm2, %k0
; VLDQ-NEXT:    vcmpltpd %zmm1, %zmm2, %k1
; VLDQ-NEXT:    kunpckbw %k0, %k1, %k0
; VLDQ-NEXT:    vpmovm2d %k0, %zmm1
; VLDQ-NEXT:    vcvtdq2pd %ymm1, %zmm0
; VLDQ-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; VLDQ-NEXT:    vcvtdq2pd %ymm1, %zmm1
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: sbto16f64:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vxorpd %xmm2, %xmm2, %xmm2
; DQNOVL-NEXT:    vcmpltpd %zmm0, %zmm2, %k0
; DQNOVL-NEXT:    vcmpltpd %zmm1, %zmm2, %k1
; DQNOVL-NEXT:    kunpckbw %k0, %k1, %k0
; DQNOVL-NEXT:    vpmovm2d %k0, %zmm1
; DQNOVL-NEXT:    vcvtdq2pd %ymm1, %zmm0
; DQNOVL-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; DQNOVL-NEXT:    vcvtdq2pd %ymm1, %zmm1
; DQNOVL-NEXT:    retq
  %cmpres = fcmp ogt <16 x double> %a, zeroinitializer
  %1 = sitofp <16 x i1> %cmpres to <16 x double>
  ret <16 x double> %1
}

define <8 x double> @sbto8f64(<8 x double> %a) {
; NOVLDQ-LABEL: sbto8f64:
; NOVLDQ:       # %bb.0:
; NOVLDQ-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; NOVLDQ-NEXT:    vcmpltpd %zmm0, %zmm1, %k1
; NOVLDQ-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; NOVLDQ-NEXT:    vcvtdq2pd %ymm0, %zmm0
; NOVLDQ-NEXT:    retq
;
; VLDQ-LABEL: sbto8f64:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; VLDQ-NEXT:    vcmpltpd %zmm0, %zmm1, %k0
; VLDQ-NEXT:    vpmovm2d %k0, %ymm0
; VLDQ-NEXT:    vcvtdq2pd %ymm0, %zmm0
; VLDQ-NEXT:    retq
;
; VLNODQ-LABEL: sbto8f64:
; VLNODQ:       # %bb.0:
; VLNODQ-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; VLNODQ-NEXT:    vcmpltpd %zmm0, %zmm1, %k1
; VLNODQ-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; VLNODQ-NEXT:    vmovdqa32 %ymm0, %ymm0 {%k1} {z}
; VLNODQ-NEXT:    vcvtdq2pd %ymm0, %zmm0
; VLNODQ-NEXT:    retq
;
; DQNOVL-LABEL: sbto8f64:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; DQNOVL-NEXT:    vcmpltpd %zmm0, %zmm1, %k0
; DQNOVL-NEXT:    vpmovm2d %k0, %zmm0
; DQNOVL-NEXT:    vcvtdq2pd %ymm0, %zmm0
; DQNOVL-NEXT:    retq
  %cmpres = fcmp ogt <8 x double> %a, zeroinitializer
  %1 = sitofp <8 x i1> %cmpres to <8 x double>
  ret <8 x double> %1
}

define <8 x float> @sbto8f32(<8 x float> %a) {
; ALL-LABEL: sbto8f32:
; ALL:       # %bb.0:
; ALL-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; ALL-NEXT:    vcmpltps %ymm0, %ymm1, %ymm0
; ALL-NEXT:    vcvtdq2ps %ymm0, %ymm0
; ALL-NEXT:    retq
  %cmpres = fcmp ogt <8 x float> %a, zeroinitializer
  %1 = sitofp <8 x i1> %cmpres to <8 x float>
  ret <8 x float> %1
}

define <4 x float> @sbto4f32(<4 x float> %a) {
; ALL-LABEL: sbto4f32:
; ALL:       # %bb.0:
; ALL-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; ALL-NEXT:    vcmpltps %xmm0, %xmm1, %xmm0
; ALL-NEXT:    vcvtdq2ps %xmm0, %xmm0
; ALL-NEXT:    retq
  %cmpres = fcmp ogt <4 x float> %a, zeroinitializer
  %1 = sitofp <4 x i1> %cmpres to <4 x float>
  ret <4 x float> %1
}

define <4 x double> @sbto4f64(<4 x double> %a) {
; NOVL-LABEL: sbto4f64:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; NOVL-NEXT:    vcmpltpd %ymm0, %ymm1, %ymm0
; NOVL-NEXT:    vpmovqd %zmm0, %ymm0
; NOVL-NEXT:    vcvtdq2pd %xmm0, %ymm0
; NOVL-NEXT:    retq
;
; VLDQ-LABEL: sbto4f64:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; VLDQ-NEXT:    vcmpltpd %ymm0, %ymm1, %k0
; VLDQ-NEXT:    vpmovm2d %k0, %xmm0
; VLDQ-NEXT:    vcvtdq2pd %xmm0, %ymm0
; VLDQ-NEXT:    retq
;
; VLNODQ-LABEL: sbto4f64:
; VLNODQ:       # %bb.0:
; VLNODQ-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; VLNODQ-NEXT:    vcmpltpd %ymm0, %ymm1, %k1
; VLNODQ-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; VLNODQ-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; VLNODQ-NEXT:    vcvtdq2pd %xmm0, %ymm0
; VLNODQ-NEXT:    retq
  %cmpres = fcmp ogt <4 x double> %a, zeroinitializer
  %1 = sitofp <4 x i1> %cmpres to <4 x double>
  ret <4 x double> %1
}

define <2 x float> @sbto2f32(<2 x float> %a) {
; ALL-LABEL: sbto2f32:
; ALL:       # %bb.0:
; ALL-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; ALL-NEXT:    vcmpltps %xmm0, %xmm1, %xmm0
; ALL-NEXT:    vcvtdq2ps %xmm0, %xmm0
; ALL-NEXT:    retq
  %cmpres = fcmp ogt <2 x float> %a, zeroinitializer
  %1 = sitofp <2 x i1> %cmpres to <2 x float>
  ret <2 x float> %1
}

define <2 x double> @sbto2f64(<2 x double> %a) {
; NOVL-LABEL: sbto2f64:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; NOVL-NEXT:    vcmpltpd %xmm0, %xmm1, %xmm0
; NOVL-NEXT:    vpermilps {{.*#+}} xmm0 = xmm0[0,2,2,3]
; NOVL-NEXT:    vcvtdq2pd %xmm0, %xmm0
; NOVL-NEXT:    retq
;
; VLDQ-LABEL: sbto2f64:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; VLDQ-NEXT:    vcmpltpd %xmm0, %xmm1, %k0
; VLDQ-NEXT:    vpmovm2d %k0, %xmm0
; VLDQ-NEXT:    vcvtdq2pd %xmm0, %xmm0
; VLDQ-NEXT:    retq
;
; VLNODQ-LABEL: sbto2f64:
; VLNODQ:       # %bb.0:
; VLNODQ-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; VLNODQ-NEXT:    vcmpltpd %xmm0, %xmm1, %k1
; VLNODQ-NEXT:    vpcmpeqd %xmm0, %xmm0, %xmm0
; VLNODQ-NEXT:    vmovdqa32 %xmm0, %xmm0 {%k1} {z}
; VLNODQ-NEXT:    vcvtdq2pd %xmm0, %xmm0
; VLNODQ-NEXT:    retq
  %cmpres = fcmp ogt <2 x double> %a, zeroinitializer
  %1 = sitofp <2 x i1> %cmpres to <2 x double>
  ret <2 x double> %1
}

define <16 x float> @ucto16f32(<16 x i8> %a) {
; ALL-LABEL: ucto16f32:
; ALL:       # %bb.0:
; ALL-NEXT:    vpmovzxbd {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; ALL-NEXT:    vcvtdq2ps %zmm0, %zmm0
; ALL-NEXT:    retq
  %b = uitofp <16 x i8> %a to <16 x float>
  ret <16 x float>%b
}

define <8 x double> @ucto8f64(<8 x i8> %a) {
; ALL-LABEL: ucto8f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; ALL-NEXT:    vcvtdq2pd %ymm0, %zmm0
; ALL-NEXT:    retq
  %b = uitofp <8 x i8> %a to <8 x double>
  ret <8 x double> %b
}

define <16 x float> @swto16f32(<16 x i16> %a) {
; ALL-LABEL: swto16f32:
; ALL:       # %bb.0:
; ALL-NEXT:    vpmovsxwd %ymm0, %zmm0
; ALL-NEXT:    vcvtdq2ps %zmm0, %zmm0
; ALL-NEXT:    retq
  %b = sitofp <16 x i16> %a to <16 x float>
  ret <16 x float> %b
}

define <8 x double> @swto8f64(<8 x i16> %a) {
; ALL-LABEL: swto8f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vpmovsxwd %xmm0, %ymm0
; ALL-NEXT:    vcvtdq2pd %ymm0, %zmm0
; ALL-NEXT:    retq
  %b = sitofp <8 x i16> %a to <8 x double>
  ret <8 x double> %b
}

define <16 x double> @swto16f64(<16 x i16> %a) {
; ALL-LABEL: swto16f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vpmovsxwd %ymm0, %zmm1
; ALL-NEXT:    vcvtdq2pd %ymm1, %zmm0
; ALL-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; ALL-NEXT:    vcvtdq2pd %ymm1, %zmm1
; ALL-NEXT:    retq
  %b = sitofp <16 x i16> %a to <16 x double>
  ret <16 x double> %b
}

define <16 x double> @ucto16f64(<16 x i8> %a) {
; ALL-LABEL: ucto16f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vpmovzxbd {{.*#+}} zmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero,xmm0[8],zero,zero,zero,xmm0[9],zero,zero,zero,xmm0[10],zero,zero,zero,xmm0[11],zero,zero,zero,xmm0[12],zero,zero,zero,xmm0[13],zero,zero,zero,xmm0[14],zero,zero,zero,xmm0[15],zero,zero,zero
; ALL-NEXT:    vcvtdq2pd %ymm1, %zmm0
; ALL-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; ALL-NEXT:    vcvtdq2pd %ymm1, %zmm1
; ALL-NEXT:    retq
  %b = uitofp <16 x i8> %a to <16 x double>
  ret <16 x double> %b
}

define <16 x float> @uwto16f32(<16 x i16> %a) {
; ALL-LABEL: uwto16f32:
; ALL:       # %bb.0:
; ALL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; ALL-NEXT:    vcvtdq2ps %zmm0, %zmm0
; ALL-NEXT:    retq
  %b = uitofp <16 x i16> %a to <16 x float>
  ret <16 x float> %b
}

define <8 x double> @uwto8f64(<8 x i16> %a) {
; ALL-LABEL: uwto8f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; ALL-NEXT:    vcvtdq2pd %ymm0, %zmm0
; ALL-NEXT:    retq
  %b = uitofp <8 x i16> %a to <8 x double>
  ret <8 x double> %b
}

define <16 x double> @uwto16f64(<16 x i16> %a) {
; ALL-LABEL: uwto16f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vpmovzxwd {{.*#+}} zmm1 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; ALL-NEXT:    vcvtdq2pd %ymm1, %zmm0
; ALL-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; ALL-NEXT:    vcvtdq2pd %ymm1, %zmm1
; ALL-NEXT:    retq
  %b = uitofp <16 x i16> %a to <16 x double>
  ret <16 x double> %b
}

define <16 x float> @sito16f32(<16 x i32> %a) {
; ALL-LABEL: sito16f32:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvtdq2ps %zmm0, %zmm0
; ALL-NEXT:    retq
  %b = sitofp <16 x i32> %a to <16 x float>
  ret <16 x float> %b
}

define <16 x double> @sito16f64(<16 x i32> %a) {
; ALL-LABEL: sito16f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vcvtdq2pd %ymm0, %zmm2
; ALL-NEXT:    vextractf64x4 $1, %zmm0, %ymm0
; ALL-NEXT:    vcvtdq2pd %ymm0, %zmm1
; ALL-NEXT:    vmovaps %zmm2, %zmm0
; ALL-NEXT:    retq
  %b = sitofp <16 x i32> %a to <16 x double>
  ret <16 x double> %b
}

define <16 x float> @usto16f32(<16 x i16> %a) {
; ALL-LABEL: usto16f32:
; ALL:       # %bb.0:
; ALL-NEXT:    vpmovzxwd {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero
; ALL-NEXT:    vcvtdq2ps %zmm0, %zmm0
; ALL-NEXT:    retq
  %b = uitofp <16 x i16> %a to <16 x float>
  ret <16 x float> %b
}

define <16 x float> @ubto16f32(<16 x i32> %a) {
; NODQ-LABEL: ubto16f32:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; NODQ-NEXT:    vpcmpgtd %zmm0, %zmm1, %k1
; NODQ-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; NODQ-NEXT:    vpsrld $31, %zmm0, %zmm0
; NODQ-NEXT:    vcvtdq2ps %zmm0, %zmm0
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: ubto16f32:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vpmovd2m %zmm0, %k0
; VLDQ-NEXT:    vpmovm2d %k0, %zmm0
; VLDQ-NEXT:    vpsrld $31, %zmm0, %zmm0
; VLDQ-NEXT:    vcvtdq2ps %zmm0, %zmm0
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: ubto16f32:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vpmovd2m %zmm0, %k0
; DQNOVL-NEXT:    vpmovm2d %k0, %zmm0
; DQNOVL-NEXT:    vpsrld $31, %zmm0, %zmm0
; DQNOVL-NEXT:    vcvtdq2ps %zmm0, %zmm0
; DQNOVL-NEXT:    retq
  %mask = icmp slt <16 x i32> %a, zeroinitializer
  %1 = uitofp <16 x i1> %mask to <16 x float>
  ret <16 x float> %1
}

define <16 x double> @ubto16f64(<16 x i32> %a) {
; NODQ-LABEL: ubto16f64:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; NODQ-NEXT:    vpcmpgtd %zmm0, %zmm1, %k1
; NODQ-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; NODQ-NEXT:    vpsrld $31, %zmm0, %zmm1
; NODQ-NEXT:    vcvtdq2pd %ymm1, %zmm0
; NODQ-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; NODQ-NEXT:    vcvtdq2pd %ymm1, %zmm1
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: ubto16f64:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vpmovd2m %zmm0, %k0
; VLDQ-NEXT:    vpmovm2d %k0, %zmm0
; VLDQ-NEXT:    vpsrld $31, %zmm0, %zmm1
; VLDQ-NEXT:    vcvtdq2pd %ymm1, %zmm0
; VLDQ-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; VLDQ-NEXT:    vcvtdq2pd %ymm1, %zmm1
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: ubto16f64:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vpmovd2m %zmm0, %k0
; DQNOVL-NEXT:    vpmovm2d %k0, %zmm0
; DQNOVL-NEXT:    vpsrld $31, %zmm0, %zmm1
; DQNOVL-NEXT:    vcvtdq2pd %ymm1, %zmm0
; DQNOVL-NEXT:    vextracti64x4 $1, %zmm1, %ymm1
; DQNOVL-NEXT:    vcvtdq2pd %ymm1, %zmm1
; DQNOVL-NEXT:    retq
  %mask = icmp slt <16 x i32> %a, zeroinitializer
  %1 = uitofp <16 x i1> %mask to <16 x double>
  ret <16 x double> %1
}

define <8 x float> @ubto8f32(<8 x i32> %a) {
; NOVL-LABEL: ubto8f32:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; NOVL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; NOVL-NEXT:    vpbroadcastd {{.*#+}} ymm1 = [1065353216,1065353216,1065353216,1065353216,1065353216,1065353216,1065353216,1065353216]
; NOVL-NEXT:    vpand %ymm1, %ymm0, %ymm0
; NOVL-NEXT:    retq
;
; VL-LABEL: ubto8f32:
; VL:       # %bb.0:
; VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; VL-NEXT:    vpcmpgtd %ymm0, %ymm1, %ymm0
; VL-NEXT:    vpandd {{.*}}(%rip){1to8}, %ymm0, %ymm0
; VL-NEXT:    retq
  %mask = icmp slt <8 x i32> %a, zeroinitializer
  %1 = uitofp <8 x i1> %mask to <8 x float>
  ret <8 x float> %1
}

define <8 x double> @ubto8f64(<8 x i32> %a) {
; ALL-LABEL: ubto8f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vpsrld $31, %ymm0, %ymm0
; ALL-NEXT:    vcvtdq2pd %ymm0, %zmm0
; ALL-NEXT:    retq
  %mask = icmp slt <8 x i32> %a, zeroinitializer
  %1 = uitofp <8 x i1> %mask to <8 x double>
  ret <8 x double> %1
}

define <4 x float> @ubto4f32(<4 x i32> %a) {
; NOVL-LABEL: ubto4f32:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; NOVL-NEXT:    vpcmpgtd %xmm0, %xmm1, %xmm0
; NOVL-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [1065353216,1065353216,1065353216,1065353216]
; NOVL-NEXT:    vpand %xmm1, %xmm0, %xmm0
; NOVL-NEXT:    retq
;
; VL-LABEL: ubto4f32:
; VL:       # %bb.0:
; VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; VL-NEXT:    vpcmpgtd %xmm0, %xmm1, %xmm0
; VL-NEXT:    vpandd {{.*}}(%rip){1to4}, %xmm0, %xmm0
; VL-NEXT:    retq
  %mask = icmp slt <4 x i32> %a, zeroinitializer
  %1 = uitofp <4 x i1> %mask to <4 x float>
  ret <4 x float> %1
}

define <4 x double> @ubto4f64(<4 x i32> %a) {
; ALL-LABEL: ubto4f64:
; ALL:       # %bb.0:
; ALL-NEXT:    vpsrld $31, %xmm0, %xmm0
; ALL-NEXT:    vcvtdq2pd %xmm0, %ymm0
; ALL-NEXT:    retq
  %mask = icmp slt <4 x i32> %a, zeroinitializer
  %1 = uitofp <4 x i1> %mask to <4 x double>
  ret <4 x double> %1
}

define <2 x float> @ubto2f32(<2 x i32> %a) {
; NOVL-LABEL: ubto2f32:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; NOVL-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; NOVL-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [1065353216,1065353216,1065353216,1065353216]
; NOVL-NEXT:    vpandn %xmm1, %xmm0, %xmm0
; NOVL-NEXT:    retq
;
; VL-LABEL: ubto2f32:
; VL:       # %bb.0:
; VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; VL-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; VL-NEXT:    vpandnd {{.*}}(%rip){1to4}, %xmm0, %xmm0
; VL-NEXT:    retq
  %mask = icmp ne <2 x i32> %a, zeroinitializer
  %1 = uitofp <2 x i1> %mask to <2 x float>
  ret <2 x float> %1
}

define <2 x double> @ubto2f64(<2 x i32> %a) {
; NOVL-LABEL: ubto2f64:
; NOVL:       # %bb.0:
; NOVL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; NOVL-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; NOVL-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [1,1,1,1]
; NOVL-NEXT:    vpandn %xmm1, %xmm0, %xmm0
; NOVL-NEXT:    vcvtdq2pd %xmm0, %xmm0
; NOVL-NEXT:    retq
;
; VL-LABEL: ubto2f64:
; VL:       # %bb.0:
; VL-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; VL-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; VL-NEXT:    vpandnd {{.*}}(%rip){1to4}, %xmm0, %xmm0
; VL-NEXT:    vcvtdq2pd %xmm0, %xmm0
; VL-NEXT:    retq
  %mask = icmp ne <2 x i32> %a, zeroinitializer
  %1 = uitofp <2 x i1> %mask to <2 x double>
  ret <2 x double> %1
}

define <2 x i64> @test_2f64toub(<2 x double> %a, <2 x i64> %passthru) {
; NOVLDQ-LABEL: test_2f64toub:
; NOVLDQ:       # %bb.0:
; NOVLDQ-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; NOVLDQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; NOVLDQ-NEXT:    vcvttpd2udq %zmm0, %ymm0
; NOVLDQ-NEXT:    vpslld $31, %ymm0, %ymm0
; NOVLDQ-NEXT:    vptestmd %zmm0, %zmm0, %k1
; NOVLDQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; NOVLDQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; NOVLDQ-NEXT:    vzeroupper
; NOVLDQ-NEXT:    retq
;
; VLDQ-LABEL: test_2f64toub:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvttpd2udq %xmm0, %xmm0
; VLDQ-NEXT:    vpslld $31, %xmm0, %xmm0
; VLDQ-NEXT:    vpmovd2m %xmm0, %k1
; VLDQ-NEXT:    vmovdqa64 %xmm1, %xmm0 {%k1} {z}
; VLDQ-NEXT:    retq
;
; VLNODQ-LABEL: test_2f64toub:
; VLNODQ:       # %bb.0:
; VLNODQ-NEXT:    vcvttpd2udq %xmm0, %xmm0
; VLNODQ-NEXT:    vpslld $31, %xmm0, %xmm0
; VLNODQ-NEXT:    vptestmd %xmm0, %xmm0, %k1
; VLNODQ-NEXT:    vmovdqa64 %xmm1, %xmm0 {%k1} {z}
; VLNODQ-NEXT:    retq
;
; DQNOVL-LABEL: test_2f64toub:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; DQNOVL-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; DQNOVL-NEXT:    vcvttpd2udq %zmm0, %ymm0
; DQNOVL-NEXT:    vpslld $31, %ymm0, %ymm0
; DQNOVL-NEXT:    vpmovd2m %zmm0, %k1
; DQNOVL-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; DQNOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; DQNOVL-NEXT:    vzeroupper
; DQNOVL-NEXT:    retq
  %mask = fptoui <2 x double> %a to <2 x i1>
  %select = select <2 x i1> %mask, <2 x i64> %passthru, <2 x i64> zeroinitializer
  ret <2 x i64> %select
}

define <4 x i64> @test_4f64toub(<4 x double> %a, <4 x i64> %passthru) {
; NOVLDQ-LABEL: test_4f64toub:
; NOVLDQ:       # %bb.0:
; NOVLDQ-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; NOVLDQ-NEXT:    vcvttpd2dq %ymm0, %xmm0
; NOVLDQ-NEXT:    vpslld $31, %xmm0, %xmm0
; NOVLDQ-NEXT:    vptestmd %zmm0, %zmm0, %k1
; NOVLDQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; NOVLDQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; NOVLDQ-NEXT:    retq
;
; VLDQ-LABEL: test_4f64toub:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvttpd2dq %ymm0, %xmm0
; VLDQ-NEXT:    vpslld $31, %xmm0, %xmm0
; VLDQ-NEXT:    vpmovd2m %xmm0, %k1
; VLDQ-NEXT:    vmovdqa64 %ymm1, %ymm0 {%k1} {z}
; VLDQ-NEXT:    retq
;
; VLNODQ-LABEL: test_4f64toub:
; VLNODQ:       # %bb.0:
; VLNODQ-NEXT:    vcvttpd2dq %ymm0, %xmm0
; VLNODQ-NEXT:    vpslld $31, %xmm0, %xmm0
; VLNODQ-NEXT:    vptestmd %xmm0, %xmm0, %k1
; VLNODQ-NEXT:    vmovdqa64 %ymm1, %ymm0 {%k1} {z}
; VLNODQ-NEXT:    retq
;
; DQNOVL-LABEL: test_4f64toub:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; DQNOVL-NEXT:    vcvttpd2dq %ymm0, %xmm0
; DQNOVL-NEXT:    vpslld $31, %xmm0, %xmm0
; DQNOVL-NEXT:    vpmovd2m %zmm0, %k1
; DQNOVL-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; DQNOVL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; DQNOVL-NEXT:    retq
  %mask = fptoui <4 x double> %a to <4 x i1>
  %select = select <4 x i1> %mask, <4 x i64> %passthru, <4 x i64> zeroinitializer
  ret <4 x i64> %select
}

define <8 x i64> @test_8f64toub(<8 x double> %a, <8 x i64> %passthru) {
; NOVLDQ-LABEL: test_8f64toub:
; NOVLDQ:       # %bb.0:
; NOVLDQ-NEXT:    vcvttpd2dq %zmm0, %ymm0
; NOVLDQ-NEXT:    vpslld $31, %ymm0, %ymm0
; NOVLDQ-NEXT:    vptestmd %zmm0, %zmm0, %k1
; NOVLDQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; NOVLDQ-NEXT:    retq
;
; VLDQ-LABEL: test_8f64toub:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvttpd2dq %zmm0, %ymm0
; VLDQ-NEXT:    vpslld $31, %ymm0, %ymm0
; VLDQ-NEXT:    vpmovd2m %ymm0, %k1
; VLDQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; VLDQ-NEXT:    retq
;
; VLNODQ-LABEL: test_8f64toub:
; VLNODQ:       # %bb.0:
; VLNODQ-NEXT:    vcvttpd2dq %zmm0, %ymm0
; VLNODQ-NEXT:    vpslld $31, %ymm0, %ymm0
; VLNODQ-NEXT:    vptestmd %ymm0, %ymm0, %k1
; VLNODQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; VLNODQ-NEXT:    retq
;
; DQNOVL-LABEL: test_8f64toub:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vcvttpd2dq %zmm0, %ymm0
; DQNOVL-NEXT:    vpslld $31, %ymm0, %ymm0
; DQNOVL-NEXT:    vpmovd2m %zmm0, %k1
; DQNOVL-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; DQNOVL-NEXT:    retq
  %mask = fptoui <8 x double> %a to <8 x i1>
  %select = select <8 x i1> %mask, <8 x i64> %passthru, <8 x i64> zeroinitializer
  ret <8 x i64> %select
}

define <2 x i64> @test_2f32toub(<2 x float> %a, <2 x i64> %passthru) {
; NOVLDQ-LABEL: test_2f32toub:
; NOVLDQ:       # %bb.0:
; NOVLDQ-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; NOVLDQ-NEXT:    vcvttps2dq %xmm0, %xmm0
; NOVLDQ-NEXT:    vpslld $31, %xmm0, %xmm0
; NOVLDQ-NEXT:    vptestmd %zmm0, %zmm0, %k1
; NOVLDQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; NOVLDQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; NOVLDQ-NEXT:    vzeroupper
; NOVLDQ-NEXT:    retq
;
; VLDQ-LABEL: test_2f32toub:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvttps2dq %xmm0, %xmm0
; VLDQ-NEXT:    vpslld $31, %xmm0, %xmm0
; VLDQ-NEXT:    vpmovd2m %xmm0, %k1
; VLDQ-NEXT:    vmovdqa64 %xmm1, %xmm0 {%k1} {z}
; VLDQ-NEXT:    retq
;
; VLNODQ-LABEL: test_2f32toub:
; VLNODQ:       # %bb.0:
; VLNODQ-NEXT:    vcvttps2dq %xmm0, %xmm0
; VLNODQ-NEXT:    vpslld $31, %xmm0, %xmm0
; VLNODQ-NEXT:    vptestmd %xmm0, %xmm0, %k1
; VLNODQ-NEXT:    vmovdqa64 %xmm1, %xmm0 {%k1} {z}
; VLNODQ-NEXT:    retq
;
; DQNOVL-LABEL: test_2f32toub:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; DQNOVL-NEXT:    vcvttps2dq %xmm0, %xmm0
; DQNOVL-NEXT:    vpslld $31, %xmm0, %xmm0
; DQNOVL-NEXT:    vpmovd2m %zmm0, %k1
; DQNOVL-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; DQNOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; DQNOVL-NEXT:    vzeroupper
; DQNOVL-NEXT:    retq
  %mask = fptoui <2 x float> %a to <2 x i1>
  %select = select <2 x i1> %mask, <2 x i64> %passthru, <2 x i64> zeroinitializer
  ret <2 x i64> %select
}

define <4 x i64> @test_4f32toub(<4 x float> %a, <4 x i64> %passthru) {
; NOVLDQ-LABEL: test_4f32toub:
; NOVLDQ:       # %bb.0:
; NOVLDQ-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; NOVLDQ-NEXT:    vcvttps2dq %xmm0, %xmm0
; NOVLDQ-NEXT:    vpslld $31, %xmm0, %xmm0
; NOVLDQ-NEXT:    vptestmd %zmm0, %zmm0, %k1
; NOVLDQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; NOVLDQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; NOVLDQ-NEXT:    retq
;
; VLDQ-LABEL: test_4f32toub:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvttps2dq %xmm0, %xmm0
; VLDQ-NEXT:    vpslld $31, %xmm0, %xmm0
; VLDQ-NEXT:    vpmovd2m %xmm0, %k1
; VLDQ-NEXT:    vmovdqa64 %ymm1, %ymm0 {%k1} {z}
; VLDQ-NEXT:    retq
;
; VLNODQ-LABEL: test_4f32toub:
; VLNODQ:       # %bb.0:
; VLNODQ-NEXT:    vcvttps2dq %xmm0, %xmm0
; VLNODQ-NEXT:    vpslld $31, %xmm0, %xmm0
; VLNODQ-NEXT:    vptestmd %xmm0, %xmm0, %k1
; VLNODQ-NEXT:    vmovdqa64 %ymm1, %ymm0 {%k1} {z}
; VLNODQ-NEXT:    retq
;
; DQNOVL-LABEL: test_4f32toub:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; DQNOVL-NEXT:    vcvttps2dq %xmm0, %xmm0
; DQNOVL-NEXT:    vpslld $31, %xmm0, %xmm0
; DQNOVL-NEXT:    vpmovd2m %zmm0, %k1
; DQNOVL-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; DQNOVL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; DQNOVL-NEXT:    retq
  %mask = fptoui <4 x float> %a to <4 x i1>
  %select = select <4 x i1> %mask, <4 x i64> %passthru, <4 x i64> zeroinitializer
  ret <4 x i64> %select
}

define <8 x i64> @test_8f32toub(<8 x float> %a, <8 x i64> %passthru) {
; NOVLDQ-LABEL: test_8f32toub:
; NOVLDQ:       # %bb.0:
; NOVLDQ-NEXT:    vcvttps2dq %ymm0, %ymm0
; NOVLDQ-NEXT:    vpslld $31, %ymm0, %ymm0
; NOVLDQ-NEXT:    vptestmd %zmm0, %zmm0, %k1
; NOVLDQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; NOVLDQ-NEXT:    retq
;
; VLDQ-LABEL: test_8f32toub:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvttps2dq %ymm0, %ymm0
; VLDQ-NEXT:    vpslld $31, %ymm0, %ymm0
; VLDQ-NEXT:    vpmovd2m %ymm0, %k1
; VLDQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; VLDQ-NEXT:    retq
;
; VLNODQ-LABEL: test_8f32toub:
; VLNODQ:       # %bb.0:
; VLNODQ-NEXT:    vcvttps2dq %ymm0, %ymm0
; VLNODQ-NEXT:    vpslld $31, %ymm0, %ymm0
; VLNODQ-NEXT:    vptestmd %ymm0, %ymm0, %k1
; VLNODQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; VLNODQ-NEXT:    retq
;
; DQNOVL-LABEL: test_8f32toub:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vcvttps2dq %ymm0, %ymm0
; DQNOVL-NEXT:    vpslld $31, %ymm0, %ymm0
; DQNOVL-NEXT:    vpmovd2m %zmm0, %k1
; DQNOVL-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; DQNOVL-NEXT:    retq
  %mask = fptoui <8 x float> %a to <8 x i1>
  %select = select <8 x i1> %mask, <8 x i64> %passthru, <8 x i64> zeroinitializer
  ret <8 x i64> %select
}

define <16 x i32> @test_16f32toub(<16 x float> %a, <16 x i32> %passthru) {
; NODQ-LABEL: test_16f32toub:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vcvttps2dq %zmm0, %zmm0
; NODQ-NEXT:    vpslld $31, %zmm0, %zmm0
; NODQ-NEXT:    vptestmd %zmm0, %zmm0, %k1
; NODQ-NEXT:    vmovdqa32 %zmm1, %zmm0 {%k1} {z}
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: test_16f32toub:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvttps2dq %zmm0, %zmm0
; VLDQ-NEXT:    vpslld $31, %zmm0, %zmm0
; VLDQ-NEXT:    vpmovd2m %zmm0, %k1
; VLDQ-NEXT:    vmovdqa32 %zmm1, %zmm0 {%k1} {z}
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: test_16f32toub:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vcvttps2dq %zmm0, %zmm0
; DQNOVL-NEXT:    vpslld $31, %zmm0, %zmm0
; DQNOVL-NEXT:    vpmovd2m %zmm0, %k1
; DQNOVL-NEXT:    vmovdqa32 %zmm1, %zmm0 {%k1} {z}
; DQNOVL-NEXT:    retq
  %mask = fptoui <16 x float> %a to <16 x i1>
  %select = select <16 x i1> %mask, <16 x i32> %passthru, <16 x i32> zeroinitializer
  ret <16 x i32> %select
}

define <2 x i64> @test_2f64tosb(<2 x double> %a, <2 x i64> %passthru) {
; NOVLDQ-LABEL: test_2f64tosb:
; NOVLDQ:       # %bb.0:
; NOVLDQ-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; NOVLDQ-NEXT:    vcvttpd2dq %xmm0, %xmm0
; NOVLDQ-NEXT:    vpslld $31, %xmm0, %xmm0
; NOVLDQ-NEXT:    vptestmd %zmm0, %zmm0, %k1
; NOVLDQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; NOVLDQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; NOVLDQ-NEXT:    vzeroupper
; NOVLDQ-NEXT:    retq
;
; VLDQ-LABEL: test_2f64tosb:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvttpd2dq %xmm0, %xmm0
; VLDQ-NEXT:    vpslld $31, %xmm0, %xmm0
; VLDQ-NEXT:    vpmovd2m %xmm0, %k1
; VLDQ-NEXT:    vmovdqa64 %xmm1, %xmm0 {%k1} {z}
; VLDQ-NEXT:    retq
;
; VLNODQ-LABEL: test_2f64tosb:
; VLNODQ:       # %bb.0:
; VLNODQ-NEXT:    vcvttpd2dq %xmm0, %xmm0
; VLNODQ-NEXT:    vpslld $31, %xmm0, %xmm0
; VLNODQ-NEXT:    vptestmd %xmm0, %xmm0, %k1
; VLNODQ-NEXT:    vmovdqa64 %xmm1, %xmm0 {%k1} {z}
; VLNODQ-NEXT:    retq
;
; DQNOVL-LABEL: test_2f64tosb:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; DQNOVL-NEXT:    vcvttpd2dq %xmm0, %xmm0
; DQNOVL-NEXT:    vpslld $31, %xmm0, %xmm0
; DQNOVL-NEXT:    vpmovd2m %zmm0, %k1
; DQNOVL-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; DQNOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; DQNOVL-NEXT:    vzeroupper
; DQNOVL-NEXT:    retq
  %mask = fptosi <2 x double> %a to <2 x i1>
  %select = select <2 x i1> %mask, <2 x i64> %passthru, <2 x i64> zeroinitializer
  ret <2 x i64> %select
}

define <4 x i64> @test_4f64tosb(<4 x double> %a, <4 x i64> %passthru) {
; NOVLDQ-LABEL: test_4f64tosb:
; NOVLDQ:       # %bb.0:
; NOVLDQ-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; NOVLDQ-NEXT:    vcvttpd2dq %ymm0, %xmm0
; NOVLDQ-NEXT:    vptestmd %zmm0, %zmm0, %k1
; NOVLDQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; NOVLDQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; NOVLDQ-NEXT:    retq
;
; VLDQ-LABEL: test_4f64tosb:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvttpd2dq %ymm0, %xmm0
; VLDQ-NEXT:    vpmovd2m %xmm0, %k1
; VLDQ-NEXT:    vmovdqa64 %ymm1, %ymm0 {%k1} {z}
; VLDQ-NEXT:    retq
;
; VLNODQ-LABEL: test_4f64tosb:
; VLNODQ:       # %bb.0:
; VLNODQ-NEXT:    vcvttpd2dq %ymm0, %xmm0
; VLNODQ-NEXT:    vptestmd %xmm0, %xmm0, %k1
; VLNODQ-NEXT:    vmovdqa64 %ymm1, %ymm0 {%k1} {z}
; VLNODQ-NEXT:    retq
;
; DQNOVL-LABEL: test_4f64tosb:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; DQNOVL-NEXT:    vcvttpd2dq %ymm0, %xmm0
; DQNOVL-NEXT:    vpmovd2m %zmm0, %k1
; DQNOVL-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; DQNOVL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; DQNOVL-NEXT:    retq
  %mask = fptosi <4 x double> %a to <4 x i1>
  %select = select <4 x i1> %mask, <4 x i64> %passthru, <4 x i64> zeroinitializer
  ret <4 x i64> %select
}

define <8 x i64> @test_8f64tosb(<8 x double> %a, <8 x i64> %passthru) {
; NOVLDQ-LABEL: test_8f64tosb:
; NOVLDQ:       # %bb.0:
; NOVLDQ-NEXT:    vcvttpd2dq %zmm0, %ymm0
; NOVLDQ-NEXT:    vptestmd %zmm0, %zmm0, %k1
; NOVLDQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; NOVLDQ-NEXT:    retq
;
; VLDQ-LABEL: test_8f64tosb:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvttpd2dq %zmm0, %ymm0
; VLDQ-NEXT:    vpmovd2m %ymm0, %k1
; VLDQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; VLDQ-NEXT:    retq
;
; VLNODQ-LABEL: test_8f64tosb:
; VLNODQ:       # %bb.0:
; VLNODQ-NEXT:    vcvttpd2dq %zmm0, %ymm0
; VLNODQ-NEXT:    vptestmd %ymm0, %ymm0, %k1
; VLNODQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; VLNODQ-NEXT:    retq
;
; DQNOVL-LABEL: test_8f64tosb:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vcvttpd2dq %zmm0, %ymm0
; DQNOVL-NEXT:    vpmovd2m %zmm0, %k1
; DQNOVL-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; DQNOVL-NEXT:    retq
  %mask = fptosi <8 x double> %a to <8 x i1>
  %select = select <8 x i1> %mask, <8 x i64> %passthru, <8 x i64> zeroinitializer
  ret <8 x i64> %select
}

define <2 x i64> @test_2f32tosb(<2 x float> %a, <2 x i64> %passthru) {
; NOVLDQ-LABEL: test_2f32tosb:
; NOVLDQ:       # %bb.0:
; NOVLDQ-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; NOVLDQ-NEXT:    vcvttps2dq %xmm0, %xmm0
; NOVLDQ-NEXT:    vptestmd %zmm0, %zmm0, %k1
; NOVLDQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; NOVLDQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; NOVLDQ-NEXT:    vzeroupper
; NOVLDQ-NEXT:    retq
;
; VLDQ-LABEL: test_2f32tosb:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvttps2dq %xmm0, %xmm0
; VLDQ-NEXT:    vpmovd2m %xmm0, %k1
; VLDQ-NEXT:    vmovdqa64 %xmm1, %xmm0 {%k1} {z}
; VLDQ-NEXT:    retq
;
; VLNODQ-LABEL: test_2f32tosb:
; VLNODQ:       # %bb.0:
; VLNODQ-NEXT:    vcvttps2dq %xmm0, %xmm0
; VLNODQ-NEXT:    vptestmd %xmm0, %xmm0, %k1
; VLNODQ-NEXT:    vmovdqa64 %xmm1, %xmm0 {%k1} {z}
; VLNODQ-NEXT:    retq
;
; DQNOVL-LABEL: test_2f32tosb:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; DQNOVL-NEXT:    vcvttps2dq %xmm0, %xmm0
; DQNOVL-NEXT:    vpmovd2m %zmm0, %k1
; DQNOVL-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; DQNOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; DQNOVL-NEXT:    vzeroupper
; DQNOVL-NEXT:    retq
  %mask = fptosi <2 x float> %a to <2 x i1>
  %select = select <2 x i1> %mask, <2 x i64> %passthru, <2 x i64> zeroinitializer
  ret <2 x i64> %select
}

define <4 x i64> @test_4f32tosb(<4 x float> %a, <4 x i64> %passthru) {
; NOVLDQ-LABEL: test_4f32tosb:
; NOVLDQ:       # %bb.0:
; NOVLDQ-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; NOVLDQ-NEXT:    vcvttps2dq %xmm0, %xmm0
; NOVLDQ-NEXT:    vptestmd %zmm0, %zmm0, %k1
; NOVLDQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; NOVLDQ-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; NOVLDQ-NEXT:    retq
;
; VLDQ-LABEL: test_4f32tosb:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvttps2dq %xmm0, %xmm0
; VLDQ-NEXT:    vpmovd2m %xmm0, %k1
; VLDQ-NEXT:    vmovdqa64 %ymm1, %ymm0 {%k1} {z}
; VLDQ-NEXT:    retq
;
; VLNODQ-LABEL: test_4f32tosb:
; VLNODQ:       # %bb.0:
; VLNODQ-NEXT:    vcvttps2dq %xmm0, %xmm0
; VLNODQ-NEXT:    vptestmd %xmm0, %xmm0, %k1
; VLNODQ-NEXT:    vmovdqa64 %ymm1, %ymm0 {%k1} {z}
; VLNODQ-NEXT:    retq
;
; DQNOVL-LABEL: test_4f32tosb:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; DQNOVL-NEXT:    vcvttps2dq %xmm0, %xmm0
; DQNOVL-NEXT:    vpmovd2m %zmm0, %k1
; DQNOVL-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; DQNOVL-NEXT:    # kill: def $ymm0 killed $ymm0 killed $zmm0
; DQNOVL-NEXT:    retq
  %mask = fptosi <4 x float> %a to <4 x i1>
  %select = select <4 x i1> %mask, <4 x i64> %passthru, <4 x i64> zeroinitializer
  ret <4 x i64> %select
}

define <8 x i64> @test_8f32tosb(<8 x float> %a, <8 x i64> %passthru) {
; NOVLDQ-LABEL: test_8f32tosb:
; NOVLDQ:       # %bb.0:
; NOVLDQ-NEXT:    vcvttps2dq %ymm0, %ymm0
; NOVLDQ-NEXT:    vptestmd %zmm0, %zmm0, %k1
; NOVLDQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; NOVLDQ-NEXT:    retq
;
; VLDQ-LABEL: test_8f32tosb:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvttps2dq %ymm0, %ymm0
; VLDQ-NEXT:    vpmovd2m %ymm0, %k1
; VLDQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; VLDQ-NEXT:    retq
;
; VLNODQ-LABEL: test_8f32tosb:
; VLNODQ:       # %bb.0:
; VLNODQ-NEXT:    vcvttps2dq %ymm0, %ymm0
; VLNODQ-NEXT:    vptestmd %ymm0, %ymm0, %k1
; VLNODQ-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; VLNODQ-NEXT:    retq
;
; DQNOVL-LABEL: test_8f32tosb:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vcvttps2dq %ymm0, %ymm0
; DQNOVL-NEXT:    vpmovd2m %zmm0, %k1
; DQNOVL-NEXT:    vmovdqa64 %zmm1, %zmm0 {%k1} {z}
; DQNOVL-NEXT:    retq
  %mask = fptosi <8 x float> %a to <8 x i1>
  %select = select <8 x i1> %mask, <8 x i64> %passthru, <8 x i64> zeroinitializer
  ret <8 x i64> %select
}

define <16 x i32> @test_16f32tosb(<16 x float> %a, <16 x i32> %passthru) {
; NODQ-LABEL: test_16f32tosb:
; NODQ:       # %bb.0:
; NODQ-NEXT:    vcvttps2dq %zmm0, %zmm0
; NODQ-NEXT:    vptestmd %zmm0, %zmm0, %k1
; NODQ-NEXT:    vmovdqa32 %zmm1, %zmm0 {%k1} {z}
; NODQ-NEXT:    retq
;
; VLDQ-LABEL: test_16f32tosb:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vcvttps2dq %zmm0, %zmm0
; VLDQ-NEXT:    vpmovd2m %zmm0, %k1
; VLDQ-NEXT:    vmovdqa32 %zmm1, %zmm0 {%k1} {z}
; VLDQ-NEXT:    retq
;
; DQNOVL-LABEL: test_16f32tosb:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    vcvttps2dq %zmm0, %zmm0
; DQNOVL-NEXT:    vpmovd2m %zmm0, %k1
; DQNOVL-NEXT:    vmovdqa32 %zmm1, %zmm0 {%k1} {z}
; DQNOVL-NEXT:    retq
  %mask = fptosi <16 x float> %a to <16 x i1>
  %select = select <16 x i1> %mask, <16 x i32> %passthru, <16 x i32> zeroinitializer
  ret <16 x i32> %select
}

define <2 x double> @test_sito2f64_mask_load(<2 x i32> *%a, <2 x i64> %c) {
; SSE-LABEL: sitofp_load_2i32_to_2f64:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtdq2pd (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: sitofp_load_2i32_to_2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtdq2pd (%rdi), %xmm0
; AVX-NEXT:    retq
; NOVLDQ-LABEL: test_sito2f64_mask_load:
; NOVLDQ:       # %bb.0:
; NOVLDQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; NOVLDQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; NOVLDQ-NEXT:    vpcmpgtq %zmm0, %zmm1, %k1
; NOVLDQ-NEXT:    vcvtdq2pd (%rdi), %xmm0
; NOVLDQ-NEXT:    vmovapd %zmm0, %zmm0 {%k1} {z}
; NOVLDQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; NOVLDQ-NEXT:    vzeroupper
; NOVLDQ-NEXT:    retq
;
; VLDQ-LABEL: test_sito2f64_mask_load:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vpmovq2m %xmm0, %k1
; VLDQ-NEXT:    vcvtdq2pd (%rdi), %xmm0 {%k1} {z}
; VLDQ-NEXT:    retq
;
; VLNODQ-LABEL: test_sito2f64_mask_load:
; VLNODQ:       # %bb.0:
; VLNODQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; VLNODQ-NEXT:    vpcmpgtq %xmm0, %xmm1, %k1
; VLNODQ-NEXT:    vcvtdq2pd (%rdi), %xmm0 {%k1} {z}
; VLNODQ-NEXT:    retq
;
; DQNOVL-LABEL: test_sito2f64_mask_load:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; DQNOVL-NEXT:    vpmovq2m %zmm0, %k1
; DQNOVL-NEXT:    vcvtdq2pd (%rdi), %xmm0
; DQNOVL-NEXT:    vmovapd %zmm0, %zmm0 {%k1} {z}
; DQNOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; DQNOVL-NEXT:    vzeroupper
; DQNOVL-NEXT:    retq
  %mask = icmp slt <2 x i64> %c, zeroinitializer
  %ld = load <2 x i32>, <2 x i32> *%a
  %cvt = sitofp <2 x i32> %ld to <2 x double>
  %sel = select <2 x i1> %mask, <2 x double> %cvt, <2 x double> zeroinitializer
  ret <2 x double> %sel
}

define <2 x double> @test_uito2f64_mask_load(<2 x i32> *%a, <2 x i64> %c) {
; SSE-LABEL: sitofp_load_2i32_to_2f64:
; SSE:       # %bb.0:
; SSE-NEXT:    cvtdq2pd (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: sitofp_load_2i32_to_2f64:
; AVX:       # %bb.0:
; AVX-NEXT:    vcvtdq2pd (%rdi), %xmm0
; AVX-NEXT:    retq
; NOVLDQ-LABEL: test_uito2f64_mask_load:
; NOVLDQ:       # %bb.0:
; NOVLDQ-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; NOVLDQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; NOVLDQ-NEXT:    vpcmpgtq %zmm0, %zmm1, %k1
; NOVLDQ-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; NOVLDQ-NEXT:    vcvtudq2pd %ymm0, %zmm0
; NOVLDQ-NEXT:    vmovapd %zmm0, %zmm0 {%k1} {z}
; NOVLDQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; NOVLDQ-NEXT:    vzeroupper
; NOVLDQ-NEXT:    retq
;
; VLDQ-LABEL: test_uito2f64_mask_load:
; VLDQ:       # %bb.0:
; VLDQ-NEXT:    vpmovq2m %xmm0, %k1
; VLDQ-NEXT:    vcvtudq2pd (%rdi), %xmm0 {%k1} {z}
; VLDQ-NEXT:    retq
;
; VLNODQ-LABEL: test_uito2f64_mask_load:
; VLNODQ:       # %bb.0:
; VLNODQ-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; VLNODQ-NEXT:    vpcmpgtq %xmm0, %xmm1, %k1
; VLNODQ-NEXT:    vcvtudq2pd (%rdi), %xmm0 {%k1} {z}
; VLNODQ-NEXT:    retq
;
; DQNOVL-LABEL: test_uito2f64_mask_load:
; DQNOVL:       # %bb.0:
; DQNOVL-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; DQNOVL-NEXT:    vpmovq2m %zmm0, %k1
; DQNOVL-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; DQNOVL-NEXT:    vcvtudq2pd %ymm0, %zmm0
; DQNOVL-NEXT:    vmovapd %zmm0, %zmm0 {%k1} {z}
; DQNOVL-NEXT:    # kill: def $xmm0 killed $xmm0 killed $zmm0
; DQNOVL-NEXT:    vzeroupper
; DQNOVL-NEXT:    retq
  %mask = icmp slt <2 x i64> %c, zeroinitializer
  %ld = load <2 x i32>, <2 x i32> *%a
  %cvt = uitofp <2 x i32> %ld to <2 x double>
  %sel = select <2 x i1> %mask, <2 x double> %cvt, <2 x double> zeroinitializer
  ret <2 x double> %sel
}
