; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; Test removal of AND operations that don't affect last 6 bits of shift amount
; operand.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu | FileCheck %s

; Test that AND is not removed when some lower 6 bits are not set.
define i32 @f1(i32 %a, i32 %sh) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    nill %r3, 31
; CHECK-NEXT:    sll %r2, 0(%r3)
; CHECK-NEXT:    br %r14
  %and = and i32 %sh, 31
  %shift = shl i32 %a, %and
  ret i32 %shift
}

; Test removal of AND mask with only bottom 6 bits set.
define i32 @f2(i32 %a, i32 %sh) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sll %r2, 0(%r3)
; CHECK-NEXT:    br %r14
  %and = and i32 %sh, 63
  %shift = shl i32 %a, %and
  ret i32 %shift
}

; Test removal of AND mask including but not limited to bottom 6 bits.
define i32 @f3(i32 %a, i32 %sh) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sll %r2, 0(%r3)
; CHECK-NEXT:    br %r14
  %and = and i32 %sh, 255
  %shift = shl i32 %a, %and
  ret i32 %shift
}

; Test removal of AND mask from SRA.
define i32 @f4(i32 %a, i32 %sh) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sra %r2, 0(%r3)
; CHECK-NEXT:    br %r14
  %and = and i32 %sh, 63
  %shift = ashr i32 %a, %and
  ret i32 %shift
}

; Test removal of AND mask from SRL.
define i32 @f5(i32 %a, i32 %sh) {
; CHECK-LABEL: f5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srl %r2, 0(%r3)
; CHECK-NEXT:    br %r14
  %and = and i32 %sh, 63
  %shift = lshr i32 %a, %and
  ret i32 %shift
}

; Test removal of AND mask from SLLG.
define i64 @f6(i64 %a, i64 %sh) {
; CHECK-LABEL: f6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sllg %r2, %r2, 0(%r3)
; CHECK-NEXT:    br %r14
  %and = and i64 %sh, 63
  %shift = shl i64 %a, %and
  ret i64 %shift
}

; Test removal of AND mask from SRAG.
define i64 @f7(i64 %a, i64 %sh) {
; CHECK-LABEL: f7:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srag %r2, %r2, 0(%r3)
; CHECK-NEXT:    br %r14
  %and = and i64 %sh, 63
  %shift = ashr i64 %a, %and
  ret i64 %shift
}

; Test removal of AND mask from SRLG.
define i64 @f8(i64 %a, i64 %sh) {
; CHECK-LABEL: f8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srlg %r2, %r2, 0(%r3)
; CHECK-NEXT:    br %r14
  %and = and i64 %sh, 63
  %shift = lshr i64 %a, %and
  ret i64 %shift
}

; Test that AND with two register operands is not affected.
define i32 @f9(i32 %a, i32 %b, i32 %sh) {
; CHECK-LABEL: f9:
; CHECK:       # %bb.0:
; CHECK-NEXT:    nr %r3, %r4
; CHECK-NEXT:    sll %r2, 0(%r3)
; CHECK-NEXT:    br %r14
  %and = and i32 %sh, %b
  %shift = shl i32 %a, %and
  ret i32 %shift
}

; Test that AND is not entirely removed if the result is reused.
define i32 @f10(i32 %a, i32 %sh) {
; CHECK-LABEL: f10:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sll %r2, 0(%r3)
; CHECK-NEXT:    nilf %r3, 63
; CHECK-NEXT:    ar %r2, %r3
; CHECK-NEXT:    br %r14
  %and = and i32 %sh, 63
  %shift = shl i32 %a, %and
  %reuse = add i32 %and, %shift
  ret i32 %reuse
}

; Test that AND is not removed for i128 (which calls __ashlti3)
define i128 @f11(i128 %a, i32 %sh) {
; CHECK-LABEL: f11:
; CHECK:       # %bb.0:
; CHECK-NEXT:    stmg %r13, %r15, 104(%r15)
; CHECK-NEXT:    .cfi_offset %r13, -56
; CHECK-NEXT:    .cfi_offset %r14, -48
; CHECK-NEXT:    .cfi_offset %r15, -40
; CHECK-NEXT:    aghi %r15, -192
; CHECK-NEXT:    .cfi_def_cfa_offset 352
; CHECK-NEXT:    lg %r0, 8(%r3)
; CHECK-NEXT:    # kill: def $r4l killed $r4l def $r4d
; CHECK-NEXT:    lgr %r13, %r2
; CHECK-NEXT:    lg %r1, 0(%r3)
; CHECK-NEXT:    stg %r0, 168(%r15)
; CHECK-NEXT:    risbg %r4, %r4, 57, 191, 0
; CHECK-NEXT:    la %r2, 176(%r15)
; CHECK-NEXT:    la %r3, 160(%r15)
; CHECK-NEXT:    stg %r1, 160(%r15)
; CHECK-NEXT:    brasl %r14, __ashlti3@PLT
; CHECK-NEXT:    lg %r0, 184(%r15)
; CHECK-NEXT:    lg %r1, 176(%r15)
; CHECK-NEXT:    stg %r0, 8(%r13)
; CHECK-NEXT:    stg %r1, 0(%r13)
; CHECK-NEXT:    lmg %r13, %r15, 296(%r15)
; CHECK-NEXT:    br %r14
  %and = and i32 %sh, 127
  %ext = zext i32 %and to i128
  %shift = shl i128 %a, %ext
  ret i128 %shift
}

