; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -disable-peephole -mtriple=x86_64-unknown-unknown -mattr=+avx512vnni,+avx512vl,+avx512bw | FileCheck %s --check-prefixes=CHECK

define <4 x i32> @test_pmaddwd_v8i16_add_v4i32(<4 x i32> %a0, <8 x i16> %a1, <8 x i16> %a2) {
; CHECK-LABEL: test_pmaddwd_v8i16_add_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %1 = call <4 x i32> @llvm.x86.sse2.pmadd.wd(<8 x i16> %a1, <8 x i16> %a2)
  %2 = add <4 x i32> %1, %a0
  ret <4 x i32> %2
}

define <4 x i32> @test_pmaddwd_v8i16_add_v4i32_commute(<4 x i32> %a0, <8 x i16> %a1, <8 x i16> %a2) {
; CHECK-LABEL: test_pmaddwd_v8i16_add_v4i32_commute:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd %xmm2, %xmm1, %xmm0
; CHECK-NEXT:    retq
  %1 = call <4 x i32> @llvm.x86.sse2.pmadd.wd(<8 x i16> %a1, <8 x i16> %a2)
  %2 = add <4 x i32> %a0, %1
  ret <4 x i32> %2
}

define <4 x i32> @test_pmaddwd_v8i16_add_v4i32_load1(<4 x i32> %a0, <8 x i16>* %p1, <8 x i16> %a2) {
; CHECK-LABEL: test_pmaddwd_v8i16_add_v4i32_load1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd (%rdi), %xmm1, %xmm0
; CHECK-NEXT:    retq
  %a1 = load <8 x i16>, <8 x i16>* %p1
  %1 = call <4 x i32> @llvm.x86.sse2.pmadd.wd(<8 x i16> %a1, <8 x i16> %a2)
  %2 = add <4 x i32> %1, %a0
  ret <4 x i32> %2
}

define <4 x i32> @test_pmaddwd_v8i16_add_v4i32_load2(<4 x i32> %a0, <8 x i16> %a1, <8 x i16>* %p2) {
; CHECK-LABEL: test_pmaddwd_v8i16_add_v4i32_load2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd (%rdi), %xmm1, %xmm0
; CHECK-NEXT:    retq
  %a2 = load <8 x i16>, <8 x i16>* %p2
  %1 = call <4 x i32> @llvm.x86.sse2.pmadd.wd(<8 x i16> %a1, <8 x i16> %a2)
  %2 = add <4 x i32> %1, %a0
  ret <4 x i32> %2
}

define <4 x i32> @test_pmaddwd_v8i16_add_v4i32_commute_load1(<4 x i32> %a0, <8 x i16>* %p1, <8 x i16> %a2) {
; CHECK-LABEL: test_pmaddwd_v8i16_add_v4i32_commute_load1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd (%rdi), %xmm1, %xmm0
; CHECK-NEXT:    retq
  %a1 = load <8 x i16>, <8 x i16>* %p1
  %1 = call <4 x i32> @llvm.x86.sse2.pmadd.wd(<8 x i16> %a1, <8 x i16> %a2)
  %2 = add <4 x i32> %a0, %1
  ret <4 x i32> %2
}

define <4 x i32> @test_pmaddwd_v8i16_add_v4i32_commute_load2(<4 x i32> %a0, <8 x i16> %a1, <8 x i16>* %p2) {
; CHECK-LABEL: test_pmaddwd_v8i16_add_v4i32_commute_load2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd (%rdi), %xmm1, %xmm0
; CHECK-NEXT:    retq
  %a2 = load <8 x i16>, <8 x i16>* %p2
  %1 = call <4 x i32> @llvm.x86.sse2.pmadd.wd(<8 x i16> %a1, <8 x i16> %a2)
  %2 = add <4 x i32> %a0, %1
  ret <4 x i32> %2
}

define <8 x i32> @test_pmaddwd_v16i16_add_v8i32(<8 x i32> %a0, <16 x i16> %a1, <16 x i16> %a2) {
; CHECK-LABEL: test_pmaddwd_v16i16_add_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %1 = call <8 x i32> @llvm.x86.avx2.pmadd.wd(<16 x i16> %a1, <16 x i16> %a2)
  %2 = add <8 x i32> %1, %a0
  ret <8 x i32> %2
}

define <8 x i32> @test_pmaddwd_v16i16_add_v8i32_commute(<8 x i32> %a0, <16 x i16> %a1, <16 x i16> %a2) {
; CHECK-LABEL: test_pmaddwd_v16i16_add_v8i32_commute:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd %ymm2, %ymm1, %ymm0
; CHECK-NEXT:    retq
  %1 = call <8 x i32> @llvm.x86.avx2.pmadd.wd(<16 x i16> %a1, <16 x i16> %a2)
  %2 = add <8 x i32> %a0, %1
  ret <8 x i32> %2
}

define <8 x i32> @test_pmaddwd_v16i16_add_v8i32_load1(<8 x i32> %a0, <16 x i16>* %p1, <16 x i16> %a2) {
; CHECK-LABEL: test_pmaddwd_v16i16_add_v8i32_load1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd (%rdi), %ymm1, %ymm0
; CHECK-NEXT:    retq
  %a1 = load <16 x i16>, <16 x i16>* %p1
  %1 = call <8 x i32> @llvm.x86.avx2.pmadd.wd(<16 x i16> %a1, <16 x i16> %a2)
  %2 = add <8 x i32> %1, %a0
  ret <8 x i32> %2
}

define <8 x i32> @test_pmaddwd_v16i16_add_v8i32_load2(<8 x i32> %a0, <16 x i16> %a1, <16 x i16>* %p2) {
; CHECK-LABEL: test_pmaddwd_v16i16_add_v8i32_load2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd (%rdi), %ymm1, %ymm0
; CHECK-NEXT:    retq
  %a2 = load <16 x i16>, <16 x i16>* %p2
  %1 = call <8 x i32> @llvm.x86.avx2.pmadd.wd(<16 x i16> %a1, <16 x i16> %a2)
  %2 = add <8 x i32> %1, %a0
  ret <8 x i32> %2
}

define <8 x i32> @test_pmaddwd_v16i16_add_v8i32_commute_load1(<8 x i32> %a0, <16 x i16>* %p1, <16 x i16> %a2) {
; CHECK-LABEL: test_pmaddwd_v16i16_add_v8i32_commute_load1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd (%rdi), %ymm1, %ymm0
; CHECK-NEXT:    retq
  %a1 = load <16 x i16>, <16 x i16>* %p1
  %1 = call <8 x i32> @llvm.x86.avx2.pmadd.wd(<16 x i16> %a1, <16 x i16> %a2)
  %2 = add <8 x i32> %a0, %1
  ret <8 x i32> %2
}

define <8 x i32> @test_pmaddwd_v16i16_add_v8i32_commute_load2(<8 x i32> %a0, <16 x i16> %a1, <16 x i16>* %p2) {
; CHECK-LABEL: test_pmaddwd_v16i16_add_v8i32_commute_load2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd (%rdi), %ymm1, %ymm0
; CHECK-NEXT:    retq
  %a2 = load <16 x i16>, <16 x i16>* %p2
  %1 = call <8 x i32> @llvm.x86.avx2.pmadd.wd(<16 x i16> %a1, <16 x i16> %a2)
  %2 = add <8 x i32> %a0, %1
  ret <8 x i32> %2
}

define <16 x i32> @test_pmaddwd_v32i16_add_v16i32(<16 x i32> %a0, <32 x i16> %a1, <32 x i16> %a2) {
; CHECK-LABEL: test_pmaddwd_v32i16_add_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %1 = call <16 x i32> @llvm.x86.avx512.pmaddw.d.512(<32 x i16> %a1, <32 x i16> %a2)
  %2 = add <16 x i32> %1, %a0
  ret <16 x i32> %2
}

define <16 x i32> @test_pmaddwd_v32i16_add_v16i32_commute(<16 x i32> %a0, <32 x i16> %a1, <32 x i16> %a2) {
; CHECK-LABEL: test_pmaddwd_v32i16_add_v16i32_commute:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd %zmm2, %zmm1, %zmm0
; CHECK-NEXT:    retq
  %1 = call <16 x i32> @llvm.x86.avx512.pmaddw.d.512(<32 x i16> %a1, <32 x i16> %a2)
  %2 = add <16 x i32> %a0, %1
  ret <16 x i32> %2
}

define <16 x i32> @test_pmaddwd_v32i16_add_v16i32_load1(<16 x i32> %a0, <32 x i16>* %p1, <32 x i16> %a2) {
; CHECK-LABEL: test_pmaddwd_v32i16_add_v16i32_load1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd (%rdi), %zmm1, %zmm0
; CHECK-NEXT:    retq
  %a1 = load <32 x i16>, <32 x i16>* %p1
  %1 = call <16 x i32> @llvm.x86.avx512.pmaddw.d.512(<32 x i16> %a1, <32 x i16> %a2)
  %2 = add <16 x i32> %1, %a0
  ret <16 x i32> %2
}

define <16 x i32> @test_pmaddwd_v32i16_add_v16i32_load2(<16 x i32> %a0, <32 x i16> %a1, <32 x i16>* %p2) {
; CHECK-LABEL: test_pmaddwd_v32i16_add_v16i32_load2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd (%rdi), %zmm1, %zmm0
; CHECK-NEXT:    retq
  %a2 = load <32 x i16>, <32 x i16>* %p2
  %1 = call <16 x i32> @llvm.x86.avx512.pmaddw.d.512(<32 x i16> %a1, <32 x i16> %a2)
  %2 = add <16 x i32> %1, %a0
  ret <16 x i32> %2
}

define <16 x i32> @test_pmaddwd_v32i16_add_v16i32_commute_load1(<16 x i32> %a0, <32 x i16>* %p1, <32 x i16> %a2) {
; CHECK-LABEL: test_pmaddwd_v32i16_add_v16i32_commute_load1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd (%rdi), %zmm1, %zmm0
; CHECK-NEXT:    retq
  %a1 = load <32 x i16>, <32 x i16>* %p1
  %1 = call <16 x i32> @llvm.x86.avx512.pmaddw.d.512(<32 x i16> %a1, <32 x i16> %a2)
  %2 = add <16 x i32> %a0, %1
  ret <16 x i32> %2
}

define <16 x i32> @test_pmaddwd_v32i16_add_v16i32_commute_load2(<16 x i32> %a0, <32 x i16> %a1, <32 x i16>* %p2) {
; CHECK-LABEL: test_pmaddwd_v32i16_add_v16i32_commute_load2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdpwssd (%rdi), %zmm1, %zmm0
; CHECK-NEXT:    retq
  %a2 = load <32 x i16>, <32 x i16>* %p2
  %1 = call <16 x i32> @llvm.x86.avx512.pmaddw.d.512(<32 x i16> %a1, <32 x i16> %a2)
  %2 = add <16 x i32> %a0, %1
  ret <16 x i32> %2
}

declare <4 x i32> @llvm.x86.sse2.pmadd.wd(<8 x i16>, <8 x i16>)
declare <8 x i32> @llvm.x86.avx2.pmadd.wd(<16 x i16>, <16 x i16>)
declare <16 x i32> @llvm.x86.avx512.pmaddw.d.512(<32 x i16>, <32 x i16>)
