/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nvdl;

import com.thaiopensource.validate.nvdl.ActionSet;
import com.thaiopensource.validate.nvdl.AttributeActionSet;
import com.thaiopensource.validate.nvdl.NamespaceSpecification;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

class Mode {
    static final int ATTRIBUTE_PROCESSING_NONE = 0;
    static final int ATTRIBUTE_PROCESSING_QUALIFIED = 1;
    static final int ATTRIBUTE_PROCESSING_FULL = 2;
    static final Mode CURRENT = new Mode("#current", null);
    private static final String ANONYMOUS_MODE_NAME_PREFIX = "#anonymous#";
    private static int anonymousModeCounter = 0;
    private boolean anonymous;
    private final String name;
    private Mode baseMode;
    private boolean defined;
    private Locator whereDefined;
    private Locator whereUsed;
    private final Hashtable elementMap = new Hashtable();
    private final Hashtable attributeMap = new Hashtable();
    private int attributeProcessing = -1;
    private final Hashtable nssElementMap = new Hashtable();
    private final Hashtable nssAttributeMap = new Hashtable();
    private List includedModes = new ArrayList();

    void addIncludedMode(Mode mode) {
        this.includedModes.add(mode);
    }

    Mode(String string, Mode mode) {
        this.name = string;
        this.baseMode = mode;
    }

    public Mode(Mode mode) {
        this(ANONYMOUS_MODE_NAME_PREFIX + anonymousModeCounter++, mode);
        this.anonymous = true;
    }

    String getName() {
        return this.name;
    }

    Mode getBaseMode() {
        return this.baseMode;
    }

    void setBaseMode(Mode mode) {
        this.baseMode = mode;
    }

    ActionSet getElementActions(String string) {
        ActionSet actionSet = this.getElementActionsExplicit(string);
        if (actionSet == null) {
            actionSet = this.getElementActionsExplicit("##any");
        }
        return actionSet;
    }

    private ActionSet getElementActionsExplicit(String string) {
        Object object;
        Object object2;
        ActionSet actionSet = (ActionSet)this.elementMap.get(string);
        if (actionSet == null) {
            object2 = this.nssElementMap.keys();
            while (object2.hasMoreElements() && actionSet == null) {
                object = (NamespaceSpecification)object2.nextElement();
                if (!((NamespaceSpecification)object).covers(string)) continue;
                actionSet = (ActionSet)this.nssElementMap.get(object);
            }
            if (actionSet != null) {
                this.elementMap.put(string, actionSet);
            }
        }
        if (actionSet == null && this.includedModes != null) {
            object2 = this.includedModes.iterator();
            while (actionSet == null && object2.hasNext()) {
                object = (Mode)object2.next();
                actionSet = super.getElementActionsExplicit(string);
            }
            if (actionSet != null) {
                actionSet = actionSet.changeCurrentMode(this);
                this.elementMap.put(string, actionSet);
            }
        }
        if (actionSet == null && this.baseMode != null && (actionSet = this.baseMode.getElementActionsExplicit(string)) != null) {
            actionSet = actionSet.changeCurrentMode(this);
            this.elementMap.put(string, actionSet);
        }
        if (actionSet != null && actionSet.getCancelNestedActions()) {
            actionSet = null;
        }
        return actionSet;
    }

    AttributeActionSet getAttributeActions(String string) {
        AttributeActionSet attributeActionSet = this.getAttributeActionsExplicit(string);
        if (attributeActionSet == null) {
            attributeActionSet = this.getAttributeActionsExplicit("##any");
        }
        return attributeActionSet;
    }

    private AttributeActionSet getAttributeActionsExplicit(String string) {
        Object object;
        Object object2;
        AttributeActionSet attributeActionSet = (AttributeActionSet)this.attributeMap.get(string);
        if (attributeActionSet == null) {
            object2 = this.nssAttributeMap.keys();
            while (object2.hasMoreElements() && attributeActionSet == null) {
                object = (NamespaceSpecification)object2.nextElement();
                if (!((NamespaceSpecification)object).covers(string)) continue;
                attributeActionSet = (AttributeActionSet)this.nssAttributeMap.get(object);
            }
            if (attributeActionSet != null) {
                this.attributeMap.put(string, attributeActionSet);
            }
        }
        if (attributeActionSet == null && this.includedModes != null) {
            object2 = this.includedModes.iterator();
            while (attributeActionSet == null && object2.hasNext()) {
                object = (Mode)object2.next();
                attributeActionSet = super.getAttributeActionsExplicit(string);
            }
            if (attributeActionSet != null) {
                this.attributeMap.put(string, attributeActionSet);
            }
        }
        if (attributeActionSet == null && this.baseMode != null && (attributeActionSet = this.baseMode.getAttributeActionsExplicit(string)) != null) {
            this.attributeMap.put(string, attributeActionSet);
        }
        if (attributeActionSet != null && attributeActionSet.getCancelNestedActions()) {
            attributeActionSet = null;
        }
        return attributeActionSet;
    }

    int getAttributeProcessing() {
        if (this.attributeProcessing == -1) {
            this.attributeProcessing = this.baseMode != null ? this.baseMode.getAttributeProcessing() : 0;
            Enumeration enumeration = this.nssAttributeMap.keys();
            while (enumeration.hasMoreElements() && this.attributeProcessing != 2) {
                NamespaceSpecification namespaceSpecification = (NamespaceSpecification)enumeration.nextElement();
                AttributeActionSet attributeActionSet = (AttributeActionSet)this.nssAttributeMap.get(namespaceSpecification);
                if (attributeActionSet.getAttach() && !attributeActionSet.getReject() && attributeActionSet.getSchemas().length <= 0) continue;
                this.attributeProcessing = namespaceSpecification.ns.equals("") || namespaceSpecification.ns.equals("##any") ? 2 : 1;
            }
        }
        return this.attributeProcessing;
    }

    Locator getWhereDefined() {
        return this.whereDefined;
    }

    boolean isDefined() {
        return this.defined;
    }

    boolean isAnonymous() {
        return this.anonymous;
    }

    Locator getWhereUsed() {
        return this.whereUsed;
    }

    void noteUsed(Locator locator) {
        if (this.whereUsed == null && locator != null) {
            this.whereUsed = new LocatorImpl(locator);
        }
    }

    void noteDefined(Locator locator) {
        this.defined = true;
        if (this.whereDefined == null && locator != null) {
            this.whereDefined = new LocatorImpl(locator);
        }
    }

    boolean bindElement(String string, String string2, ActionSet actionSet) {
        NamespaceSpecification namespaceSpecification = new NamespaceSpecification(string, string2);
        if (this.nssElementMap.get(namespaceSpecification) != null) {
            return false;
        }
        Enumeration enumeration = this.nssElementMap.keys();
        while (enumeration.hasMoreElements()) {
            NamespaceSpecification namespaceSpecification2 = (NamespaceSpecification)enumeration.nextElement();
            if (!namespaceSpecification.compete(namespaceSpecification2)) continue;
            return false;
        }
        this.nssElementMap.put(namespaceSpecification, actionSet);
        return true;
    }

    boolean bindAttribute(String string, String string2, AttributeActionSet attributeActionSet) {
        NamespaceSpecification namespaceSpecification = new NamespaceSpecification(string, string2);
        if (this.nssAttributeMap.get(namespaceSpecification) != null) {
            return false;
        }
        Enumeration enumeration = this.nssAttributeMap.keys();
        while (enumeration.hasMoreElements()) {
            NamespaceSpecification namespaceSpecification2 = (NamespaceSpecification)enumeration.nextElement();
            if (!namespaceSpecification.compete(namespaceSpecification2)) continue;
            return false;
        }
        this.nssAttributeMap.put(namespaceSpecification, attributeActionSet);
        return true;
    }
}

