/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.compound;

import java.util.Set;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.compound.CompoundWordTokenFilterBase;

public class DictionaryCompoundWordTokenFilter
extends CompoundWordTokenFilterBase {
    public DictionaryCompoundWordTokenFilter(TokenStream input, String[] dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        super(input, dictionary, minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
    }

    public DictionaryCompoundWordTokenFilter(TokenStream input, String[] dictionary) {
        super(input, dictionary);
    }

    public DictionaryCompoundWordTokenFilter(TokenStream input, Set dictionary) {
        super(input, dictionary);
    }

    public DictionaryCompoundWordTokenFilter(TokenStream input, Set dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        super(input, dictionary, minWordSize, minSubwordSize, maxSubwordSize, onlyLongestMatch);
    }

    protected void decomposeInternal(Token token) {
        if (token.termLength() < this.minWordSize) {
            return;
        }
        char[] lowerCaseTermBuffer = DictionaryCompoundWordTokenFilter.makeLowerCaseCopy(token.termBuffer());
        for (int i = 0; i < token.termLength() - this.minSubwordSize; ++i) {
            Token longestMatchToken = null;
            for (int j = this.minSubwordSize - 1; j < this.maxSubwordSize && i + j <= token.termLength(); ++j) {
                if (!this.dictionary.contains(lowerCaseTermBuffer, i, j)) continue;
                if (this.onlyLongestMatch) {
                    if (longestMatchToken != null) {
                        if (longestMatchToken.termLength() >= j) continue;
                        longestMatchToken = this.createToken(i, j, token);
                        continue;
                    }
                    longestMatchToken = this.createToken(i, j, token);
                    continue;
                }
                this.tokens.add(this.createToken(i, j, token));
            }
            if (!this.onlyLongestMatch || longestMatchToken == null) continue;
            this.tokens.add(longestMatchToken);
        }
    }
}

