/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ky extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_type_nu_gujr = "Гужарати сандары";
        final Object[][] data = new Object[][] {
            { "001", "Дүйнө" },
            { "002", "Африка" },
            { "003", "Түндүк Америка" },
            { "005", "Түштүк Америка" },
            { "009", "Океания" },
            { "011", "Батыш Африка" },
            { "013", "Борбордук Америка" },
            { "014", "Чыгыш Африка" },
            { "015", "Түндүк Африка" },
            { "017", "Борбордук Африка" },
            { "018", "Түштүк Африка" },
            { "019", "Америка" },
            { "021", "Түндүк Америка (чөлкөм)" },
            { "029", "Кариб аралдары" },
            { "030", "Чыгыш Азия" },
            { "034", "Түштүк Азия" },
            { "035", "Түштүк-Чыгыш Азия" },
            { "039", "Түштүк Европа" },
            { "053", "Австралазия" },
            { "054", "Меланезия" },
            { "057", "Микронезия чөлкөмү" },
            { "061", "Полинезия" },
            { "142", "Азия" },
            { "143", "Борбор Азия" },
            { "145", "Батыш Азия" },
            { "150", "Европа" },
            { "151", "Чыгыш Европа" },
            { "154", "Түндүк Европа" },
            { "155", "Батыш Европа" },
            { "202", "Африка өлкөлөрү" },
            { "419", "Латын Америкасы" },
            { "AC", "Вознесение аралы" },
            { "AD", "Андорра" },
            { "AE", "Бириккен Араб Эмираттары" },
            { "AF", "Афганистан" },
            { "AG", "Антигуа жана Барбуда" },
            { "AI", "Ангилья" },
            { "AL", "Албания" },
            { "AM", "Армения" },
            { "AO", "Ангола" },
            { "AQ", "Антарктида" },
            { "AR", "Аргентина" },
            { "AS", "Америкалык Самоа" },
            { "AT", "Австрия" },
            { "AU", "Австралия" },
            { "AW", "Аруба" },
            { "AX", "Аланд аралдары" },
            { "AZ", "Азербайжан" },
            { "BA", "Босния жана Герцеговина" },
            { "BB", "Барбадос" },
            { "BD", "Бангладеш" },
            { "BE", "Бельгия" },
            { "BF", "Буркина-Фасо" },
            { "BG", "Болгария" },
            { "BH", "Бахрейн" },
            { "BI", "Бурунди" },
            { "BJ", "Бенин" },
            { "BL", "Сент Бартелеми" },
            { "BM", "Бермуд аралдары" },
            { "BN", "Бруней" },
            { "BO", "Боливия" },
            { "BQ", "Кариб Нидерланддары" },
            { "BR", "Бразилия" },
            { "BS", "Багама аралдары" },
            { "BT", "Бутан" },
            { "BV", "Буве аралы" },
            { "BW", "Ботсвана" },
            { "BY", "Беларусь" },
            { "BZ", "Белиз" },
            { "CA", "Канада" },
            { "CC", "Кокос (Килинг) аралдары" },
            { "CD", "Конго-Киншаса" },
            { "CF", "Борбордук Африка Республикасы" },
            { "CG", "Конго-Браззавил" },
            { "CH", "Швейцария" },
            { "CI", "Кот-д’Ивуар" },
            { "CK", "Кук аралдары" },
            { "CL", "Чили" },
            { "CM", "Камерун" },
            { "CN", "Кытай" },
            { "CO", "Колумбия" },
            { "CP", "Клиппертон аралы" },
            { "CQ", "саркча (нормандча)" },
            { "CR", "Коста-Рика" },
            { "CU", "Куба" },
            { "CV", "Кабо-Верде" },
            { "CW", "Кюрасао" },
            { "CX", "Рождество аралы" },
            { "CY", "Кипр" },
            { "CZ", "Чехия" },
            { "DE", "Германия" },
            { "DG", "Диего Гарсия" },
            { "DJ", "Джибути" },
            { "DK", "Дания" },
            { "DM", "Доминика" },
            { "DO", "Доминика Республикасы" },
            { "DZ", "Алжир" },
            { "EA", "Сеута жана Мелилла" },
            { "EC", "Эквадор" },
            { "EE", "Эстония" },
            { "EG", "Египет" },
            { "EH", "Батыш Сахара" },
            { "ER", "Эритрея" },
            { "ES", "Испания" },
            { "ET", "Эфиопия" },
            { "EU", "Европа Биримдиги" },
            { "EZ", "Еврозона" },
            { "FI", "Финляндия" },
            { "FJ", "Фиджи" },
            { "FK", "Фолкленд аралдары" },
            { "FM", "Микронезия" },
            { "FO", "Фарер аралдары" },
            { "FR", "Франция" },
            { "GA", "Габон" },
            { "GB", "Улуу Британия" },
            { "GD", "Гренада" },
            { "GE", "Грузия" },
            { "GF", "Франция Гвианасы" },
            { "GG", "Гернси" },
            { "GH", "Гана" },
            { "GI", "Гибралтар" },
            { "GL", "Гренландия" },
            { "GM", "Гамбия" },
            { "GN", "Гвинея" },
            { "GP", "Гваделупа" },
            { "GQ", "Экватордук Гвинея" },
            { "GR", "Греция" },
            { "GS", "Түштүк Жоржия жана Түштүк Сэндвич аралдары" },
            { "GT", "Гватемала" },
            { "GU", "Гуам" },
            { "GW", "Гвинея-Бисау" },
            { "GY", "Гайана" },
            { "HK", "Гонконг Кытай ААА" },
            { "HM", "Херд жана Макдональд аралдары" },
            { "HN", "Гондурас" },
            { "HR", "Хорватия" },
            { "HT", "Гаити" },
            { "HU", "Венгрия" },
            { "IC", "Канар аралдары" },
            { "ID", "Индонезия" },
            { "IE", "Ирландия" },
            { "IL", "Израиль" },
            { "IM", "Мэн аралы" },
            { "IN", "Индия" },
            { "IO", "Инди океанындагы Британ территориясы" },
            { "IQ", "Ирак" },
            { "IR", "Иран" },
            { "IS", "Исландия" },
            { "IT", "Италия" },
            { "JE", "Жерси" },
            { "JM", "Ямайка" },
            { "JO", "Иордания" },
            { "JP", "Жапония" },
            { "KE", "Кения" },
            { "KG", "Кыргызстан" },
            { "KH", "Камбоджа" },
            { "KI", "Кирибати" },
            { "KM", "Коморос" },
            { "KN", "Сент-Китс жана Невис" },
            { "KP", "Түндүк Корея" },
            { "KR", "Түштүк Корея" },
            { "KW", "Кувейт" },
            { "KY", "Кайман аралдары" },
            { "KZ", "Казакстан" },
            { "LA", "Лаос" },
            { "LB", "Ливан" },
            { "LC", "Сент-Люсия" },
            { "LI", "Лихтенштейн" },
            { "LK", "Шри-Ланка" },
            { "LR", "Либерия" },
            { "LS", "Лесото" },
            { "LT", "Литва" },
            { "LU", "Люксембург" },
            { "LV", "Латвия" },
            { "LY", "Ливия" },
            { "MA", "Марокко" },
            { "MC", "Монако" },
            { "MD", "Молдова" },
            { "ME", "Черногория" },
            { "MF", "Сент-Мартин" },
            { "MG", "Мадагаскар" },
            { "MH", "Маршалл аралдары" },
            { "MK", "Түндүк Македония" },
            { "ML", "Мали" },
            { "MM", "Мьянма (Бирма)" },
            { "MN", "Монголия" },
            { "MO", "Макао Кытай ААА" },
            { "MP", "Түндүк Мариана аралдары" },
            { "MQ", "Мартиника" },
            { "MR", "Мавритания" },
            { "MS", "Монтсеррат" },
            { "MT", "Мальта" },
            { "MU", "Маврикий" },
            { "MV", "Мальдив" },
            { "MW", "Малави" },
            { "MX", "Мексика" },
            { "MY", "Малайзия" },
            { "MZ", "Мозамбик" },
            { "NA", "Намибия" },
            { "NC", "Жаңы Каледония" },
            { "NE", "Нигер" },
            { "NF", "Норфолк аралы" },
            { "NG", "Нигерия" },
            { "NI", "Никарагуа" },
            { "NL", "Нидерланд" },
            { "NO", "Норвегия" },
            { "NP", "Непал" },
            { "NR", "Науру" },
            { "NU", "Ниуэ" },
            { "NZ", "Жаңы Зеландия" },
            { "OM", "Оман" },
            { "PA", "Панама" },
            { "PE", "Перу" },
            { "PF", "Полинезия (франциялык)" },
            { "PG", "Папуа-Жаңы Гвинея" },
            { "PH", "Филиппин" },
            { "PK", "Пакистан" },
            { "PL", "Польша" },
            { "PM", "Сен-Пьер жана Микелон" },
            { "PN", "Питкэрн аралдары" },
            { "PR", "Пуэрто-Рико" },
            { "PS", "Палестина аймактары" },
            { "PT", "Португалия" },
            { "PW", "Палау" },
            { "PY", "Парагвай" },
            { "QA", "Катар" },
            { "QO", "Алыскы Океания" },
            { "RE", "Реюньон" },
            { "RO", "Румыния" },
            { "RS", "Сербия" },
            { "RU", "Россия" },
            { "RW", "Руанда" },
            { "SA", "Сауд Арабиясы" },
            { "SB", "Соломон аралдары" },
            { "SC", "Сейшел аралдары" },
            { "SD", "Судан" },
            { "SE", "Швеция" },
            { "SG", "Сингапур" },
            { "SH", "Ыйык Елена" },
            { "SI", "Словения" },
            { "SJ", "Шпицберген жана Ян-Майен" },
            { "SK", "Словакия" },
            { "SL", "Сьерра-Леоне" },
            { "SM", "Сан Марино" },
            { "SN", "Сенегал" },
            { "SO", "Сомали" },
            { "SR", "Суринам" },
            { "SS", "Түштүк Судан" },
            { "ST", "Сан-Томе жана Принсипи" },
            { "SV", "Эль-Сальвадор" },
            { "SX", "Синт-Мартен" },
            { "SY", "Сирия" },
            { "SZ", "Свазиленд" },
            { "TA", "Тристан-да-Кунья" },
            { "TC", "Түркс жана Кайкос аралдары" },
            { "TD", "Чад" },
            { "TF", "Франциянын Түштүктөгү аймактары" },
            { "TG", "Того" },
            { "TH", "Тайланд" },
            { "TJ", "Тажикстан" },
            { "TK", "Токелау" },
            { "TL", "Тимор-Лесте" },
            { "TM", "Түркмөнстан" },
            { "TN", "Тунис" },
            { "TO", "Тонга" },
            { "TR", "Түркия" },
            { "TT", "Тринидад жана Тобаго" },
            { "TV", "Тувалу" },
            { "TW", "Тайвань" },
            { "TZ", "Танзания" },
            { "UA", "Украина" },
            { "UG", "Уганда" },
            { "UM", "АКШнын сырткы аралдары" },
            { "UN", "БУ" },
            { "US", "Кошмо Штаттар" },
            { "UY", "Уругвай" },
            { "UZ", "Өзбекстан" },
            { "VA", "Ватикан" },
            { "VC", "Сент-Винсент жана Гренадиндер" },
            { "VE", "Венесуэла" },
            { "VG", "Виргин аралдары (Британия)" },
            { "VI", "Виргин аралдары (АКШ)" },
            { "VN", "Вьетнам" },
            { "VU", "Вануату" },
            { "WF", "Уоллис жана Футуна" },
            { "WS", "Самоа" },
            { "XA", "Жасалма- Акцент" },
            { "XB", "Жасалма - эки тараптуу" },
            { "XK", "Косово" },
            { "YE", "Йемен" },
            { "YT", "Майотта" },
            { "ZA", "Түштүк-Африка Республикасы" },
            { "ZM", "Замбия" },
            { "ZW", "Зимбабве" },
            { "ZZ", "Белгисиз чөлкөм" },
            { "aa", "афарча" },
            { "ab", "абхазча" },
            { "af", "африкаанча" },
            { "ak", "аканча" },
            { "am", "амхарча" },
            { "an", "арагончо" },
            { "ar", "арабча" },
            { "as", "ассамча" },
            { "av", "аварикче" },
            { "ay", "аймарача" },
            { "az", "азербайжанча" },
            { "ba", "башкырча" },
            { "be", "беларусча" },
            { "bg", "болгарча" },
            { "bi", "бисламача" },
            { "bm", "бамбарача" },
            { "bn", "бангладешче" },
            { "bo", "тибетче" },
            { "br", "бретончо" },
            { "bs", "боснийче" },
            { "ca", "каталончо" },
            { "ce", "чеченче" },
            { "ch", "чаморрочо" },
            { "co", "корсиканча" },
            { "cs", "чехче" },
            { "cu", "чиркөө славянча" },
            { "cv", "чувашча" },
            { "cy", "уелшче" },
            { "da", "датча" },
            { "de", "немисче" },
            { "dv", "дивехиче" },
            { "dz", "жонгуча" },
            { "ee", "эбече" },
            { "el", "грекче" },
            { "en", "англисче" },
            { "eo", "эсперанто" },
            { "es", "испанча" },
            { "et", "эстончо" },
            { "eu", "баскча" },
            { "fa", "фарсча" },
            { "ff", "фулача" },
            { "fi", "финче" },
            { "fj", "фижиче" },
            { "fo", "фарерче" },
            { "fr", "французча" },
            { "fy", "батыш фризче" },
            { "ga", "ирландча" },
            { "gd", "шотладиялык гелча" },
            { "gl", "галисияча" },
            { "gn", "гуараниче" },
            { "gu", "гужаратча" },
            { "gv", "мэнксыча" },
            { "ha", "хаусача" },
            { "he", "ивритче" },
            { "hi", "хиндиче" },
            { "hr", "хорватча" },
            { "ht", "гаитиче" },
            { "hu", "венгерче" },
            { "hy", "армянча" },
            { "hz", "герерочо" },
            { "ia", "интерлингва" },
            { "id", "индонезияча" },
            { "ie", "интерлинг" },
            { "ig", "игбочо" },
            { "ii", "сычуань йиче" },
            { "io", "идочо" },
            { "is", "исландча" },
            { "it", "италиянча" },
            { "iu", "инуктитутча" },
            { "ja", "жапончо" },
            { "jv", "жаванизче" },
            { "ka", "грузинче" },
            { "ki", "кикуйиче" },
            { "kj", "куаньямача" },
            { "kk", "казакча" },
            { "kl", "калаалисутча" },
            { "km", "кмерче" },
            { "kn", "каннадача" },
            { "ko", "корейче" },
            { "kr", "кануриче" },
            { "ks", "кашмирче" },
            { "ku", "курманжиче (курдча)" },
            { "kv", "комиче" },
            { "kw", "корнишче" },
            { "ky", "кыргызча" },
            { "la", "латынча" },
            { "lb", "люксембургча" },
            { "lg", "гандача" },
            { "li", "лимбургиче" },
            { "ln", "лингалача" },
            { "lo", "лаочо" },
            { "lt", "литовчо" },
            { "lu", "луба-катангача" },
            { "lv", "латышча" },
            { "mg", "малагасча" },
            { "mh", "маршаллча" },
            { "mi", "маориче" },
            { "mk", "македончо" },
            { "ml", "малайаламча" },
            { "mn", "монголчо" },
            { "mr", "маратиче" },
            { "ms", "малайча" },
            { "mt", "малтизче" },
            { "my", "бурмача" },
            { "na", "науруча" },
            { "nb", "норвежче (букмал)" },
            { "nd", "түндүк ндыбелче" },
            { "ne", "непалча" },
            { "ng", "ндонгача" },
            { "nl", "голландча" },
            { "nn", "норвежче (нинорск)" },
            { "no", "норвежче" },
            { "nr", "түштүк ндебелече" },
            { "nv", "наваджочо" },
            { "ny", "ньянджача" },
            { "oc", "окситанча" },
            { "om", "оромочо" },
            { "or", "орияча" },
            { "os", "осетинче" },
            { "pa", "пунжабиче" },
            { "pl", "полякча" },
            { "ps", "пуштуча" },
            { "pt", "португалча" },
            { "qu", "кечуача" },
            { "rm", "романшча" },
            { "rn", "рундиче" },
            { "ro", "румынча" },
            { "ru", "орусча" },
            { "rw", "руандача" },
            { "sa", "санскритче" },
            { "sc", "сардинче" },
            { "sd", "синдхиче" },
            { "se", "түндүк саамиче" },
            { "sg", "сангочо" },
            { "sh", "серб-хорват" },
            { "si", "сингалача" },
            { "sk", "словакча" },
            { "sl", "словенче" },
            { "sm", "самоанча" },
            { "sn", "шонача" },
            { "so", "сомаличе" },
            { "sq", "албанча" },
            { "sr", "сербче" },
            { "ss", "сватиче" },
            { "st", "сесоточо" },
            { "su", "сунданча" },
            { "sv", "шведче" },
            { "sw", "суахиличе" },
            { "ta", "тамилче" },
            { "te", "телугуча" },
            { "tg", "тажикче" },
            { "th", "тайча" },
            { "ti", "тигриниача" },
            { "tk", "түркмөнчө" },
            { "tn", "тсванача" },
            { "to", "тонгача" },
            { "tr", "түркчө" },
            { "ts", "тсонгача" },
            { "tt", "татарча" },
            { "tw", "тви" },
            { "ty", "таитиче" },
            { "ug", "уйгурча" },
            { "uk", "украинче" },
            { "ur", "урдуча" },
            { "uz", "өзбекче" },
            { "ve", "вендача" },
            { "vi", "вьетнамча" },
            { "vo", "волапюкча" },
            { "wa", "валлончо" },
            { "wo", "уолофчо" },
            { "xh", "косача" },
            { "yi", "идишче" },
            { "yo", "йорубача" },
            { "za", "чжуанча" },
            { "zh", "кытайча" },
            { "zu", "зулуча" },
            { "ace", "ачехче" },
            { "ada", "адаңмече" },
            { "ady", "адыгейче" },
            { "agq", "агемче" },
            { "ain", "айнуча" },
            { "ale", "алеутча" },
            { "alt", "түштүк алтайча" },
            { "ann", "оболочо (Нигерия)" },
            { "anp", "ангикача" },
            { "arn", "мапучече" },
            { "arp", "арапахочо" },
            { "ars", "арабча (нежди диалекти)" },
            { "asa", "асуча" },
            { "ast", "астурийче" },
            { "atj", "атикамекче" },
            { "awa", "авадхиче" },
            { "bal", "белужиче" },
            { "ban", "баличе" },
            { "bas", "басаача" },
            { "bem", "бембача" },
            { "bez", "бенача" },
            { "bgc", "харьянвиче" },
            { "bgn", "чыгыш балучиче" },
            { "bho", "бхожпуриче" },
            { "bin", "биниче" },
            { "bla", "сиксикача" },
            { "blo", "анииче" },
            { "brx", "бодочо" },
            { "bug", "бугийче" },
            { "byn", "блинче" },
            { "cay", "каюгиче" },
            { "ccp", "чакма" },
            { "ceb", "себуанча" },
            { "cgg", "чигача" },
            { "chk", "чуукиче" },
            { "chm", "мариче" },
            { "cho", "чокточо" },
            { "chp", "чипевайанча" },
            { "chr", "черокиче" },
            { "chy", "шайеннче" },
            { "ckb", "борбордук курдча" },
            { "clc", "чилкотинче (британдык колумбиядагы аймак)" },
            { "crg", "мичифче (индей тили)" },
            { "crj", "түштүк-чыгыш криче (индей тили)" },
            { "crk", "өрөөндүк криче (индей тили)" },
            { "crl", "чыгыш криче (индей тилдери)" },
            { "crm", "муус криче (индей тили)" },
            { "crr", "каролиналык алгонкинче" },
            { "crs", "сеселва креол французча" },
            { "csw", "суампи криче (индей тили)" },
            { "dak", "дакотача" },
            { "dar", "даргинче" },
            { "dav", "таитача" },
            { "dgr", "догрибче" },
            { "dje", "зармача" },
            { "doi", "догриче" },
            { "dsb", "төмөнкү сорбианча" },
            { "dua", "дуалача" },
            { "dyo", "жола-фониче" },
            { "dzg", "дазагача" },
            { "ebu", "эмбуча" },
            { "efi", "эфикче" },
            { "eka", "экажукча" },
            { "ewo", "эвондочо" },
            { "fil", "филипинче" },
            { "fon", "фончо" },
            { "frc", "французча (кажун диалектиси)" },
            { "frr", "түндүк фризче (евразиялык тилдер)" },
            { "fur", "фриулча" },
            { "gaa", "гача" },
            { "gag", "гагаузча" },
            { "gan", "Гань Кытайча" },
            { "gez", "гиизче" },
            { "gil", "гилбертче" },
            { "gor", "горонталочо" },
            { "gsw", "немисче (Швейцария)" },
            { "guz", "гусиче" },
            { "gwi", "гвичинче" },
            { "hai", "хайдача" },
            { "hak", "Хакка кытайча" },
            { "haw", "гавайча" },
            { "hax", "хайдача (индей тили)" },
            { "hil", "хилигайнончо" },
            { "hmn", "хмонгчо" },
            { "hsb", "жогорку сорбианча" },
            { "hsn", "Сянь Кытайча" },
            { "hup", "хупача" },
            { "hur", "халкомелемче (индей тили)" },
            { "iba", "ибанча" },
            { "ibb", "ибибиочо" },
            { "ikt", "инуктитутча (Канада)" },
            { "ilo", "илокочо" },
            { "inh", "ингушча" },
            { "jbo", "ложбанча" },
            { "jgo", "нгомбача" },
            { "jmc", "мачамече" },
            { "kab", "кабылча" },
            { "kac", "кахинче" },
            { "kaj", "джуча" },
            { "kam", "камбача" },
            { "kbd", "кабардинче" },
            { "kcg", "тяпча" },
            { "kde", "макондече" },
            { "kea", "кабувердиче" },
            { "kfo", "корочо" },
            { "kgp", "кайнгангча (индей тили)" },
            { "kha", "хасиче" },
            { "khq", "койра чиниче" },
            { "kkj", "какочо" },
            { "kln", "каленжиче" },
            { "kmb", "кимбундуча" },
            { "koi", "коми-пермякча" },
            { "kok", "конканиче" },
            { "kpe", "кпеллече" },
            { "krc", "карачай-балкарча" },
            { "krl", "карелче" },
            { "kru", "курухча" },
            { "ksb", "шамабалача" },
            { "ksf", "бафияча" },
            { "ksh", "колоньяча" },
            { "kum", "кумыкча" },
            { "kwk", "кваквалача (индей тили)" },
            { "kxv", "куви" },
            { "lad", "ладиночо" },
            { "lag", "лангиче" },
            { "lez", "лезгинче" },
            { "lij", "лигурча" },
            { "lil", "лиллуэтче (индей тили)" },
            { "lkt", "лакотача" },
            { "lmo", "ломбардча" },
            { "lou", "луизиана креолчо" },
            { "loz", "лозиче" },
            { "lrc", "түндүк луриче" },
            { "lsm", "саамиача (Уганда, Кения)" },
            { "lua", "луба-лулуача" },
            { "lun", "лундача" },
            { "luo", "луочо" },
            { "lus", "мизочо" },
            { "luy", "лухияча" },
            { "mad", "мадурисче" },
            { "mag", "магахиче" },
            { "mai", "маитиличе" },
            { "mak", "макасарча" },
            { "mas", "масайча" },
            { "mdf", "мокшача" },
            { "men", "мендече" },
            { "mer", "меруча" },
            { "mfe", "морисианча" },
            { "mgh", "макуача" },
            { "mgo", "метача" },
            { "mic", "микмакча" },
            { "min", "минанкабауча" },
            { "mni", "манипуриче" },
            { "moe", "инну-аймунча (индейлер тили)" },
            { "moh", "мохаукча" },
            { "mos", "моссиче" },
            { "mua", "мундангча" },
            { "mul", "бир нече тилде" },
            { "mus", "крикче" },
            { "mwl", "мирандизче" },
            { "myv", "эрзянча" },
            { "mzn", "мазандераниче" },
            { "nap", "неополитанча" },
            { "naq", "намача" },
            { "nds", "төмөнкү немисче" },
            { "new", "невариче" },
            { "nia", "ниасча" },
            { "niu", "ньюанча" },
            { "nmg", "квасиочо" },
            { "nnh", "нгимбунча" },
            { "nog", "ногайча" },
            { "nqo", "нкочо" },
            { "nso", "түндүк соточо" },
            { "nus", "нуерче" },
            { "nyn", "ныйанколчо" },
            { "ojb", "түндүк-батыш ожибвече (индей тили)" },
            { "ojc", "борбордук ожибвече" },
            { "ojs", "ожи-криче (индей тили)" },
            { "ojw", "батыш ожибвече (индей тили)" },
            { "oka", "оканаганча (Канада)" },
            { "pag", "пангасиче" },
            { "pam", "пампангача" },
            { "pap", "папиаменточо" },
            { "pau", "палауанча" },
            { "pcm", "аргындашкан тил (Нигерия)" },
            { "pis", "пижинче (Соломон Аралдары)" },
            { "pqm", "малесит-пассамакуоддиче (индей тили)" },
            { "prg", "пруссча" },
            { "quc", "кичече" },
            { "raj", "ражастаниче" },
            { "rap", "рапаньюча" },
            { "rar", "раротонгача" },
            { "rhg", "рохинжача" },
            { "rof", "ромбочо" },
            { "rup", "аромунча" },
            { "rwk", "руача" },
            { "sad", "сандавече" },
            { "sah", "сахача" },
            { "saq", "самбуруча" },
            { "sat", "санталиче" },
            { "sba", "нгамбайча" },
            { "sbp", "сангуча" },
            { "scn", "сицилийче" },
            { "sco", "шотландча" },
            { "sdh", "түштүк курдча" },
            { "seh", "сенача" },
            { "ses", "койраборо сенниче" },
            { "shi", "ташелитче" },
            { "shn", "шанча" },
            { "slh", "түштүк лушуцидче (индей тили)" },
            { "sma", "түштүк саамиче" },
            { "smj", "луле саамиче" },
            { "smn", "инари саамиче" },
            { "sms", "сколт саамиче" },
            { "snk", "сонинкече" },
            { "srn", "сранан тонгочо" },
            { "ssy", "сахочо" },
            { "str", "стрейтс салишче (индей тили)" },
            { "suk", "сукумача" },
            { "swb", "коморчо" },
            { "syr", "сирияча" },
            { "szl", "силесче" },
            { "tce", "түштүк тутчонече (индей тили)" },
            { "tem", "тимнече" },
            { "teo", "тесочо" },
            { "tet", "тетумча" },
            { "tgx", "тагишче (индей тили)" },
            { "tht", "талтанча (индей тили)" },
            { "tig", "тигрече" },
            { "tlh", "клингончо" },
            { "tli", "тлинкитче (индей тили)" },
            { "tok", "токипонача (эксперименталдык тил)" },
            { "tpi", "ток-писинче" },
            { "trv", "тарокочо" },
            { "ttm", "түндүк тутчончо (индей тили)" },
            { "tum", "тумбукача" },
            { "tvl", "тувалуча" },
            { "twq", "тасабакча" },
            { "tyv", "тувинче" },
            { "tzm", "борбордук Атлас тамазигтче" },
            { "udm", "удмуртча" },
            { "umb", "умбундуча" },
            { "und", "белгисиз тилде" },
            { "vai", "вайиче" },
            { "vec", "венециянча" },
            { "vmw", "махувача" },
            { "vun", "вунжочо" },
            { "wae", "валцерче" },
            { "wal", "вольяттача" },
            { "war", "варайча" },
            { "wbp", "ворлпириче" },
            { "wuu", "\"У\" диалектинде (Кытай)" },
            { "xal", "калмыкча" },
            { "xnr", "кангри" },
            { "xog", "согача" },
            { "yav", "янгбенче" },
            { "ybb", "йембача" },
            { "yrl", "ньенгатуча (түштүк америка тилдери)" },
            { "yue", "кантончо" },
            { "zgh", "марокко тамазигт адабий тилинде" },
            { "zun", "зуниче" },
            { "zxx", "тилдик мазмун жок" },
            { "zza", "зазача" },
            { "Adlm", "Адлам (жазуу)" },
            { "Arab", "Араб" },
            { "Aran", "Насталик (Араб жазуусу)" },
            { "Armn", "Армян" },
            { "Beng", "Бенгал" },
            { "Bopo", "Бопомофо" },
            { "Brai", "Брейл" },
            { "Cakm", "Чакма (жазуу)" },
            { "Cans", "канадалык муун жазуусу" },
            { "Cher", "чероки (жазуу)" },
            { "Cyrl", "Кирилл" },
            { "Deva", "Деванагари" },
            { "Ethi", "Эфиоп" },
            { "Geor", "Грузин" },
            { "Grek", "Грек" },
            { "Gujr", "Гужарати" },
            { "Guru", "Гурмухи" },
            { "Hanb", "Ханб" },
            { "Hang", "Хангул" },
            { "Hani", "Хань" },
            { "Hans", "Жөнөкөйлөштүрүлгөн" },
            { "Hant", "Салттуу" },
            { "Hebr", "Иврит" },
            { "Hira", "Хирагана" },
            { "Hrkt", "Жапон силлабографиясы" },
            { "Jamo", "Джамо" },
            { "Jpan", "Жапан" },
            { "Kana", "Катакана" },
            { "Khmr", "Кмер" },
            { "Knda", "Каннада" },
            { "Kore", "Корей" },
            { "Laoo", "Лао" },
            { "Latn", "Латын" },
            { "Mlym", "Малайалам" },
            { "Mong", "Монгол" },
            { "Mtei", "мейтей-маек (жазуу)" },
            { "Mymr", "Мйанмар" },
            { "Nkoo", "нко (жазуу)" },
            { "Olck", "Ол-чики (жазуу)" },
            { "Orya", "Орийа" },
            { "Rohg", "Ханифи (жазуу)" },
            { "Sinh", "Сингала" },
            { "Sund", "сундан жазуусу" },
            { "Syrc", "сириялык жазуу" },
            { "Taml", "Тамил" },
            { "Telu", "Телу" },
            { "Tfng", "Тифинаг (жазуу)" },
            { "Thaa", "Таана" },
            { "Thai", "Тай" },
            { "Tibt", "Тибет" },
            { "Vaii", "Ваи (жазуу)" },
            { "Yiii", "Йи (жазуу)" },
            { "Zmth", "Математикалык маани" },
            { "Zsye", "Быйтыкча" },
            { "Zsym", "Белгилер" },
            { "Zxxx", "Жазылбаган" },
            { "Zyyy", "Жалпы" },
            { "Zzzz", "Белгисиз жазуу" },
            { "de_CH", "адабий немисче (Швейцария)" },
            { "en_US", "англисче (Америка Кошмо Штаттары)" },
            { "es_ES", "испанча (Европа)" },
            { "fa_AF", "дари" },
            { "nl_BE", "фламандча" },
            { "pt_PT", "португалча (Европа)" },
            { "ro_MD", "молдованча" },
            { "sw_CD", "конго суахаличе" },
            { "ar_001", "азыркы адабий араб тилинде" },
            { "key.ca", "Жылнаама" },
            { "key.cf", "Валюта форматы" },
            { "key.co", "Иргөө тартиби" },
            { "key.cu", "Валюта" },
            { "key.em", "Быйтыкчалардын презентациясы" },
            { "key.hc", "Саат мерчеми (12/24)" },
            { "key.lb", "Саптарды ажыратуу стили" },
            { "key.lw", "Сөздөрдүн ичиндеги саптардын үзүлүшү" },
            { "key.ms", "Өлчөө тутуму" },
            { "key.nu", "Сандар" },
            { "key.ss", "Аббревиатурадан кийин сүйлөм тыныгуусу." },
            { "nds_NL", "төмөнкү саксончо" },
            { "zh_Hans", "кытайча (жөнөкөйлөштүрүлгөн)" },
            { "zh_Hant", "кытайча (салттуу)" },
            { "type.ca.roc", "Мингуо жылнаамасы" },
            { "type.hc.h11", "12 сааттык тутум (0–11)" },
            { "type.hc.h12", "12 сааттык тутум (1–12)" },
            { "type.hc.h23", "24 сааттык тутум (0–23)" },
            { "type.hc.h24", "24 сааттык тутум (1–24)" },
            { "type.nu.arab", "Араб-индус сандары" },
            { "type.nu.armn", "Армян сандары" },
            { "type.nu.beng", "Бенгали сандары" },
            { "type.nu.cakm", "Чакма сандары" },
            { "type.nu.deva", "Деванагари сандары" },
            { "type.nu.ethi", "Эфиоп сандары" },
            { "type.nu.geor", "Грузин сандары" },
            { "type.nu.grek", "Грек сандары" },
            { "type.nu.gujr", metaValue_type_nu_gujr },
            { "type.nu.guru", metaValue_type_nu_gujr },
            { "type.nu.hans", "Жөнөкөйлөштүрүлгөн кытай сандары" },
            { "type.nu.hant", "Салттуу кытай сандары" },
            { "type.nu.hebr", "Иврит сандары" },
            { "type.nu.java", "Ява сандары" },
            { "type.nu.jpan", "Жапон сандары" },
            { "type.nu.khmr", "Кмер сандары" },
            { "type.nu.knda", "Каннада сандары" },
            { "type.nu.laoo", "Лао сандары" },
            { "type.nu.latn", "Батыш сандары" },
            { "type.nu.mlym", "Малайалам сандары" },
            { "type.nu.mtei", "Митей-маек сандары" },
            { "type.nu.mymr", "Мйанмар сандары" },
            { "type.nu.olck", "Ол-чики сандары" },
            { "type.nu.orya", "Ория сандары" },
            { "type.nu.taml", "Салттуу тамил сандары" },
            { "type.nu.telu", "Телугу сандары" },
            { "type.nu.thai", "Тай сандары" },
            { "type.nu.tibt", "Тибет сандары" },
            { "type.nu.vaii", "Ваи сандары" },
            { "type.ca.dangi", "Данги жылнаамасы" },
            { "type.co.ducet", "Демейки Unicode иргөө тартиби" },
            { "type.lb.loose", "Саптардын арасы кенен" },
            { "type.nu.roman", "Роман сандары" },
            { "type.ca.coptic", "Копт жылнаамасы" },
            { "type.ca.hebrew", "Иврит жылнаамасы" },
            { "type.co.search", "Жалпы издөө" },
            { "type.d0.fwidth", "Кең формат" },
            { "type.d0.hwidth", "Кыска формат" },
            { "type.lb.normal", "Саптардын арасы орточо" },
            { "type.lb.strict", "Саптардын арасы тыкыс" },
            { "type.ms.metric", "Метрикалык тутум" },
            { "type.ca.chinese", "Кытай жылнаамасы" },
            { "type.ca.islamic", "Ислам жылнаамасы" },
            { "type.ca.iso8601", "ИСО-8601 жылнаамасы" },
            { "type.ca.persian", "Перс жылнаамасы" },
            { "type.cf.account", "Эсептешүү валютасынын форматы" },
            { "type.nu.arabext", "Кеңейтилген араб-индус сандары" },
            { "type.nu.armnlow", "Армян сандары (кичинекей тамга менен))" },
            { "type.nu.greklow", "Грек сандары (кичинекей тамга менен))" },
            { "type.nu.hanidec", "Кытай ондук сандары" },
            { "type.nu.hansfin", "Жөнөкөйлөштүрүлгөн кытай каржы сандары" },
            { "type.nu.hantfin", "Салттуу кытай каржы сандары" },
            { "type.nu.jpanfin", "Жапон каржы сандары" },
            { "type.nu.tamldec", "Тамил сандары" },
            { "type.ca.buddhist", "Будда жылнаамасы" },
            { "type.ca.ethiopic", "Эфиоп жылнаамасы" },
            { "type.ca.japanese", "Жапон жылнаамасы" },
            { "type.cf.standard", "Стандарттык валюта форматы" },
            { "type.co.standard", "Стандарттык иргөө тартиби" },
            { "type.ms.uksystem", "Британ империясынын өлчөө тутуму" },
            { "type.ms.ussystem", "АКШ өлчөө тутуму" },
            { "type.nu.fullwide", "Толук эндүү сандар" },
            { "type.nu.romanlow", "Роман сандары (кичинекей тамга менен)" },
            { "type.ca.gregorian", "Григориан жылнаамасы" },
            { "type.ca.islamic-civil", "Ислам жылнаамасы (жадыбал)" },
            { "type.ca.islamic-umalqura", "Ислам жылнаамасы (Умм аль-Кура)" },
            { "type.ca.ethiopic-amete-alem", "Эфиопиялык Амет Алем жылнаамасы" },
        };
        return data;
    }
}
