/* do not edit automatically generated by mc from M2Diagnostic.  */
/* M2Diagnotic provides memory and time diagnosics to the user.

Copyright (C) 2024-2026 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaiusmod2@gmail.com>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2Diagnostic_H)
#   define _M2Diagnostic_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GDynamicStrings.h"

#   if defined (_M2Diagnostic_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

#if !defined (M2Diagnostic_Diagnostic_D)
#  define M2Diagnostic_Diagnostic_D
   typedef void *M2Diagnostic_Diagnostic;
#endif

typedef struct M2Diagnostic_DiagProc_p M2Diagnostic_DiagProc;

typedef void (*M2Diagnostic_DiagProc_t) (M2Diagnostic_Diagnostic);
struct M2Diagnostic_DiagProc_p { M2Diagnostic_DiagProc_t proc; };


/*
   InitTimeDiagnostic - create and return a time diagnostic.
                        The format string can be free form and may
                        contain {1T}, {1C} or {1P}.
                        {1T} will contain the time and
                        {1C} the count of the number of times the
                        code enters the time diagnostic code region.
                        {1P} generates the time as a percentage.
                        {0T} is the total time for the application.
                        {{ is rendered as a single {.
*/

EXTERN M2Diagnostic_Diagnostic M2Diagnostic_InitTimeDiagnostic (const char *name_, unsigned int _name_high, const char *format_, unsigned int _format_high);

/*
   EnterDiagnostic - attribute all execution time from now to TimeDiag.
*/

EXTERN void M2Diagnostic_EnterDiagnostic (M2Diagnostic_Diagnostic TimeDiag);

/*
   ExitDiagnostic - stop attributing execution time to TimeDiag.
*/

EXTERN void M2Diagnostic_ExitDiagnostic (M2Diagnostic_Diagnostic TimeDiag);

/*
   InitMemDiagnostic - create and return a memory diagnostic.
                       The format string can be free form and may
                       contain {1M} {1d} {1x} {1P}.
                       {1M} is replaced by the value of the first parameter
                       with memory size units.
                       {1d} unsigned decimal.  {1x} unsigned hexadecimal.
                       {0M} is the global allocation (Storage.mod:ALLOCATE).
                       {1P} is the percentage of param 1 relative
                       to global memory.
*/

EXTERN M2Diagnostic_Diagnostic M2Diagnostic_InitMemDiagnostic (const char *name_, unsigned int _name_high, const char *format_, unsigned int _format_high);

/*
   MemIncr - allow the appropriate parameter to be incremented.
             All parameters are initially set to zero and are stored
             as LONGCARD.
*/

EXTERN void M2Diagnostic_MemIncr (M2Diagnostic_Diagnostic MemDiag, unsigned int paramno, unsigned int incr);

/*
   MemDecr - allow the appropriate parameter to be decremented.
             All parameters are initially set to zero and are stored
             as LONGCARD.
*/

EXTERN void M2Diagnostic_MemDecr (M2Diagnostic_Diagnostic MemDiag, unsigned int paramno, unsigned int decr);

/*
   MemSet - allow the appropriate parameter to be set to value.
            All parameters are initially set to zero.
*/

EXTERN void M2Diagnostic_MemSet (M2Diagnostic_Diagnostic MemDiag, unsigned int paramno, unsigned int value);

/*
   TotalHeapIncr - increments the total heap used.
*/

EXTERN void M2Diagnostic_TotalHeapIncr (unsigned int incr);

/*
   TotalHeapDecr - decrements the total heap used.
*/

EXTERN void M2Diagnostic_TotalHeapDecr (unsigned int incr);

/*
   SetEnable - set the enable flag in Diag to value.
*/

EXTERN void M2Diagnostic_SetEnable (M2Diagnostic_Diagnostic Diag, bool value);

/*
   Lookup - returns the Diagnostic containing name or NIL
            if it does not exist.
*/

EXTERN M2Diagnostic_Diagnostic M2Diagnostic_Lookup (const char *name_, unsigned int _name_high);

/*
   GetName - returns the name of Diag.
*/

EXTERN DynamicStrings_String M2Diagnostic_GetName (M2Diagnostic_Diagnostic Diag);

/*
   ForeachDiagDo - for diag in global diag list do
                      dp (diag);
                   end
*/

EXTERN void M2Diagnostic_ForeachDiagDo (M2Diagnostic_DiagProc dp);

/*
   SetDefaultConfig - force the Diag enable flag to the
                      time or mem global default.
*/

EXTERN void M2Diagnostic_SetDefaultConfig (M2Diagnostic_Diagnostic Diag);

/*
   Configure - will turn on or off all the memory or time
               instrumentation diagnostics and set the defaults
               time and mem values.
*/

EXTERN void M2Diagnostic_Configure (bool time_, bool mem);

/*
   Generate - return a string containing the output from
              all the diagnostics enabled.
*/

EXTERN DynamicStrings_String M2Diagnostic_Generate (void);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
