/* armeb.v4a-linux.elf-entry.h
   created from armeb.v4a-linux.elf-entry.bin, 15350 (0x3bf6) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) Markus Franz Xaver Johannes Oberhumer
   Copyright (C) Laszlo Molnar
   Copyright (C) John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_ARMEB_V4A_LINUX_ELF_ENTRY_SIZE    15350
#define STUB_ARMEB_V4A_LINUX_ELF_ENTRY_ADLER32 0x25b9d463
#define STUB_ARMEB_V4A_LINUX_ELF_ENTRY_CRC32   0x6101d86b

unsigned char stub_armeb_v4a_linux_elf_entry[15350] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  2,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   0,  1,  0, 40,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0, 15,136,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,
/* 0x0030 */   0, 21,  0, 18,235,  0,  0,220,225,160,  0, 14,227,160, 16,  4,
/* 0x0040 */ 227,160, 32,  0,227,160, 48,  0,227,160, 64,  0,233, 45,  0, 31,
/* 0x0050 */ 227,160, 48,  8,227,160, 32,  0,225,160, 16, 13,227,160,  0, 11,
/* 0x0060 */ 227,160,112, 67,239,  0,  0,  0,226,141,208, 20,235,  0,  0, 20,
/* 0x0070 */ 227,160, 48,  8,227,160, 32,  0,227,160, 16,  0,227,160,  0, 11,
/* 0x0080 */ 227,160,112, 67,239,  0,  0,  0,225,160,240, 14,229,141,224, 12,
/* 0x0090 */ 226,141,  0, 40,235,  0,  1, 44,235,  0,  1, 44,232,176,  0,  6,
/* 0x00a0 */ 227, 81,  0,  6, 10,  0,  0,  7,227, 81,  0,  0, 26,  0,  0,  1,
/* 0x00b0 */ 227,160, 42,  1,225,224, 32,  2,226,130, 32,  1,225,160,128,  2,
/* 0x00c0 */ 235,  0,  0,128,226,142,160,  4,229,154,112,  0,227,160, 12,  1,
/* 0x00d0 */ 226,128,  0, 49,224,135, 96,  0,229,141, 96, 20,225,160,176, 13,
/* 0x00e0 */ 224, 77,208,  0,227,205,208,  7,227,160,  0,  0,225,160, 16, 13,
/* 0x00f0 */ 232,161,  0,  1,225, 81,  0, 11, 58,  0,  0, 22,225,160, 32, 13,
/* 0x0100 */ 225,160, 16,  6,227,160,  0,  0,235,255,255,254,227, 16, 11,  2,
/* 0x0110 */  90,  0,  0, 32,231,240,  1,240,225,160, 22, 32,225,160, 22,  1,
/* 0x0120 */ 224, 64,  0,  1,226, 64,  0,  1,224,129, 32,  7,226,130, 32, 24,
/* 0x0130 */ 227,194, 32,  7,232,189,  0,  8,232,162,  0,  8,225, 93,  0, 11,
/* 0x0140 */  58,  0,  0, 39,229,141, 16, 16,225,160,176,  0,226,135, 64, 24,
/* 0x0150 */ 229,157, 80, 12,227,196, 64,  7,229,157, 48, 32,225,160, 32,  8,
/* 0x0160 */ 232,129,  0, 60,233, 45,  0,128,225,160, 48, 13,226,129, 32, 16,
/* 0x0170 */ 229,218,  0,  8,233, 45,  0,  1,229,154, 16,  4,226,138,  0, 12,
/* 0x0180 */ 235,  0,  1, 48,226,141,208,  8,229,157, 32, 20,229,157, 16, 16,
/* 0x0190 */ 225,160,  0, 11,227,160,112,  4,239,  0,  0,  0,227,160, 80,  0,
/* 0x01a0 */ 225,160, 64, 11,227,160, 48, 18,227,160, 32,  5,229,157, 16, 20,
/* 0x01b0 */ 229,157,  0, 16,227,160,112,192,239,  0,  0,  0,225,160,  0, 11,
/* 0x01c0 */ 227,160,112,  6,239,  0,  0,  0,229,157,  0,  8,229, 26, 16,  4,
/* 0x01d0 */ 224,128, 64,  1,227,193, 16,  2,224, 73, 80,  1,232,141,  0, 48,
/* 0x01e0 */ 229,157,192, 16,226,140,240, 16, 47,112,114,111, 99, 47,115,101,
/* 0x01f0 */ 108,102, 47, 99,109,100,108,105,110,101,  0,  0,227,160,  0,  0,
/* 0x0200 */ 227,160,112,  6,239,  0,  0,  0,227,160, 16,  0,227,160,  0,  0,
/* 0x0210 */ 233, 45,  0,  3,225,160,  0, 13,227,160,112, 42,239,  0,  0,  0,
/* 0x0220 */ 232,189,  0, 65,227,160, 32,252,226,143, 16,172,225,160,  0,  6,
/* 0x0230 */ 227,160,112,  4,239,  0,  0,  0,225,160,  0,  6,227,160,112,  6,
/* 0x0240 */ 239,  0,  0,  0,226, 77,218,  1,227,160, 32,  0,226, 79, 16,108,
/* 0x0250 */ 227,224,  0,  0,225,160,192,  7,227,160,112, 66,227,135,124,  1,
/* 0x0260 */ 239,  0,  0,  0,225,160,112, 12,225,160, 96,  0,225,160, 16, 13,
/* 0x0270 */ 227,160, 42,  1,227,160,112,  3,239,  0,  0,  0,225,160,  0,  6,
/* 0x0280 */ 227,160,112,  6,239,  0,  0,  0,227,160,112, 64,239,  0,  0,  0,
/* 0x0290 */ 226, 77,208, 16,225,160, 16,  0,225,160,  0, 13,235,  0,  1,  7,
/* 0x02a0 */ 227,160, 64,  0,225,160, 48, 13,226,141, 32, 16,226,143, 16, 24,
/* 0x02b0 */ 226,143,  0, 23,233, 45,  0, 31,227,160, 32,  0,225,160, 16, 13,
/* 0x02c0 */ 227,160,112, 11,239,  0,  0,  0,234,  0,  0,140, 45,113,  0, 47,
/* 0x02d0 */ 117,115,114, 47, 98,105,110, 47,103,100, 98,  0,115,101,116, 32,
/* 0x02e0 */ 112,114,111,109,112,116, 10,105,110,102,111, 32,105,110,102,101,
/* 0x02f0 */ 114,105,111,114,115, 10,112,114,105,110,116, 32, 34,114, 48, 45,
/* 0x0300 */ 114, 55, 34, 10,120, 47, 56,120,119, 32, 36,115,112, 32, 43, 32,
/* 0x0310 */  48,120, 50, 56, 10,112,114,105,110,116, 32, 34,114, 56, 45,114,
/* 0x0320 */  49, 53, 34, 10,120, 47, 56,120,119, 10,115,101,116, 32, 36,112,
/* 0x0330 */  99, 32, 61, 32, 42, 40,105,110,116, 32, 42, 41, 40, 36,115,112,
/* 0x0340 */  32, 43, 32, 48,120, 54, 52, 41, 10,112,114,105,110,116, 32, 34,
/* 0x0350 */ 102, 97,117,108,116,105,110,103, 32,105,110,115,116,114, 34, 10,
/* 0x0360 */ 120, 47,105, 32, 36,112, 99, 10,112,114,105,110,116, 32, 34,102,
/* 0x0370 */  97,117,108,116, 32, 99,111,110,116,101,120,116, 34, 10,120, 47,
/* 0x0380 */  49, 53,105, 32, 36,112, 99, 32, 45, 32, 55, 42, 52, 10,115,101,
/* 0x0390 */ 116, 32, 36,115,112, 32, 61, 32, 42, 40,108,111,110,103, 32, 42,
/* 0x03a0 */  41, 40, 36,115,112, 32, 43, 32, 48,120, 53, 99, 41, 10,112,114,
/* 0x03b0 */ 105,110,116, 32, 34,117,115,101,114, 32,115,116, 97, 99,107, 34,
/* 0x03c0 */  10,120, 47, 54, 52,120,119, 32, 36,115,112, 10,107,105,108,108,
/* 0x03d0 */  10,113,117,105,116, 32, 49,  0,225,160,  0,  0, 47,112,114,111,
/* 0x03e0 */  99, 47,115,101,108,102, 47,109, 97,112,115,  0, 10, 10, 83, 73,
/* 0x03f0 */  71, 83, 69, 71, 86, 32, 97,100,100,114,101,115,115, 32,115,112,
/* 0x0400 */  97, 99,101, 58, 10,  0,  0,  0,225,160,192, 14,225,160,224, 15,
/* 0x0410 */ 225,160,240, 12,233, 45,  0,  6,227,160, 32, 25,226, 79, 16, 56,
/* 0x0420 */ 227,160,  0,  2,227,160,112,  4,239,  0,  0,  0,227,160, 32,  0,
/* 0x0430 */ 226, 79, 16, 92,227,224,  0,  0,225,160,192,  7,227,160,112, 66,
/* 0x0440 */ 227,135,124,  1,239,  0,  0,  0,225,160,112, 12,225,160, 96,  0,
/* 0x0450 */ 226, 77,218,  1,227,160, 42,  1,225,160, 16, 13,225,160,  0,  6,
/* 0x0460 */ 227,160,112,  3,239,  0,  0,  0,227, 80,  0,  0, 10,  0,  0,252,
/* 0x0470 */ 225,160, 32,  0,225,160, 16, 13,227,160,  0,  2,227,160,112,  4,
/* 0x0480 */ 239,  0,  0,  0,234,  0,  0,239,226,141,218,  1,225,160,  0,  6,
/* 0x0490 */ 227,160,112,  6,239,  0,  0,  0,227,160,  0,  0,227,160, 16,  0,
/* 0x04a0 */ 227,160,112,  2,239,  0,  0,  0,227, 80,  0,  0, 10,  0,  0, 89,
/* 0x04b0 */ 234,  0,  1,  6,227,160, 32,  0,233, 45, 64,  4,235,  0,  1, 13,
/* 0x04c0 */ 232,189, 64,  4,229,192, 32,  0,225,160,240, 14,225,160,192,  1,
/* 0x04d0 */ 227,160, 32,  0,225,160, 48,  1,224,145, 17,129,224,162, 33,130,
/* 0x04e0 */ 224,130, 46,163,225,160, 48,  1,224,145, 18,  1,224,162, 34,  2,
/* 0x04f0 */ 224,130, 46, 35,225,160, 48,  1,224,145, 20,  1,224,162, 36,  2,
/* 0x0500 */ 224,130, 44, 35,225,160, 48,  1,224,145, 24,  1,224,162, 40,  2,
/* 0x0510 */ 224,130, 40, 35,224, 81, 31,140,224,194, 32,172,224,145, 16, 12,
/* 0x0520 */ 226,178, 16,  0,224,129, 33,  1,224, 76, 32,130,233, 45, 64,  4,
/* 0x0530 */  10,  0,  1, 40,235,  0,  1, 13,232,189, 64,  2,226,129, 16, 48,
/* 0x0540 */ 228,192, 16,  1,225,160,240, 14,228,144, 16,  4,227, 81,  0,  0,
/* 0x0550 */  26,  0,  1, 44,225,160,240, 14,224,129, 16,  0,233, 45, 64, 62,
/* 0x0560 */ 227,224, 80,  0,227,160, 65,  2,234,  0,  1, 73,232,189,  0, 26,
/* 0x0570 */ 224, 64,  0,  1,224, 66, 32,  3,229,132, 32,  0,232,189,128, 48,
/* 0x0580 */ 224,148, 64,  4, 17,160,240, 14,228,208, 64,  1,224,164, 64,  4,
/* 0x0590 */ 225,176, 76,  4,225,160,240, 14,227,160, 16,  1,225,160,192, 14,
/* 0x05a0 */ 235,  0,  1, 58,224,177, 16,  1,235,  0,  1, 58, 58,  0,  1, 66,
/* 0x05b0 */ 225,160,240, 12,228,208, 48,  1,228,194, 48,  1,235,  0,  1, 58,
/* 0x05c0 */  42,  0,  1, 71,235,  0,  1, 64,226, 81, 48,  3,227,160, 16,  0,
/* 0x05d0 */  58,  0,  1, 83,228,208, 80,  1,225,133, 84,  3,225,240, 80,  5,
/* 0x05e0 */  10,  0,  1, 53,235,  0,  1, 58,224,177, 16,  1,235,  0,  1, 58,
/* 0x05f0 */ 224,177, 16,  1, 26,  0,  1, 90,235,  0,  1, 64,226,129, 16,  2,
/* 0x0600 */ 227,117, 12, 13, 50,129, 16,  1,231,210, 48,  5,226, 81, 16,  1,
/* 0x0610 */ 228,194, 48,  1, 42,  0,  1, 92,234,  0,  1, 73,227,224,  0,  0,
/* 0x0620 */ 225,160,  6,  0,225,160,240, 14,231,240,  1,240,225,160,240, 14,
/* 0x0630 */ 227, 82,  0,  0, 10,  0,  0,  7,225,160, 64,  0,228,209, 48,  1,
/* 0x0640 */ 226, 66, 32,  1,228,192, 48,  1, 26,  0,  0,  3,225,160,  0,  4,
/* 0x0650 */ 225,160,240, 14,227, 82,  0,  0, 10,  0,  0, 15,225,160, 48,  0,
/* 0x0660 */ 228,192, 16,  1,226, 82, 32,  1, 26,  0,  0, 12,225,160,  0,  3,
/* 0x0670 */ 225,160,240, 14,227, 82,  0,  0, 10,  0,  0, 23,228,209, 48,  1,
/* 0x0680 */ 226, 82, 32,  1,228,192, 48,  1, 26,  0,  0, 19,225,160,240, 14,
/* 0x0690 */ 225,160,192,  7,225,160,192,  7,227,160,112,129,227,135,124,  1,
/* 0x06a0 */ 239,  0,  0,  0,225,160,112, 12,225,160,112, 12,225,160,240, 14,
/* 0x06b0 */ 225,160,192,  7,227,160,112,  6,239,  0,  0,  0,225,160,112, 12,
/* 0x06c0 */ 225,160,240, 14,225,160,192,  7,227,160,112,  1,239,  0,  0,  0,
/* 0x06d0 */ 225,160,112, 12,225,160,240, 14,225,160,192,  7,227,160,112,148,
/* 0x06e0 */ 239,  0,  0,  0,225,160,112, 12,225,160,240, 14,225,160,192,  7,
/* 0x06f0 */ 227,160,112,118,239,  0,  0,  0,225,160,112, 12,225,160,240, 14,
/* 0x0700 */ 225,160,192,  7,227,160,112, 93,239,  0,  0,  0,225,160,112, 12,
/* 0x0710 */ 225,160,240, 14,225,160,192,  7,227,160,112, 20,239,  0,  0,  0,
/* 0x0720 */ 225,160,112, 12,225,160,240, 14,225,160,192,  7,227,160,112, 19,
/* 0x0730 */ 239,  0,  0,  0,225,160,112, 12,225,160,240, 14,225,160,192,  7,
/* 0x0740 */ 227,160,112, 39,239,  0,  0,  0,225,160,112, 12,225,160,240, 14,
/* 0x0750 */ 225,160,192,  7,227,160,112,  5,239,  0,  0,  0,225,160,112, 12,
/* 0x0760 */ 225,160,240, 14,225,160,192,  7,227,160,112,  3,239,  0,  0,  0,
/* 0x0770 */ 225,160,112, 12,225,160,240, 14,225,160,192,  7,227,160,112,106,
/* 0x0780 */ 239,  0,  0,  0,225,160,112, 12,225,160,240, 14,225,160,192,  7,
/* 0x0790 */ 227,160,112,122,239,  0,  0,  0,225,160,112, 12,225,160,240, 14,
/* 0x07a0 */ 225,160,192,  7,227,160,112, 10,239,  0,  0,  0,225,160,112, 12,
/* 0x07b0 */ 225,160,240, 14,225,160,192,  7,227,160,112,  4,239,  0,  0,  0,
/* 0x07c0 */ 225,160,112, 12,225,160,240, 14,227,160,112,  0,225,160,118,  7,
/* 0x07d0 */ 225,199,112,  0,224, 64,  0,  7,224,129, 16,  7,225,160,192,  7,
/* 0x07e0 */ 227,160,112,144,239,  0,  0,  0,225,160,112, 12,225,160,240, 14,
/* 0x07f0 */ 231,240,  1,240,225,160,240, 14,233, 45, 64, 48,229,157, 80, 16,
/* 0x0800 */ 229,157, 64, 12,225,160, 86, 37,227,224,192,  0,225,160,198, 12,
/* 0x0810 */ 225,192,192, 12,224, 64,  0, 12,224,129, 16, 12,225,160,192,  7,
/* 0x0820 */ 227,160,112,192,239,  0,  0,  0,225,160,112, 12,232,189,128, 48,
/* 0x0830 */ 225,160,192, 14,225,160,224, 15,225,160,240, 12,  0,  0,  0,  0,
/* 0x0840 */ 234,255,255,254,234,255,255,254,226,  0, 32, 63,226,  0, 48, 31,
/* 0x0850 */ 227, 83,  0, 26,154,  0,  0,  5,227, 16,  0, 32, 18, 66, 32, 70,
/* 0x0860 */   2, 66, 32, 43,226,130,  0, 64,225, 47,255, 30,225,160,192,  2,
/* 0x0870 */ 234,  0,  0, 17,229,208, 32,  0,227,130, 32, 32,229,209, 48,  0,
/* 0x0880 */ 227,131, 48, 32,224, 82, 32,  3, 26,  0,  0, 21,226,128,  0,  1,
/* 0x0890 */ 226,129, 16,  1,226, 76,192,  1,227,124,  0,  1, 26,  0,  0,  9,
/* 0x08a0 */ 227,160, 32,  0,225,160,  0,  2,225, 47,255, 30,233, 45, 64,112,
/* 0x08b0 */ 226, 77,208, 64,225,160, 80,  0,225,160, 96,  1,225,160,  0, 13,
/* 0x08c0 */ 227,160, 16,255,227,160, 32, 64,235,255,255,254,225,160,  0,  5,
/* 0x08d0 */ 225,160, 16, 13,235,255,255,254,226, 80, 64,  0,186,  0,  0, 41,
/* 0x08e0 */ 225,221, 48,184,226,  3, 58, 15,227, 83,  9,  1,  3,160, 64,  0,
/* 0x08f0 */ 234,  0,  0, 53,227,116,  0,  2, 26,  0,  0, 47,225,160,  0,  5,
/* 0x0900 */ 227,160, 29,  7,235,255,255,254,225,160, 64,  0,226, 86, 48,  0,
/* 0x0910 */  19,160, 48,  1,224, 19, 63,164, 17,160,  0,  5, 17,160, 16,  4,
/* 0x0920 */  27,255,255,254,225,160,  0,  4,226,141,208, 64,232,189,128,112,
/* 0x0930 */ 233, 45, 65,240,225,160,112,  0,225,160, 96,  1,235,  0,  0, 63,
/* 0x0940 */  47,100, 97,116, 97, 47,100, 97,116, 97, 47,  0,225,160, 16, 14,
/* 0x0950 */ 227,160, 32, 11,235,255,255,254,227,160, 64,  0,229,192, 64,  0,
/* 0x0960 */ 225,160,  0,  7,227,160, 16,  1,235,  0,  0, 23,235,  0,  0, 77,
/* 0x0970 */  47,112,114,111, 99, 47,115,101,108,102, 47, 99,109,100,108,105,
/* 0x0980 */ 110,101,  0,  0,225,160,128, 14,225,160,  0,  8,225,160, 16,  4,
/* 0x0990 */ 225,160, 32,  4,235,255,255,254,225,160, 64,  0,225,160, 16,  6,
/* 0x09a0 */ 227,160, 46,255,226,130, 32, 15,235,255,255,254,225,160, 80,  0,
/* 0x09b0 */ 225,160,  0,  4,235,255,255,254,227, 85,  0,  0,177,160,  0,  8,
/* 0x09c0 */ 187,255,255,254,227,160, 48,  0,231,198, 48,  5,229,214, 48,  0,
/* 0x09d0 */ 227, 83,  0,  0,  1,160, 16,  6, 10,  0,  0,139,225,160, 16,  6,
/* 0x09e0 */ 229,241, 48,  1,227, 83,  0,  0, 26,  0,  0,100,234,  0,  0,139,
/* 0x09f0 */ 229,116, 48,  1,227, 83,  0, 47, 26,  0,  0,104,224,100,128,  1,
/* 0x0a00 */ 226,135,  0, 10,225,160, 16,  4,225,160, 32,  8,235,255,255,254,
/* 0x0a10 */ 225,160, 80,  0,227,160, 96,  0,229,192, 96,  0,225,160,  0,  7,
/* 0x0a20 */ 225,160, 16,  6,235,  0,  0, 23,227,112,  0, 13, 26,  0,  0,141,
/* 0x0a30 */ 235,  0,  0,126, 99,111,109, 46,116,101,114,109,117,120, 47,102,
/* 0x0a40 */ 105,108,101,115,  0,  0,  0,  0,225,160, 16, 14,226,135,  0, 11,
/* 0x0a50 */ 227,160, 32, 16,235,255,255,254,225,160, 16,  4,225,160, 32,  8,
/* 0x0a60 */ 235,255,255,254,225,160, 80,  0,229,192, 96,  0,225,160,  0,  7,
/* 0x0a70 */ 227,160, 16,  1,235,  0,  0, 23,234,  0,  0,141,225,160, 64,  1,
/* 0x0a80 */ 234,  0,  0,104,235,  0,  0,144, 47, 99, 97, 99,104,101,  0,  0,
/* 0x0a90 */ 225,160, 16, 14,225,160,  0,  5,227,160, 32,  6,235,255,255,254,
/* 0x0aa0 */ 225,160, 64,  0,227,160, 96,  0,229,192, 96,  0,225,160,  0,  7,
/* 0x0ab0 */ 227,160, 16,  1,235,  0,  0, 23,235,  0,  0,157, 47,117,112,120,
/* 0x0ac0 */   0,  0,  0,  0,225,160, 16, 14,225,160,  0,  4,227,160, 32,  4,
/* 0x0ad0 */ 235,255,255,254,225,160, 64,  0,235,255,255,254,225,160, 80,  0,
/* 0x0ae0 */ 235,255,255,254,229,196,  0,  0,225,160,  3, 37,235,255,255,254,
/* 0x0af0 */ 229,196,  0,  1,225,160,  6, 37,235,255,255,254,229,196,  0,  2,
/* 0x0b00 */ 229,196, 96,  3,225,160,  0,  6,232,189,129,240,233, 45, 65,240,
/* 0x0b10 */ 226, 77,218,  1,226, 77,208, 12,225,160,112,  0,225,160,128,  1,
/* 0x0b20 */ 225,160, 96,  2,235,  0,  0,183,117,112,120,  0,225,160, 64, 14,
/* 0x0b30 */ 225,160,  0,  4,227,160, 16, 16,235,255,255,254,225,160, 80,  0,
/* 0x0b40 */ 227,112,  0, 22, 26,  0,  0,194,225,160,  0,  4,227,160, 16,  0,
/* 0x0b50 */ 235,255,255,254,225,160, 80,  0,227, 85,  0,  0,170,  0,  0,215,
/* 0x0b60 */ 235,  0,  0,200, 47,100,101,118, 47,115,104,109,  0,  0,  0,  0,
/* 0x0b70 */ 225,160,  0, 14,227,160, 25,  1,226,129, 16,  2,227,129, 21,  1,
/* 0x0b80 */ 227,160, 45,  7,235,255,255,254,226, 80, 80,  0,170,  0,  0,215,
/* 0x0b90 */ 235,  0,  0,213,109,101,109,102,100, 95, 99,114,101, 97,116,101,
/* 0x0ba0 */   0,  0,  0,  0,225,160,  0, 14,235,255,255,254,226,141, 64, 12,
/* 0x0bb0 */ 225,160,  0,  4,235,255,255,254,235,  0,  0,220, 97,110,100,  0,
/* 0x0bc0 */ 225,160,  0, 14,225,160, 16,  4,227,160, 32,  3,235,  0,  0,  7,
/* 0x0bd0 */ 227, 80,  0,  0, 10,  0,  0,238,235,  0,  0,228, 76,105,110,  0,
/* 0x0be0 */ 225,160,  0, 14,225,160, 16,  4,227,160, 32,  3,235,  0,  0,  7,
/* 0x0bf0 */ 227, 80,  0,  0, 26,  0,  0,238,229,212, 48,130,227, 83,  0, 52,
/* 0x0c00 */ 131,160, 64,  1,138,  0,  1, 16,227, 86,  0,  0, 26,  0,  0,247,
/* 0x0c10 */ 235,255,255,254,226, 80, 96,  0,  3,160, 49,  2,  2,141, 42,  1,
/* 0x0c20 */   2,130, 32, 12,  7,194,105,195,  2,141, 96, 12,227,117,  0, 38,
/* 0x0c30 */  26,  0,  1, 15,227, 86,  0,  0, 10,  0,  1, 15,229,214, 48,  0,
/* 0x0c40 */ 227, 83,  0,  0, 26,  0,  1,  4,225,160,  0,  6,226,141, 27,  2,
/* 0x0c50 */ 226,129, 16, 12,235,  0,  0, 56,227, 80,  0,  0,186,  0,  1, 76,
/* 0x0c60 */ 225,160,  0,  6,227,160, 16,194,227,160, 45,  7,235,255,255,254,
/* 0x0c70 */ 226, 80, 80,  0,177,160,  0,  5,186,  0,  1, 76,225,160,  0,  6,
/* 0x0c80 */ 235,255,255,254,227,160, 64,  0,234,  0,  1, 16,227,160, 64,  0,
/* 0x0c90 */ 227, 87,  0,  0, 10,  0,  1, 23,235,255,255,254,225,224,  0,  0,
/* 0x0ca0 */ 224,  0,  0,  7,224, 96,112,  7,224,136,128,  0,227, 88,  0,  0,
/* 0x0cb0 */  10,  0,  1, 50,227, 84,  0,  0, 10,  0,  1, 33,225,160,  0,  5,
/* 0x0cc0 */ 225,160, 16,  8,235,255,255,254,227, 80,  0,  0,170,  0,  1, 50,
/* 0x0cd0 */ 234,  0,  1, 76,225,160,  0,  5,226, 72, 16,  1,227,160, 32,  0,
/* 0x0ce0 */ 235,255,255,254,227,224, 26,  1,227,160, 64,  0,226,141, 58,  1,
/* 0x0cf0 */ 226,131, 48, 12,231,195, 64,  1,225,160,  0,  5,224,131, 16,  1,
/* 0x0d00 */ 227,160, 32,  1,235,255,255,254,225,160,  0,  5,225,160, 16,  4,
/* 0x0d10 */ 225,160, 32,  4,235,255,255,254,227, 87,  0,  0,  3,160,192,  1,
/* 0x0d20 */  10,  0,  1, 62,235,255,255,254,225,160, 32,  0,225,215, 48,  0,
/* 0x0d30 */  10,  0,  1, 74,225,160,  0,  5,225,160, 16,  7,226, 98, 32,  0,
/* 0x0d40 */ 235,255,255,254,234,  0,  1, 74,229,141, 80,  0,227,160, 48,  0,
/* 0x0d50 */ 229,141, 48,  4,225,160,  0,  7,225,160, 16,  8,227,160, 32,  3,
/* 0x0d60 */ 225,160, 48, 12,235,255,255,254,227,112, 10,  1,146,133, 48,  1,
/* 0x0d70 */ 145,128,  0,  3,234,  0,  1, 76,227,160,192, 17,234,  0,  1, 62,
/* 0x0d80 */ 226,141,208, 12,226,141,218,  1,232,189,129,240,233, 45, 64,240,
/* 0x0d90 */ 226, 77,208,  8,225,160,112,  0,225,160, 96,  1,235,  0,  0,  4,
/* 0x0da0 */ 117,112,120,  0,225,160, 64, 14,225,160,  0,  4,227,160, 16, 16,
/* 0x0db0 */ 235,255,255,254,225,160, 80,  0,227,112,  0, 22, 26,  0,  0, 15,
/* 0x0dc0 */ 225,160,  0,  4,227,160, 16,  0,235,255,255,254,225,160, 80,  0,
/* 0x0dd0 */ 227, 85,  0,  0,170,  0,  0, 55,235,  0,  0, 21, 47,100,101,118,
/* 0x0de0 */  47,115,104,109,  0,  0,  0,  0,225,160,  0, 14,227,160, 25,  1,
/* 0x0df0 */ 226,129, 16,  2,227,129, 21,  1,227,160, 45,  7,235,255,255,254,
/* 0x0e00 */ 226, 80, 80,  0,170,  0,  0, 55,227,117,  0, 21, 17,160, 64,  5,
/* 0x0e10 */  26,  0,  0, 76,235,  0,  0, 49, 85, 80, 88, 45, 53, 46, 48, 32,
/* 0x0e20 */ 119, 97,110,116,115, 32,109,101,109,102,100, 95, 99,114,101, 97,
/* 0x0e30 */ 116,101, 40, 41, 44, 32,111,114, 32,110,101,101,100,115, 32, 47,
/* 0x0e40 */ 100,101,118, 47,115,104,109, 40, 44, 79, 95, 84, 77, 80, 70, 73,
/* 0x0e50 */  76, 69, 44, 41, 10,  0,  0,  0,225,160, 16, 14,227,160,  0,  2,
/* 0x0e60 */ 227,160, 32, 61,235,255,255,254,227,160,  0,127,235,255,255,254,
/* 0x0e70 */ 225,160,  0,  5,225,160, 16,  6,235,255,255,254,227, 80,  0,  0,
/* 0x0e80 */ 177,160, 64,  0,186,  0,  0, 76,229,141, 80,  0,227,160, 48,  0,
/* 0x0e90 */ 229,141, 48,  4,225,160,  0,  7,225,160, 16,  6,227,160, 32,  3,
/* 0x0ea0 */ 225, 87,  0,  3,  3,160, 48,  1, 19,160, 48, 17,235,255,255,254,
/* 0x0eb0 */ 225,160, 64,  0,235,255,255,254,225, 80,  0,  4,130,132, 48,  1,
/* 0x0ec0 */ 128,133, 64,  3,225,160,  0,  4,226,141,208,  8,232,189,128,240,
/* 0x0ed0 */   0,  0,  0,  0,229, 31,144, 16,229, 31, 32, 16,226, 79, 48, 24,
/* 0x0ee0 */ 224, 67, 48,  9,235,  0,  0,  5,225,160,240, 14,233, 45,  0,  7,
/* 0x0ef0 */ 226, 77,208,  8,233, 45, 64, 11,  0, 46,115,121,109,116, 97, 98,
/* 0x0f00 */   0, 46,115,116,114,116, 97, 98,  0, 46,115,104,115,116,114,116,
/* 0x0f10 */  97, 98,  0, 46,114,101,108, 69, 76, 70, 83, 73, 71, 83, 69, 71,
/* 0x0f20 */  86,  0, 46,114,101,108, 69, 76, 70, 77, 65, 73, 78, 88, 50,  0,
/* 0x0f30 */  69, 76, 70, 77, 65, 73, 78, 89,  0, 46,114,101,108, 69, 76, 70,
/* 0x0f40 */  77, 65, 73, 78, 90,  0, 46,114,101,108, 72, 85, 77, 70, 95, 65,
/* 0x0f50 */   0, 46,114,101,108, 72, 85, 77, 70, 95, 76,  0, 46,114,101,108,
/* 0x0f60 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,  0, 46,114,101,108,
/* 0x0f70 */  85, 77, 70, 95, 76, 73, 78, 85, 88,  0, 46,114,101,108, 69, 76,
/* 0x0f80 */  70, 77, 65, 73, 78, 88,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0fa0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0fb0 */   0,  0,  0, 31,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,
/* 0x0fc0 */   0,  0,  0, 52,  0,  0,  0, 92,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0fd0 */   0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0, 27,  0,  0,  0,  9,
/* 0x0fe0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 22,156,  0,  0,  0, 16,
/* 0x0ff0 */   0,  0,  0, 19,  0,  0,  0,  1,  0,  0,  0,  4,  0,  0,  0,  8,
/* 0x1000 */   0,  0,  0, 46,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,
/* 0x1010 */   0,  0,  0,144,  0,  0,  5,152,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1020 */   0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 42,  0,  0,  0,  9,
/* 0x1030 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 22,172,  0,  0,  1, 24,
/* 0x1040 */   0,  0,  0, 19,  0,  0,  0,  3,  0,  0,  0,  4,  0,  0,  0,  8,
/* 0x1050 */   0,  0,  0, 56,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,
/* 0x1060 */   0,  0,  6, 40,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1070 */   0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0, 69,  0,  0,  0,  1,
/* 0x1080 */   0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  6, 40,  0,  0,  2, 24,
/* 0x1090 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,
/* 0x10a0 */   0,  0,  0, 65,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x10b0 */   0,  0, 23,196,  0,  0,  0, 56,  0,  0,  0, 19,  0,  0,  0,  6,
/* 0x10c0 */   0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 82,  0,  0,  0,  1,
/* 0x10d0 */   0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  8, 64,  0,  0,  0,  4,
/* 0x10e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,
/* 0x10f0 */   0,  0,  0, 78,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1100 */   0,  0, 23,252,  0,  0,  0,  8,  0,  0,  0, 19,  0,  0,  0,  8,
/* 0x1110 */   0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 93,  0,  0,  0,  1,
/* 0x1120 */   0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  8, 68,  0,  0,  0,  4,
/* 0x1130 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,
/* 0x1140 */   0,  0,  0, 89,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1150 */   0,  0, 24,  4,  0,  0,  0,  8,  0,  0,  0, 19,  0,  0,  0, 10,
/* 0x1160 */   0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,104,  0,  0,  0,  1,
/* 0x1170 */   0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  8, 72,  0,  0,  5, 68,
/* 0x1180 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,
/* 0x1190 */   0,  0,  0,100,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x11a0 */   0,  0, 24, 12,  0,  0,  2,192,  0,  0,  0, 19,  0,  0,  0, 12,
/* 0x11b0 */   0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,120,  0,  0,  0,  1,
/* 0x11c0 */   0,  0,  0,  6,  0,  0,  0,  0,  0,  0, 13,140,  0,  0,  1, 68,
/* 0x11d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,
/* 0x11e0 */   0,  0,  0,116,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x11f0 */   0,  0, 26,204,  0,  0,  0,128,  0,  0,  0, 19,  0,  0,  0, 14,
/* 0x1200 */   0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,134,  0,  0,  0,  1,
/* 0x1210 */   0,  0,  0,  6,  0,  0,  0,  0,  0,  0, 14,208,  0,  0,  0, 40,
/* 0x1220 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,
/* 0x1230 */   0,  0,  0,130,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1240 */   0,  0, 27, 76,  0,  0,  0, 16,  0,  0,  0, 19,  0,  0,  0, 16,
/* 0x1250 */   0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0, 17,  0,  0,  0,  3,
/* 0x1260 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 14,248,  0,  0,  0,143,
/* 0x1270 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,
/* 0x1280 */   0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1290 */   0,  0, 18,208,  0,  0,  2,160,  0,  0,  0, 20,  0,  0,  0, 10,
/* 0x12a0 */   0,  0,  0,  4,  0,  0,  0, 16,  0,  0,  0,  9,  0,  0,  0,  3,
/* 0x12b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 21,112,  0,  0,  1, 43,
/* 0x12c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,
/* 0x12d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x12e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0,  1,
/* 0x12f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0,  3,
/* 0x1300 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0,  6,
/* 0x1310 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0, 12,
/* 0x1320 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0, 14,
/* 0x1330 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0, 16,
/* 0x1340 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0,  5,
/* 0x1350 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0,  8,
/* 0x1360 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  0, 10,
/* 0x1370 */   0,  0,  0,  1,  0,  0,  5,140,  0,  0,  0,  0, 16,  0,  0,  3,
/* 0x1380 */   0,  0,  0, 15,  0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  0,  0,
/* 0x1390 */   0,  0,  0, 20,  0,  0,  0,236,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x13a0 */   0,  0,  0, 27,  0,  0,  5,152,  0,  0,  0,  0, 16,  0,  0,  3,
/* 0x13b0 */   0,  0,  0, 43,  0,  0,  0,  8,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x13c0 */   0,  0,  0, 50,  0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  0,  0,
/* 0x13d0 */   0,  0,  0, 58,  0,  0,  1,160,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x13e0 */   0,  0,  0, 64,  0,  0,  0, 76,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x13f0 */   0,  0,  0, 72,  0,  0,  0,216,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x1400 */   0,  0,  0, 82,  0,  0,  1,  0,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x1410 */   0,  0,  0, 88,  0,  0,  2,196,  0,  0,  2,128, 18,  0,  0, 12,
/* 0x1420 */   0,  0,  0,112,  0,  0,  1,208,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x1430 */   0,  0,  0,117,  0,  0,  0,  0,  0,  0,  1, 68, 18,  0,  0, 14,
/* 0x1440 */   0,  0,  0,139,  0,  0,  1,100,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x1450 */   0,  0,  0,145,  0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  0,  5,
/* 0x1460 */   0,  0,  0,160,  0,  0,  1,140,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x1470 */   0,  0,  0,166,  0,  0,  0,176,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x1480 */   0,  0,  0,176,  0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x1490 */   0,  0,  0,191,  0,  0,  0,104,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x14a0 */   0,  0,  0,204,  0,  0,  0,  4,  0,  0,  0,  0, 16,  0,  0, 16,
/* 0x14b0 */   0,  0,  0,211,  0,  0,  1, 60,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x14c0 */   0,  0,  0,216,  0,  0,  1,120,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x14d0 */   0,  0,  0,223,  0,  0,  0, 44,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x14e0 */   0,  0,  0,230,  0,  0,  4,200,  0,  0,  0,196, 18,  0,  0,  3,
/* 0x14f0 */   0,  0,  0,253,  0,  0,  1,200,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x1500 */   0,  0,  1,  5,  0,  0,  0,196,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x1510 */   0,  0,  1, 11,  0,  0,  1, 80,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x1520 */   0,  0,  1, 16,  0,  0,  2, 24,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x1530 */   0,  0,  1, 21,  0,  0,  0,156,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x1540 */   0,  0,  1, 26,  0,  0,  1, 40,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x1550 */   0,  0,  1, 31,  0,  0,  1, 20,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x1560 */   0,  0,  1, 37,  0,  0,  0,136,  0,  0,  0,  0, 16,  0,  0,  6,
/* 0x1570 */   0,103,101,116, 95,112, 97,103,101, 95,109, 97,115,107,  0, 77,
/* 0x1580 */  70, 76, 71,  0,103,101,116,112,105,100,  0,117,112,120, 95,109,
/* 0x1590 */ 109, 97,112, 95, 97,110,100, 95,102,100,  0,109,101,109, 99,112,
/* 0x15a0 */ 121,  0, 79, 95, 66, 73, 78, 70, 79,  0, 80,115,121,110, 99,  0,
/* 0x15b0 */ 109,101,109,112, 99,112,121,  0,102,116,114,117,110, 99, 97,116,
/* 0x15c0 */ 101,  0,108,115,101,101,107,  0,117,112,120, 95,109,109, 97,112,
/* 0x15d0 */  95, 97,110,100, 95,102,100, 95, 97,110,100,114,111,105,100,  0,
/* 0x15e0 */ 109,109, 97,112,  0,117,112,120, 95,109,109, 97,112, 95, 97,110,
/* 0x15f0 */ 100, 95,102,100, 95,108,105,110,117,120,  0,117,110, 97,109,101,
/* 0x1600 */   0,101,110,100, 95,100,101, 99,111,109,112,114,101,115,115,  0,
/* 0x1610 */ 119,114,105,116,101,  0,102,100, 97,116, 97,115,121,110, 99,  0,
/* 0x1620 */ 103,101,116, 95,117,112,120,102,110, 95,112, 97,116,104,  0,109,
/* 0x1630 */ 101,109,102,100, 95, 99,114,101, 97,116,101,  0, 95,115,116, 97,
/* 0x1640 */ 114,116,  0,114,101, 97,100,  0,117,110,108,105,110,107,  0,109,
/* 0x1650 */ 101,109,115,101,116,  0,117, 99,108, 95,110,114,118, 50, 98, 95,
/* 0x1660 */ 100,101, 99,111,109,112,114,101,115,115, 95, 56,  0,109,121, 95,
/* 0x1670 */  98,107,112,116,  0,102,115,121,110, 99,  0,115,116, 97,116,  0,
/* 0x1680 */  99,112,114, 48,  0,101,120,105,116,  0,111,112,101,110,  0,109,
/* 0x1690 */ 107,100,105,114,  0, 99,108,111,115,101,  0,  0,  0,  0,  0,  0,
/* 0x16a0 */   0,  0,  2,  1,  0,  0,  0, 56,  0,  0,  1,  1,  0,  0,  0,  4,
/* 0x16b0 */   0,  0,  2,  1,  0,  0,  0,  8,  0,  0,  2,  1,  0,  0,  0, 20,
/* 0x16c0 */   0,  0,  2,  1,  0,  0,  0, 28,  0,  0,  2,  1,  0,  0,  0, 48,
/* 0x16d0 */   0,  0,  3,  1,  0,  0,  0,104,  0,  0,  2,  1,  0,  0,  0,120,
/* 0x16e0 */   0,  0, 13,  1,  0,  0,  0,128,  0,  0,  2,  1,  0,  0,  0,176,
/* 0x16f0 */   0,  0,  2,  1,  0,  0,  0,240,  0,  0,  2,  1,  0,  0,  2, 12,
/* 0x1700 */   0,  0,  2,  1,  0,  0,  2, 56,  0,  0,  2,  1,  0,  0,  3,220,
/* 0x1710 */   0,  0,  2,  1,  0,  0,  3,244,  0,  0,  2,  1,  0,  0,  4, 28,
/* 0x1720 */   0,  0,  2,  1,  0,  0,  4, 32,  0,  0,  2,  1,  0,  0,  4, 44,
/* 0x1730 */   0,  0,  2,  1,  0,  0,  4,160,  0,  0,  2,  1,  0,  0,  4,164,
/* 0x1740 */   0,  0,  2,  1,  0,  0,  4,192,  0,  0,  2,  1,  0,  0,  4,216,
/* 0x1750 */   0,  0,  2,  1,  0,  0,  5, 16,  0,  0,  2,  1,  0,  0,  5, 24,
/* 0x1760 */   0,  0,  2,  1,  0,  0,  5, 28,  0,  0,  2,  1,  0,  0,  5, 44,
/* 0x1770 */   0,  0,  2,  1,  0,  0,  5, 48,  0,  0,  2,  1,  0,  0,  5, 52,
/* 0x1780 */   0,  0,  2,  1,  0,  0,  5, 64,  0,  0,  2,  1,  0,  0,  5, 80,
/* 0x1790 */   0,  0,  2,  1,  0,  0,  5, 84,  0,  0,  2,  1,  0,  0,  5, 92,
/* 0x17a0 */   0,  0,  2,  1,  0,  0,  5,100,  0,  0,  2,  1,  0,  0,  5,104,
/* 0x17b0 */   0,  0,  2,  1,  0,  0,  5,132,  0,  0,  2,  1,  0,  0,  5,136,
/* 0x17c0 */   0,  0,  2,  1,  0,  0,  0, 12,  0,  0,  3,  1,  0,  0,  0, 32,
/* 0x17d0 */   0,  0,  3,  1,  0,  0,  0, 48,  0,  0,  3,  1,  0,  0,  0, 64,
/* 0x17e0 */   0,  0,  3,  1,  0,  0,  0, 80,  0,  0,  3,  1,  0,  0,  0, 96,
/* 0x17f0 */   0,  0,  3,  1,  0,  0,  2, 20,  0,  0, 15,  2,  0,  0,  0,  0,
/* 0x1800 */   0,  0, 20,  1,  0,  0,  0,  0,  0,  0, 22,  1,  0,  0,  0, 12,
/* 0x1810 */   0,  0,  4,  1,  0,  0,  0, 40,  0,  0,  4,  1,  0,  0,  0, 64,
/* 0x1820 */   0,  0,  4,  1,  0,  0,  0, 84,  0,  0,  4,  1,  0,  0,  0,128,
/* 0x1830 */   0,  0, 32,  1,  0,  0,  0,140,  0,  0, 36,  1,  0,  0,  0,148,
/* 0x1840 */   0,  0,  4,  1,  0,  0,  0,168,  0,  0,  4,  1,  0,  0,  0,176,
/* 0x1850 */   0,  0,  4,  1,  0,  0,  0,188,  0,  0, 40,  1,  0,  0,  0,216,
/* 0x1860 */   0,  0, 34,  1,  0,  0,  0,244,  0,  0,  4,  1,  0,  0,  1, 12,
/* 0x1870 */   0,  0, 17,  1,  0,  0,  1, 32,  0,  0,  4,  1,  0,  0,  1, 36,
/* 0x1880 */   0,  0,  4,  1,  0,  0,  1, 76,  0,  0, 39,  1,  0,  0,  1, 96,
/* 0x1890 */   0,  0, 30,  1,  0,  0,  1,108,  0,  0, 41,  1,  0,  0,  1,120,
/* 0x18a0 */   0,  0, 34,  1,  0,  0,  1,144,  0,  0,  4,  1,  0,  0,  1,160,
/* 0x18b0 */   0,  0,  4,  1,  0,  0,  1,164,  0,  0,  4,  1,  0,  0,  1,176,
/* 0x18c0 */   0,  0,  4,  1,  0,  0,  1,196,  0,  0, 17,  1,  0,  0,  1,220,
/* 0x18d0 */   0,  0,  4,  1,  0,  0,  1,228,  0,  0,  4,  1,  0,  0,  1,232,
/* 0x18e0 */   0,  0,  4,  1,  0,  0,  2, 12,  0,  0, 17,  1,  0,  0,  2, 24,
/* 0x18f0 */   0,  0, 17,  1,  0,  0,  2, 44,  0,  0,  4,  1,  0,  0,  2, 48,
/* 0x1900 */   0,  0,  4,  1,  0,  0,  2, 56,  0,  0,  4,  1,  0,  0,  2, 60,
/* 0x1910 */   0,  0,  4,  1,  0,  0,  2, 84,  0,  0, 17,  1,  0,  0,  2,108,
/* 0x1920 */   0,  0,  4,  1,  0,  0,  2,112,  0,  0,  4,  1,  0,  0,  2,136,
/* 0x1930 */   0,  0, 17,  1,  0,  0,  2,144,  0,  0, 12,  1,  0,  0,  2,152,
/* 0x1940 */   0,  0,  4,  1,  0,  0,  2,164,  0,  0,  4,  1,  0,  0,  2,176,
/* 0x1950 */   0,  0,  4,  1,  0,  0,  2,220,  0,  0,  4,  1,  0,  0,  2,240,
/* 0x1960 */   0,  0, 28,  1,  0,  0,  2,252,  0,  0,  4,  1,  0,  0,  3,  8,
/* 0x1970 */   0,  0, 28,  1,  0,  0,  3, 20,  0,  0,  4,  1,  0,  0,  3, 24,
/* 0x1980 */   0,  0,  4,  1,  0,  0,  3, 60,  0,  0, 39,  1,  0,  0,  3, 68,
/* 0x1990 */   0,  0,  4,  1,  0,  0,  3, 72,  0,  0,  4,  1,  0,  0,  3, 96,
/* 0x19a0 */   0,  0, 34,  1,  0,  0,  3,108,  0,  0, 23,  1,  0,  0,  3,112,
/* 0x19b0 */   0,  0,  4,  1,  0,  0,  3,132,  0,  0,  4,  1,  0,  0,  3,140,
/* 0x19c0 */   0,  0,  4,  1,  0,  0,  3,144,  0,  0,  4,  1,  0,  0,  3,164,
/* 0x19d0 */   0,  0,  4,  1,  0,  0,  3,172,  0,  0,  4,  1,  0,  0,  3,188,
/* 0x19e0 */   0,  0,  4,  1,  0,  0,  3,196,  0,  0,  4,  1,  0,  0,  3,200,
/* 0x19f0 */   0,  0, 27,  1,  0,  0,  3,232,  0,  0,  4,  1,  0,  0,  3,240,
/* 0x1a00 */   0,  0,  4,  1,  0,  0,  3,252,  0,  0,  4,  1,  0,  0,  4, 12,
/* 0x1a10 */   0,  0,  4,  1,  0,  0,  4, 20,  0,  0,  4,  1,  0,  0,  4, 36,
/* 0x1a20 */   0,  0, 39,  1,  0,  0,  4, 48,  0,  0,  4,  1,  0,  0,  4, 56,
/* 0x1a30 */   0,  0, 31,  1,  0,  0,  4, 64,  0,  0,  4,  1,  0,  0,  4, 76,
/* 0x1a40 */   0,  0,  4,  1,  0,  0,  4, 80,  0,  0, 10,  1,  0,  0,  4,104,
/* 0x1a50 */   0,  0,  4,  1,  0,  0,  4,112,  0,  0,  4,  1,  0,  0,  4,124,
/* 0x1a60 */   0,  0, 18,  1,  0,  0,  4,132,  0,  0,  4,  1,  0,  0,  4,136,
/* 0x1a70 */   0,  0,  4,  1,  0,  0,  4,152,  0,  0, 19,  1,  0,  0,  4,188,
/* 0x1a80 */   0,  0, 25,  1,  0,  0,  4,204,  0,  0, 19,  1,  0,  0,  4,216,
/* 0x1a90 */   0,  0,  4,  1,  0,  0,  4,220,  0,  0, 10,  1,  0,  0,  4,232,
/* 0x1aa0 */   0,  0,  4,  1,  0,  0,  4,248,  0,  0, 25,  1,  0,  0,  4,252,
/* 0x1ab0 */   0,  0,  4,  1,  0,  0,  5, 28,  0,  0, 21,  1,  0,  0,  5, 44,
/* 0x1ac0 */   0,  0,  4,  1,  0,  0,  5, 52,  0,  0,  4,  1,  0,  0,  0, 16,
/* 0x1ad0 */   0,  0,  5,  1,  0,  0,  0, 36,  0,  0, 28,  1,  0,  0,  0, 48,
/* 0x1ae0 */   0,  0,  5,  1,  0,  0,  0, 60,  0,  0, 28,  1,  0,  0,  0, 72,
/* 0x1af0 */   0,  0,  5,  1,  0,  0,  0, 76,  0,  0,  5,  1,  0,  0,  0,112,
/* 0x1b00 */   0,  0, 39,  1,  0,  0,  0,120,  0,  0,  5,  1,  0,  0,  0,132,
/* 0x1b10 */   0,  0,  5,  1,  0,  0,  0,136,  0,  0,  5,  1,  0,  0,  0,216,
/* 0x1b20 */   0,  0, 25,  1,  0,  0,  0,224,  0,  0, 38,  1,  0,  0,  0,236,
/* 0x1b30 */   0,  0, 18,  1,  0,  0,  0,248,  0,  0,  5,  1,  0,  0,  1, 32,
/* 0x1b40 */   0,  0, 21,  1,  0,  0,  1, 40,  0,  0, 10,  1,  0,  0,  0,  0,
/* 0x1b50 */   0,  0, 11,  2,  0,  0,  0, 20,  0,  0,  6,  1,102,105,108,101,
/* 0x1b60 */  32,102,111,114,109, 97,116, 32,101,108,102, 51, 50, 45, 98,105,
/* 0x1b70 */ 103, 97,114,109, 10, 10, 83,101, 99,116,105,111,110,115, 58, 10,
/* 0x1b80 */  73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1b90 */  32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32,
/* 0x1ba0 */  32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32,
/* 0x1bb0 */  70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,110, 32, 32,
/* 0x1bc0 */  70,108, 97,103,115, 10, 32, 32, 48, 32, 69, 76, 70, 83, 73, 71,
/* 0x1bd0 */  83, 69, 71, 86, 32, 32, 32, 32, 48, 53, 99, 32, 32, 48, 32, 32,
/* 0x1be0 */  48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1bf0 */  78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32, 69, 76, 70, 77, 65,
/* 0x1c00 */  73, 78, 88, 50, 32, 32, 32, 32, 32, 48, 53, 57, 56, 32, 32, 48,
/* 0x1c10 */  32, 32, 48, 32, 32, 48, 57, 48, 32, 32, 50, 42, 42, 50, 32, 32,
/* 0x1c20 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 69, 76, 70,
/* 0x1c30 */  77, 65, 73, 78, 89, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32,
/* 0x1c40 */  32, 48, 32, 32, 48, 54, 50, 56, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1c50 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32, 69, 76, 70,
/* 0x1c60 */  77, 65, 73, 78, 90, 32, 32, 32, 32, 32, 32, 48, 50, 49, 56, 32,
/* 0x1c70 */  32, 48, 32, 32, 48, 32, 32, 48, 54, 50, 56, 32, 32, 50, 42, 42,
/* 0x1c80 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32,
/* 0x1c90 */  72, 85, 77, 70, 95, 65, 32, 32, 32, 32, 32, 32, 32, 32, 48, 52,
/* 0x1ca0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 56, 52, 48, 32, 32, 50, 42,
/* 0x1cb0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53,
/* 0x1cc0 */  32, 72, 85, 77, 70, 95, 76, 32, 32, 32, 32, 32, 32, 32, 32, 48,
/* 0x1cd0 */  52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 56, 52, 52, 32, 32, 50,
/* 0x1ce0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32,
/* 0x1cf0 */  54, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 32, 32, 32,
/* 0x1d00 */  48, 53, 52, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 56, 52, 56,
/* 0x1d10 */  32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1d20 */  10, 32, 32, 55, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 32,
/* 0x1d30 */  32, 32, 32, 48, 49, 52, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x1d40 */ 100, 56, 99, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69,
/* 0x1d50 */  78, 84, 83, 10, 32, 32, 56, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x1d60 */  32, 32, 32, 32, 32, 32, 48, 50, 56, 32, 32, 48, 32, 32, 48, 32,
/* 0x1d70 */  32, 48,101,100, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1d80 */  84, 69, 78, 84, 83, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66,
/* 0x1d90 */  76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x1da0 */  32, 32,100, 32, 32, 69, 76, 70, 83, 73, 71, 83, 69, 71, 86, 32,
/* 0x1db0 */  48, 32, 69, 76, 70, 83, 73, 71, 83, 69, 71, 86, 10, 48, 48, 48,
/* 0x1dc0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76,
/* 0x1dd0 */  70, 77, 65, 73, 78, 88, 50, 32, 48, 32, 69, 76, 70, 77, 65, 73,
/* 0x1de0 */  78, 88, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x1df0 */  32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,
/* 0x1e00 */  69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e10 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x1e20 */  68, 82, 79, 73, 68, 32, 48, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x1e30 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x1e40 */  32, 32,100, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 48,
/* 0x1e50 */  32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48,
/* 0x1e60 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77,
/* 0x1e70 */  65, 73, 78, 88, 32, 48, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10,
/* 0x1e80 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x1e90 */  32, 69, 76, 70, 77, 65, 73, 78, 89, 32, 48, 32, 69, 76, 70, 77,
/* 0x1ea0 */  65, 73, 78, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x1eb0 */  32, 32, 32,100, 32, 32, 72, 85, 77, 70, 95, 65, 32, 48, 32, 72,
/* 0x1ec0 */  85, 77, 70, 95, 65, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1ed0 */  32, 32, 32, 32,100, 32, 32, 72, 85, 77, 70, 95, 76, 32, 48, 32,
/* 0x1ee0 */  72, 85, 77, 70, 95, 76, 10, 48, 48, 48, 48, 48, 53, 56, 99, 32,
/* 0x1ef0 */ 103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x1f00 */  50, 32, 48, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,
/* 0x1f10 */ 107, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x1f20 */  32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32, 77, 70, 76, 71, 10,
/* 0x1f30 */  48, 48, 48, 48, 48, 48,101, 99, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x1f40 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,103,101,116,112,
/* 0x1f50 */ 105,100, 10, 48, 48, 48, 48, 48, 53, 57, 56, 32,103, 32, 32, 32,
/* 0x1f60 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 32, 48, 32,
/* 0x1f70 */ 117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100, 10,
/* 0x1f80 */  48, 48, 48, 48, 48, 48, 48, 56, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x1f90 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,101,109, 99,
/* 0x1fa0 */ 112,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x1fb0 */  32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32, 79, 95, 66, 73,
/* 0x1fc0 */  78, 70, 79, 10, 48, 48, 48, 48, 48, 49, 97, 48, 32,103, 32, 32,
/* 0x1fd0 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,
/* 0x1fe0 */  80,115,121,110, 99, 10, 48, 48, 48, 48, 48, 48, 52, 99, 32,103,
/* 0x1ff0 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32,
/* 0x2000 */  48, 32,109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 48,
/* 0x2010 */ 100, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x2020 */  73, 78, 90, 32, 48, 32,102,116,114,117,110, 99, 97,116,101, 10,
/* 0x2030 */  48, 48, 48, 48, 48, 49, 48, 48, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x2040 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,108,115,101,101,
/* 0x2050 */ 107, 10, 48, 48, 48, 48, 48, 50, 99, 52, 32,103, 32, 32, 32, 32,
/* 0x2060 */  32, 70, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 32, 48,
/* 0x2070 */  50, 56, 48, 32,117,112,120, 95,109,109, 97,112, 95, 97,110,100,
/* 0x2080 */  95,102,100, 95, 97,110,100,114,111,105,100, 10, 48, 48, 48, 48,
/* 0x2090 */  48, 49,100, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x20a0 */  77, 65, 73, 78, 90, 32, 48, 32,109,109, 97,112, 10, 48, 48, 48,
/* 0x20b0 */  48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 85, 77,
/* 0x20c0 */  70, 95, 76, 73, 78, 85, 88, 32, 48, 49, 52, 52, 32,117,112,120,
/* 0x20d0 */  95,109,109, 97,112, 95, 97,110,100, 95,102,100, 95,108,105,110,
/* 0x20e0 */ 117,120, 10, 48, 48, 48, 48, 48, 49, 54, 52, 32,103, 32, 32, 32,
/* 0x20f0 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,117,
/* 0x2100 */ 110, 97,109,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32,
/* 0x2110 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 89, 32, 48,
/* 0x2120 */  32,101,110,100, 95,100,101, 99,111,109,112,114,101,115,115, 10,
/* 0x2130 */  48, 48, 48, 48, 48, 49, 56, 99, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x2140 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,119,114,105,116,
/* 0x2150 */ 101, 10, 48, 48, 48, 48, 48, 48, 98, 48, 32,103, 32, 32, 32, 32,
/* 0x2160 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,102,100,
/* 0x2170 */  97,116, 97,115,121,110, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2180 */  32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x2190 */  90, 32, 48, 32,103,101,116, 95,117,112,120,102,110, 95,112, 97,
/* 0x21a0 */ 116,104, 10, 48, 48, 48, 48, 48, 48, 54, 56, 32,103, 32, 32, 32,
/* 0x21b0 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,
/* 0x21c0 */ 101,109,102,100, 95, 99,114,101, 97,116,101, 10, 48, 48, 48, 48,
/* 0x21d0 */  48, 48, 48, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x21e0 */  77, 65, 73, 78, 88, 32, 48, 32, 95,115,116, 97,114,116, 10, 48,
/* 0x21f0 */  48, 48, 48, 48, 49, 51, 99, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x2200 */  69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,114,101, 97,100, 10,
/* 0x2210 */  48, 48, 48, 48, 48, 49, 55, 56, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x2220 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,117,110,108,105,
/* 0x2230 */ 110,107, 10, 48, 48, 48, 48, 48, 48, 50, 99, 32,103, 32, 32, 32,
/* 0x2240 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,
/* 0x2250 */ 101,109,115,101,116, 10, 48, 48, 48, 48, 48, 52, 99, 56, 32,103,
/* 0x2260 */  32, 32, 32, 32, 32, 70, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50,
/* 0x2270 */  32, 48, 99, 52, 32,117, 99,108, 95,110,114,118, 50, 98, 95,100,
/* 0x2280 */ 101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48, 48,
/* 0x2290 */  48, 49, 99, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x22a0 */  77, 65, 73, 78, 90, 32, 48, 32,109,121, 95, 98,107,112,116, 10,
/* 0x22b0 */  48, 48, 48, 48, 48, 48, 99, 52, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x22c0 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,102,115,121,110,
/* 0x22d0 */  99, 10, 48, 48, 48, 48, 48, 49, 53, 48, 32,103, 32, 32, 32, 32,
/* 0x22e0 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,115,116,
/* 0x22f0 */  97,116, 10, 48, 48, 48, 48, 48, 50, 49, 56, 32,103, 32, 32, 32,
/* 0x2300 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 99,
/* 0x2310 */ 112,114, 48, 10, 48, 48, 48, 48, 48, 48, 57, 99, 32,103, 32, 32,
/* 0x2320 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,
/* 0x2330 */ 101,120,105,116, 10, 48, 48, 48, 48, 48, 49, 50, 56, 32,103, 32,
/* 0x2340 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48,
/* 0x2350 */  32,111,112,101,110, 10, 48, 48, 48, 48, 48, 49, 49, 52, 32,103,
/* 0x2360 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32,
/* 0x2370 */  48, 32,109,107,100,105,114, 10, 48, 48, 48, 48, 48, 48, 56, 56,
/* 0x2380 */  32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x2390 */  90, 32, 48, 32, 99,108,111,115,101, 10, 10, 82, 69, 76, 79, 67,
/* 0x23a0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x23b0 */  82, 32, 91, 69, 76, 70, 83, 73, 71, 83, 69, 71, 86, 93, 58, 10,
/* 0x23c0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x23d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x23e0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x23f0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x2400 */  65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 48, 51, 56, 32, 82,
/* 0x2410 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2420 */  32, 69, 76, 70, 83, 73, 71, 83, 69, 71, 86, 10, 10, 82, 69, 76,
/* 0x2430 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x2440 */  70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78, 88, 50, 93, 58,
/* 0x2450 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x2460 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x2470 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 65, 82, 77,
/* 0x2480 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x2490 */  77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32,
/* 0x24a0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x24b0 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48,
/* 0x24c0 */  48, 48, 49, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x24d0 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50,
/* 0x24e0 */  10, 48, 48, 48, 48, 48, 48, 49, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x24f0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x2500 */  65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82,
/* 0x2510 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2520 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48,
/* 0x2530 */  54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2540 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48,
/* 0x2550 */  48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2560 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,117,112,120, 95,109,109,
/* 0x2570 */  97,112, 95, 97,110,100, 95,102,100, 10, 48, 48, 48, 48, 48, 48,
/* 0x2580 */  56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2590 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48,
/* 0x25a0 */  48, 48, 48, 48, 48, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x25b0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x25c0 */  78, 88, 50, 10, 48, 48, 48, 48, 48, 48,102, 48, 32, 82, 95, 65,
/* 0x25d0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x25e0 */  76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 50, 48,
/* 0x25f0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2600 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48,
/* 0x2610 */  48, 48, 48, 50, 51, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2620 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x2630 */  88, 50, 10, 48, 48, 48, 48, 48, 51,100, 99, 32, 82, 95, 65, 82,
/* 0x2640 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x2650 */  70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 51,102, 52,
/* 0x2660 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2670 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48,
/* 0x2680 */  48, 48, 52, 49, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2690 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x26a0 */  50, 10, 48, 48, 48, 48, 48, 52, 50, 48, 32, 82, 95, 65, 82, 77,
/* 0x26b0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x26c0 */  77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 52, 50, 99, 32,
/* 0x26d0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x26e0 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48,
/* 0x26f0 */  48, 52, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2700 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50,
/* 0x2710 */  10, 48, 48, 48, 48, 48, 52, 97, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2720 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x2730 */  65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 52, 99, 48, 32, 82,
/* 0x2740 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2750 */  32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48,
/* 0x2760 */  52,100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2770 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10,
/* 0x2780 */  48, 48, 48, 48, 48, 53, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2790 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x27a0 */  73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 53, 49, 56, 32, 82, 95,
/* 0x27b0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x27c0 */  69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 53,
/* 0x27d0 */  49, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x27e0 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48,
/* 0x27f0 */  48, 48, 48, 48, 53, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2800 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x2810 */  78, 88, 50, 10, 48, 48, 48, 48, 48, 53, 51, 48, 32, 82, 95, 65,
/* 0x2820 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x2830 */  76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 53, 51,
/* 0x2840 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2850 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48,
/* 0x2860 */  48, 48, 48, 53, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2870 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x2880 */  88, 50, 10, 48, 48, 48, 48, 48, 53, 53, 48, 32, 82, 95, 65, 82,
/* 0x2890 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x28a0 */  70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 53, 53, 52,
/* 0x28b0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x28c0 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48,
/* 0x28d0 */  48, 48, 53, 53, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x28e0 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x28f0 */  50, 10, 48, 48, 48, 48, 48, 53, 54, 52, 32, 82, 95, 65, 82, 77,
/* 0x2900 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x2910 */  77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 53, 54, 56, 32,
/* 0x2920 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2930 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48,
/* 0x2940 */  48, 53, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2950 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50,
/* 0x2960 */  10, 48, 48, 48, 48, 48, 53, 56, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x2970 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x2980 */  65, 73, 78, 88, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x2990 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69,
/* 0x29a0 */  76, 70, 77, 65, 73, 78, 90, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x29b0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x29c0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x29d0 */  48, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x29e0 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48,
/* 0x29f0 */  48, 48, 48, 48, 48, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2a00 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x2a10 */  78, 90, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 65, 82,
/* 0x2a20 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x2a30 */  70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 52, 48, 32,
/* 0x2a40 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2a50 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48,
/* 0x2a60 */  48, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2a70 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48,
/* 0x2a80 */  48, 48, 48, 48, 48, 54, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2a90 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x2aa0 */  78, 90, 10, 48, 48, 48, 48, 48, 50, 49, 52, 32, 82, 95, 65, 82,
/* 0x2ab0 */  77, 95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32, 79, 95,
/* 0x2ac0 */  66, 73, 78, 70, 79, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x2ad0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 72,
/* 0x2ae0 */  85, 77, 70, 95, 65, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x2af0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2b00 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x2b10 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2b20 */  32, 32, 32, 32,117,112,120, 95,109,109, 97,112, 95, 97,110,100,
/* 0x2b30 */  95,102,100, 95, 97,110,100,114,111,105,100, 10, 10, 82, 69, 76,
/* 0x2b40 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x2b50 */  70, 79, 82, 32, 91, 72, 85, 77, 70, 95, 76, 93, 58, 10, 79, 70,
/* 0x2b60 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x2b70 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x2b80 */  48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2b90 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,117,112,120, 95,109,109,
/* 0x2ba0 */  97,112, 95, 97,110,100, 95,102,100, 95,108,105,110,117,120, 10,
/* 0x2bb0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x2bc0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 85, 77, 70, 95, 65, 78, 68,
/* 0x2bd0 */  82, 79, 73, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x2be0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2bf0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99,
/* 0x2c00 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2c10 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x2c20 */  48, 48, 48, 48, 48, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2c30 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x2c40 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48, 52, 48, 32, 82,
/* 0x2c50 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2c60 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x2c70 */  48, 48, 48, 53, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2c80 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x2c90 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65,
/* 0x2ca0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,
/* 0x2cb0 */ 101,109,115,101,116, 10, 48, 48, 48, 48, 48, 48, 56, 99, 32, 82,
/* 0x2cc0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2cd0 */  32,115,116, 97,116, 10, 48, 48, 48, 48, 48, 48, 57, 52, 32, 82,
/* 0x2ce0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2cf0 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x2d00 */  48, 48, 48, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2d10 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x2d20 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 48, 98, 48, 32, 82, 95, 65,
/* 0x2d30 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x2d40 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48,
/* 0x2d50 */  48, 98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2d60 */  32, 32, 32, 32, 32, 32,109,107,100,105,114, 10, 48, 48, 48, 48,
/* 0x2d70 */  48, 48,100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2d80 */  32, 32, 32, 32, 32, 32, 32,109,121, 95, 98,107,112,116, 10, 48,
/* 0x2d90 */  48, 48, 48, 48, 48,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2da0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x2db0 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 48, 99, 32, 82,
/* 0x2dc0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2dd0 */  32,109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 49, 50,
/* 0x2de0 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2df0 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x2e00 */  48, 48, 48, 48, 48, 49, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2e10 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x2e20 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 52, 99, 32,
/* 0x2e30 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2e40 */  32, 32,111,112,101,110, 10, 48, 48, 48, 48, 48, 49, 54, 48, 32,
/* 0x2e50 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2e60 */  32, 32,114,101, 97,100, 10, 48, 48, 48, 48, 48, 49, 54, 99, 32,
/* 0x2e70 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2e80 */  32, 32, 99,108,111,115,101, 10, 48, 48, 48, 48, 48, 49, 55, 56,
/* 0x2e90 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2ea0 */  32, 32, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48,
/* 0x2eb0 */  49, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2ec0 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x2ed0 */  68, 10, 48, 48, 48, 48, 48, 49, 97, 48, 32, 82, 95, 65, 82, 77,
/* 0x2ee0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x2ef0 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 97,
/* 0x2f00 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2f10 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x2f20 */  48, 48, 48, 48, 48, 49, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2f30 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x2f40 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 99, 52, 32,
/* 0x2f50 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2f60 */  32, 32,109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 49,
/* 0x2f70 */ 100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2f80 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x2f90 */  10, 48, 48, 48, 48, 48, 49,101, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2fa0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x2fb0 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49,101, 56,
/* 0x2fc0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2fd0 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x2fe0 */  48, 48, 48, 48, 50, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2ff0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112, 99,112,
/* 0x3000 */ 121, 10, 48, 48, 48, 48, 48, 50, 49, 56, 32, 82, 95, 65, 82, 77,
/* 0x3010 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,
/* 0x3020 */ 112, 99,112,121, 10, 48, 48, 48, 48, 48, 50, 50, 99, 32, 82, 95,
/* 0x3030 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3040 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x3050 */  48, 50, 51, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3060 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x3070 */  73, 68, 10, 48, 48, 48, 48, 48, 50, 51, 56, 32, 82, 95, 65, 82,
/* 0x3080 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x3090 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50,
/* 0x30a0 */  51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x30b0 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x30c0 */  10, 48, 48, 48, 48, 48, 50, 53, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x30d0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112,
/* 0x30e0 */  99,112,121, 10, 48, 48, 48, 48, 48, 50, 54, 99, 32, 82, 95, 65,
/* 0x30f0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x3100 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48,
/* 0x3110 */  50, 55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3120 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x3130 */  68, 10, 48, 48, 48, 48, 48, 50, 56, 56, 32, 82, 95, 65, 82, 77,
/* 0x3140 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,
/* 0x3150 */ 112, 99,112,121, 10, 48, 48, 48, 48, 48, 50, 57, 48, 32, 82, 95,
/* 0x3160 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3170 */ 103,101,116,112,105,100, 10, 48, 48, 48, 48, 48, 50, 57, 56, 32,
/* 0x3180 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3190 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x31a0 */  48, 48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x31b0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x31c0 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 98, 48, 32, 82, 95,
/* 0x31d0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x31e0 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x31f0 */  48, 50,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3200 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x3210 */  73, 68, 10, 48, 48, 48, 48, 48, 50,102, 48, 32, 82, 95, 65, 82,
/* 0x3220 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,
/* 0x3230 */ 109,102,100, 95, 99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48,
/* 0x3240 */  50,102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3250 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x3260 */  68, 10, 48, 48, 48, 48, 48, 51, 48, 56, 32, 82, 95, 65, 82, 77,
/* 0x3270 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,
/* 0x3280 */ 102,100, 95, 99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 51,
/* 0x3290 */  49, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x32a0 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x32b0 */  10, 48, 48, 48, 48, 48, 51, 49, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x32c0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x32d0 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 51, 99,
/* 0x32e0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x32f0 */  32, 32, 32,111,112,101,110, 10, 48, 48, 48, 48, 48, 51, 52, 52,
/* 0x3300 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3310 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x3320 */  48, 48, 48, 48, 51, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3330 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x3340 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 54, 48, 32, 82,
/* 0x3350 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3360 */  32,109,121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 51, 54,
/* 0x3370 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3380 */  32, 32, 32, 32,117,110, 97,109,101, 10, 48, 48, 48, 48, 48, 51,
/* 0x3390 */  55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x33a0 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x33b0 */  10, 48, 48, 48, 48, 48, 51, 56, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x33c0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x33d0 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 56, 99,
/* 0x33e0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x33f0 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x3400 */  48, 48, 48, 48, 51, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3410 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x3420 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 97, 52, 32, 82,
/* 0x3430 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3440 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x3450 */  48, 48, 51, 97, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3460 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x3470 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 98, 99, 32, 82, 95, 65,
/* 0x3480 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x3490 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48,
/* 0x34a0 */  51, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x34b0 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x34c0 */  68, 10, 48, 48, 48, 48, 48, 51, 99, 56, 32, 82, 95, 65, 82, 77,
/* 0x34d0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,103,101,116,
/* 0x34e0 */  95,117,112,120,102,110, 95,112, 97,116,104, 10, 48, 48, 48, 48,
/* 0x34f0 */  48, 51,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3500 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x3510 */  73, 68, 10, 48, 48, 48, 48, 48, 51,102, 48, 32, 82, 95, 65, 82,
/* 0x3520 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x3530 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51,
/* 0x3540 */ 102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3550 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x3560 */  10, 48, 48, 48, 48, 48, 52, 48, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x3570 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x3580 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 49, 52,
/* 0x3590 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x35a0 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x35b0 */  48, 48, 48, 48, 52, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x35c0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,111,112,101,110, 10, 48,
/* 0x35d0 */  48, 48, 48, 48, 52, 51, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x35e0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x35f0 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 51, 56, 32, 82,
/* 0x3600 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3610 */  32,117,110,108,105,110,107, 10, 48, 48, 48, 48, 48, 52, 52, 48,
/* 0x3620 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3630 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x3640 */  48, 48, 48, 48, 52, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3650 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x3660 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 53, 48, 32, 82,
/* 0x3670 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3680 */  32,103,101,116, 95,112, 97,103,101, 95,109, 97,115,107, 10, 48,
/* 0x3690 */  48, 48, 48, 48, 52, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x36a0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x36b0 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 55, 48, 32, 82,
/* 0x36c0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x36d0 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x36e0 */  48, 48, 52, 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x36f0 */  32, 32, 32, 32, 32, 32, 32, 32,102,116,114,117,110, 99, 97,116,
/* 0x3700 */ 101, 10, 48, 48, 48, 48, 48, 52, 56, 52, 32, 82, 95, 65, 82, 77,
/* 0x3710 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x3720 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 56,
/* 0x3730 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3740 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x3750 */  48, 48, 48, 48, 48, 52, 57, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3760 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,108,115,101,101,107,
/* 0x3770 */  10, 48, 48, 48, 48, 48, 52, 98, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x3780 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,119,114,105,116,
/* 0x3790 */ 101, 10, 48, 48, 48, 48, 48, 52, 99, 99, 32, 82, 95, 65, 82, 77,
/* 0x37a0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,108,115,101,
/* 0x37b0 */ 101,107, 10, 48, 48, 48, 48, 48, 52,100, 56, 32, 82, 95, 65, 82,
/* 0x37c0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x37d0 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52,
/* 0x37e0 */ 100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x37f0 */  32, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109, 97,
/* 0x3800 */ 115,107, 10, 48, 48, 48, 48, 48, 52,101, 56, 32, 82, 95, 65, 82,
/* 0x3810 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x3820 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52,
/* 0x3830 */ 102, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3840 */  32, 32, 32, 32, 32,119,114,105,116,101, 10, 48, 48, 48, 48, 48,
/* 0x3850 */  52,102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3860 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x3870 */  68, 10, 48, 48, 48, 48, 48, 53, 49, 99, 32, 82, 95, 65, 82, 77,
/* 0x3880 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,109, 97,
/* 0x3890 */ 112, 10, 48, 48, 48, 48, 48, 53, 50, 99, 32, 82, 95, 65, 82, 77,
/* 0x38a0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x38b0 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 53, 51,
/* 0x38c0 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x38d0 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x38e0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x38f0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 85, 77, 70, 95, 76, 73, 78,
/* 0x3900 */  85, 88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x3910 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3920 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82,
/* 0x3930 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3940 */  32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48,
/* 0x3950 */  48, 50, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3960 */  32, 32, 32, 32, 32, 32,109,101,109,102,100, 95, 99,114,101, 97,
/* 0x3970 */ 116,101, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 65, 82,
/* 0x3980 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x3990 */  70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 51, 99,
/* 0x39a0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x39b0 */  32, 32, 32,109,101,109,102,100, 95, 99,114,101, 97,116,101, 10,
/* 0x39c0 */  48, 48, 48, 48, 48, 48, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x39d0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 76,
/* 0x39e0 */  73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 52, 99, 32, 82, 95,
/* 0x39f0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3a00 */  85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48,
/* 0x3a10 */  55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3a20 */  32, 32, 32, 32, 32,111,112,101,110, 10, 48, 48, 48, 48, 48, 48,
/* 0x3a30 */  55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3a40 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48,
/* 0x3a50 */  48, 48, 48, 48, 48, 56, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3a60 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73,
/* 0x3a70 */  78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 56, 56, 32, 82, 95, 65,
/* 0x3a80 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x3a90 */  77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48,100,
/* 0x3aa0 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3ab0 */  32, 32, 32, 32,119,114,105,116,101, 10, 48, 48, 48, 48, 48, 48,
/* 0x3ac0 */ 101, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3ad0 */  32, 32, 32, 32, 32,101,120,105,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x3ae0 */ 101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3af0 */  32, 32, 32, 32, 32,102,116,114,117,110, 99, 97,116,101, 10, 48,
/* 0x3b00 */  48, 48, 48, 48, 48,102, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3b10 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73,
/* 0x3b20 */  78, 85, 88, 10, 48, 48, 48, 48, 48, 49, 50, 48, 32, 82, 95, 65,
/* 0x3b30 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,
/* 0x3b40 */ 109, 97,112, 10, 48, 48, 48, 48, 48, 49, 50, 56, 32, 82, 95, 65,
/* 0x3b50 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,103,
/* 0x3b60 */ 101,116, 95,112, 97,103,101, 95,109, 97,115,107, 10, 10, 82, 69,
/* 0x3b70 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x3b80 */  32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78, 88, 93, 58,
/* 0x3b90 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x3ba0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x3bb0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 65, 82, 77,
/* 0x3bc0 */  95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32, 77, 70, 76,
/* 0x3bd0 */  71, 10, 48, 48, 48, 48, 48, 48, 49, 52, 32, 82, 95, 65, 82, 77,
/* 0x3be0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x3bf0 */  77, 65, 73, 78, 88, 10
};
