/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SWT_AWT {
    public static String embeddedFrameClass;
    static String EMBEDDED_FRAME_KEY;
    static boolean loaded;
    static boolean swingInitialized;

    static final native long getAWTHandle(Object var0);

    static final native void setDebug(Frame var0, boolean var1);

    static final native Object initFrame(long var0, String var2);

    static final native void validateWithBounds(Frame var0, int var1, int var2, int var3, int var4);

    static final native void synthesizeWindowActivation(Frame var0, boolean var1);

    static final native void registerListeners(Frame var0);

    static synchronized void loadLibrary() {
        if (loaded) {
            return;
        }
        loaded = true;
        try {
            System.loadLibrary("jawt");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Library.loadLibrary("swt-awt");
    }

    static synchronized void initializeSwing() {
        if (swingInitialized) {
            return;
        }
        swingInitialized = true;
        if (OS.isX11()) {
            GDK.gdk_x11_display_error_trap_push(GDK.gdk_display_get_default());
        }
        try {
            Class<?> clazz = Class.forName("javax.swing.UIManager");
            Method method = clazz.getMethod("getDefaults", new Class[0]);
            if (method != null) {
                method.invoke(clazz, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Frame getFrame(Composite parent) {
        if (parent == null) {
            SWT.error(4);
        }
        if ((parent.getStyle() & 0x1000000) == 0) {
            return null;
        }
        return (Frame)parent.getData(EMBEDDED_FRAME_KEY);
    }

    public static Frame new_Frame(Composite parent) {
        if (OS.IsWin32) {
            SWT.error(20);
        }
        if (parent == null) {
            SWT.error(4);
        }
        if ((parent.getStyle() & 0x1000000) == 0) {
            SWT.error(5);
        }
        long handle = parent.embeddedHandle;
        String className = embeddedFrameClass != null ? embeddedFrameClass : "sun.awt.X11.XEmbeddedFrame";
        try {
            if (embeddedFrameClass != null) {
                Class.forName(className);
            }
            SWT_AWT.loadLibrary();
        }
        catch (ClassNotFoundException cne) {
            SWT.error(20, cne);
        }
        catch (Throwable e2) {
            SWT.error(1, e2, " [Error while starting AWT]");
        }
        SWT_AWT.initializeSwing();
        Frame[] frame = new Frame[1];
        Object object = SWT_AWT.initFrame(handle, className);
        if (object == null || !(object instanceof Frame)) {
            SWT.error(1, new Throwable(), " [Error while starting AWT]");
        }
        frame[0] = (Frame)object;
        parent.setData(EMBEDDED_FRAME_KEY, frame[0]);
        if (Device.DEBUG) {
            SWT_AWT.setDebug(frame[0], true);
        }
        SWT_AWT.registerListeners(frame[0]);
        AWTEventListener awtListener = event -> {
            Window window;
            if (event.getID() == 200 && (window = (Window)event.getSource()).getParent() == frame[0]) {
                parent.getDisplay().asyncExec(() -> {
                    if (parent.isDisposed()) {
                        return;
                    }
                    Shell shell = parent.getShell();
                    long awtHandle = SWT_AWT.getAWTHandle(window);
                    if (awtHandle == 0L) {
                        return;
                    }
                    long xWindow = GDK.gdk_x11_window_get_xid(GTK.gtk_widget_get_window(GTK.gtk_widget_get_toplevel(shell.handle)));
                    OS.XSetTransientForHint(GDK.gdk_x11_display_get_xdisplay(GDK.gdk_display_get_default()), awtHandle, xWindow);
                });
            }
        };
        frame[0].getToolkit().addAWTEventListener(awtListener, 64L);
        Listener shellListener = e -> {
            switch (e.type) {
                case 20: {
                    EventQueue.invokeLater(() -> frame[0].dispatchEvent(new WindowEvent(frame[0], 204)));
                    break;
                }
                case 19: {
                    EventQueue.invokeLater(() -> frame[0].dispatchEvent(new WindowEvent(frame[0], 203)));
                }
            }
        };
        Shell shell = parent.getShell();
        shell.addListener(20, shellListener);
        shell.addListener(19, shellListener);
        Listener listener = e -> {
            switch (e.type) {
                case 12: {
                    Shell shell1 = parent.getShell();
                    shell1.removeListener(20, shellListener);
                    shell1.removeListener(19, shellListener);
                    parent.setVisible(false);
                    EventQueue.invokeLater(() -> {
                        frame[0].getToolkit().removeAWTEventListener(awtListener);
                        frame[0].dispose();
                    });
                    break;
                }
                case 11: {
                    Rectangle clientArea = DPIUtil.autoScaleUp(parent.getClientArea());
                    EventQueue.invokeLater(() -> frame[0].setSize(clientArea.width, clientArea.height));
                }
            }
        };
        parent.addListener(12, listener);
        parent.addListener(11, listener);
        parent.getDisplay().asyncExec(() -> {
            if (parent.isDisposed()) {
                return;
            }
            Rectangle clientArea = DPIUtil.autoScaleUp(parent.getClientArea());
            EventQueue.invokeLater(() -> {
                frame[0].setSize(clientArea.width, clientArea.height);
                frame[0].validate();
            });
        });
        return frame[0];
    }

    public static Shell new_Shell(final Display display, final Canvas parent) {
        if (OS.IsWin32) {
            SWT.error(20);
        }
        if (display == null) {
            SWT.error(4);
        }
        if (parent == null) {
            SWT.error(4);
        }
        long handle = 0L;
        try {
            SWT_AWT.loadLibrary();
            handle = SWT_AWT.getAWTHandle(parent);
        }
        catch (Throwable e) {
            SWT.error(20, e);
        }
        if (handle == 0L) {
            SWT.error(5, null, " [peer not created]");
        }
        final Shell shell = Shell.gtk_new(display, handle);
        ComponentAdapter listener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                display.syncExec(() -> {
                    if (shell.isDisposed()) {
                        return;
                    }
                    Dimension dim = parent.getSize();
                    shell.setSize(DPIUtil.autoScaleDown(new Point(dim.width, dim.height)));
                });
            }
        };
        parent.addComponentListener(listener);
        shell.addListener(12, event -> parent.removeComponentListener(listener));
        shell.setVisible(true);
        return shell;
    }

    static {
        EMBEDDED_FRAME_KEY = "org.eclipse.swt.awt.SWT_AWT.embeddedFrame";
    }
}

