/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.monitor.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.service.ReadyMarker;
import org.openhab.core.service.ReadyMarkerFilter;
import org.openhab.core.service.ReadyService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@NonNullByDefault
public class EventLogger
implements EventSubscriber,
ReadyService.ReadyTracker {
    private final Map<String, Logger> eventLoggers = new HashMap<String, Logger>();
    private final Set<String> subscribedEventTypes = Set.of("ALL");
    private final ReadyService readyService;
    private boolean loggingActive = false;

    @Activate
    public EventLogger(@Reference ReadyService readyService) {
        this.readyService = readyService;
        readyService.registerTracker((ReadyService.ReadyTracker)this, new ReadyMarkerFilter().withType("startlevel").withIdentifier(Integer.toString(40)));
    }

    @Deactivate
    protected void deactivate() {
        this.readyService.unregisterTracker((ReadyService.ReadyTracker)this);
    }

    public Set<String> getSubscribedEventTypes() {
        return this.subscribedEventTypes;
    }

    public void receive(Event event) {
        Logger logger = this.getLogger(event.getType());
        logger.trace("Received event of type '{}' under the topic '{}' with payload: '{}'", new Object[]{event.getType(), event.getTopic(), event.getPayload()});
        if (this.loggingActive) {
            logger.info("{}", (Object)event);
        }
    }

    private Logger getLogger(String eventType) {
        return Objects.requireNonNull(this.eventLoggers.computeIfAbsent(eventType, type -> LoggerFactory.getLogger((String)("openhab.event." + eventType))));
    }

    public void onReadyMarkerAdded(ReadyMarker readyMarker) {
        this.loggingActive = true;
    }

    public void onReadyMarkerRemoved(ReadyMarker readyMarker) {
        this.loggingActive = false;
    }
}

