/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus.internal;

import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.imageio.IIOException;
import net.wimpi.modbus.ModbusException;
import net.wimpi.modbus.io.ModbusTransaction;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.net.ModbusSlaveConnection;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.SwallowedExceptionListener;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.io.transport.modbus.AsyncModbusFailure;
import org.openhab.core.io.transport.modbus.AsyncModbusWriteResult;
import org.openhab.core.io.transport.modbus.ModbusCommunicationInterface;
import org.openhab.core.io.transport.modbus.ModbusFailureCallback;
import org.openhab.core.io.transport.modbus.ModbusManager;
import org.openhab.core.io.transport.modbus.ModbusReadCallback;
import org.openhab.core.io.transport.modbus.ModbusReadRequestBlueprint;
import org.openhab.core.io.transport.modbus.ModbusResponse;
import org.openhab.core.io.transport.modbus.ModbusResultCallback;
import org.openhab.core.io.transport.modbus.ModbusWriteCallback;
import org.openhab.core.io.transport.modbus.ModbusWriteRequestBlueprint;
import org.openhab.core.io.transport.modbus.PollTask;
import org.openhab.core.io.transport.modbus.TaskWithEndpoint;
import org.openhab.core.io.transport.modbus.WriteTask;
import org.openhab.core.io.transport.modbus.endpoint.EndpointPoolConfiguration;
import org.openhab.core.io.transport.modbus.endpoint.ModbusSerialSlaveEndpoint;
import org.openhab.core.io.transport.modbus.endpoint.ModbusSlaveEndpoint;
import org.openhab.core.io.transport.modbus.endpoint.ModbusSlaveEndpointVisitor;
import org.openhab.core.io.transport.modbus.endpoint.ModbusTCPSlaveEndpoint;
import org.openhab.core.io.transport.modbus.endpoint.ModbusUDPSlaveEndpoint;
import org.openhab.core.io.transport.modbus.exception.ModbusConnectionException;
import org.openhab.core.io.transport.modbus.exception.ModbusUnexpectedResponseFunctionCodeException;
import org.openhab.core.io.transport.modbus.exception.ModbusUnexpectedResponseSizeException;
import org.openhab.core.io.transport.modbus.exception.ModbusUnexpectedTransactionIdException;
import org.openhab.core.io.transport.modbus.internal.AggregateStopWatch;
import org.openhab.core.io.transport.modbus.internal.BasicPollTask;
import org.openhab.core.io.transport.modbus.internal.BasicWriteTask;
import org.openhab.core.io.transport.modbus.internal.ModbusConnectionPool;
import org.openhab.core.io.transport.modbus.internal.ModbusLibraryWrapper;
import org.openhab.core.io.transport.modbus.internal.ModbusResponseImpl;
import org.openhab.core.io.transport.modbus.internal.pooling.ModbusSlaveConnectionFactoryImpl;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ModbusManager.class}, configurationPid={"transport.modbus"})
@NonNullByDefault
public class ModbusManagerImpl
implements ModbusManager {
    private final Logger logger = LoggerFactory.getLogger(ModbusManagerImpl.class);
    private final Logger pollMonitorLogger = LoggerFactory.getLogger((String)(ModbusManagerImpl.class.getName() + ".PollMonitor"));
    public static final long DEFAULT_TCP_INTER_TRANSACTION_DELAY_MILLIS = 60L;
    public static final long DEFAULT_SERIAL_INTER_TRANSACTION_DELAY_MILLIS = 35L;
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 10000;
    private static final String MODBUS_POLLER_THREAD_POOL_NAME = "modbusManagerPollerThreadPool";
    private static final int MODBUS_EXCEPTION_SLAVE_DEVICE_BUSY = 6;
    private static final long WARN_QUEUE_SIZE = 500L;
    private static final long MONITOR_QUEUE_INTERVAL_MILLIS = 10000L;
    private static final Function<ModbusSlaveEndpoint, EndpointPoolConfiguration> DEFAULT_POOL_CONFIGURATION = endpoint -> endpoint.accept(new ModbusSlaveEndpointVisitor<EndpointPoolConfiguration>(){

        @Override
        public @NonNull EndpointPoolConfiguration visit(ModbusTCPSlaveEndpoint modbusIPSlavePoolingKey) {
            EndpointPoolConfiguration endpointPoolConfig = new EndpointPoolConfiguration();
            endpointPoolConfig.setInterTransactionDelayMillis(60L);
            endpointPoolConfig.setConnectMaxTries(3);
            endpointPoolConfig.setConnectTimeoutMillis(10000);
            return endpointPoolConfig;
        }

        @Override
        public @NonNull EndpointPoolConfiguration visit(ModbusSerialSlaveEndpoint modbusSerialSlavePoolingKey) {
            EndpointPoolConfiguration endpointPoolConfig = new EndpointPoolConfiguration();
            endpointPoolConfig.setReconnectAfterMillis(-1);
            endpointPoolConfig.setInterTransactionDelayMillis(35L);
            endpointPoolConfig.setConnectMaxTries(3);
            endpointPoolConfig.setConnectTimeoutMillis(10000);
            return endpointPoolConfig;
        }

        @Override
        public @NonNull EndpointPoolConfiguration visit(ModbusUDPSlaveEndpoint modbusUDPSlavePoolingKey) {
            EndpointPoolConfiguration endpointPoolConfig = new EndpointPoolConfiguration();
            endpointPoolConfig.setInterTransactionDelayMillis(60L);
            endpointPoolConfig.setConnectMaxTries(3);
            endpointPoolConfig.setConnectTimeoutMillis(10000);
            return endpointPoolConfig;
        }
    });
    private final PollOperation pollOperation = new PollOperation();
    private final WriteOperation writeOperation = new WriteOperation();
    private volatile long lastQueueMonitorLog = -1L;
    private volatile @Nullable KeyedObjectPool<ModbusSlaveEndpoint, @Nullable ModbusSlaveConnection> connectionPool;
    private volatile @Nullable ModbusSlaveConnectionFactoryImpl connectionFactory;
    private volatile Map<PollTask, ScheduledFuture<?>> scheduledPollTasks = new ConcurrentHashMap();
    private volatile @Nullable ScheduledExecutorService scheduledThreadPoolExecutor;
    private volatile @Nullable ScheduledFuture<?> monitorFuture;
    private volatile Set<ModbusCommunicationInterfaceImpl> communicationInterfaces = ConcurrentHashMap.newKeySet();

    private <R> void checkTransactionId(net.wimpi.modbus.msg.ModbusResponse response, ModbusRequest libRequest, String operationId) throws ModbusUnexpectedTransactionIdException {
        if (response.getTransactionID() != libRequest.getTransactionID() && !response.isHeadless()) {
            throw new ModbusUnexpectedTransactionIdException(libRequest.getTransactionID(), response.getTransactionID());
        }
    }

    private <R> void checkFunctionCode(net.wimpi.modbus.msg.ModbusResponse response, ModbusRequest libRequest, String operationId) throws ModbusUnexpectedResponseFunctionCodeException {
        if (response.getFunctionCode() != libRequest.getFunctionCode()) {
            throw new ModbusUnexpectedResponseFunctionCodeException(libRequest.getTransactionID(), response.getTransactionID());
        }
    }

    private <R> void checkResponseSize(net.wimpi.modbus.msg.ModbusResponse response, ModbusReadRequestBlueprint request, String operationId) throws ModbusUnexpectedResponseSizeException {
        int responseCount = ModbusLibraryWrapper.getNumberOfItemsInResponse(response, request);
        if (responseCount < request.getDataLength()) {
            throw new ModbusUnexpectedResponseSizeException(request.getDataLength(), responseCount);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void constructConnectionPool() {
        ModbusSlaveConnectionFactoryImpl connectionFactory = new ModbusSlaveConnectionFactoryImpl(DEFAULT_POOL_CONFIGURATION);
        @Nullable ModbusConnectionPool genericKeyedObjectPool = new ModbusConnectionPool(connectionFactory);
        genericKeyedObjectPool.setSwallowedExceptionListener(new SwallowedExceptionListener(){

            @Override
            public void onSwallowException(@Nullable Exception e) {
                LoggerFactory.getLogger(ModbusManagerImpl.class).warn("Connection pool swallowed unexpected exception:{} {}", new Object[]{Optional.ofNullable(e).map(ex -> ex.getClass().getSimpleName()).orElse(""), Optional.ofNullable(e).map(ex -> ex.getMessage()).orElse("<null>"), e});
            }
        });
        this.connectionPool = genericKeyedObjectPool;
        this.connectionFactory = connectionFactory;
    }

    private Optional<ModbusSlaveConnection> borrowConnection(ModbusSlaveEndpoint endpoint) {
        ModbusSlaveConnection slaveConnection;
        Optional<ModbusSlaveConnection> connection = Optional.empty();
        KeyedObjectPool<ModbusSlaveEndpoint, @Nullable ModbusSlaveConnection> pool = this.connectionPool;
        if (pool == null) {
            return connection;
        }
        long start = System.currentTimeMillis();
        try {
            connection = Optional.ofNullable(pool.borrowObject(endpoint));
        }
        catch (Exception e) {
            this.logger.warn("Error getting a new connection for endpoint {}. Error was: {} {}", new Object[]{endpoint, e.getClass().getName(), e.getMessage()});
        }
        if (connection.isPresent() && !(slaveConnection = connection.get()).isConnected()) {
            this.logger.trace("Received connection which is unconnected, preventing use by returning connection to pool.");
            this.returnConnection(endpoint, connection);
            connection = Optional.empty();
        }
        this.logger.trace("borrowing connection (got {}) for endpoint {} took {} ms", new Object[]{connection, endpoint, System.currentTimeMillis() - start});
        return connection;
    }

    private void invalidate(ModbusSlaveEndpoint endpoint, Optional<ModbusSlaveConnection> connection) {
        KeyedObjectPool<ModbusSlaveEndpoint, @Nullable ModbusSlaveConnection> pool = this.connectionPool;
        if (pool == null) {
            return;
        }
        long start = System.currentTimeMillis();
        connection.ifPresent(con -> {
            try {
                pool.invalidateObject(endpoint, (ModbusSlaveConnection)con);
            }
            catch (Exception e) {
                this.logger.warn("Error invalidating connection in pool for endpoint {}. Error was: {} {}", new Object[]{endpoint, e.getClass().getName(), e.getMessage(), e});
            }
        });
        this.logger.trace("invalidating connection for endpoint {} took {} ms", (Object)endpoint, (Object)(System.currentTimeMillis() - start));
    }

    private void returnConnection(ModbusSlaveEndpoint endpoint, Optional<ModbusSlaveConnection> connection) {
        KeyedObjectPool<ModbusSlaveEndpoint, @Nullable ModbusSlaveConnection> pool = this.connectionPool;
        if (pool == null) {
            return;
        }
        long start = System.currentTimeMillis();
        connection.ifPresent(con -> {
            try {
                pool.returnObject(endpoint, (ModbusSlaveConnection)con);
                this.logger.trace("returned connection to pool for endpoint {}", (Object)endpoint);
            }
            catch (Exception e) {
                this.logger.warn("Error returning connection to pool for endpoint {}. Error was: {} {}", new Object[]{endpoint, e.getClass().getName(), e.getMessage(), e});
            }
        });
        this.logger.trace("returning connection for endpoint {} took {} ms", (Object)endpoint, (Object)(System.currentTimeMillis() - start));
    }

    private <R, C extends ModbusResultCallback, F extends ModbusFailureCallback<R>, T extends TaskWithEndpoint<R, C, F>> Optional<ModbusSlaveConnection> getConnection(AggregateStopWatch timer, boolean oneOffTask, @NonNull T task) throws PollTaskUnregistered {
        KeyedObjectPool<ModbusSlaveEndpoint, @Nullable ModbusSlaveConnection> connectionPool = this.connectionPool;
        if (connectionPool == null) {
            return Optional.empty();
        }
        String operationId = timer.operationId;
        this.logger.trace("Executing task {} (oneOff={})! Waiting for connection. Idle connections for this endpoint: {}, and active {} [operation ID {}]", new Object[]{task, oneOffTask, connectionPool.getNumIdle(task.getEndpoint()), connectionPool.getNumActive(task.getEndpoint()), operationId});
        long connectionBorrowStart = System.currentTimeMillis();
        Object failureCallback = task.getFailureCallback();
        ModbusSlaveEndpoint endpoint = task.getEndpoint();
        Object request = task.getRequest();
        Optional connection = timer.connection.timeSupplier(() -> this.borrowConnection(endpoint));
        this.logger.trace("Executing task {} (oneOff={})! Connection received in {} ms [operation ID {}]", new Object[]{task, oneOffTask, System.currentTimeMillis() - connectionBorrowStart, operationId});
        if (this.scheduledThreadPoolExecutor == null) {
            timer.connection.timeRunnable(() -> this.invalidate(endpoint, connection));
            return Optional.empty();
        }
        if (connection.isEmpty()) {
            this.logger.warn("Could not connect to endpoint {} -- aborting request {} [operation ID {}]", new Object[]{endpoint, request, operationId});
            timer.callback.timeRunnable(() -> this.invokeCallbackWithError(request, (ModbusFailureCallback)failureCallback, new ModbusConnectionException(endpoint)));
        }
        return connection;
    }

    private <R> void invokeCallbackWithError(R request, ModbusFailureCallback<R> callback, Exception error) {
        try {
            this.logger.trace("Calling error response callback {} for request {}. Error was {} {}", new Object[]{callback, request, error.getClass().getName(), error.getMessage()});
            callback.handle(new AsyncModbusFailure<R>(request, error));
        }
        catch (Throwable throwable) {
            this.logger.trace("Called write response callback {} for request {}. Error was {} {}", new Object[]{callback, request, error.getClass().getName(), error.getMessage()});
            throw throwable;
        }
        this.logger.trace("Called write response callback {} for request {}. Error was {} {}", new Object[]{callback, request, error.getClass().getName(), error.getMessage()});
    }

    private void invokeCallbackWithResponse(ModbusWriteRequestBlueprint request, ModbusWriteCallback callback, ModbusResponse response) {
        try {
            this.logger.trace("Calling write response callback {} for request {}. Response was {}", new Object[]{callback, request, response});
            callback.handle(new AsyncModbusWriteResult(request, response));
        }
        catch (Throwable throwable) {
            this.logger.trace("Called write response callback {} for request {}. Response was {}", new Object[]{callback, request, response});
            throw throwable;
        }
        this.logger.trace("Called write response callback {} for request {}. Response was {}", new Object[]{callback, request, response});
    }

    private void verifyTaskIsRegistered(PollTask task) throws PollTaskUnregistered {
        if (!this.scheduledPollTasks.containsKey(task)) {
            String msg = String.format("Poll task %s is unregistered", task);
            this.logger.debug(msg);
            throw new PollTaskUnregistered(msg);
        }
    }

    /*
     * Exception decompiling
     */
    private <R, C extends ModbusResultCallback, F extends ModbusFailureCallback<R>, T extends TaskWithEndpoint<R, C, F>> void executeOperation(T task, boolean oneOffTask, ModbusOperation<T> operation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 23[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ModbusCommunicationInterface newModbusCommunicationInterface(ModbusSlaveEndpoint endpoint, @Nullable EndpointPoolConfiguration configuration) throws IllegalArgumentException {
        boolean openCommFoundWithSameEndpointDifferentConfig = this.communicationInterfaces.stream().filter(comm -> comm.endpoint.equals(endpoint)).anyMatch(comm -> !Optional.ofNullable(comm.configuration).orElseGet(() -> DEFAULT_POOL_CONFIGURATION.apply(endpoint)).equals(Optional.ofNullable(configuration).orElseGet(() -> DEFAULT_POOL_CONFIGURATION.apply(endpoint))));
        if (openCommFoundWithSameEndpointDifferentConfig) {
            throw new IllegalArgumentException("Communication interface is already open with different configuration to this same endpoint");
        }
        ModbusCommunicationInterfaceImpl comm2 = new ModbusCommunicationInterfaceImpl(endpoint, configuration);
        this.communicationInterfaces.add(comm2);
        return comm2;
    }

    @Override
    public EndpointPoolConfiguration getEndpointPoolConfiguration(ModbusSlaveEndpoint endpoint) {
        Objects.requireNonNull(this.connectionFactory, "Not activated!");
        return this.connectionFactory.getEndpointPoolConfiguration(endpoint);
    }

    private void unregisterCommunicationInterface(ModbusCommunicationInterface commInterface) {
        this.communicationInterfaces.remove(commInterface);
        this.maybeCloseConnections(commInterface.getEndpoint());
    }

    private void maybeCloseConnections(ModbusSlaveEndpoint endpoint) {
        ModbusSlaveConnectionFactoryImpl localConnectionFactory;
        boolean lastCommWithThisEndpointWasRemoved = this.communicationInterfaces.stream().noneMatch(comm -> comm.endpoint.equals(endpoint));
        if (lastCommWithThisEndpointWasRemoved && (localConnectionFactory = this.connectionFactory) != null) {
            localConnectionFactory.disconnectOnReturn(endpoint, System.currentTimeMillis());
            try {
                if (this.connectionPool != null) {
                    this.connectionPool.clear(endpoint);
                }
            }
            catch (Exception e) {
                this.logger.warn("Could not clear endpoint {}. Stack trace follows", (Object)endpoint, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(Map<String, Object> configProperties) {
        ModbusManagerImpl modbusManagerImpl = this;
        synchronized (modbusManagerImpl) {
            ScheduledExecutorService scheduledThreadPoolExecutor;
            this.logger.info("Modbus manager activated");
            if (this.connectionPool == null) {
                this.constructConnectionPool();
            }
            if ((scheduledThreadPoolExecutor = this.scheduledThreadPoolExecutor) == null) {
                this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor = ThreadPoolManager.getScheduledPool((String)MODBUS_POLLER_THREAD_POOL_NAME);
            }
            if (scheduledThreadPoolExecutor.isShutdown()) {
                this.logger.warn("Thread pool is shut down! Aborting activation of ModbusMangerImpl");
                throw new IllegalStateException("Thread pool(s) shut down! Aborting activation of ModbusMangerImpl");
            }
            this.monitorFuture = scheduledThreadPoolExecutor.scheduleWithFixedDelay(this::logTaskQueueInfo, 0L, 10000L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate() {
        ModbusManagerImpl modbusManagerImpl = this;
        synchronized (modbusManagerImpl) {
            KeyedObjectPool<ModbusSlaveEndpoint, @Nullable ModbusSlaveConnection> connectionPool = this.connectionPool;
            if (connectionPool != null) {
                for (ModbusCommunicationInterface modbusCommunicationInterface : this.communicationInterfaces) {
                    try {
                        modbusCommunicationInterface.close();
                    }
                    catch (Exception e) {
                        this.logger.warn("Error when closing communication interface", (Throwable)e);
                    }
                }
                connectionPool.close();
                connectionPool = null;
                this.connectionPool = null;
            }
            if (this.monitorFuture != null) {
                this.monitorFuture.cancel(true);
                this.monitorFuture = null;
            }
            this.scheduledThreadPoolExecutor = null;
            this.connectionFactory = null;
            this.logger.debug("Modbus manager deactivated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logTaskQueueInfo() {
        Logger logger = this.pollMonitorLogger;
        synchronized (logger) {
            ScheduledExecutorService scheduledThreadPoolExecutor = this.scheduledThreadPoolExecutor;
            if (scheduledThreadPoolExecutor == null) {
                return;
            }
            if (System.currentTimeMillis() - this.lastQueueMonitorLog < 10000L) {
                return;
            }
            this.lastQueueMonitorLog = System.currentTimeMillis();
            this.pollMonitorLogger.trace("<POLL MONITOR>");
            this.scheduledPollTasks.forEach((task, future) -> this.pollMonitorLogger.trace("POLL MONITOR: scheduled poll task. FC: {}, start {}, length {}, done: {}, canceled: {}, delay: {}. Full task {}", new Object[]{((ModbusReadRequestBlueprint)task.getRequest()).getFunctionCode(), ((ModbusReadRequestBlueprint)task.getRequest()).getReference(), ((ModbusReadRequestBlueprint)task.getRequest()).getDataLength(), future.isDone(), future.isCancelled(), future.getDelay(TimeUnit.MILLISECONDS), task}));
            if (scheduledThreadPoolExecutor instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor executor = (ThreadPoolExecutor)((Object)scheduledThreadPoolExecutor);
                this.pollMonitorLogger.trace("POLL MONITOR: scheduledThreadPoolExecutor queue size: {}, remaining space {}. Active threads {}", new Object[]{executor.getQueue().size(), executor.getQueue().remainingCapacity(), executor.getActiveCount()});
                if ((long)executor.getQueue().size() >= 500L) {
                    this.pollMonitorLogger.warn("Many ({}) tasks queued in scheduledThreadPoolExecutor! This might be sign of bad design or bug in the binding code.", (Object)executor.getQueue().size());
                }
            }
            this.pollMonitorLogger.trace("</POLL MONITOR>");
        }
    }

    static /* synthetic */ Logger access$0(ModbusManagerImpl modbusManagerImpl) {
        return modbusManagerImpl.logger;
    }

    static /* synthetic */ PollOperation access$1(ModbusManagerImpl modbusManagerImpl) {
        return modbusManagerImpl.pollOperation;
    }

    static /* synthetic */ void access$2(ModbusManagerImpl modbusManagerImpl, TaskWithEndpoint taskWithEndpoint, boolean bl, ModbusOperation modbusOperation) {
        modbusManagerImpl.executeOperation(taskWithEndpoint, bl, modbusOperation);
    }

    static /* synthetic */ WriteOperation access$3(ModbusManagerImpl modbusManagerImpl) {
        return modbusManagerImpl.writeOperation;
    }

    private /* synthetic */ void lambda$6(ModbusSlaveEndpoint modbusSlaveEndpoint, Optional c) {
        this.returnConnection(modbusSlaveEndpoint, c);
    }

    private /* synthetic */ void lambda$7(ModbusSlaveEndpoint modbusSlaveEndpoint, Optional c) {
        this.invalidate(modbusSlaveEndpoint, c);
    }

    private /* synthetic */ void lambda$8(ModbusSlaveEndpoint modbusSlaveEndpoint, Optional c) {
        this.invalidate(modbusSlaveEndpoint, c);
    }

    private /* synthetic */ void lambda$9(ModbusSlaveEndpoint modbusSlaveEndpoint, Optional c) {
        this.invalidate(modbusSlaveEndpoint, c);
    }

    private /* synthetic */ void lambda$10(ModbusSlaveEndpoint modbusSlaveEndpoint, Optional c) {
        this.invalidate(modbusSlaveEndpoint, c);
    }

    private /* synthetic */ void lambda$11(Object object, ModbusFailureCallback modbusFailureCallback, Exception exception) {
        this.invokeCallbackWithError(object, modbusFailureCallback, exception);
    }

    private /* synthetic */ void lambda$12(ModbusSlaveEndpoint modbusSlaveEndpoint, Optional c) {
        this.invalidate(modbusSlaveEndpoint, c);
    }

    private class ModbusCommunicationInterfaceImpl
    implements ModbusCommunicationInterface {
        private volatile ModbusSlaveEndpoint endpoint;
        private volatile Set<PollTask> pollTasksRegisteredByThisCommInterface = ConcurrentHashMap.newKeySet();
        private volatile boolean closed;
        private @Nullable EndpointPoolConfiguration configuration;

        private ModbusCommunicationInterfaceImpl(@Nullable ModbusSlaveEndpoint endpoint, EndpointPoolConfiguration configuration) {
            this.endpoint = endpoint;
            this.configuration = configuration;
            ModbusManagerImpl.this.connectionFactory.setEndpointPoolConfiguration(endpoint, configuration);
        }

        @Override
        public Future<?> submitOneTimePoll(ModbusReadRequestBlueprint request, ModbusReadCallback resultCallback, ModbusFailureCallback<ModbusReadRequestBlueprint> failureCallback) {
            if (this.closed) {
                throw new IllegalStateException("Communication interface is closed already!");
            }
            ScheduledExecutorService executor = ModbusManagerImpl.this.scheduledThreadPoolExecutor;
            Objects.requireNonNull(executor, "Not activated!");
            long scheduleTime = System.currentTimeMillis();
            BasicPollTask task = new BasicPollTask(this.endpoint, request, resultCallback, failureCallback);
            ModbusManagerImpl.this.logger.debug("Scheduling one-off poll task {}", (Object)task);
            return executor.submit(() -> {
                long millisInThreadPoolWaiting = System.currentTimeMillis() - scheduleTime;
                ModbusManagerImpl.this.logger.debug("Will now execute one-off poll task {}, waited in thread pool for {}", (Object)task, (Object)millisInThreadPoolWaiting);
                ModbusManagerImpl.this.executeOperation(task, true, ModbusManagerImpl.this.pollOperation);
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PollTask registerRegularPoll(ModbusReadRequestBlueprint request, long pollPeriodMillis, long initialDelayMillis, ModbusReadCallback resultCallback, ModbusFailureCallback<ModbusReadRequestBlueprint> failureCallback) {
            ModbusManagerImpl modbusManagerImpl = ModbusManagerImpl.this;
            synchronized (modbusManagerImpl) {
                if (this.closed) {
                    throw new IllegalStateException("Communication interface is closed already!");
                }
                ScheduledExecutorService executor = ModbusManagerImpl.this.scheduledThreadPoolExecutor;
                Objects.requireNonNull(executor, "Not activated!");
                BasicPollTask task = new BasicPollTask(this.endpoint, request, resultCallback, failureCallback);
                ModbusManagerImpl.this.logger.trace("Registering poll task {} with period {} using initial delay {}", new Object[]{task, pollPeriodMillis, initialDelayMillis});
                if (ModbusManagerImpl.this.scheduledPollTasks.containsKey(task)) {
                    ModbusManagerImpl.this.logger.trace("Unregistering previous poll task (possibly with different period)");
                    this.unregisterRegularPoll(task);
                }
                ScheduledFuture<?> future = executor.scheduleWithFixedDelay(() -> {
                    long started = System.currentTimeMillis();
                    ModbusManagerImpl.this.logger.debug("Executing scheduled ({}ms) poll task {}. Current millis: {}", new Object[]{pollPeriodMillis, task, started});
                    try {
                        ModbusManagerImpl.this.executeOperation(task, false, ModbusManagerImpl.this.pollOperation);
                    }
                    catch (RuntimeException e) {
                        ModbusManagerImpl.this.logger.warn("Execution of scheduled ({}ms) poll task {} failed unexpectedly. Ignoring exception, polling again according to poll interval.", new Object[]{pollPeriodMillis, task, e});
                    }
                    long finished = System.currentTimeMillis();
                    ModbusManagerImpl.this.logger.debug("Execution of scheduled ({}ms) poll task {} finished at {}. Was started at millis: {} (=duration of {} millis)", new Object[]{pollPeriodMillis, task, finished, started, finished - started});
                }, initialDelayMillis, pollPeriodMillis, TimeUnit.MILLISECONDS);
                ModbusManagerImpl.this.scheduledPollTasks.put(task, future);
                this.pollTasksRegisteredByThisCommInterface.add(task);
                ModbusManagerImpl.this.logger.trace("Registered poll task {} with period {} using initial delay {}", new Object[]{task, pollPeriodMillis, initialDelayMillis});
                return task;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean unregisterRegularPoll(PollTask task) {
            ModbusManagerImpl modbusManagerImpl = ModbusManagerImpl.this;
            synchronized (modbusManagerImpl) {
                ScheduledFuture<?> future;
                block6: {
                    block5: {
                        if (!this.closed) break block5;
                        return false;
                    }
                    this.pollTasksRegisteredByThisCommInterface.remove(task);
                    ModbusSlaveConnectionFactoryImpl localConnectionFactory = ModbusManagerImpl.this.connectionFactory;
                    Objects.requireNonNull(localConnectionFactory, "Not activated!");
                    future = ModbusManagerImpl.this.scheduledPollTasks.remove(task);
                    if (future != null) break block6;
                    ModbusManagerImpl.this.logger.warn("Caller tried to unregister nonexisting poll task {}", (Object)task);
                    return false;
                }
                ModbusManagerImpl.this.logger.debug("Unregistering regular poll task {} (interrupting if necessary)", (Object)task);
                future.cancel(true);
                ModbusManagerImpl.this.logger.debug("Poll task {} canceled", (Object)task);
                return true;
            }
        }

        @Override
        public Future<?> submitOneTimeWrite(ModbusWriteRequestBlueprint request, ModbusWriteCallback resultCallback, ModbusFailureCallback<ModbusWriteRequestBlueprint> failureCallback) {
            if (this.closed) {
                throw new IllegalStateException("Communication interface is closed already!");
            }
            ScheduledExecutorService localScheduledThreadPoolExecutor = ModbusManagerImpl.this.scheduledThreadPoolExecutor;
            Objects.requireNonNull(localScheduledThreadPoolExecutor, "Not activated!");
            BasicWriteTask task = new BasicWriteTask(this.endpoint, request, resultCallback, failureCallback);
            long scheduleTime = System.currentTimeMillis();
            ModbusManagerImpl.this.logger.debug("Scheduling one-off write task {}", (Object)task);
            return localScheduledThreadPoolExecutor.submit(() -> {
                long millisInThreadPoolWaiting = System.currentTimeMillis() - scheduleTime;
                ModbusManagerImpl.this.logger.debug("Will now execute one-off write task {}, waited in thread pool for {}", (Object)task, (Object)millisInThreadPoolWaiting);
                ModbusManagerImpl.this.executeOperation(task, true, ModbusManagerImpl.this.writeOperation);
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws Exception {
            ModbusManagerImpl modbusManagerImpl = ModbusManagerImpl.this;
            synchronized (modbusManagerImpl) {
                if (this.closed) {
                    return;
                }
                LinkedList<PollTask> tasksToUnregister = new LinkedList<PollTask>(this.pollTasksRegisteredByThisCommInterface);
                for (PollTask task : tasksToUnregister) {
                    this.unregisterRegularPoll(task);
                }
                ModbusManagerImpl.this.unregisterCommunicationInterface(this);
                this.closed = true;
            }
        }

        @Override
        public ModbusSlaveEndpoint getEndpoint() {
            return this.endpoint;
        }
    }

    @FunctionalInterface
    private static interface ModbusOperation<T> {
        public void accept(AggregateStopWatch var1, T var2, ModbusSlaveConnection var3) throws ModbusException, IIOException, ModbusUnexpectedTransactionIdException, ModbusUnexpectedResponseFunctionCodeException, ModbusUnexpectedResponseSizeException;
    }

    private class PollOperation
    implements ModbusOperation<PollTask> {
        private PollOperation() {
        }

        @Override
        public void accept(AggregateStopWatch timer, PollTask task, ModbusSlaveConnection connection) throws ModbusException, ModbusUnexpectedTransactionIdException, ModbusUnexpectedResponseFunctionCodeException, ModbusUnexpectedResponseSizeException {
            ModbusSlaveEndpoint endpoint = task.getEndpoint();
            ModbusReadRequestBlueprint request = (ModbusReadRequestBlueprint)task.getRequest();
            ModbusReadCallback callback = (ModbusReadCallback)task.getResultCallback();
            String operationId = timer.operationId;
            ModbusTransaction transaction = ModbusLibraryWrapper.createTransactionForEndpoint(endpoint, connection);
            ModbusRequest libRequest = ModbusLibraryWrapper.createRequest(request);
            transaction.setRequest(libRequest);
            ModbusManagerImpl.this.logger.trace("Going execute transaction with request request (FC={}): {} [operation ID {}]", new Object[]{request.getFunctionCode(), libRequest.getHexMessage(), operationId});
            timer.transaction.timeRunnableWithModbusException(transaction::execute);
            net.wimpi.modbus.msg.ModbusResponse response = transaction.getResponse();
            ModbusManagerImpl.this.logger.trace("Response for read request (FC={}, transaction ID={}): {} [operation ID {}]", new Object[]{response.getFunctionCode(), response.getTransactionID(), response.getHexMessage(), operationId});
            ModbusManagerImpl.this.checkTransactionId(response, libRequest, operationId);
            ModbusManagerImpl.this.checkFunctionCode(response, libRequest, operationId);
            ModbusManagerImpl.this.checkResponseSize(response, request, operationId);
            timer.callback.timeRunnable(() -> ModbusLibraryWrapper.invokeCallbackWithResponse(request, callback, response));
        }
    }

    static class PollTaskUnregistered
    extends Exception {
        private static final long serialVersionUID = 6939730579178506885L;

        public PollTaskUnregistered(String msg) {
            super(msg);
        }
    }

    private class WriteOperation
    implements ModbusOperation<WriteTask> {
        private WriteOperation() {
        }

        @Override
        public void accept(AggregateStopWatch timer, WriteTask task, ModbusSlaveConnection connection) throws ModbusException, ModbusUnexpectedTransactionIdException, ModbusUnexpectedResponseFunctionCodeException {
            ModbusSlaveEndpoint endpoint = task.getEndpoint();
            ModbusWriteRequestBlueprint request = (ModbusWriteRequestBlueprint)task.getRequest();
            @Nullable ModbusWriteCallback callback = (ModbusWriteCallback)task.getResultCallback();
            String operationId = timer.operationId;
            ModbusTransaction transaction = ModbusLibraryWrapper.createTransactionForEndpoint(endpoint, connection);
            ModbusRequest libRequest = ModbusLibraryWrapper.createRequest(request);
            transaction.setRequest(libRequest);
            ModbusManagerImpl.this.logger.trace("Going execute transaction with read request (FC={}): {} [operation ID {}]", new Object[]{request.getFunctionCode(), libRequest.getHexMessage(), operationId});
            timer.transaction.timeRunnableWithModbusException(transaction::execute);
            net.wimpi.modbus.msg.ModbusResponse response = transaction.getResponse();
            ModbusManagerImpl.this.logger.trace("Response for write request (FC={}, transaction ID={}): {} [operation ID {}]", new Object[]{response.getFunctionCode(), response.getTransactionID(), response.getHexMessage(), operationId});
            ModbusManagerImpl.this.checkTransactionId(response, libRequest, operationId);
            ModbusManagerImpl.this.checkFunctionCode(response, libRequest, operationId);
            timer.callback.timeRunnable(() -> ModbusManagerImpl.this.invokeCallbackWithResponse(request, callback, new ModbusResponseImpl(response)));
        }
    }
}

