//
// NotificationCenterTest.h
//
// Definition of the NotificationCenterTest class.
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// SPDX-License-Identifier:	BSL-1.0
//


#ifndef NotificationCenterTest_INCLUDED
#define NotificationCenterTest_INCLUDED


#include "Poco/Foundation.h"
#include "CppUnit/TestCase.h"
#include "Poco/Notification.h"
#include "Poco/AutoPtr.h"
#include "Poco/Mutex.h"
#include <set>


class TestNotification;

namespace Poco {
	class NotificationCenter;
}


class NotificationCenterTest: public CppUnit::TestCase
{
public:
	NotificationCenterTest(const std::string& name);
	~NotificationCenterTest();

	void testNotificationCenter1();
#ifdef POCO_TEST_DEPRECATED
	void testNotificationCenter2();
	void testNotificationCenter3();
	void testNotificationCenter4();
	void testNotificationCenter5();
#endif
	void testNotificationCenterAuto();
#ifdef POCO_TEST_DEPRECATED
	void testDefaultNotificationCenter();
#endif
	void testDeadlock();

	void setUp();
	void tearDown();

	static CppUnit::Test* suite();

	void handleAuto(const Poco::AutoPtr<Poco::Notification>& pNf);
	void handleDeadlock(const Poco::AutoPtr<Poco::Notification>& pNf);

protected:
#ifdef POCO_TEST_DEPRECATED
	void handle1(Poco::Notification* pNf);
	void handle2(Poco::Notification* pNf);
	void handle3(Poco::Notification* pNf);
	void handleTest(TestNotification* pNf);
#endif

private:
	std::set<std::string> _set;
	std::atomic<bool> _handle1Done;
	std::atomic<bool> _handleAuto1Done;
	std::atomic<bool> _handlerStarted;
	std::atomic<int> _handlerCallCount;
	Poco::Mutex _mutex;
	Poco::NotificationCenter* _pNC;
};


#endif // NotificationCenterTest_INCLUDED
