/* PR c/102989 */
/* { dg-do run { target bitint } } */
/* { dg-options "-std=c23 -pedantic-errors" } */

#include <stdatomic.h>

extern void abort (void);

#if __BITINT_MAXWIDTH__ >= 575
_Atomic _BitInt(575) v;
_BitInt(575) count, res;
const _BitInt(575) init = ~(_BitInt(575)) 0wb;

void
test_fetch_add ()
{
  atomic_init (&v, 59465222573183779324781274162178653782927579944977967117312772499849358939735575735090252965265846823956223131844773977101864574011188590603103408821590130462520809924774161wb);
  count = 21849324526703540909725517290562575722142104889154621021004438836543599493803029317660194646869455042293514095831327249339063542203879269024249546998746919066599380031180974wb;

  if (atomic_fetch_add_explicit (&v, count, memory_order_relaxed)
      != 59465222573183779324781274162178653782927579944977967117312772499849358939735575735090252965265846823956223131844773977101864574011188590603103408821590130462520809924774161wb)
    abort ();

  if (atomic_fetch_add_explicit (&v, -48324598397571087754171506195219221853271763472221035086980364394554212400270766919963305485900701475788840363160834710492683133292253640988518950921616217692973141455340373wb,
				 memory_order_consume)
      != -42350653636664946795744469057082365512495989716473331818714316710055654119727328532407752918486220628549098485331968443234754400938307745356420121730609534429183196118394433wb)
    abort ();

  if (atomic_fetch_add_explicit (&v, count, memory_order_acquire)
      != 32989948702316232480335285257522007651797921361911553051336846941838746033267838132787142126234600390460896864515266515948244982922814218638834004898720831836147048500614762wb)
    abort ();

  if (atomic_fetch_add_explicit (&v, 6958312589905983216078981134518695082538588883298046610645489916662738759809700053844918067866491080683973037493524864531300139437943661326918145212620326291059845453630984wb,
				 memory_order_release)
      != 54839273229019773390060802548084583373940026251066174072341285778382345527070867450447336773104055432754410960346593765287308525126693487663083551897467750902746428531795736wb)
    abort ();

  if (atomic_fetch_add_explicit (&v, count, memory_order_acq_rel)
      != 61797585818925756606139783682603278456478615134364220682986775695045084286880567504292254840970546513438383997840118629818608664564637148990001697110088077193806273985426720wb)
    abort ();

  if (atomic_fetch_add_explicit (&v, -40070085597220253007443375012839311464160438432662764715171645999337062215395237625623334979615599652975898123428005079853660189572782012739700306191422569739682093304494995wb,
				 memory_order_seq_cst)
      != -40018290390922969514385959536657740838944954527087078253040313514859928772582336763205751042781520939066937619336623790518010310384859186969521833442111587697897732057741874wb)
    abort ();

  if (atomic_fetch_add (&v, 7196090098608011755205055682070541953902689411792805630101863619558545582022760829169235622333653743217332966939875542415224317593660770300818700993340012969018217868600175wb)
      != 43576824748409044508421925960326542714460281590856076988819568532251621565288359196329114508224401902755999970243440799304012017195734405274550937917412426520723560712112699wb)
    abort ();

  if (atomic_load (&v) != 50772914847017056263626981642397084668362971002648882618921432151810167147311120025498350130558055645973332937183316341719236334789395175575369638910752439489741778580712874wb)
    abort ();
}

void
test_fetch_sub ()
{
  atomic_store_explicit (&v, -24875491091433158113922205635657739252057730543056417031972993454853665637813018617125143194799847437263037065304695383952916979113678037118532311779822859742705294727822376wb,
			 memory_order_release);
  count = 6813702694653136917886567607003795360731391695538381923575500076220746287948057449348609672603971831069550813465757196210073636056135824219022209113495061317682354090030599wb;

  if (atomic_fetch_sub_explicit (&v, count, memory_order_relaxed)
      != -24875491091433158113922205635657739252057730543056417031972993454853665637813018617125143194799847437263037065304695383952916979113678037118532311779822859742705294727822376wb)
    abort ();

  if (atomic_fetch_sub_explicit (&v, 8502925336737158389204618905966437550402192530184998378452912098895816391400915282714213521081597588768568861040471642522181200007537708168290327879425612502090295717806034wb,
				 memory_order_consume)
      != -31689193786086295031808773242661534612789122238594798955548493531074411925761076066473752867403819268332587878770452580162990615169813861337554520893317921060387648817852975wb)
    abort ();

  if (atomic_fetch_sub_explicit (&v, count, memory_order_acquire)
      != -40192119122823453421013392148627972163191314768779797334001405629970228317161991349187966388485416857101156739810924222685171815177351569505844848772743533562477944535659009wb)
    abort ();

  if (atomic_fetch_sub_explicit (&v, -14654459030451169455889477114198307761108411115104251375487725308584250511764953921137486025925617622862411621191578047606524662379041353882420330350079004108508600686109553wb,
				 memory_order_release)
      != -47005821817476590338899959755631767523922706464318179257576905706190974605110048798536576061089388688170707553276681418895245451233487393724867057886238594880160298625689608wb)
    abort ();

  if (atomic_fetch_sub_explicit (&v, count, memory_order_acq_rel)
      != -32351362787025420883010482641433459762814295349213927882089180397606724093345094877399090035163771065308295932085103371288720788854446039842446727536159590771651697939580055wb)
    abort ();

  if (atomic_fetch_sub_explicit (&v, 22886836433700729148520267039236396292049781709943309196356241086882444816631218673962641435859436811686812355905147988710440709035301495069683757516099446883747069843672565wb,
				 memory_order_seq_cst)
      != -39165065481678557800897050248437255123545687044752309805664680473827470381293152326747699707767742896377846745550860567498794424910581864061468936649654652089334052029610654wb)
    abort ();

  if (atomic_fetch_sub (&v, 49406467535448986167225179068150076098092817730200780462287871488076089290458383699602612866098591282427581289588523598202726797161439183859560135056424525356253246480887928wb)
      != 61613298821172980080833943222149943601970205795910300955010606485738697355341562584447859386994342786734176611552061113466447383207492245852620383385192484985222264201066349wb)
    abort ();

  if (atomic_load_explicit (&v, memory_order_acquire)
      != 12206831285723993913608764153999867503877388065709520492722734997662608064883178884845246520895751504306595321963537515263720586046053061993060248328767959628969017720178421wb)
    abort ();
}

void
test_fetch_and ()
{
  atomic_store (&v, init);

  if (atomic_fetch_and_explicit (&v, 0, memory_order_relaxed) != init)
    abort ();

  if (atomic_fetch_and_explicit (&v, init, memory_order_consume) != 0)
    abort ();

  if (atomic_fetch_and_explicit (&v, 0, memory_order_acquire) != 0)
    abort ();

  v = ~v;
  if (atomic_fetch_and_explicit (&v, init, memory_order_release) != init)
    abort ();

  if (atomic_fetch_and_explicit (&v, 0, memory_order_acq_rel) != init)
    abort ();

  if (atomic_fetch_and_explicit (&v, 0, memory_order_seq_cst) != 0)
    abort ();

  if (atomic_fetch_and (&v, 0) != 0)
    abort ();
}

void
test_fetch_xor ()
{
  v = init;
  count = 0;

  if (atomic_fetch_xor_explicit (&v, count, memory_order_relaxed) != init)
    abort ();

  if (atomic_fetch_xor_explicit (&v, ~count, memory_order_consume) != init)
    abort ();

  if (atomic_fetch_xor_explicit (&v, 0, memory_order_acquire) != 0)
    abort ();

  if (atomic_fetch_xor_explicit (&v, ~count, memory_order_release) != 0)
    abort ();

  if (atomic_fetch_xor_explicit (&v, 0, memory_order_acq_rel) != init)
    abort ();

  if (atomic_fetch_xor_explicit (&v, ~count, memory_order_seq_cst) != init)
    abort ();

  if (atomic_fetch_xor (&v, ~count) != 0)
    abort ();
}

void
test_fetch_or ()
{
  v = 0wb;
  count = 28269553036454149273332760011886696253239742350009903329945699220681916416wb;

  if (atomic_fetch_or_explicit (&v, count, memory_order_relaxed) != 0wb)
    abort ();

  count *= 2;
  if (atomic_fetch_or_explicit (&v, 56539106072908298546665520023773392506479484700019806659891398441363832832wb,
				memory_order_consume)
      != 28269553036454149273332760011886696253239742350009903329945699220681916416wb)
    abort ();

  count *= 2;
  if (atomic_fetch_or_explicit (&v, count, memory_order_acquire)
      != 84808659109362447819998280035660088759719227050029709989837097662045749248wb)
    abort ();

  count *= 2;
  if (atomic_fetch_or_explicit (&v, 226156424291633194186662080095093570025917938800079226639565593765455331328wb,
				memory_order_release)
      != 197886871255179044913329320083206873772678196450069323309619894544773414912wb)
    abort ();

  count *= 2;
  if (atomic_fetch_or_explicit (&v, count, memory_order_acq_rel)
      != 424043295546812239099991400178300443798596135250148549949185488310228746240wb)
    abort ();

  count *= 2;
  if (atomic_fetch_or_explicit (&v, count, memory_order_seq_cst)
      != 876356144130078627473315560368487583850432012850307003228316675841139408896wb)
    abort ();

  count *= 2;
  if (atomic_fetch_or (&v, count) != 1780981841296611404219963880748861863954103768050623909786579050902960734208wb)
    abort ();
}


/* Test the OP routines with a result which isn't used.  */

void
test_add ()
{
  v = 0;
  count = 1486842905609751694333995980623369134886360644481888406879896752089037065255179570086557965294767349553406889549100250674362935254187127254353474822610854717612397677wb;

  atomic_fetch_add (&v, count);
  if (v != 1486842905609751694333995980623369134886360644481888406879896752089037065255179570086557965294767349553406889549100250674362935254187127254353474822610854717612397677wb)
    abort ();

  atomic_fetch_add_explicit (&v, count, memory_order_consume);
  if (v != 2973685811219503388667991961246738269772721288963776813759793504178074130510359140173115930589534699106813779098200501348725870508374254508706949645221709435224795354wb)
    abort ();

  atomic_fetch_add (&v, 1486842905609751694333995980623369134886360644481888406879896752089037065255179570086557965294767349553406889549100250674362935254187127254353474822610854717612397677wb);
  if (v != 4460528716829255083001987941870107404659081933445665220639690256267111195765538710259673895884302048660220668647300752023088805762561381763060424467832564152837193031wb)
    abort ();

  atomic_fetch_add_explicit (&v, 1486842905609751694333995980623369134886360644481888406879896752089037065255179570086557965294767349553406889549100250674362935254187127254353474822610854717612397677wb,
			     memory_order_release);
  if (v != 5947371622439006777335983922493476539545442577927553627519587008356148261020718280346231861179069398213627558196401002697451741016748509017413899290443418870449590708wb)
    abort ();

  atomic_fetch_add (&v, 1486842905609751694333995980623369134886360644481888406879896752089037065255179570086557965294767349553406889549100250674362935254187127254353474822610854717612397677wb);
  if (v != 7434214528048758471669979903116845674431803222409442034399483760445185326275897850432789826473836747767034447745501253371814676270935636271767374113054273588061988385wb)
    abort ();

  atomic_fetch_add_explicit (&v, count, memory_order_seq_cst);
  if (v != 8921057433658510166003975883740214809318163866891330441279380512534222391531077420519347791768604097320441337294601504046177611525122763526120848935665128305674386062wb)
    abort ();
}

void
test_sub ()
{
  v = res = 55339930658115792138308584702507715233391812567721958037499562620485942364609138719919541704955047331226014242859673113345829202990143617633801993282898070230404539826267403wb;
  count = 0;

  atomic_fetch_sub (&v, count + 2266681016524228072657464685355732111725088152428495977635446886262656759828446929716740827028716649170693025791717921736186782036315322643449879013364541057wb);
  res -= 2266681016524228072657464685355732111725088152428495977635446886262656759828446929716740827028716649170693025791717921736186782036315322643449879013364541057wb;
  if (v != res)
    abort ();

  atomic_fetch_sub_explicit (&v, count + 2266681016524228072657464685355732111725088152428495977635446886262656759828446929716740827028716649170693025791717921736186782036315322643449879013364541057wb, memory_order_consume);
  res -= 2266681016524228072657464685355732111725088152428495977635446886262656759828446929716740827028716649170693025791717921736186782036315322643449879013364541057wb;
  if (v != res)
    abort ();

  atomic_fetch_sub (&v, 2266681016524228072657464685355732111725088152428495977635446886262656759828446929716740827028716649170693025791717921736186782036315322643449879013364541057wb);
  res -= 2266681016524228072657464685355732111725088152428495977635446886262656759828446929716740827028716649170693025791717921736186782036315322643449879013364541057wb;
  if (v != res)
    abort ();

  atomic_fetch_sub_explicit (&v, 2266681016524228072657464685355732111725088152428495977635446886262656759828446929716740827028716649170693025791717921736186782036315322643449879013364541057wb, memory_order_release);
  res -= 2266681016524228072657464685355732111725088152428495977635446886262656759828446929716740827028716649170693025791717921736186782036315322643449879013364541057wb;
  if (v != res)
    abort ();

  atomic_fetch_sub (&v, count + 2266681016524228072657464685355732111725088152428495977635446886262656759828446929716740827028716649170693025791717921736186782036315322643449879013364541057wb);
  res -= 2266681016524228072657464685355732111725088152428495977635446886262656759828446929716740827028716649170693025791717921736186782036315322643449879013364541057wb;
  if (v != res)
    abort ();

  atomic_fetch_sub_explicit (&v, count + 2266681016524228072657464685355732111725088152428495977635446886262656759828446929716740827028716649170693025791717921736186782036315322643449879013364541057wb, memory_order_seq_cst);
  res -= 2266681016524228072657464685355732111725088152428495977635446886262656759828446929716740827028716649170693025791717921736186782036315322643449879013364541057wb;
  if (v != res)
    abort ();
}

void
test_and ()
{
  v = init;

  atomic_fetch_and (&v, 0);
  if (v != 0)
    abort ();

  v = init;
  atomic_fetch_and_explicit (&v, init, memory_order_consume);
  if (v != init)
    abort ();

  atomic_fetch_and (&v, 0);
  if (v != 0)
    abort ();

  v = ~v;
  atomic_fetch_and_explicit (&v, init, memory_order_release);
  if (v != init)
    abort ();

  atomic_fetch_and (&v, 0);
  if (v != 0)
    abort ();

  v = ~v;
  atomic_fetch_and_explicit (&v, 0, memory_order_seq_cst);
  if (v != 0)
    abort ();
}

void
test_xor ()
{
  v = init;
  count = 0;

  atomic_fetch_xor (&v, count);
  if (v != init)
    abort ();

  atomic_fetch_xor_explicit (&v, ~count, memory_order_consume);
  if (v != 0)
    abort ();

  atomic_fetch_xor (&v, 0);
  if (v != 0)
    abort ();

  atomic_fetch_xor_explicit (&v, ~count, memory_order_release);
  if (v != init)
    abort ();

  atomic_fetch_xor_explicit (&v, 0, memory_order_acq_rel);
  if (v != init)
    abort ();

  atomic_fetch_xor (&v, ~count);
  if (v != 0)
    abort ();
}

void
test_or ()
{
  v = 0;
  count = 19342813113834066795298816wb;

  atomic_fetch_or (&v, count);
  if (v != 19342813113834066795298816wb)
    abort ();

  count *= 2;
  atomic_fetch_or_explicit (&v, count, memory_order_consume);
  if (v != 58028439341502200385896448wb)
    abort ();

  count *= 2;
  atomic_fetch_or (&v, 77371252455336267181195264wb);
  if (v != 135399691796838467567091712wb)
    abort ();

  count *= 2;
  atomic_fetch_or_explicit (&v, 154742504910672534362390528wb,
			    memory_order_release);
  if (v != 290142196707511001929482240wb)
    abort ();

  count *= 2;
  atomic_fetch_or (&v, count);
  if (v != 599627206528856070654263296wb)
    abort ();

  count *= 2;
  atomic_fetch_or_explicit (&v, count, memory_order_seq_cst);
  if (v != 1218597226171546208103825408wb)
    abort ();
}

void
test_exchange (void)
{
  atomic_store (&v, -285679222948993342888321238830899996788334328454283006589115162661816862491992700267590986826514460282130796141107636816730207482542791159837024986802592659048696136633096wb);
  if (atomic_exchange (&v, 5310030317361876753340683501073244375280341322936688061997080395958520351093955920782059690068348979597317732862920837580508090330213951646930178946470395395144632931547601wb)
      != -285679222948993342888321238830899996788334328454283006589115162661816862491992700267590986826514460282130796141107636816730207482542791159837024986802592659048696136633096wb
      || atomic_load (&v) != 5310030317361876753340683501073244375280341322936688061997080395958520351093955920782059690068348979597317732862920837580508090330213951646930178946470395395144632931547601wb)
    abort ();
  if (atomic_exchange_explicit (&v, -4427613371507571222951705350055906255006016685171218855857415580222001757304647519678682295710994407542058879878792272713121656498918585491540313864044915269100507689612649wb,
			        memory_order_relaxed)
      != 5310030317361876753340683501073244375280341322936688061997080395958520351093955920782059690068348979597317732862920837580508090330213951646930178946470395395144632931547601wb
      || (atomic_load_explicit (&v, memory_order_acquire)
	  != -4427613371507571222951705350055906255006016685171218855857415580222001757304647519678682295710994407542058879878792272713121656498918585491540313864044915269100507689612649wb))
    abort ();

  count = 5310030317361876753340683501073244375280341322936688061997080395958520351093955920782059690068348979597317732862920837580508090330213951646930178946470395395144632931547601wb;
  if (atomic_compare_exchange_strong (&v, &count,
				      8894166061872682036448354332319628975793195843703235778626260413018342611721096976767565811189387129127069300488196032026080940074010266394902215699511191435840967345778707wb))
    abort ();
  if (count != -4427613371507571222951705350055906255006016685171218855857415580222001757304647519678682295710994407542058879878792272713121656498918585491540313864044915269100507689612649wb
      || atomic_load (&v) != -4427613371507571222951705350055906255006016685171218855857415580222001757304647519678682295710994407542058879878792272713121656498918585491540313864044915269100507689612649wb)
    abort ();
  if (!atomic_compare_exchange_strong (&v, &count,
				       8894166061872682036448354332319628975793195843703235778626260413018342611721096976767565811189387129127069300488196032026080940074010266394902215699511191435840967345778707wb))
    abort ();
  if (count != -4427613371507571222951705350055906255006016685171218855857415580222001757304647519678682295710994407542058879878792272713121656498918585491540313864044915269100507689612649wb
      || atomic_load (&v) != 8894166061872682036448354332319628975793195843703235778626260413018342611721096976767565811189387129127069300488196032026080940074010266394902215699511191435840967345778707wb)
    abort ();

  count = 5310030317361876753340683501073244375280341322936688061997080395958520351093955920782059690068348979597317732862920837580508090330213951646930178946470395395144632931547601wb;
  if (atomic_compare_exchange_strong_explicit (&v, &count,
					       -20263258027145541347005514871938569231358927704236809883668741851321168433670480594273940614283839738125120292424689828120954658857299483460682957837178666219043928324493674wb,
					       memory_order_seq_cst,
					       memory_order_relaxed))
    abort ();
  if (count != 8894166061872682036448354332319628975793195843703235778626260413018342611721096976767565811189387129127069300488196032026080940074010266394902215699511191435840967345778707wb
      || atomic_load (&v) != 8894166061872682036448354332319628975793195843703235778626260413018342611721096976767565811189387129127069300488196032026080940074010266394902215699511191435840967345778707wb)
    abort ();
  if (!atomic_compare_exchange_strong_explicit (&v, &count,
						-20263258027145541347005514871938569231358927704236809883668741851321168433670480594273940614283839738125120292424689828120954658857299483460682957837178666219043928324493674wb,
						memory_order_seq_cst,
						memory_order_seq_cst))
    abort ();
  if (count != 8894166061872682036448354332319628975793195843703235778626260413018342611721096976767565811189387129127069300488196032026080940074010266394902215699511191435840967345778707wb
      || atomic_load (&v) != -20263258027145541347005514871938569231358927704236809883668741851321168433670480594273940614283839738125120292424689828120954658857299483460682957837178666219043928324493674wb)
    abort ();

  count = atomic_load (&v);
  do
    res = count + 3438682542819842029328613486899299339199839206022263296398180581126218550036955367421469273900216774711772362599086182416923053671263751262393559525082445581168420546542404wb;
  while (!atomic_compare_exchange_weak (&v, &count, res));
  if (atomic_load (&v) != -16824575484325699317676901385039269892159088498214546587270561270194949883633525226852471340383622963413347929825603645704031605186035732198289398312096220637875507777951270wb)
    abort ();

  count = atomic_load_explicit (&v, memory_order_acquire);
  do
    res = count + 55351299008567209999272942257960316150846002020561006740901388462123844029522178721330031429855007927083338249659817829635668878607777961512926342979905691183772323299904096wb;
  while (!atomic_compare_exchange_weak_explicit (&v, &count, res,
						 memory_order_relaxed,
						 memory_order_relaxed));
  if (atomic_load (&v) != 38526723524241510681596040872921046258686913522346460153630827191928894145888653494477560089471384963669990319834214183931637273421742229314636944667809470545896815521952826wb)
    abort ();
}
#endif

int
main ()
{
#if __BITINT_MAXWIDTH__ >= 575
  test_fetch_add ();
  test_fetch_sub ();
  test_fetch_and ();
  test_fetch_xor ();
  test_fetch_or ();
  test_add ();
  test_sub ();
  test_and ();
  test_xor ();
  test_or ();
  test_exchange ();
#endif
  return 0;
}
